/*******************************************************************************
  Copyright (c) 2023, Intel Corporation

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

      * Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
      * Neither the name of Intel Corporation nor the names of its contributors
        may be used to endorse or promote products derived from this software
        without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/* ZUC-EEA3-256,  */
#include "cipher_test.h"

const struct cipher_test zuc_eea3_256_test_json[] = {
        { 200, 256, 1,
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x58\xd0\x3a\xd6\x2e\x03\x2c\xe2\xda\xfc\x68\x3a\x39\xbd\xcb\x03\x52\xa2\xbc\x67\xf1\xb7"
          "\xde\x74\x16\x3c\xe3\xa1\x01\xef\x55\x58\x96\x39\xd7\x5b\x95\xfa\x68\x1b\x7f\x09\x0d\xf7"
          "\x56\x39\x1c\xcc\x90\x3b\x76\x12\x74\x4d\x54\x4c\x17\xbc\x3f\xad\x8b\x16\x3b\x08\x21\x78"
          "\x7c\x0b\x97\x77\x5b\xb8\x49\x43\xc6\xbb\xe8\xad\x8a\xfd",
          1, 640 },
        { 184, 256, 2,
          "\x8f\x8e\xf9\xd8\xfb\x0a\xce\x2b\x23\x19\x48\x42\xcb\x5c\x6d\x98\x1e\x71\x68\x74\xe1\xdf"
          "\xeb\xe0\xf2\x46\x02\x71\xbb\x69\x0d\x9e",
          "\x2c\xe8\x87\x0f\x8c\x7f\x47\x2a\x02\x2d\x24\xcd\x23\x3f\x4d\x0a\x40\x0d\x12\xdd\xc4\x16"
          "\x26",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xc1\xce\x46\xd2\x4e\x78\x6f\x97\xcf\xc0\xa5\x3c\xec\x50\x6e\x17\xe0\x8c\x7e\x33\x84\x98"
          "\x2b\xc1\x68\x97\x24\x83\x03\x7c\x0d\xc5\x19\xa1\xe8\xb1\xb7\x53\x4f\x3b\x8a\xa3\xce\x9b"
          "\x3d\xd0\x1a\xf7\x7d\xae\x4c\x6b\xe4\xe3\x12\x70\x63\xc9\x4c\xcf\x1f\xf7\x18\xdf\xf1\x7d"
          "\x96\xe4\x60\xa8\x3b\xf5\x71\x7d\x2a\x87\x1d\x82\xed\x92\xc5\xe7\x6e\xd9\x3c\x01\x0d\x87"
          "\x13\x3b\x1a\x92\xa2\x83\x1a\x5b\x9a\xfb\x81\x1d\xdb\xbd\x82\x01\x3b\x32\x0e\x2c\x67\x3c"
          "\x14\x13\x9d\x58\xf1\x88\x9d\xe5\xd6\xe3\x48\xaa\x43\xc2\x08\xa6\x64\xa8\xad\x71\x26\x7e"
          "\xe7\xed\x0c\x58\xd3\x27\x42\x5e\x10\xb0\x03\x62\x18\x30\xde\xdb\x45\xcd\x78\xdd\xee\x4f"
          "\xa1\x45\xa6\xbf\xc1\x37\x3e\x47\x5c\x1b\xb6\x8b\x63\x87\x49\xc4\x1b\x9e\xea\x01\x62\x2a"
          "\x44\x65\x17\x0f\xee\xcc\x7f\xe6\xab\x05\x46\x25\x7d\xdc\x40\x1e",
          1, 1536 },
        { 184, 256, 3,
          "\x92\xf9\x27\xe8\xab\x48\x46\xdb\x2f\xa3\x61\x36\x7e\x89\xe1\x17\xc9\x99\x57\x63\xe0\xe4"
          "\x4c\xce\x20\x03\x8a\x9c\x9a\x44\xca\x64",
          "\x7d\x51\xfb\x42\xf8\x7e\x62\xfa\x60\x25\xb9\x2b\x4e\xd6\x1c\x2e\xcc\x6c\x65\x18\x1e\x9d"
          "\x04",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xe4\x14\xf9\x26\x45\xc6\x2e\x12\xb0\xe1\x33\xf6\xa7\x96\x22\xfb\x0f\xe0\x07\x5c\x6e\xbe"
          "\x10\x1b\x37\xe4\xf7\x1c\x94\xcf\xf1\x73\x02\x64\x61\x40\xb4\xf1\xfb\xcf\x8c\xc6\xa2\xda"
          "\xd7\x3f\xb4\xcc\xa8\x7b\x13\xaa\xd2\x6e\x2a\x1b\x0a\x07\xef\x88\x41\xfb\x6c\x10\x3f\x41"
          "\x60\xb3\x4c\x7d\x00\x9c\x72\x2f\x4a\xa2\xc1\x0c\xf4\x6f\xbf\xed\xec\xaf\xeb\xbc\xc8\x2a"
          "\x54\x60\x48\x7d\xfe\x20\x38\x6a",
          1, 768 },
        { 184, 256, 4,
          "\xa7\x72\xf5\xfe\x9d\x81\xd1\xcf\x22\x8e\x45\x53\x67\x75\xac\xc9\x04\x19\x57\x55\x0f\x6c"
          "\x39\xf9\xc5\x1b\x1e\x9e\xbb\x22\xa2\xf5",
          "\xce\x51\x11\x83\x9b\x64\x4d\x20\x51\x92\x71\x3b\x43\x47\xf9\x38\x79\x0f\xd2\x59\xbc\x35"
          "\xd3",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00",
          "\x89\x63\x69\xca\x77\xd3\x05\xf7\xa3\xcb\xf6\xba\xb3\x8c\x14\x4f\xc3\x73\xf4\xf0\xf5\x0c"
          "\xf1\xad\x0f\x41\x65\x48\x40\x47\x5e\xef\xad\xea\x1c\x3c\x15\xa0\xd2\x72\x25\x14\x1d\x6f"
          "\xa0\x0f\xe8\x9a",
          1, 384 },
        { 184, 256, 5,
          "\xf8\xa0\x45\x4f\x6d\xea\x74\x6e\x4c\xd1\x6e\xb0\xc3\xa2\x1f\x57\xeb\x6f\x35\x2d\x6a\x02"
          "\x5b\x35\x32\xba\x47\x3f\x1f\x0e\xdd\xc9",
          "\x07\x90\xeb\x7d\x09\x6d\xc1\xf1\x86\x47\xea\x57\xe4\xb8\x92\xb1\x4e\x3b\x2d\x62\xaa\x53"
          "\x6f",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00",
          "\xc6\x02\x3c\x58\x53\xc9\xae\xba\x0a\x47\x10\xdc\x85\x76\x13\x82\x08\x66\xbc\x3e\x9c\x2d"
          "\xb2\x42\x20\x3a\x0a\x0c\x49\x1d\xe9\x44\x73\x87\xe5\x60\x9d\x98\xff\xf1\x33\xc3\xd0\x3d"
          "\x49\xfc\x77\x07",
          1, 384 },
        { 200, 256, 6,
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f\x3f\x3f\x3f\x3f"
          "\x3f\x3f\x3f",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x33\x56\xcb\xae\xd1\xa1\xc1\x8b\x6b\xaa\x4f\xfe\x34\x3f\x77\x7c\x9e\x15\x12\x8f\x25\x1a"
          "\xb6\x5b\x94\x9f\x7b\x26\xef\x71\x57\xf2\x96\xdd\x2f\xa9\xdf\x95\xe3\xee\x7a\x5b\xe0\x2e"
          "\xc3\x2b\xa5\x85\x50\x5a\xf3\x16\xc2\xf9\xde\xd2\x7c\xdb\xd9\x35\xe4\x41\xce\x11\x15\xfd"
          "\x0a\x80\xbb\x7a\xef\x67\x68\x98\x94\x16\xb8\xfa\xc8\xc2",
          1, 640 },
        { 200, 256, 7,
          "\x67\xc6\x69\x73\x51\xff\x4a\xec\x29\xcd\xba\xab\xf2\xfb\xe3\x46\x7c\xc2\x54\xf8\x1b\xe8"
          "\xe7\x8d\x76\x5a\x2e\x63\x33\x9f\xc9\x9a",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f\x3f\x3f\x3f\x3f"
          "\x3f\x3f\x3f",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xb7\xa0\x40\x5e\xd0\xe5\xe4\x47\xba\x13\xf2\xb5\xa9\xed\x8a\x25\xe4\x3e\x8e\x62\xd7\xb3"
          "\xe6\x46\xc5\x71\xa1\xc6\xcd\x76\xea\x59\x3a\x49\x3d\xe2\xf9\x52\x91\x00\xaf\x20\x69\x60"
          "\xcc\xe8\x4b\x38\x0b\xb8\x42\xcd\x1b\x12\xac\xd9\x89\x50\x87\x46\x85\xd1\x57\x66\xfa\x65"
          "\x85\x98\xff\xb7\x89\x3f\x34\xff\x9f\xf1\x3d\x80\xe8\x54",
          1, 640 },
        { 200, 256, 8,
          "\xc2\x54\xf8\x1b\xe8\xe7\x8d\x76\x5a\x2e\x63\x33\x9f\xc9\x9a\x66\x32\x0d\xb7\x31\x58\xa3"
          "\x5a\x25\x5d\x05\x17\x58\xe9\x5e\xd4\xab",
          "\x67\xc6\x69\x73\x51\xff\x4a\xec\x29\xcd\xba\xab\xf2\xfb\xe3\x46\x7c\x3f\x3f\x3f\x3f\x3f"
          "\x3f\x3f\x3f",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x8d\x59\x00\x3c\xb9\x8f\xe2\x79\xc7\xe8\x85\x35\xef\xe5\xb5\x51\xde\xa5\xec\xb1\xca\xdc"
          "\x55\x5a\x3c\xd3\xa9\xb4\x32\x22\x34\xd9\x42\xe2\x99\x4a\x9b\x87\xfd\x46\x73\x54\xdc\x68"
          "\xea\xe8\xd4\xba\xdc\x1c\xb7\x44\x13\xa0\xa0\xa2\x18\x86\x3f\x35\x92\xd1\x1c\x8c\xae\xff"
          "\xa3\x1b\x4e\xe8\x6f\xc6\x49\x37\xf9\x8a\xc6\x90\x7c\x36",
          1, 640 },
        { 200, 256, 9,
          "\x8d\x76\x5a\x2e\x63\x33\x9f\xc9\x9a\x66\x32\x0d\xb7\x31\x58\xa3\x5a\x25\x5d\x05\x17\x58"
          "\xe9\x5e\xd4\xab\xb2\xcd\xc6\x9b\xb4\x54",
          "\x67\xc6\x69\x73\x51\xff\x4a\xec\x29\xcd\xba\xab\xf2\xfb\xe3\x46\x7c\x30\x25\x13\x38\x06"
          "\x3e\x23\x27",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xd8\x2e\x40\x78\x2c\x03\xa7\x1a\x90\xa5\x05\xc5\x8e\x61\x26\x8b\xe2\x5f\x61\xf6\x1f\xd4"
          "\x6d\x04\x0d\x9e\x48\x78\x38\xf3\x2f\x97\x46\x00\x4e\xac\xcc\x93\x09\x43\x92\x1a\x17\x42"
          "\x38\xf8\x8c\x9b\x7e\x90\xc2\x9f\x4a\x16\x0c\x2a\x43\x3b\xbb\xd9\x50\xee\x85\xd9\x7d\x1e"
          "\x3a\xb5\x57\xfb\x56\xd8\xb4\x34\x5c\x5c\x0b\x48\x67\x37",
          1, 640 },
        { 184, 256, 10,
          "\x67\xc6\x69\x73\x51\xff\x4a\xec\x29\xcd\xba\xab\xf2\xfb\xe3\x46\x7c\xc2\x54\xf8\x1b\xe8"
          "\xe7\x8d\x76\x5a\x2e\x63\x33\x9f\xc9\x9a",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
          "\xff",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xb7\xa0\x40\x5e\xd0\xe5\xe4\x47\xba\x13\xf2\xb5\xa9\xed\x8a\x25\xe4\x3e\x8e\x62\xd7\xb3"
          "\xe6\x46\xc5\x71\xa1\xc6\xcd\x76\xea\x59\x3a\x49\x3d\xe2\xf9\x52\x91\x00\xaf\x20\x69\x60"
          "\xcc\xe8\x4b\x38\x0b\xb8\x42\xcd\x1b\x12\xac\xd9\x89\x50\x87\x46\x85\xd1\x57\x66\xfa\x65"
          "\x85\x98\xff\xb7\x89\x3f\x34\xff\x9f\xf1\x3d\x80\xe8\x54",
          1, 640 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};
