#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.
import os, commands

def get_raw_lsb_release():
    return commands.getoutput('lsb_release -r')

def get_raw_lshw():
    return commands.getoutput('lshw')

def get_raw_lspci():
    return commands.getoutput('lspci')

def get_raw_lshw():
    return commands.getoutput('lshw')

def get_raw_cpuinfo():
    return commands.getoutput('cat /proc/cpuinfo')

def get_cpuinfo():
    return commands.getoutput('cat /proc/cpuinfo | grep "model name"')

def _get_parsed_lshw():
    lshw = []
    raw_lshw = get_raw_lshw().split()
    for i in raw_lshw: # IT'S NEEDED TO BE ROOT!
        lshw.append(''.join(i.split(':')))
    return lshw

def get_vendor():
    l = _get_parsed_lshw()
    for i in range(len(l)):
        if l[i] == 'vendor':
            return l[i+1]
    return None
    
def get_product():
    l = _get_parsed_lshw()
    for i in range(len(l)):
        if l[i] == 'product':
            return l[i+1]
    return None

def get_release():
    return get_raw_lsb_release().split()[1]

def get_cpu():
    return get_cpuinfo().split('\n')[0].split('\t: ')[1]

def get_memory():
    memory_tag_found = False
    l = _get_parsed_lshw()
    for i in range(len(l)):
        if l[i] == 'size' and memory_tag_found:
            return l[i+1]
        elif l[i] == '*-memory':
            memory_tag_found = True
        else:
            pass

class SystemInfo(object):
    @staticmethod
    def get_lspci():
        return get_raw_lspci()
    @staticmethod
    def get_cpuinfo():
        return get_raw_cpuinfo()
    @staticmethod
    def get_cpu():
        return get_cpu()
    @staticmethod
    def get_memory():
        return get_memory()
    @staticmethod
    def get_release():
        return get_release()            

