/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 * 
 * Contributions from:
 *     Ryan Wagoner <ryan@wgnrs.dynu.com>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

#define PLUGIN_NAME "File IMSpector logging plugin"
#define PLUGIN_SHORT_NAME "File"

extern "C"
{
	bool initloggingplugin(struct loggingplugininfo &ploggingplugininfo,
		class Options &options, bool debugmode);
	void closeloggingplugin(void);
	int logevents(std::vector<struct imevent> &imevents);
};

std::string fileloggingdir;
bool localdebugmode = false;

bool initloggingplugin(struct loggingplugininfo &loggingplugininfo,
	class Options &options, bool debugmode)
{
	fileloggingdir = options["file_logging_dir"];

	if (fileloggingdir.empty()) return false;

	localdebugmode = debugmode;

	loggingplugininfo.pluginname = PLUGIN_NAME;
		
	return true;
}

void closeloggingplugin(void)
{
	return;
}

/* The main plugin function. See loggingplugin.cpp. */
int logevents(std::vector<struct imevent> &imevents)
{
	for (std::vector<struct imevent>::iterator i = imevents.begin();
		i != imevents.end(); i++)
	{
		FILE *hfile = NULL;
		std::string filename = fileloggingdir;
		
		filename += "/" + (*i).protocolname;
		if (strstr(filename.c_str(), "..")) return 1;
		if (mkdir(filename.c_str(), 0777) < 0)
		{
			if (errno != EEXIST) return 1;
		}

		filename += "/" + (*i).localid;
		
		if (strstr(filename.c_str(), "..")) return 1;
		if (mkdir(filename.c_str(), 0777) < 0)
		{
			if (errno != EEXIST) return 1;
		}
		
		filename += "/" + (*i).remoteid;
		if (strstr(filename.c_str(), "..")) return 1;
		if (mkdir(filename.c_str(), 0777) < 0)
		{
			if (errno != EEXIST) return 1;
		}
		
		char date[STRING_SIZE];
		memset(date, 0, STRING_SIZE);
		
		if (!strftime(date, STRING_SIZE, "%F", localtime(&(*i).timestamp)))
			return 1;
		
		std::string datestring = date;
		filename += "/" + datestring;
		if (!(hfile = fopen(filename.c_str(), "a"))) return 1;
		
		fprintf(hfile, "%s,", (*i).clientaddress.c_str());
		fprintf(hfile, "%ld,", (*i).timestamp);
		fprintf(hfile, "%d,", (*i).outgoing ? 1 : 0);
		fprintf(hfile, "%d,", (*i).type);
		fprintf(hfile, "%d,", (*i).filtered ? 1 : 0);
		fprintf(hfile, "%s,", (*i).categories.c_str());
		
		std::string eventdata = (*i).eventdata;
		
		size_t pos = 0;
		while ((pos = eventdata.find("\n"), pos) != std::string::npos)
			eventdata.replace(pos, 1, "\\n");
		
		fprintf(hfile, "%s", eventdata.c_str());
		fprintf(hfile, "\n");
		
		fclose(hfile);
	}

	return 0;
}
