{- This module was generated from data in the Kate syntax
   highlighting file lilypond.xml, version 4, by Wilbert Berendsen (info@wilbertberendsen.nl) -}

module Text.Highlighting.Kate.Syntax.Lilypond
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "LilyPond"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.ly;*.LY;*.ily;*.ILY;*.lyi;*.LYI"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("LilyPond","lilypond")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("LilyPond","lilypond") -> return ()
      ("LilyPond","music") -> return ()
      ("LilyPond","default") -> return ()
      ("LilyPond","basic") -> return ()
      ("LilyPond","musiccommand") -> (popContext) >> pEndLine
      ("LilyPond","command") -> (popContext) >> pEndLine
      ("LilyPond","assignment") -> (popContext) >> pEndLine
      ("LilyPond","pitch") -> return ()
      ("LilyPond","duration") -> return ()
      ("LilyPond","chord") -> return ()
      ("LilyPond","chordpitch") -> return ()
      ("LilyPond","chordend") -> return ()
      ("LilyPond","commentline") -> (popContext) >> pEndLine
      ("LilyPond","commentblock") -> return ()
      ("LilyPond","string") -> return ()
      ("LilyPond","connect") -> return ()
      ("LilyPond","scheme") -> return ()
      ("LilyPond","scheme2") -> (popContext >> popContext) >> pEndLine
      ("LilyPond","scheme3") -> return ()
      ("LilyPond","schemerules") -> return ()
      ("LilyPond","schemequote") -> (popContext) >> pEndLine
      ("LilyPond","schemelily") -> return ()
      ("LilyPond","schemecommentline") -> (popContext) >> pEndLine
      ("LilyPond","schemecommentblock") -> return ()
      ("LilyPond","schemesub") -> (popContext) >> pEndLine
      ("LilyPond","schemestring") -> return ()
      ("LilyPond","notemode") -> return ()
      ("LilyPond","notemode2") -> return ()
      ("LilyPond","noterules") -> return ()
      ("LilyPond","drummode") -> return ()
      ("LilyPond","drummode2") -> return ()
      ("LilyPond","drumrules") -> return ()
      ("LilyPond","drumchord") -> return ()
      ("LilyPond","chordmode") -> return ()
      ("LilyPond","chordmode2") -> return ()
      ("LilyPond","chordrules") -> return ()
      ("LilyPond","figuremode") -> return ()
      ("LilyPond","figuremode2") -> return ()
      ("LilyPond","figurerules") -> return ()
      ("LilyPond","figure") -> return ()
      ("LilyPond","lyricmode") -> return ()
      ("LilyPond","lyricmode2") -> return ()
      ("LilyPond","lyricsto") -> return ()
      ("LilyPond","lyricsto2") -> return ()
      ("LilyPond","lyricsto3") -> return ()
      ("LilyPond","lyricrules") -> return ()
      ("LilyPond","markup") -> return ()
      ("LilyPond","markup2") -> return ()
      ("LilyPond","markuprules") -> return ()
      ("LilyPond","section") -> return ()
      ("LilyPond","section2") -> return ()
      ("LilyPond","sectionrules") -> return ()
      ("LilyPond","context") -> return ()
      ("LilyPond","context2") -> return ()
      ("LilyPond","set") -> return ()
      ("LilyPond","override") -> return ()
      ("LilyPond","tempo") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_contexts = Set.fromList $ words $ "ChoirStaff ChordNames CueVoice Devnull DrumStaff DrumVoice Dynamics FiguredBass FretBoards Global GrandStaff GregorianTranscriptionStaff GregorianTranscriptionVoice Lyrics MensuralStaff MensuralVoice NoteNames PianoStaff RhythmicStaff Score Staff StaffGroup TabStaff TabVoice Timing VaticanaStaff VaticanaVoice Voice"
list_deprecatedcontexts = Set.fromList $ words $ "InnerChoirStaff InnerStaffGroup"
list_layoutobjects = Set.fromList $ words $ "Accidental AccidentalCautionary AccidentalPlacement AccidentalSuggestion Ambitus AmbitusAccidental AmbitusLine AmbitusNoteHead Arpeggio BalloonTextItem BarLine BarNumber BassFigure BassFigureAlignment BassFigureAlignmentPositioning BassFigureBracket BassFigureContinuation BassFigureLine Beam BendAfter BreakAlignGroup BreakAlignment BreathingSign ChordName Clef ClusterSpanner ClusterSpannerBeacon CombineTextScript Custos DotColumn Dots DoublePercentRepeat DoublePercentRepeatCounter DynamicLineSpanner DynamicText DynamicTextSpanner Episema Fingering FretBoard Glissando GraceSpacing GridLine GridPoint Hairpin HarmonicParenthesesItem HorizontalBracket InstrumentName InstrumentSwitch KeyCancellation KeySignature LaissezVibrerTie LaissezVibrerTieColumn LedgerLineSpanner LeftEdge LigatureBracket LyricExtender LyricHyphen LyricSpace LyricText MeasureGrouping MelodyItem MensuralLigature MetronomeMark MultiMeasureRest MultiMeasureRestNumber MultiMeasureRestText NonMusicalPaperColumn NoteCollision NoteColumn NoteHead NoteName NoteSpacing OctavateEight OttavaBracket PaperColumn ParenthesesItem PercentRepeat PercentRepeatCounter PhrasingSlur PianoPedalBracket RehearsalMark RepeatSlash RepeatTie RepeatTieColumn Rest RestCollision Script ScriptColumn ScriptRow SeparationItem Slur SostenutoPedal SostenutoPedalLineSpanner SpacingSpanner SpanBar StaffGrouper StaffSpacing StaffSymbol StanzaNumber Stem StemTremolo StringNumber StrokeFinger SustainPedal SustainPedalLineSpanner System SystemStartBar SystemStartBrace SystemStartBracket SystemStartSquare TabNoteHead TextScript TextSpanner Tie TieColumn TimeSignature TrillPitchAccidental TrillPitchGroup TrillPitchHead TrillSpanner TupletBracket TupletNumber UnaCordaPedal UnaCordaPedalLineSpanner VaticanaLigature VerticalAlignment VerticalAxisGroup VoiceFollower VoltaBracket VoltaBracketSpanner"
list_properties = Set.fromList $ words $ "aDueText alignAboveContext alignBassFigureAccidentals alignBelowContext allowBeamBreak associatedVoice autoAccidentals autoBeamCheck autoBeamSettings autoBeaming autoCautionaries automaticBars barAlways barCheckSynchronize barNumberVisibility baseMoment bassFigureFormatFunction bassStaffProperties beamExceptions beatGrouping beatLength beatStructure chordChanges chordNameExceptions chordNameExceptionsFull chordNameExceptionsPartial chordNameFunction chordNameSeparator chordNoteNamer chordPrefixSpacer chordRootNamer clefGlyph clefOctavation clefPosition connectArpeggios countPercentRepeats createKeyOnClefChange createSpacing crescendoSpanner crescendoText currentBarNumber decrescendoSpanner decrescendoText defaultBarType doubleSlurs doubleRepeatType drumPitchTable drumStyleTable dynamicAbsoluteVolumeFunction explicitClefVisibility explicitKeySignatureVisibility extendersOverRests extraNatural figuredBassAlterationDirection figuredBassCenterContinuations figuredBassFormatter figuredBassPlusDirection fingeringOrientations firstClef followVoice fontSize forbidBreak forceClef gridInterval hairpinToBarline harmonicAccidentals highStringOne ignoreBarChecks ignoreFiguredBassRest ignoreMelismata implicitBassFigures implicitTimeSignatureVisibility instrumentCueName instrumentEqualizer instrumentName instrumentTransposition internalBarNumber keepAliveInterfaces keyAlterationOrder keySignature lyricMelismaAlignment majorSevenSymbol markFormatter maximumFretStretch measureLength measurePosition melismaBusyProperties metronomeMarkFormatter middleCClefPosition middleCOffset middleCPosition midiInstrument midiMaximumVolume midiMinimumVolume minimumFret minimumPageTurnLength minimumRepeatLengthForPageTurn noteToFretFunction ottavation output pedalSostenutoStrings pedalSostenutoStyle pedalSustainStrings pedalSustainStyle pedalUnaCordaStrings pedalUnaCordaStyle printKeyCancellation printOctaveNames printPartCombineTexts proportionalNotationDuration recordEventSequence rehearsalMark repeatCommands restNumberThreshold scriptDefinitions shapeNoteStyles shortInstrumentName shortVocalName skipBars skipTypesetting soloIIText soloText squashedPosition staffLineLayoutFunction stanza stemLeftBeamCount stemRightBeamCount stringNumberOrientations stringOneTopmost stringTunings strokeFingerOrientations subdivideBeams suggestAccidentals systemStartDelimiter systemStartDelimiterHierarchy tablatureFormat tempoUnitCount tempoUnitDuration tempoWholesPerMinute tieWaitForNote timeSignatureFraction timing tonic topLevelAlignment trebleStaffProperties tremoloFlags tupletFullLength tupletFullLengthNote tupletSpannerDuration useBassFigureExtenders verticallySpacedContexts vocalName voltaOnThisStaff voltaSpannerDuration whichBar"
list_deprecatedproperties = Set.fromList $ words $ "barNumberAlignSymbol centralCPosition extraVerticalExtent fingerHorizontalDirection instr instrument keyAccidentalOrder minimumVerticalExtent rehearsalMarkAlignSymbol soloADue tupletNumberFormatFunction vocNam"
list_musicexpressions = Set.fromList $ words $ "AbsoluteDynamicEvent AnnotateOutputEvent ApplyContext ApplyOutputEvent ArpeggioEvent ArticulationEvent AutoChangeMusic BarCheck BassFigureEvent BeamEvent BeamForbidEvent BendAfterEvent BreathingEvent ClusterNoteEvent ContextChange ContextSpeccedMusic CrescendoEvent DecrescendoEvent Event EventChord ExtenderEvent FingeringEvent GlissandoEvent GraceMusic HarmonicEvent HyphenEvent KeyChangeEvent LabelEvent LaissezVibrerEvent LigatureEvent LineBreakEvent LyricCombineMusic LyricEvent MarkEvent MultiMeasureRestEvent MultiMeasureRestMusic MultiMeasureTextEvent Music NoteEvent NoteGroupingEvent OverrideProperty PageBreakEvent PageTurnEvent PartCombineMusic PercentEvent PercentRepeatedMusic PesOrFlexaEvent PhrasingSlurEvent PropertySet PropertyUnset QuoteMusic RelativeOctaveCheck RelativeOctaveMusic RepeatTieEvent RepeatedMusic RestEvent RevertProperty ScriptEvent SequentialMusic SimultaneousMusic SkipEvent SkipMusic SlurEvent SoloOneEvent SoloTwoEvent SostenutoEvent SpacingSectionEvent SpanEvent StaffSpanEvent StringNumberEvent StrokeFingerEvent SustainEvent TextScriptEvent TextSpanEvent TieEvent TimeScaledMusic TransposedMusic TremoloEvent TremoloRepeatedMusic TremoloSpanEvent TrillSpanEvent TupletSpanEvent UnaCordaEvent UnfoldedRepeatedMusic UnisonoEvent UnrelativableMusic VoiceSeparator VoltaRepeatedMusic"
list_drumpitchnames = Set.fromList $ words $ "acousticbassdrum acousticsnare agh agl bassdrum bd bda boh bohm boho bol bolm bolo cab cabasa cb cgh cghm cgho cgl cglm cglo chinesecymbal cl claves closedhihat cowbell crashcymbal crashcymbala crashcymbalb cuim cuio cymc cymca cymcb cymch cymr cymra cymrb cyms da db dc dd de electricsnare fivedown fiveup fourdown fourup gui guil guiro guis halfopenhihat handclap hc hh hhc hhho hho hhp hiagogo hibongo hiconga highfloortom hightom hihat himidtom hisidestick hitimbale hiwoodblock loagogo lobongo loconga longguiro longwhistle losidestick lotimbale lowfloortom lowmidtom lowoodblock lowtom mar maracas mutecuica mutehibongo mutehiconga mutelobongo muteloconga mutetriangle onedown oneup opencuica openhibongo openhiconga openhihat openlobongo openloconga opentriangle pedalhihat rb ridebell ridecymbal ridecymbala ridecymbalb shortguiro shortwhistle sidestick sn sna snare sne splashcymbal ss ssh ssl tamb tambourine tamtam threedown threeup timh timl tomfh tomfl tomh toml tommh tomml tri triangle trim trio tt twodown twoup ua ub uc ud ue vibraslap vibs wbh wbl whl whs"

regex_'5cb'5ba'2dz'5d'2b'5cs'2a'3d = compileRegex True "\\b[a-z]+\\s*="
regex_'5ba'2dz'5d'2b'5cd'2b'5c'2e'2a'5b'2c'27'5d'2b = compileRegex True "[a-z]+\\d+\\.*[,']+"
regex_'28'5cb'5bsrR'5d'28'3f'21'5bA'2dZa'2dz'5d'29'7c'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29 = compileRegex True "(\\b[srR](?![A-Za-z])|\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z])))"
regex_'3a'5cd'2a = compileRegex True ":\\d*"
regex_'5c'5c'28p'7b1'2c5'7d'7cmp'7cmf'7cf'7b1'2c5'7d'7cs'3ffp'7csff'3f'7cspp'3f'7c'5bsr'5d'3ffz'7ccresc'7cdecresc'7cdim'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(p{1,5}|mp|mf|f{1,5}|s?fp|sff?|spp?|[sr]?fz|cresc|decresc|dim)(?![A-Za-z])"
regex_'5c'5c'5b'3c'21'3e'5d = compileRegex True "\\\\[<!>]"
regex_'5c'5c'28'5cd'2b'7caccent'7cmarcato'7cstaccat'28issim'29'3fo'7cespressivo'7ctenuto'7cportato'7c'28up'7cdown'29'28bow'7cmordent'7cprall'29'7cflageolet'7cthumb'7c'5blr'5d'28heel'7ctoe'29'7copen'7cstopped'7cturn'7creverseturn'7ctrill'7cmordent'7cprall'28prall'7cmordent'7cdown'7cup'29'3f'7clineprall'7csignumcongruentiae'7c'28short'7clong'7cverylong'29'3ffermata'7csegno'7c'28var'29'3fcoda'7csnappizzicato'7chalfopen'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(\\d+|accent|marcato|staccat(issim)?o|espressivo|tenuto|portato|(up|down)(bow|mordent|prall)|flageolet|thumb|[lr](heel|toe)|open|stopped|turn|reverseturn|trill|mordent|prall(prall|mordent|down|up)?|lineprall|signumcongruentiae|(short|long|verylong)?fermata|segno|(var)?coda|snappizzicato|halfopen)(?![A-Za-z])"
regex_'5c'5c'5b'28'29'5d = compileRegex True "\\\\[()]"
regex_'5c'5c'5b'5d'5b'5d = compileRegex True "\\\\[][]"
regex_'5c'5cnote'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\note(mode|s)(?![A-Za-z])"
regex_'5c'5cdrum'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\drum(mode|s)(?![A-Za-z])"
regex_'5c'5cchord'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\chord(mode|s)(?![A-Za-z])"
regex_'5c'5cfigure'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\figure(mode|s)(?![A-Za-z])"
regex_'5c'5c'28lyric'28mode'7cs'29'7caddlyrics'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(lyric(mode|s)|addlyrics)(?![A-Za-z])"
regex_'5c'5clyricsto'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\lyricsto(?![A-Za-z])"
regex_'5c'5cmarkup'28lines'29'3f'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\markup(lines)?(?![A-Za-z])"
regex_'5c'5c'28header'7cpaper'7clayout'7cmidi'7cwith'29'5cb = compileRegex True "\\\\(header|paper|layout|midi|with)\\b"
regex_'5c'5c'28new'7ccontext'7cchange'29'5cb = compileRegex True "\\\\(new|context|change)\\b"
regex_'5c'5c'28un'29'3fset'5cb = compileRegex True "\\\\(un)?set\\b"
regex_'5c'5c'28override'28Property'29'3f'7crevert'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(override(Property)?|revert)(?![A-Za-z])"
regex_'5c'5cskip'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\skip(?![A-Za-z])"
regex_'5c'5ctempo'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\tempo(?![A-Za-z])"
regex_'5c'5c'28accepts'7calias'7cconsists'7cdefaultchild'7cdenies'7cdescription'7cgrobdescriptions'7cinclude'7cinvalid'7clanguage'7cname'7cobjectid'7conce'7cremove'7csequential'7csimultaneous'7ctype'7cversion'7cscore'7cbook'7cbookpart'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(accepts|alias|consists|defaultchild|denies|description|grobdescriptions|include|invalid|language|name|objectid|once|remove|sequential|simultaneous|type|version|score|book|bookpart)(?![A-Za-z])"
regex_'5c'5c'28'28aiken'7cfunk'7csacredHarp'7csouthernHarmony'7cwalker'29Heads'28Minor'29'3f'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\((aiken|funk|sacredHarp|southernHarmony|walker)Heads(Minor)?)(?![A-Za-z])"
regex_'5c'5c'28acciaccatura'7caddQuote'7cafterGrace'7callowPageTurn'7calternative'7capply'28Context'7cMusic'7cOutput'29'7cappoggiatura'7carpeggio'28Arrow'28Down'7cUp'29'7cBracket'7cNormal'7cParenthesis'29'3f'7c'28a'7cde'29scendens'7cauctum'7caugmentum'7cautoBeamO'28ff'7cn'29'7cautochange'7cballoon'28Grob'29'3fText'7cbar'7cbarNumberCheck'7cbendAfter'7cbreathe'7cbreak'7ccadenzaO'28ff'7cn'29'7ccavum'7cclef'28'5cs'2b'28treble'7cviolin'7cG'7calto'7cC'7ctenor'7c'28sub'29'3fbass'7cF'7cfrench'7c'28mezzo'29'3fsoprano'7c'28var'29'3fbaritone'7cpercussion'7ctab'29'29'3f'7c'28end'29'3f'28de'29'3fcr'7ccresc'28TextCresc'7cHairpin'29'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(acciaccatura|addQuote|afterGrace|allowPageTurn|alternative|apply(Context|Music|Output)|appoggiatura|arpeggio(Arrow(Down|Up)|Bracket|Normal|Parenthesis)?|(a|de)scendens|auctum|augmentum|autoBeamO(ff|n)|autochange|balloon(Grob)?Text|bar|barNumberCheck|bendAfter|breathe|break|cadenzaO(ff|n)|cavum|clef(\\s+(treble|violin|G|alto|C|tenor|(sub)?bass|F|french|(mezzo)?soprano|(var)?baritone|percussion|tab))?|(end)?(de)?cr|cresc(TextCresc|Hairpin))(?![A-Za-z])"
regex_'5c'5c'28'28cue'7ctransposedCue'29During'7cdefault'7cdeminutum'7cdim'28Text'28Decresc'7cDecr'7cDim'29'7cHairpin'29'7cdisplay'28Lily'29'3fMusic'7cdivisio'28Maior'7cMaxima'7cMinima'29'7c'28dynamic'7cdots'7cphrasingSlur'7cslur'7cstem'7ctie'7ctuplet'29'28Down'7cNeutral'7cUp'29'7c'28balloon'7ctext'29LengthO'28ff'7cn'29'7cfeatherDurations'7cfigure'28mode'7cs'29'7cfinalis'7cflexa'7c'28french'7cgerman'7citalian'7csemiGerman'29Chords'7cglissando'7cgrace'7charmonic'7c'28unH'7ch'29ideNotes'7c'28hide'7cshow'29StaffSwitch'7cinclinatum'7c'28keep'7cremove'29WithTag'7ckey'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f'7ckillCues'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\((cue|transposedCue)During|default|deminutum|dim(Text(Decresc|Decr|Dim)|Hairpin)|display(Lily)?Music|divisio(Maior|Maxima|Minima)|(dynamic|dots|phrasingSlur|slur|stem|tie|tuplet)(Down|Neutral|Up)|(balloon|text)LengthO(ff|n)|featherDurations|figure(mode|s)|finalis|flexa|(french|german|italian|semiGerman)Chords|glissando|grace|harmonic|(unH|h)ideNotes|(hide|show)StaffSwitch|inclinatum|(keep|remove)WithTag|key(\\s+\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z])))?|killCues)(?![A-Za-z])"
regex_'5c'5c'28label'7claissezVibrer'7clinea'7cmakeClusters'7cmark'7cmaxima'7cmelisma'28End'29'3f'7cmergeDifferently'28Head'7cDott'29edO'28ff'7cn'29'7cnewSpacingSection'7cno'28Beam'7cBreak'7cPageBreak'7cPageTurn'29'7cnormalsize'7cnumericTimeSignature'7coctaveCheck'7coneVoice'7coriscus'7cottava'7cpage'28'2dref'7cBreak'7cTurn'29'7cparallelMusic'7cparenthesize'7cpartcombine'7cpartial'28'5cs'2a'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a'29'3f'7cpes'7cpitchedTrill'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(label|laissezVibrer|linea|makeClusters|mark|maxima|melisma(End)?|mergeDifferently(Head|Dott)edO(ff|n)|newSpacingSection|no(Beam|Break|PageBreak|PageTurn)|normalsize|numericTimeSignature|octaveCheck|oneVoice|oriscus|ottava|page(-ref|Break|Turn)|parallelMusic|parenthesize|partcombine|partial(\\s*(\\\\(longa|breve)\\b|(1|2|4|8|16|32|64|128|256|512|1024|2048)(?!\\d))(\\s*\\.+)?(\\s*\\*\\s*\\d+(/\\d+)?)*)?|pes|pitchedTrill)(?![A-Za-z])"
regex_'5c'5c'28pointAndClickO'28ff'7cn'29'7cquilisma'7cquoteDuring'7crelative'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f'7cRemoveEmptyStaffContext'7crepeat'28'5cs'2b'28unfold'7cvolta'7ctremolo'7cpercent'29'28'5cs'2b'5cd'2b'29'3f'29'3f'7crepeatTie'7cresetRelativeOctave'7crest'7cscaleDurations'7cscoreTweak'7ceasyHeadsO'28ff'7cn'29'7cshift'28Durations'7cOff'7cOn'7b1'2c3'7d'29'7c'28slur'7ctie'29'28Both'7cDashed'7cDotted'7cSolid'29'7csmall'7cspacingTweaks'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(pointAndClickO(ff|n)|quilisma|quoteDuring|relative(\\s+\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z])))?|RemoveEmptyStaffContext|repeat(\\s+(unfold|volta|tremolo|percent)(\\s+\\d+)?)?|repeatTie|resetRelativeOctave|rest|scaleDurations|scoreTweak|easyHeadsO(ff|n)|shift(Durations|Off|On{1,3})|(slur|tie)(Both|Dashed|Dotted|Solid)|small|spacingTweaks)(?![A-Za-z])"
regex_'5c'5c'28'28start'7cstop'29'28Group'7c'28Text'7cTrill'29Span'7cStaff'29'7cstemBoth'7cstropha'7csuper'7c'28sustain'7csostenuto'29O'28ff'7cn'29'7ctable'2dof'2dcontents'7ctag'7ctimes'3f'28'5cs'2a'5cd'2b'2f'5cd'2b'29'3f'7ctiny'7ctocItem'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\((start|stop)(Group|(Text|Trill)Span|Staff)|stemBoth|stropha|super|(sustain|sostenuto)O(ff|n)|table-of-contents|tag|times?(\\s*\\d+/\\d+)?|tiny|tocItem)(?![A-Za-z])"
regex_'5c'5c'28transpose'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'5cs'2a'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f'7ctransposition'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(transpose(\\s+\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z]))\\s*\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z])))?|transposition(\\s+\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z]))))(?![A-Za-z])"
regex_'5c'5c'28tweak'7cunfoldRepeats'7cvirg'28ul'29'3fa'7cvoice'28One'7cTwo'7cThree'7cFour'29'7cwithMusicProperty'7ccm'7cmm'7cin'7cpt'7cmajor'7cminor'7cionian'7clocrian'7caeolian'7cmixolydian'7clydian'7cphrygian'7cdorian'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(tweak|unfoldRepeats|virg(ul)?a|voice(One|Two|Three|Four)|withMusicProperty|cm|mm|in|pt|major|minor|ionian|locrian|aeolian|mixolydian|lydian|phrygian|dorian)(?![A-Za-z])"
regex_'5c'5c'28dash'28Hat'7cPlus'7cDash'7cBar'7cLarger'7cDot'7cUnderscore'29'7cfermataMarkup'7cpipeSymbol'7cslashSeparator'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(dash(Hat|Plus|Dash|Bar|Larger|Dot|Underscore)|fermataMarkup|pipeSymbol|slashSeparator)(?![A-Za-z])"
regex_'5c'5c'28consistsend'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(consistsend)(?![A-Za-z])"
regex_'5c'5c'28arpeggio'28Up'7cDown'7cNeutral'29'7cnewpage'7cscript'28Up'7cDown'7cBoth'29'7c'28empty'7cfat'29Text'7csetEasyHeads'7c'28default'7cvoice'7cmodernVoice'7cpiano'7cforget'29Accidentals'7c'28modern'28Voice'29'3f'7cpiano'29Cautionaries'7cnoResetKey'7ccompressMusic'7coctave'7c'28sustain'7csostenuto'29'28Down'7cUp'29'7cset'28Hairpin'7cText'29'28Cresc'7cDecresc'7cDim'29'7csetTextDecr'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(arpeggio(Up|Down|Neutral)|newpage|script(Up|Down|Both)|(empty|fat)Text|setEasyHeads|(default|voice|modernVoice|piano|forget)Accidentals|(modern(Voice)?|piano)Cautionaries|noResetKey|compressMusic|octave|(sustain|sostenuto)(Down|Up)|set(Hairpin|Text)(Cresc|Decresc|Dim)|setTextDecr)(?![A-Za-z])"
regex_'5c'5c'28translator'7cnewcontext'29'5cb = compileRegex True "\\\\(translator|newcontext)\\b"
regex_'5c'5cproperty'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\property(?![A-Za-z])"
regex_'5c'5c'5bA'2dZa'2dz'5d'2b = compileRegex True "\\\\[A-Za-z]+"
regex_'5cb'28dash'28Hat'7cPlus'7cDash'7cBar'7cLarger'7cDot'7cUnderscore'29'7cfermataMarkup'7cpipeSymbol'7cslashSeparator'29'5cb = compileRegex True "\\b(dash(Hat|Plus|Dash|Bar|Larger|Dot|Underscore)|fermataMarkup|pipeSymbol|slashSeparator)\\b"
regex_'5ba'2dz'5d'2b = compileRegex True "[a-z]+"
regex_'3d'5cs'2a'28'27'2b'7c'2c'2b'29'3f = compileRegex True "=\\s*('+|,+)?"
regex_'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a = compileRegex True "(\\\\(longa|breve)\\b|(1|2|4|8|16|32|64|128|256|512|1024|2048)(?!\\d))(\\s*\\.+)?(\\s*\\*\\s*\\d+(/\\d+)?)*"
regex_'5cd'2b = compileRegex True "\\d+"
regex_'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29 = compileRegex True "\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z]))"
regex_'5b'2d'2b'5d'3f'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29 = compileRegex True "[-+]?(\\d+(\\.\\d+)?|\\.\\d+)"
regex_'23'28t'7cf'7cb'5b'2d'2b'5d'3f'5b01'2e'5d'2b'7co'5b'2d'2b'5d'3f'5b0'2d7'2e'5d'2b'7cd'5b'2d'2b'5d'3f'5b0'2d9'2e'5d'2b'7cx'5b'2d'2b'5d'3f'5b0'2d9a'2df'2e'5d'2b'29 = compileRegex True "#(t|f|b[-+]?[01.]+|o[-+]?[0-7.]+|d[-+]?[0-9.]+|x[-+]?[0-9a-f.]+)"
regex_'5b'2b'2d'5d'28inf'7cnan'29'5c'2e0 = compileRegex True "[+-](inf|nan)\\.0"
regex_'5cb'28define'7cdefined'5c'3f'7cdefine'5c'2a'28'2dpublic'29'3f'7cdefine'2d'28'5c'2a'7cbuiltin'2dmarkup'2d'28list'2d'29'3fcommand'7cclass'7c'28extra'2d'29'3fdisplay'2dmethod'7cfonts'3f'7cgrob'2dproperty'7cly'2dsyntax'28'2dloc'7c'2dsimple'29'3f'7cmacro'28'2dpublic'29'3f'7cmarkup'2d'28list'2d'29command'7cmethod'7cmodule'7cmusic'2dfunction'7cpost'2devent'2ddisplay'2dmethod'7cpublic'28'2dmacro'7c'2dtoplevel'29'3f'7csafe'2dpublic'7cspan'2devent'2ddisplay'2dmethod'29'7cdefmacro'28'5c'2a'28'2dpublic'29'3f'29'3f'7clambda'5c'2a'3f'7cand'7cor'7cif'7ccond'7ccase'7clet'5c'2a'3f'7cletrec'7cbegin'7cdo'7cdelay'7cset'21'7celse'7c'28quasi'29'3fquote'7cunquote'28'2dsplicing'29'3f'7c'28define'7clet'7cletrec'29'2dsyntax'7csyntax'2drules'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 = compileRegex True "\\b(define|defined\\?|define\\*(-public)?|define-(\\*|builtin-markup-(list-)?command|class|(extra-)?display-method|fonts?|grob-property|ly-syntax(-loc|-simple)?|macro(-public)?|markup-(list-)command|method|module|music-function|post-event-display-method|public(-macro|-toplevel)?|safe-public|span-event-display-method)|defmacro(\\*(-public)?)?|lambda\\*?|and|or|if|cond|case|let\\*?|letrec|begin|do|delay|set!|else|(quasi)?quote|unquote(-splicing)?|(define|let|letrec)-syntax|syntax-rules)(?=($|\\s|\\)))"
regex_'5cb'28not'7cboolean'5c'3f'7ceq'5c'3f'7ceqv'5c'3f'7cequal'5c'3f'7cpair'5c'3f'7ccons'7cset'2dc'5bad'5dr'21'7cc'5bad'5d'7b1'2c4'7dr'7cnull'5c'3f'7clist'5c'3f'7clist'7clength'7cappend'7creverse'7clist'2dref'7cmem'5bqv'5d'7cmember'7cass'5bqv'5d'7cassoc'7csymbol'5c'3f'7csymbol'2d'3estring'7cstring'2d'3esymbol'7cnumber'5c'3f'7ccomplex'5c'3f'7creal'5c'3f'7crational'5c'3f'7cinteger'5c'3f'7cexact'5c'3f'7cinexact'5c'3f'7czero'5c'3f'7cpositive'5c'3f'7cnegative'5c'3f'7codd'5c'3f'7ceven'5c'3f'7cmax'7cmin'7cabs'7cquotient'7cremainder'7cmodulo'7cgcd'7clcm'7cnumerator'7cdenominator'7cfloor'7cceiling'7ctruncate'7cround'7crationalize'7cexp'7clog'7csin'7ccos'7ctan'7casin'7cacos'7catan'7csqrt'7cexpt'7cmake'2drectangular'7cmake'2dpolar'7creal'2dpart'7cimag'2dpart'7cmagnitude'7cangle'7cexact'2d'3einexact'7cinexact'2d'3eexact'7cnumber'2d'3estring'7cstring'2d'3enumber'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 = compileRegex True "\\b(not|boolean\\?|eq\\?|eqv\\?|equal\\?|pair\\?|cons|set-c[ad]r!|c[ad]{1,4}r|null\\?|list\\?|list|length|append|reverse|list-ref|mem[qv]|member|ass[qv]|assoc|symbol\\?|symbol->string|string->symbol|number\\?|complex\\?|real\\?|rational\\?|integer\\?|exact\\?|inexact\\?|zero\\?|positive\\?|negative\\?|odd\\?|even\\?|max|min|abs|quotient|remainder|modulo|gcd|lcm|numerator|denominator|floor|ceiling|truncate|round|rationalize|exp|log|sin|cos|tan|asin|acos|atan|sqrt|expt|make-rectangular|make-polar|real-part|imag-part|magnitude|angle|exact->inexact|inexact->exact|number->string|string->number)(?=($|\\s|\\)))"
regex_'5cb'28char'28'28'2dci'29'3f'28'3d'5c'3f'7c'3c'5c'3f'7c'3e'5c'3f'7c'3c'3d'5c'3f'7c'3e'3d'5c'3f'29'7c'2dalphabetic'5c'3f'7c'5c'3f'7c'2dnumeric'5c'3f'7c'2dwhitespace'5c'3f'7c'2dupper'2dcase'5c'3f'7c'2dlower'2dcase'5c'3f'7c'2d'3einteger'7c'2dupcase'7c'2ddowncase'7c'2dready'5c'3f'29'7cinteger'2d'3echar'7cmake'2dstring'7cstring'28'5c'3f'7c'2dcopy'7c'2dfill'21'7c'2dlength'7c'2dref'7c'2dset'21'7c'28'2dci'29'3f'28'3d'5c'3f'7c'3c'5c'3f'7c'3e'5c'3f'7c'3c'3d'5c'3f'7c'3e'3d'5c'3f'29'7c'2dappend'29'7csubstring'7cmake'2dvector'7cvector'28'5c'3f'7c'2dlength'7c'2dref'7c'2dset'21'7c'2dfill'21'29'3f'7cprocedure'5c'3f'7capply'7cmap'7cfor'2deach'7cforce'7ccall'2dwith'2d'28current'2dcontinuation'7c'28in'7cout'29put'2dfile'29'7c'28in'7cout'29put'2dport'5c'3f'7ccurrent'2d'28in'7cout'29put'2dport'7copen'2d'28in'7cout'29put'2dfile'7cclose'2d'28in'7cout'29put'2dport'7ceof'2dobject'5c'3f'7cread'7c'28read'7cpeek'29'2dchar'7cwrite'28'2dchar'29'3f'7cdisplay'7cnewline'7ccall'2fcc'7clist'2dtail'7cstring'2d'3elist'7clist'2d'3estring'7cvector'2d'3elist'7clist'2d'3evector'7cwith'2dinput'2dfrom'2dfile'7cwith'2doutput'2dto'2dfile'7cload'7ctranscript'2d'28on'7coff'29'7ceval'7cdynamic'2dwind'7cport'5c'3f'7cvalues'7ccall'2dwith'2dvalues'7c'28scheme'2dreport'2d'7cnull'2d'7cinteraction'2d'29environment'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 = compileRegex True "\\b(char((-ci)?(=\\?|<\\?|>\\?|<=\\?|>=\\?)|-alphabetic\\?|\\?|-numeric\\?|-whitespace\\?|-upper-case\\?|-lower-case\\?|->integer|-upcase|-downcase|-ready\\?)|integer->char|make-string|string(\\?|-copy|-fill!|-length|-ref|-set!|(-ci)?(=\\?|<\\?|>\\?|<=\\?|>=\\?)|-append)|substring|make-vector|vector(\\?|-length|-ref|-set!|-fill!)?|procedure\\?|apply|map|for-each|force|call-with-(current-continuation|(in|out)put-file)|(in|out)put-port\\?|current-(in|out)put-port|open-(in|out)put-file|close-(in|out)put-port|eof-object\\?|read|(read|peek)-char|write(-char)?|display|newline|call/cc|list-tail|string->list|list->string|vector->list|list->vector|with-input-from-file|with-output-to-file|load|transcript-(on|off)|eval|dynamic-wind|port\\?|values|call-with-values|(scheme-report-|null-|interaction-)environment)(?=($|\\s|\\)))"
regex_'5ba'2dzA'2dZ'23'5d'5b'5e'5cs'28'29'7b'7d'5b'5c'5d'3b'24'22'5d'2a = compileRegex True "[a-zA-Z#][^\\s(){}[\\];$\"]*"
regex_'5c'5c'5b0fnrtav'5c'5c'22'5d = compileRegex True "\\\\[0fnrtav\\\\\"]"
regex_'3c'28'3f'21'3c'29 = compileRegex True "<(?!<)"
regex_'3a'3f'28'5b'5c'2e'5e'5d'3f'5cd'2b'5b'2d'2b'5d'3f'7c'28m'7cdim'7caug'7cmaj'7csus'29'28'3f'21'5bA'2dZa'2dz'5d'29'29'2a'28'2f'5c'2b'3f'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f = compileRegex True ":?([\\.^]?\\d+[-+]?|(m|dim|aug|maj|sus)(?![A-Za-z]))*(/\\+?\\b([a-h]((iss){1,2}|(ess){1,2}|(is){1,2}|(es){1,2}|(sharp){1,2}|(flat){1,2}|ss?|ff?)?|(do|re|mi|fa|sol|la|si)(dd?|bb?|ss?|kk?)?|q)('+|,+|(?![A-Za-z])))?"
regex_'5cb'5bsrR'5d'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\b[srR](?![A-Za-z])"
regex_'22'28'5c'5c'5b'22'5c'5c'5d'7c'5b'5e'22'5c'5c'5d'29'2b'22 = compileRegex True "\"(\\\\[\"\\\\]|[^\"\\\\])+\""
regex_'5bA'2dZa'2dz'5d'2b = compileRegex True "[A-Za-z]+"
regex_'28'5cw'2b'2d'7b2'2c'7d'7c'5cw'2b'5f'7b2'2c'7d'7c'2d'7b2'2c'7d'5cw'2b'7c'5f'7b2'2c'7d'5cw'2b'29 = compileRegex True "(\\w+-{2,}|\\w+_{2,}|-{2,}\\w+|_{2,}\\w+)"
regex_'28'2d'2d'7c'5f'5f'7c'5f'29 = compileRegex True "(--|__|_)"
regex_'5cS'2b'5c'7d = compileRegex True "\\S+\\}"
regex_'5c'5cscore'5cb = compileRegex True "\\\\score\\b"
regex_'5c'5c'28markup'7cbold'7c'28rounded'2d'29'3fbox'7cbracket'7ccaps'7c'28center'7cgeneral'7cleft'7cright'29'2dalign'7ccircle'7c'28'28center'7cdir'7cleft'7cright'29'2d'29'3fcolumn'7ccombine'7cconcat'7cdynamic'7cfill'2dline'7cfinger'7cfontCaps'7c'28abs'2d'29'3ffontsize'7cfraction'7chalign'7chbracket'7chcenter'2din'7chcenter'7chspace'7chuge'7citalic'7cjustify'7clarger'3f'7cline'7clower'7cmagnify'7cmedium'7cnormal'2dsize'2d'28sub'7csuper'29'7cnormal'2dtext'7cnormalsize'7cnumber'7con'2dthe'2dfly'7coverride'7cpad'2d'28around'7cmarkup'7cto'2dbox'7cx'29'7cpage'2dref'7cpostscript'7cput'2dadjacent'7craise'7croman'7crotate'7csans'7csmall'28er'29'3f'7csmallCaps'7csub'7csuper'7cteeny'7ctext'7ctiny'7ctranslate'28'2dscaled'29'3f'7ctransparent'7ctypewriter'7cunderline'7cupright'7cvcenter'7cwhiteout'7cwith'2d'28color'7cdimensions'7curl'29'7cwordwrap'7c'28markup'7ccolumn'2d'7cjustified'2d'7coverride'2d'7cwordwrap'2d'29lines'7cwordwrap'2d'28string'2d'29'3finternal'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(markup|bold|(rounded-)?box|bracket|caps|(center|general|left|right)-align|circle|((center|dir|left|right)-)?column|combine|concat|dynamic|fill-line|finger|fontCaps|(abs-)?fontsize|fraction|halign|hbracket|hcenter-in|hcenter|hspace|huge|italic|justify|larger?|line|lower|magnify|medium|normal-size-(sub|super)|normal-text|normalsize|number|on-the-fly|override|pad-(around|markup|to-box|x)|page-ref|postscript|put-adjacent|raise|roman|rotate|sans|small(er)?|smallCaps|sub|super|teeny|text|tiny|translate(-scaled)?|transparent|typewriter|underline|upright|vcenter|whiteout|with-(color|dimensions|url)|wordwrap|(markup|column-|justified-|override-|wordwrap-)lines|wordwrap-(string-)?internal)(?![A-Za-z])"
regex_'5c'5c'28arrow'2dhead'7cbeam'7cchar'7c'28semi'7csesqui'7cdouble'29'3f'28flat'7csharp'29'7cdraw'2d'28circle'7cline'29'7cepsfile'7ceyeglasses'7cfilled'2dbox'7cfret'2ddiagram'28'2dterse'7c'2dverbose'29'3f'7cfromproperty'7charp'2dpedal'7c'28justify'7cwordwrap'29'2d'28field'7cstring'29'7cleft'2dbrace'7clookup'7cmarkalphabet'7cmarkletter'7cmusicglyph'7cnatural'7cnote'2dby'2dnumber'7cnote'7cnull'7cpath'7cright'2dbrace'7csimple'7c'28back'29'3fslashed'2ddigit'7cstencil'7cstrut'7ctied'2dlyric'7ctriangle'7cverbatim'2dfile'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(arrow-head|beam|char|(semi|sesqui|double)?(flat|sharp)|draw-(circle|line)|epsfile|eyeglasses|filled-box|fret-diagram(-terse|-verbose)?|fromproperty|harp-pedal|(justify|wordwrap)-(field|string)|left-brace|lookup|markalphabet|markletter|musicglyph|natural|note-by-number|note|null|path|right-brace|simple|(back)?slashed-digit|stencil|strut|tied-lyric|triangle|verbatim-file)(?![A-Za-z])"
regex_'5b'5e'22'5cs'5c'5c'23'25'7b'7d'24'5d'2b = compileRegex True "[^\"\\s\\\\#%{}$]+"
regex_'5c'5c'28arrow'2dhead'7cbeam'7cchar'7c'28semi'7csesqui'7cdouble'29'3f'28flat'7csharp'29'7cdraw'2d'28circle'7cline'29'7cepsfile'7ceyeglasses'7cfilled'2dbox'7cfret'2ddiagram'28'2dterse'7c'2dverbose'29'3f'7cfromproperty'7charp'2dpedal'7c'28justify'7cwordwrap'29'2d'28field'7cstring'29'7cleft'2dbrace'7clookup'7cmarkalphabet'7cmarkletter'7cmusicglyph'7cnatural'7cnote'2dby'2dnumber'7cnote'7cnull'7cpath'7cright'2dbrace'7csimple'7c'28back'29'3fslashed'2ddigit'7cstencil'7cstrut'7ctied'2dlyric'7ctriangle'7cverbatim'2dfile'7cmarkup'7cbold'7c'28rounded'2d'29'3fbox'7cbracket'7ccaps'7c'28center'7cgeneral'7cleft'7cright'29'2dalign'7ccircle'7c'28'28center'7cdir'7cleft'7cright'29'2d'29'3fcolumn'7ccombine'7cconcat'7cdynamic'7cfill'2dline'7cfinger'7cfontCaps'7c'28abs'2d'29'3ffontsize'7cfraction'7chalign'7chbracket'7chcenter'2din'7chcenter'7chspace'7chuge'7citalic'7cjustify'7clarger'3f'7cline'7clower'7cmagnify'7cmedium'7cnormal'2dsize'2d'28sub'7csuper'29'7cnormal'2dtext'7cnormalsize'7cnumber'7con'2dthe'2dfly'7coverride'7cpad'2d'28around'7cmarkup'7cto'2dbox'7cx'29'7cpage'2dref'7cpostscript'7cput'2dadjacent'7craise'7croman'7crotate'7csans'7csmall'28er'29'3f'7csmallCaps'7csub'7csuper'7cteeny'7ctext'7ctiny'7ctranslate'28'2dscaled'29'3f'7ctransparent'7ctypewriter'7cunderline'7cupright'7cvcenter'7cwhiteout'7cwith'2d'28color'7cdimensions'7curl'29'7cwordwrap'7c'28markup'7ccolumn'2d'7cjustified'2d'7coverride'2d'7cwordwrap'2d'29lines'7cwordwrap'2d'28string'2d'29'3finternal'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(arrow-head|beam|char|(semi|sesqui|double)?(flat|sharp)|draw-(circle|line)|epsfile|eyeglasses|filled-box|fret-diagram(-terse|-verbose)?|fromproperty|harp-pedal|(justify|wordwrap)-(field|string)|left-brace|lookup|markalphabet|markletter|musicglyph|natural|note-by-number|note|null|path|right-brace|simple|(back)?slashed-digit|stencil|strut|tied-lyric|triangle|verbatim-file|markup|bold|(rounded-)?box|bracket|caps|(center|general|left|right)-align|circle|((center|dir|left|right)-)?column|combine|concat|dynamic|fill-line|finger|fontCaps|(abs-)?fontsize|fraction|halign|hbracket|hcenter-in|hcenter|hspace|huge|italic|justify|larger?|line|lower|magnify|medium|normal-size-(sub|super)|normal-text|normalsize|number|on-the-fly|override|pad-(around|markup|to-box|x)|page-ref|postscript|put-adjacent|raise|roman|rotate|sans|small(er)?|smallCaps|sub|super|teeny|text|tiny|translate(-scaled)?|transparent|typewriter|underline|upright|vcenter|whiteout|with-(color|dimensions|url)|wordwrap|(markup|column-|justified-|override-|wordwrap-)lines|wordwrap-(string-)?internal)(?![A-Za-z])"
regex_'5c'5c'28bigger'7ch'3fcenter'29'28'3f'21'5bA'2dZa'2dz'5d'29 = compileRegex True "\\\\(bigger|h?center)(?![A-Za-z])"
regex_'5c'5c'5bA'2dZa'2dz'5d'2b'28'2d'5bA'2dZa'2dz'5d'2b'29'2a = compileRegex True "\\\\[A-Za-z]+(-[A-Za-z]+)*"
regex_'28'22'3f'29'5cb'28'28Accidental'7cAmbitus'7cArpeggio'7cAuto'5fbeam'7cAxis'5fgroup'7cBalloon'7cBar'7cBar'5fnumber'7cBeam'7cBend'7cBreak'5falign'7cBreathing'5fsign'7cChord'5fname'7cChord'5ftremolo'7cClef'7cCluster'5fspanner'7cCollision'7cCompletion'5fheads'7cCustos'7cDefault'5fbar'5fline'7cDot'5fcolumn'7cDots'7cDrum'5fnotes'7cDynami'5falign'7cDynamic'7cEpisema'7cExtender'7cFigured'5fbass'7cFigured'5fbass'5fposition'7cFingering'7cFont'5fsize'7cForbid'5fline'5fbreak'7cFretboard'7cGlissando'7cGrace'5fbeam'7cGrace'7cGrace'5fspacing'7cGrid'5fline'5fspan'7cGrid'5fpoint'7cGrob'5fpq'7cHara'5fkiri'7cHorizontal'5fbracket'29'5fengraver'29'5cb'5c1 = compileRegex True "(\"?)\\b((Accidental|Ambitus|Arpeggio|Auto_beam|Axis_group|Balloon|Bar|Bar_number|Beam|Bend|Break_align|Breathing_sign|Chord_name|Chord_tremolo|Clef|Cluster_spanner|Collision|Completion_heads|Custos|Default_bar_line|Dot_column|Dots|Drum_notes|Dynami_align|Dynamic|Episema|Extender|Figured_bass|Figured_bass_position|Fingering|Font_size|Forbid_line_break|Fretboard|Glissando|Grace_beam|Grace|Grace_spacing|Grid_line_span|Grid_point|Grob_pq|Hara_kiri|Horizontal_bracket)_engraver)\\b\\1"
regex_'28'22'3f'29'5cb'28'28Hyphen'7cInstrument'5fname'7cInstrument'5fswitch'7cKey'7cLaissez'5fvibrer'7cLedger'5fline'7cLigature'5fbracket'7cLyric'7cMark'7cMeasure'5fgrouping'7cMelody'7cMensural'5fligature'7cMetronome'5fmark'7cMulti'5fmeasure'5frest'7cNew'5fdynamic'7cNew'5ffingering'7cNote'5fhead'5fline'7cNote'5fheads'7cNote'5fname'7cNote'5fspacing'7cOttava'5fspanner'7cOutput'5fproperty'7cPage'5fturn'7cPaper'5fcolumn'7cParenthesis'7cPart'5fcombine'7cPercent'5frepeat'7cPhrasing'5fslur'7cPiano'5fpedal'5falign'7cPiano'5fpedal'7cPitch'5fsquash'7cPitched'5ftrill'7cRepeat'5facknowledge'7cRepeat'5ftie'7cRest'5fcollision'7cRest'7cRhythmic'5fcolumn'7cScheme'7cScript'5fcolumn'7cScript'7cScript'5frow'29'5fengraver'29'5cb'5c1 = compileRegex True "(\"?)\\b((Hyphen|Instrument_name|Instrument_switch|Key|Laissez_vibrer|Ledger_line|Ligature_bracket|Lyric|Mark|Measure_grouping|Melody|Mensural_ligature|Metronome_mark|Multi_measure_rest|New_dynamic|New_fingering|Note_head_line|Note_heads|Note_name|Note_spacing|Ottava_spanner|Output_property|Page_turn|Paper_column|Parenthesis|Part_combine|Percent_repeat|Phrasing_slur|Piano_pedal_align|Piano_pedal|Pitch_squash|Pitched_trill|Repeat_acknowledge|Repeat_tie|Rest_collision|Rest|Rhythmic_column|Scheme|Script_column|Script|Script_row)_engraver)\\b\\1"
regex_'28'22'3f'29'5cb'28'28Separating'5fline'5fgroup'7cSlash'5frepeat'7cSlur'7cSpacing'7cSpan'5farpeggio'7cSpan'5fbar'7cSpanner'5fbreak'5fforbid'7cStaff'5fcollecting'7cStaff'5fsymbol'7cStanza'5fnumber'5falign'7cStanza'5fnumber'7cStem'7cString'5fnumber'7cSwallow'7cSystem'5fstart'5fdelimiter'7cTab'5fharmonic'7cTab'5fnote'5fheads'7cTab'5fstaff'5fsymbol'7cText'7cText'5fspanner'7cTie'7cTime'5fsignature'7cTrill'5fspanner'7cTuplet'7cTweak'7cVaticana'5fligature'7cVertical'5falign'7cVertically'5fspaced'5fcontexts'7cVolta'29'5fengraver'29'5cb'5c1 = compileRegex True "(\"?)\\b((Separating_line_group|Slash_repeat|Slur|Spacing|Span_arpeggio|Span_bar|Spanner_break_forbid|Staff_collecting|Staff_symbol|Stanza_number_align|Stanza_number|Stem|String_number|Swallow|System_start_delimiter|Tab_harmonic|Tab_note_heads|Tab_staff_symbol|Text|Text_spanner|Tie|Time_signature|Trill_spanner|Tuplet|Tweak|Vaticana_ligature|Vertical_align|Vertically_spaced_contexts|Volta)_engraver)\\b\\1"
regex_'28'22'3f'29'5cb'28'28Beam'7cControl'5ftrack'7cDrum'5fnote'7cDynamic'7cKey'7cLyric'7cNote'7cPiano'5fpedal'7cSlur'7cStaff'7cSwallow'7cTempo'7cTie'7cTime'5fsignature'29'5fperformer'29'5cb'5c1 = compileRegex True "(\"?)\\b((Beam|Control_track|Drum_note|Dynamic|Key|Lyric|Note|Piano_pedal|Slur|Staff|Swallow|Tempo|Tie|Time_signature)_performer)\\b\\1"
regex_'28'22'3f'29'5cb'28'28Note'5fswallow'7cRest'5fswallow'7cSkip'5fevent'5fswallow'7cTiming'29'5ftranslator'29'5cb'5c1 = compileRegex True "(\"?)\\b((Note_swallow|Rest_swallow|Skip_event_swallow|Timing)_translator)\\b\\1"
regex_'5cb'28dedication'7c'28sub'29'7b'2c2'7dtitle'7cpoet'7ccomposer'7cmeter'7copus'7carranger'7cinstrument'7cpiece'7cbreakbefore'7ccopyright'7ctagline'7cmutopia'28title'7ccomposer'7cpoet'7copus'7cinstrument'29'7cdate'7centeredby'7csource'7cstyle'7cmaintainer'28Email'7cWeb'29'3f'7cmoreInfo'7clastupdated'7ctexidoc'7cfooter'7c'28top'7cbottom'7cleft'7cright'29'2dmargin'7c'28foot'7chead'29'2dseparation'7cindent'7cshort'2dindent'7cpaper'2d'28height'7cwidth'29'7chorizontal'2dshift'7cline'2dwidth'7c'28inner'7couter'29'2dmargin'7ctwo'2dsided'7cbinding'2doffset'7c'28after'7cbefore'7cbetween'29'2dtitle'2dspace'7cbetween'2dsystem'2d'28space'7cpadding'29'7cpage'2dtop'2dspace'7cpage'2dbreaking'2dbetween'2dsystem'2dpadding'7c'28after'7cbefore'7cbetween'29'2dtitle'2dspacing'7cbetween'2d'28scores'2d'29'3fsystem'2dspacing'7cbottom'2dsystem'2dspacing'7ctop'2dtitle'2dspacing'7ctop'2dsystem'2dspacing'7cpage'2dbreaking'2dbetween'2dsystem'2dspacing'7csystem'2dcount'7c'28min'2d'7cmax'2d'29'3fsystems'2dper'2dpage'7cannotate'2dspacing'7cauto'2dfirst'2dpage'2dnumber'7cblank'2d'28last'2d'29'3fpage'2dforce'7cfirst'2dpage'2dnumber'7cpage'2dcount'7cpage'2dlimit'2dinter'2dsystem'2dspace'7cpage'2dlimit'2dinter'2dsystem'2dspace'2dfactor'7cpage'2dspacing'2dweight'7cprint'2dall'2dheaders'7cprint'2dfirst'2dpage'2dnumber'7cprint'2dpage'2dnumber'7cragged'2d'28bottom'7cright'29'7cragged'2dlast'28'2dbottom'29'3f'7csystem'2dseparator'2dmarkup'7cforce'2dassignment'7cinput'2dencoding'7coutput'2dscale'7c'28'28even'7codd'29'28Footer'7cHeader'29'7c'28book'7cscore'7ctoc'29Title'7ctocItem'29Markup'7csystem'2dcount'7c'28short'2d'29'3findent'29'5cb = compileRegex True "\\b(dedication|(sub){,2}title|poet|composer|meter|opus|arranger|instrument|piece|breakbefore|copyright|tagline|mutopia(title|composer|poet|opus|instrument)|date|enteredby|source|style|maintainer(Email|Web)?|moreInfo|lastupdated|texidoc|footer|(top|bottom|left|right)-margin|(foot|head)-separation|indent|short-indent|paper-(height|width)|horizontal-shift|line-width|(inner|outer)-margin|two-sided|binding-offset|(after|before|between)-title-space|between-system-(space|padding)|page-top-space|page-breaking-between-system-padding|(after|before|between)-title-spacing|between-(scores-)?system-spacing|bottom-system-spacing|top-title-spacing|top-system-spacing|page-breaking-between-system-spacing|system-count|(min-|max-)?systems-per-page|annotate-spacing|auto-first-page-number|blank-(last-)?page-force|first-page-number|page-count|page-limit-inter-system-space|page-limit-inter-system-space-factor|page-spacing-weight|print-all-headers|print-first-page-number|print-page-number|ragged-(bottom|right)|ragged-last(-bottom)?|system-separator-markup|force-assignment|input-encoding|output-scale|((even|odd)(Footer|Header)|(book|score|toc)Title|tocItem)Markup|system-count|(short-)?indent)\\b"
regex_'3d'28'5cs'2a'5bA'2dZa'2dz'5d'2b'29'3f = compileRegex True "=(\\s*[A-Za-z]+)?"
regex_'5bA'2dZa'2dz'5d'2b'28'3f'3d'5cs'2a'5c'2e'29 = compileRegex True "[A-Za-z]+(?=\\s*\\.)"
regex_'5cd'2b'5c'2e'2a'5cs'2a'3d'5cs'2a'5cd'2b = compileRegex True "\\d+\\.*\\s*=\\s*\\d+"

parseRules ("LilyPond","lilypond") =
  (((parseRules ("LilyPond","music")))
   <|>
   ((lookAhead (pRegExpr regex_'5cb'5ba'2dz'5d'2b'5cs'2a'3d) >> pushContext ("LilyPond","assignment") >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","lilypond")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","music") =
  (((pAnyChar "()~" >>= withAttribute CharTok))
   <|>
   ((pAnyChar "[]" >>= withAttribute DataTypeTok))
   <|>
   ((pAnyChar "-_^" >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","connect"))
   <|>
   ((lookAhead (pDetectChar False '\\') >> pushContext ("LilyPond","musiccommand") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("LilyPond","default")))
   <|>
   ((pDetectChar False '<' >>= withAttribute DataTypeTok) >>~ pushContext ("LilyPond","chord"))
   <|>
   ((pDetectChar False '>' >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'5ba'2dz'5d'2b'5cd'2b'5c'2e'2a'5b'2c'27'5d'2b >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'28'5cb'5bsrR'5d'28'3f'21'5bA'2dZa'2dz'5d'29'7c'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","pitch"))
   <|>
   ((pRegExpr regex_'3a'5cd'2a >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","music")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","default") =
  (((pDetect2Chars False '<' '<' >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False '>' '>' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '|' >>= withAttribute DecValTok))
   <|>
   ((lookAhead (pDetectChar False '\\') >> pushContext ("LilyPond","command") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("LilyPond","basic")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","default")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","basic") =
  (((pDetect2Chars False '%' '{' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","commentblock"))
   <|>
   ((pDetectChar False '%' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","commentline"))
   <|>
   ((pDetectChar False '"' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","string"))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","scheme"))
   <|>
   ((pDetectChar False '$' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","schemesub"))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","basic")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","musiccommand") =
  (((pRegExpr regex_'5c'5c'28p'7b1'2c5'7d'7cmp'7cmf'7cf'7b1'2c5'7d'7cs'3ffp'7csff'3f'7cspp'3f'7c'5bsr'5d'3ffz'7ccresc'7cdecresc'7cdim'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5c'5c'5b'3c'21'3e'5d >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'5cd'2b'7caccent'7cmarcato'7cstaccat'28issim'29'3fo'7cespressivo'7ctenuto'7cportato'7c'28up'7cdown'29'28bow'7cmordent'7cprall'29'7cflageolet'7cthumb'7c'5blr'5d'28heel'7ctoe'29'7copen'7cstopped'7cturn'7creverseturn'7ctrill'7cmordent'7cprall'28prall'7cmordent'7cdown'7cup'29'3f'7clineprall'7csignumcongruentiae'7c'28short'7clong'7cverylong'29'3ffermata'7csegno'7c'28var'29'3fcoda'7csnappizzicato'7chalfopen'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5c'5c'5b'28'29'5d >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5c'5c'5b'5d'5b'5d >>= withAttribute DataTypeTok))
   <|>
   ((parseRules ("LilyPond","command")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","command") =
  (((pDetect2Chars False '\\' '\\' >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'5cnote'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","notemode"))
   <|>
   ((pRegExpr regex_'5c'5cdrum'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","drummode"))
   <|>
   ((pRegExpr regex_'5c'5cchord'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","chordmode"))
   <|>
   ((pRegExpr regex_'5c'5cfigure'28mode'7cs'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","figuremode"))
   <|>
   ((pRegExpr regex_'5c'5c'28lyric'28mode'7cs'29'7caddlyrics'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","lyricmode"))
   <|>
   ((pRegExpr regex_'5c'5clyricsto'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","lyricsto"))
   <|>
   ((pRegExpr regex_'5c'5cmarkup'28lines'29'3f'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok) >>~ pushContext ("LilyPond","markup"))
   <|>
   ((pRegExpr regex_'5c'5c'28header'7cpaper'7clayout'7cmidi'7cwith'29'5cb >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","section"))
   <|>
   ((pRegExpr regex_'5c'5c'28new'7ccontext'7cchange'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","context"))
   <|>
   ((pRegExpr regex_'5c'5c'28un'29'3fset'5cb >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","set"))
   <|>
   ((pRegExpr regex_'5c'5c'28override'28Property'29'3f'7crevert'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","override"))
   <|>
   ((pRegExpr regex_'5c'5cskip'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok) >>~ pushContext ("LilyPond","duration"))
   <|>
   ((pRegExpr regex_'5c'5ctempo'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok) >>~ pushContext ("LilyPond","tempo"))
   <|>
   ((pRegExpr regex_'5c'5c'28accepts'7calias'7cconsists'7cdefaultchild'7cdenies'7cdescription'7cgrobdescriptions'7cinclude'7cinvalid'7clanguage'7cname'7cobjectid'7conce'7cremove'7csequential'7csimultaneous'7ctype'7cversion'7cscore'7cbook'7cbookpart'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'28aiken'7cfunk'7csacredHarp'7csouthernHarmony'7cwalker'29Heads'28Minor'29'3f'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28acciaccatura'7caddQuote'7cafterGrace'7callowPageTurn'7calternative'7capply'28Context'7cMusic'7cOutput'29'7cappoggiatura'7carpeggio'28Arrow'28Down'7cUp'29'7cBracket'7cNormal'7cParenthesis'29'3f'7c'28a'7cde'29scendens'7cauctum'7caugmentum'7cautoBeamO'28ff'7cn'29'7cautochange'7cballoon'28Grob'29'3fText'7cbar'7cbarNumberCheck'7cbendAfter'7cbreathe'7cbreak'7ccadenzaO'28ff'7cn'29'7ccavum'7cclef'28'5cs'2b'28treble'7cviolin'7cG'7calto'7cC'7ctenor'7c'28sub'29'3fbass'7cF'7cfrench'7c'28mezzo'29'3fsoprano'7c'28var'29'3fbaritone'7cpercussion'7ctab'29'29'3f'7c'28end'29'3f'28de'29'3fcr'7ccresc'28TextCresc'7cHairpin'29'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'28cue'7ctransposedCue'29During'7cdefault'7cdeminutum'7cdim'28Text'28Decresc'7cDecr'7cDim'29'7cHairpin'29'7cdisplay'28Lily'29'3fMusic'7cdivisio'28Maior'7cMaxima'7cMinima'29'7c'28dynamic'7cdots'7cphrasingSlur'7cslur'7cstem'7ctie'7ctuplet'29'28Down'7cNeutral'7cUp'29'7c'28balloon'7ctext'29LengthO'28ff'7cn'29'7cfeatherDurations'7cfigure'28mode'7cs'29'7cfinalis'7cflexa'7c'28french'7cgerman'7citalian'7csemiGerman'29Chords'7cglissando'7cgrace'7charmonic'7c'28unH'7ch'29ideNotes'7c'28hide'7cshow'29StaffSwitch'7cinclinatum'7c'28keep'7cremove'29WithTag'7ckey'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f'7ckillCues'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28label'7claissezVibrer'7clinea'7cmakeClusters'7cmark'7cmaxima'7cmelisma'28End'29'3f'7cmergeDifferently'28Head'7cDott'29edO'28ff'7cn'29'7cnewSpacingSection'7cno'28Beam'7cBreak'7cPageBreak'7cPageTurn'29'7cnormalsize'7cnumericTimeSignature'7coctaveCheck'7coneVoice'7coriscus'7cottava'7cpage'28'2dref'7cBreak'7cTurn'29'7cparallelMusic'7cparenthesize'7cpartcombine'7cpartial'28'5cs'2a'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a'29'3f'7cpes'7cpitchedTrill'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28pointAndClickO'28ff'7cn'29'7cquilisma'7cquoteDuring'7crelative'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f'7cRemoveEmptyStaffContext'7crepeat'28'5cs'2b'28unfold'7cvolta'7ctremolo'7cpercent'29'28'5cs'2b'5cd'2b'29'3f'29'3f'7crepeatTie'7cresetRelativeOctave'7crest'7cscaleDurations'7cscoreTweak'7ceasyHeadsO'28ff'7cn'29'7cshift'28Durations'7cOff'7cOn'7b1'2c3'7d'29'7c'28slur'7ctie'29'28Both'7cDashed'7cDotted'7cSolid'29'7csmall'7cspacingTweaks'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'28start'7cstop'29'28Group'7c'28Text'7cTrill'29Span'7cStaff'29'7cstemBoth'7cstropha'7csuper'7c'28sustain'7csostenuto'29O'28ff'7cn'29'7ctable'2dof'2dcontents'7ctag'7ctimes'3f'28'5cs'2a'5cd'2b'2f'5cd'2b'29'3f'7ctiny'7ctocItem'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28transpose'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'5cs'2a'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f'7ctransposition'28'5cs'2b'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28tweak'7cunfoldRepeats'7cvirg'28ul'29'3fa'7cvoice'28One'7cTwo'7cThree'7cFour'29'7cwithMusicProperty'7ccm'7cmm'7cin'7cpt'7cmajor'7cminor'7cionian'7clocrian'7caeolian'7cmixolydian'7clydian'7cphrygian'7cdorian'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28dash'28Hat'7cPlus'7cDash'7cBar'7cLarger'7cDot'7cUnderscore'29'7cfermataMarkup'7cpipeSymbol'7cslashSeparator'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'28consistsend'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'5c'28arpeggio'28Up'7cDown'7cNeutral'29'7cnewpage'7cscript'28Up'7cDown'7cBoth'29'7c'28empty'7cfat'29Text'7csetEasyHeads'7c'28default'7cvoice'7cmodernVoice'7cpiano'7cforget'29Accidentals'7c'28modern'28Voice'29'3f'7cpiano'29Cautionaries'7cnoResetKey'7ccompressMusic'7coctave'7c'28sustain'7csostenuto'29'28Down'7cUp'29'7cset'28Hairpin'7cText'29'28Cresc'7cDecresc'7cDim'29'7csetTextDecr'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'5c'28translator'7cnewcontext'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","context"))
   <|>
   ((pRegExpr regex_'5c'5cproperty'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","override"))
   <|>
   ((pRegExpr regex_'5c'5c'5bA'2dZa'2dz'5d'2b >>= withAttribute FunctionTok))
   <|>
   ((pDetectChar False '\\' >>= withAttribute ErrorTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","assignment") =
  (((pRegExpr regex_'5cb'28dash'28Hat'7cPlus'7cDash'7cBar'7cLarger'7cDot'7cUnderscore'29'7cfermataMarkup'7cpipeSymbol'7cslashSeparator'29'5cb >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5ba'2dz'5d'2b >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","assignment")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","pitch") =
  (((pRegExpr regex_'3d'5cs'2a'28'27'2b'7c'2c'2b'29'3f >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "!?" >>= withAttribute NormalTok))
   <|>
   ((parseRules ("LilyPond","duration")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","duration") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cd'2b >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","chord") =
  (((pDetectChar False '>' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","chordend"))
   <|>
   ((pRegExpr regex_'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","chordpitch"))
   <|>
   ((pAnyChar "<{}srR" >>= withAttribute ErrorTok))
   <|>
   ((parseRules ("LilyPond","music")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","chord")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","chordpitch") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'3d'5cs'2a'28'27'2b'7c'2c'2b'29'3f >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cd'2b >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","chordend") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","commentline") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","commentline")) >> pDefault >>= withAttribute CommentTok))

parseRules ("LilyPond","commentblock") =
  (((pDetect2Chars False '%' '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","commentblock")) >> pDefault >>= withAttribute CommentTok))

parseRules ("LilyPond","string") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' '"' >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("LilyPond","connect") =
  (((pAnyChar ".-+|>^_12345" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","scheme") =
  (((pDetectSpaces >>= withAttribute FloatTok))
   <|>
   (pushContext ("LilyPond","scheme2") >> currentContext >>= parseRules))

parseRules ("LilyPond","scheme2") =
  (((pDetectChar False '(' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","scheme3"))
   <|>
   ((parseRules ("LilyPond","schemerules")))
   <|>
   ((lookAhead (pDetectSpaces) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","scheme2")) >> pDefault >>= withAttribute FloatTok))

parseRules ("LilyPond","scheme3") =
  (((pDetectChar False ')' >>= withAttribute FloatTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","schemerules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","scheme3")) >> pDefault >>= withAttribute FloatTok))

parseRules ("LilyPond","schemerules") =
  (((pDetectChar False '(' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemerules"))
   <|>
   ((pDetectChar False ')' >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemestring"))
   <|>
   ((pDetectChar False ';' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemecommentline"))
   <|>
   ((pDetectChar False '$' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemesub"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemequote"))
   <|>
   ((pDetect2Chars False '#' '!' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemecommentblock"))
   <|>
   ((pDetect2Chars False '#' '{' >>= withAttribute FloatTok) >>~ pushContext ("LilyPond","schemelily"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_musicexpressions >>= withAttribute FloatTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_contexts >>= withAttribute FloatTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_layoutobjects >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5b'2d'2b'5d'3f'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'23'28t'7cf'7cb'5b'2d'2b'5d'3f'5b01'2e'5d'2b'7co'5b'2d'2b'5d'3f'5b0'2d7'2e'5d'2b'7cd'5b'2d'2b'5d'3f'5b0'2d9'2e'5d'2b'7cx'5b'2d'2b'5d'3f'5b0'2d9a'2df'2e'5d'2b'29 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b'2b'2d'5d'28inf'7cnan'29'5c'2e0 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'28define'7cdefined'5c'3f'7cdefine'5c'2a'28'2dpublic'29'3f'7cdefine'2d'28'5c'2a'7cbuiltin'2dmarkup'2d'28list'2d'29'3fcommand'7cclass'7c'28extra'2d'29'3fdisplay'2dmethod'7cfonts'3f'7cgrob'2dproperty'7cly'2dsyntax'28'2dloc'7c'2dsimple'29'3f'7cmacro'28'2dpublic'29'3f'7cmarkup'2d'28list'2d'29command'7cmethod'7cmodule'7cmusic'2dfunction'7cpost'2devent'2ddisplay'2dmethod'7cpublic'28'2dmacro'7c'2dtoplevel'29'3f'7csafe'2dpublic'7cspan'2devent'2ddisplay'2dmethod'29'7cdefmacro'28'5c'2a'28'2dpublic'29'3f'29'3f'7clambda'5c'2a'3f'7cand'7cor'7cif'7ccond'7ccase'7clet'5c'2a'3f'7cletrec'7cbegin'7cdo'7cdelay'7cset'21'7celse'7c'28quasi'29'3fquote'7cunquote'28'2dsplicing'29'3f'7c'28define'7clet'7cletrec'29'2dsyntax'7csyntax'2drules'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5cb'28not'7cboolean'5c'3f'7ceq'5c'3f'7ceqv'5c'3f'7cequal'5c'3f'7cpair'5c'3f'7ccons'7cset'2dc'5bad'5dr'21'7cc'5bad'5d'7b1'2c4'7dr'7cnull'5c'3f'7clist'5c'3f'7clist'7clength'7cappend'7creverse'7clist'2dref'7cmem'5bqv'5d'7cmember'7cass'5bqv'5d'7cassoc'7csymbol'5c'3f'7csymbol'2d'3estring'7cstring'2d'3esymbol'7cnumber'5c'3f'7ccomplex'5c'3f'7creal'5c'3f'7crational'5c'3f'7cinteger'5c'3f'7cexact'5c'3f'7cinexact'5c'3f'7czero'5c'3f'7cpositive'5c'3f'7cnegative'5c'3f'7codd'5c'3f'7ceven'5c'3f'7cmax'7cmin'7cabs'7cquotient'7cremainder'7cmodulo'7cgcd'7clcm'7cnumerator'7cdenominator'7cfloor'7cceiling'7ctruncate'7cround'7crationalize'7cexp'7clog'7csin'7ccos'7ctan'7casin'7cacos'7catan'7csqrt'7cexpt'7cmake'2drectangular'7cmake'2dpolar'7creal'2dpart'7cimag'2dpart'7cmagnitude'7cangle'7cexact'2d'3einexact'7cinexact'2d'3eexact'7cnumber'2d'3estring'7cstring'2d'3enumber'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5cb'28char'28'28'2dci'29'3f'28'3d'5c'3f'7c'3c'5c'3f'7c'3e'5c'3f'7c'3c'3d'5c'3f'7c'3e'3d'5c'3f'29'7c'2dalphabetic'5c'3f'7c'5c'3f'7c'2dnumeric'5c'3f'7c'2dwhitespace'5c'3f'7c'2dupper'2dcase'5c'3f'7c'2dlower'2dcase'5c'3f'7c'2d'3einteger'7c'2dupcase'7c'2ddowncase'7c'2dready'5c'3f'29'7cinteger'2d'3echar'7cmake'2dstring'7cstring'28'5c'3f'7c'2dcopy'7c'2dfill'21'7c'2dlength'7c'2dref'7c'2dset'21'7c'28'2dci'29'3f'28'3d'5c'3f'7c'3c'5c'3f'7c'3e'5c'3f'7c'3c'3d'5c'3f'7c'3e'3d'5c'3f'29'7c'2dappend'29'7csubstring'7cmake'2dvector'7cvector'28'5c'3f'7c'2dlength'7c'2dref'7c'2dset'21'7c'2dfill'21'29'3f'7cprocedure'5c'3f'7capply'7cmap'7cfor'2deach'7cforce'7ccall'2dwith'2d'28current'2dcontinuation'7c'28in'7cout'29put'2dfile'29'7c'28in'7cout'29put'2dport'5c'3f'7ccurrent'2d'28in'7cout'29put'2dport'7copen'2d'28in'7cout'29put'2dfile'7cclose'2d'28in'7cout'29put'2dport'7ceof'2dobject'5c'3f'7cread'7c'28read'7cpeek'29'2dchar'7cwrite'28'2dchar'29'3f'7cdisplay'7cnewline'7ccall'2fcc'7clist'2dtail'7cstring'2d'3elist'7clist'2d'3estring'7cvector'2d'3elist'7clist'2d'3evector'7cwith'2dinput'2dfrom'2dfile'7cwith'2doutput'2dto'2dfile'7cload'7ctranscript'2d'28on'7coff'29'7ceval'7cdynamic'2dwind'7cport'5c'3f'7cvalues'7ccall'2dwith'2dvalues'7c'28scheme'2dreport'2d'7cnull'2d'7cinteraction'2d'29environment'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'23'5d'5b'5e'5cs'28'29'7b'7d'5b'5c'5d'3b'24'22'5d'2a >>= withAttribute FloatTok))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","schemerules")) >> pDefault >>= withAttribute FloatTok))

parseRules ("LilyPond","schemequote") =
  (((pRegExpr regex_'5cb'28define'7cdefined'5c'3f'7cdefine'5c'2a'28'2dpublic'29'3f'7cdefine'2d'28'5c'2a'7cbuiltin'2dmarkup'2d'28list'2d'29'3fcommand'7cclass'7c'28extra'2d'29'3fdisplay'2dmethod'7cfonts'3f'7cgrob'2dproperty'7cly'2dsyntax'28'2dloc'7c'2dsimple'29'3f'7cmacro'28'2dpublic'29'3f'7cmarkup'2d'28list'2d'29command'7cmethod'7cmodule'7cmusic'2dfunction'7cpost'2devent'2ddisplay'2dmethod'7cpublic'28'2dmacro'7c'2dtoplevel'29'3f'7csafe'2dpublic'7cspan'2devent'2ddisplay'2dmethod'29'7cdefmacro'28'5c'2a'28'2dpublic'29'3f'29'3f'7clambda'5c'2a'3f'7cand'7cor'7cif'7ccond'7ccase'7clet'5c'2a'3f'7cletrec'7cbegin'7cdo'7cdelay'7cset'21'7celse'7c'28quasi'29'3fquote'7cunquote'28'2dsplicing'29'3f'7c'28define'7clet'7cletrec'29'2dsyntax'7csyntax'2drules'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5cb'28not'7cboolean'5c'3f'7ceq'5c'3f'7ceqv'5c'3f'7cequal'5c'3f'7cpair'5c'3f'7ccons'7cset'2dc'5bad'5dr'21'7cc'5bad'5d'7b1'2c4'7dr'7cnull'5c'3f'7clist'5c'3f'7clist'7clength'7cappend'7creverse'7clist'2dref'7cmem'5bqv'5d'7cmember'7cass'5bqv'5d'7cassoc'7csymbol'5c'3f'7csymbol'2d'3estring'7cstring'2d'3esymbol'7cnumber'5c'3f'7ccomplex'5c'3f'7creal'5c'3f'7crational'5c'3f'7cinteger'5c'3f'7cexact'5c'3f'7cinexact'5c'3f'7czero'5c'3f'7cpositive'5c'3f'7cnegative'5c'3f'7codd'5c'3f'7ceven'5c'3f'7cmax'7cmin'7cabs'7cquotient'7cremainder'7cmodulo'7cgcd'7clcm'7cnumerator'7cdenominator'7cfloor'7cceiling'7ctruncate'7cround'7crationalize'7cexp'7clog'7csin'7ccos'7ctan'7casin'7cacos'7catan'7csqrt'7cexpt'7cmake'2drectangular'7cmake'2dpolar'7creal'2dpart'7cimag'2dpart'7cmagnitude'7cangle'7cexact'2d'3einexact'7cinexact'2d'3eexact'7cnumber'2d'3estring'7cstring'2d'3enumber'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5cb'28char'28'28'2dci'29'3f'28'3d'5c'3f'7c'3c'5c'3f'7c'3e'5c'3f'7c'3c'3d'5c'3f'7c'3e'3d'5c'3f'29'7c'2dalphabetic'5c'3f'7c'5c'3f'7c'2dnumeric'5c'3f'7c'2dwhitespace'5c'3f'7c'2dupper'2dcase'5c'3f'7c'2dlower'2dcase'5c'3f'7c'2d'3einteger'7c'2dupcase'7c'2ddowncase'7c'2dready'5c'3f'29'7cinteger'2d'3echar'7cmake'2dstring'7cstring'28'5c'3f'7c'2dcopy'7c'2dfill'21'7c'2dlength'7c'2dref'7c'2dset'21'7c'28'2dci'29'3f'28'3d'5c'3f'7c'3c'5c'3f'7c'3e'5c'3f'7c'3c'3d'5c'3f'7c'3e'3d'5c'3f'29'7c'2dappend'29'7csubstring'7cmake'2dvector'7cvector'28'5c'3f'7c'2dlength'7c'2dref'7c'2dset'21'7c'2dfill'21'29'3f'7cprocedure'5c'3f'7capply'7cmap'7cfor'2deach'7cforce'7ccall'2dwith'2d'28current'2dcontinuation'7c'28in'7cout'29put'2dfile'29'7c'28in'7cout'29put'2dport'5c'3f'7ccurrent'2d'28in'7cout'29put'2dport'7copen'2d'28in'7cout'29put'2dfile'7cclose'2d'28in'7cout'29put'2dport'7ceof'2dobject'5c'3f'7cread'7c'28read'7cpeek'29'2dchar'7cwrite'28'2dchar'29'3f'7cdisplay'7cnewline'7ccall'2fcc'7clist'2dtail'7cstring'2d'3elist'7clist'2d'3estring'7cvector'2d'3elist'7clist'2d'3evector'7cwith'2dinput'2dfrom'2dfile'7cwith'2doutput'2dto'2dfile'7cload'7ctranscript'2d'28on'7coff'29'7ceval'7cdynamic'2dwind'7cport'5c'3f'7cvalues'7ccall'2dwith'2dvalues'7c'28scheme'2dreport'2d'7cnull'2d'7cinteraction'2d'29environment'29'28'3f'3d'28'24'7c'5cs'7c'5c'29'29'29 >>= withAttribute FloatTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","schemelily") =
  (((pDetect2Chars False '#' '}' >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((parseRules ("LilyPond","lilypond")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","schemelily")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","schemecommentline") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","schemecommentline")) >> pDefault >>= withAttribute CommentTok))

parseRules ("LilyPond","schemecommentblock") =
  (((pDetect2Chars False '!' '#' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","schemecommentblock")) >> pDefault >>= withAttribute CommentTok))

parseRules ("LilyPond","schemesub") =
  (((pRegExpr regex_'5ba'2dzA'2dZ'23'5d'5b'5e'5cs'28'29'7b'7d'5b'5c'5d'3b'24'22'5d'2a >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","schemestring") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b0fnrtav'5c'5c'22'5d >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","schemestring")) >> pDefault >>= withAttribute StringTok))

parseRules ("LilyPond","notemode") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","notemode2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","notemode2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","noterules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","notemode2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","noterules") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","noterules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("LilyPond","music")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","noterules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","drummode") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","drummode2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","drummode2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","drumrules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","drummode2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","drumrules") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","drumrules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3c'28'3f'21'3c'29 >>= withAttribute DataTypeTok) >>~ pushContext ("LilyPond","drumchord"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_drumpitchnames >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","duration"))
   <|>
   ((parseRules ("LilyPond","music")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","drumrules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","drumchord") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_drumpitchnames >>= withAttribute NormalTok))
   <|>
   ((parseRules ("LilyPond","chord")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","drumchord")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","chordmode") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","chordmode2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","chordmode2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","chordrules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","chordmode2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","chordrules") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","chordrules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3a'3f'28'5b'5c'2e'5e'5d'3f'5cd'2b'5b'2d'2b'5d'3f'7c'28m'7cdim'7caug'7cmaj'7csus'29'28'3f'21'5bA'2dZa'2dz'5d'29'29'2a'28'2f'5c'2b'3f'5cb'28'5ba'2dh'5d'28'28iss'29'7b1'2c2'7d'7c'28ess'29'7b1'2c2'7d'7c'28is'29'7b1'2c2'7d'7c'28es'29'7b1'2c2'7d'7c'28sharp'29'7b1'2c2'7d'7c'28flat'29'7b1'2c2'7d'7css'3f'7cff'3f'29'3f'7c'28do'7cre'7cmi'7cfa'7csol'7cla'7csi'29'28dd'3f'7cbb'3f'7css'3f'7ckk'3f'29'3f'7cq'29'28'27'2b'7c'2c'2b'7c'28'3f'21'5bA'2dZa'2dz'5d'29'29'29'3f >>= withAttribute NormalTok))
   <|>
   ((parseRules ("LilyPond","music")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","chordrules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","figuremode") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","figuremode2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","figuremode2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","figurerules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","figuremode2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","figurerules") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","figurerules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '<' >>= withAttribute DataTypeTok) >>~ pushContext ("LilyPond","figure"))
   <|>
   ((pRegExpr regex_'5cb'5bsrR'5d'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","duration"))
   <|>
   ((parseRules ("LilyPond","default")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","figurerules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","figure") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ pushContext ("LilyPond","chordend"))
   <|>
   ((parseRules ("LilyPond","basic")))
   <|>
   ((pRegExpr regex_'5c'5cmarkup'28lines'29'3f'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok) >>~ pushContext ("LilyPond","markup"))
   <|>
   ((pRegExpr regex_'5c'5cskip'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute FunctionTok) >>~ pushContext ("LilyPond","duration"))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","figure")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","lyricmode") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","lyricmode2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","lyricmode2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","lyricrules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","lyricmode2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","lyricsto") =
  (((pRegExpr regex_'22'28'5c'5c'5b'22'5c'5c'5d'7c'5b'5e'22'5c'5c'5d'29'2b'22 >>= withAttribute StringTok) >>~ pushContext ("LilyPond","lyricsto2"))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5d'2b >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","lyricsto2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","lyricsto2") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","lyricsto3"))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","lyricsto3") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","lyricrules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","lyricsto3")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","lyricrules") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","lyricrules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'5cw'2b'2d'7b2'2c'7d'7c'5cw'2b'5f'7b2'2c'7d'7c'2d'7b2'2c'7d'5cw'2b'7c'5f'7b2'2c'7d'5cw'2b'29 >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'28'5c'5c'28longa'7cbreve'29'5cb'7c'281'7c2'7c4'7c8'7c16'7c32'7c64'7c128'7c256'7c512'7c1024'7c2048'29'28'3f'21'5cd'29'29'28'5cs'2a'5c'2e'2b'29'3f'28'5cs'2a'5c'2a'5cs'2a'5cd'2b'28'2f'5cd'2b'29'3f'29'2a >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'2d'2d'7c'5f'5f'7c'5f'29 >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("LilyPond","default")))
   <|>
   ((pRegExpr regex_'5cS'2b'5c'7d >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","lyricrules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","markup") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","markup2"))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'5cscore'5cb >>= withAttribute BaseNTok) >>~ pushContext ("LilyPond","notemode"))
   <|>
   ((pRegExpr regex_'5c'5c'28markup'7cbold'7c'28rounded'2d'29'3fbox'7cbracket'7ccaps'7c'28center'7cgeneral'7cleft'7cright'29'2dalign'7ccircle'7c'28'28center'7cdir'7cleft'7cright'29'2d'29'3fcolumn'7ccombine'7cconcat'7cdynamic'7cfill'2dline'7cfinger'7cfontCaps'7c'28abs'2d'29'3ffontsize'7cfraction'7chalign'7chbracket'7chcenter'2din'7chcenter'7chspace'7chuge'7citalic'7cjustify'7clarger'3f'7cline'7clower'7cmagnify'7cmedium'7cnormal'2dsize'2d'28sub'7csuper'29'7cnormal'2dtext'7cnormalsize'7cnumber'7con'2dthe'2dfly'7coverride'7cpad'2d'28around'7cmarkup'7cto'2dbox'7cx'29'7cpage'2dref'7cpostscript'7cput'2dadjacent'7craise'7croman'7crotate'7csans'7csmall'28er'29'3f'7csmallCaps'7csub'7csuper'7cteeny'7ctext'7ctiny'7ctranslate'28'2dscaled'29'3f'7ctransparent'7ctypewriter'7cunderline'7cupright'7cvcenter'7cwhiteout'7cwith'2d'28color'7cdimensions'7curl'29'7cwordwrap'7c'28markup'7ccolumn'2d'7cjustified'2d'7coverride'2d'7cwordwrap'2d'29lines'7cwordwrap'2d'28string'2d'29'3finternal'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5c'5c'28arrow'2dhead'7cbeam'7cchar'7c'28semi'7csesqui'7cdouble'29'3f'28flat'7csharp'29'7cdraw'2d'28circle'7cline'29'7cepsfile'7ceyeglasses'7cfilled'2dbox'7cfret'2ddiagram'28'2dterse'7c'2dverbose'29'3f'7cfromproperty'7charp'2dpedal'7c'28justify'7cwordwrap'29'2d'28field'7cstring'29'7cleft'2dbrace'7clookup'7cmarkalphabet'7cmarkletter'7cmusicglyph'7cnatural'7cnote'2dby'2dnumber'7cnote'7cnull'7cpath'7cright'2dbrace'7csimple'7c'28back'29'3fslashed'2ddigit'7cstencil'7cstrut'7ctied'2dlyric'7ctriangle'7cverbatim'2dfile'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext ("LilyPond","scheme"))
   <|>
   ((pRegExpr regex_'5b'5e'22'5cs'5c'5c'23'25'7b'7d'24'5d'2b >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","markup2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","markuprules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","markup2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","markuprules") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","markuprules"))
   <|>
   ((pRegExpr regex_'5c'5cscore'5cb >>= withAttribute BaseNTok) >>~ pushContext ("LilyPond","notemode"))
   <|>
   ((pRegExpr regex_'5c'5c'28arrow'2dhead'7cbeam'7cchar'7c'28semi'7csesqui'7cdouble'29'3f'28flat'7csharp'29'7cdraw'2d'28circle'7cline'29'7cepsfile'7ceyeglasses'7cfilled'2dbox'7cfret'2ddiagram'28'2dterse'7c'2dverbose'29'3f'7cfromproperty'7charp'2dpedal'7c'28justify'7cwordwrap'29'2d'28field'7cstring'29'7cleft'2dbrace'7clookup'7cmarkalphabet'7cmarkletter'7cmusicglyph'7cnatural'7cnote'2dby'2dnumber'7cnote'7cnull'7cpath'7cright'2dbrace'7csimple'7c'28back'29'3fslashed'2ddigit'7cstencil'7cstrut'7ctied'2dlyric'7ctriangle'7cverbatim'2dfile'7cmarkup'7cbold'7c'28rounded'2d'29'3fbox'7cbracket'7ccaps'7c'28center'7cgeneral'7cleft'7cright'29'2dalign'7ccircle'7c'28'28center'7cdir'7cleft'7cright'29'2d'29'3fcolumn'7ccombine'7cconcat'7cdynamic'7cfill'2dline'7cfinger'7cfontCaps'7c'28abs'2d'29'3ffontsize'7cfraction'7chalign'7chbracket'7chcenter'2din'7chcenter'7chspace'7chuge'7citalic'7cjustify'7clarger'3f'7cline'7clower'7cmagnify'7cmedium'7cnormal'2dsize'2d'28sub'7csuper'29'7cnormal'2dtext'7cnormalsize'7cnumber'7con'2dthe'2dfly'7coverride'7cpad'2d'28around'7cmarkup'7cto'2dbox'7cx'29'7cpage'2dref'7cpostscript'7cput'2dadjacent'7craise'7croman'7crotate'7csans'7csmall'28er'29'3f'7csmallCaps'7csub'7csuper'7cteeny'7ctext'7ctiny'7ctranslate'28'2dscaled'29'3f'7ctransparent'7ctypewriter'7cunderline'7cupright'7cvcenter'7cwhiteout'7cwith'2d'28color'7cdimensions'7curl'29'7cwordwrap'7c'28markup'7ccolumn'2d'7cjustified'2d'7coverride'2d'7cwordwrap'2d'29lines'7cwordwrap'2d'28string'2d'29'3finternal'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5c'5c'28bigger'7ch'3fcenter'29'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bA'2dZa'2dz'5d'2b'28'2d'5bA'2dZa'2dz'5d'2b'29'2a >>= withAttribute FunctionTok))
   <|>
   ((parseRules ("LilyPond","basic")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","markuprules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","section") =
  (((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","section2"))
   <|>
   ((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","section2") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("LilyPond","sectionrules")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","section2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","sectionrules") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","sectionrules"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_contexts >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_deprecatedcontexts >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'22'3f'29'5cb'28'28Accidental'7cAmbitus'7cArpeggio'7cAuto'5fbeam'7cAxis'5fgroup'7cBalloon'7cBar'7cBar'5fnumber'7cBeam'7cBend'7cBreak'5falign'7cBreathing'5fsign'7cChord'5fname'7cChord'5ftremolo'7cClef'7cCluster'5fspanner'7cCollision'7cCompletion'5fheads'7cCustos'7cDefault'5fbar'5fline'7cDot'5fcolumn'7cDots'7cDrum'5fnotes'7cDynami'5falign'7cDynamic'7cEpisema'7cExtender'7cFigured'5fbass'7cFigured'5fbass'5fposition'7cFingering'7cFont'5fsize'7cForbid'5fline'5fbreak'7cFretboard'7cGlissando'7cGrace'5fbeam'7cGrace'7cGrace'5fspacing'7cGrid'5fline'5fspan'7cGrid'5fpoint'7cGrob'5fpq'7cHara'5fkiri'7cHorizontal'5fbracket'29'5fengraver'29'5cb'5c1 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'22'3f'29'5cb'28'28Hyphen'7cInstrument'5fname'7cInstrument'5fswitch'7cKey'7cLaissez'5fvibrer'7cLedger'5fline'7cLigature'5fbracket'7cLyric'7cMark'7cMeasure'5fgrouping'7cMelody'7cMensural'5fligature'7cMetronome'5fmark'7cMulti'5fmeasure'5frest'7cNew'5fdynamic'7cNew'5ffingering'7cNote'5fhead'5fline'7cNote'5fheads'7cNote'5fname'7cNote'5fspacing'7cOttava'5fspanner'7cOutput'5fproperty'7cPage'5fturn'7cPaper'5fcolumn'7cParenthesis'7cPart'5fcombine'7cPercent'5frepeat'7cPhrasing'5fslur'7cPiano'5fpedal'5falign'7cPiano'5fpedal'7cPitch'5fsquash'7cPitched'5ftrill'7cRepeat'5facknowledge'7cRepeat'5ftie'7cRest'5fcollision'7cRest'7cRhythmic'5fcolumn'7cScheme'7cScript'5fcolumn'7cScript'7cScript'5frow'29'5fengraver'29'5cb'5c1 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'22'3f'29'5cb'28'28Separating'5fline'5fgroup'7cSlash'5frepeat'7cSlur'7cSpacing'7cSpan'5farpeggio'7cSpan'5fbar'7cSpanner'5fbreak'5fforbid'7cStaff'5fcollecting'7cStaff'5fsymbol'7cStanza'5fnumber'5falign'7cStanza'5fnumber'7cStem'7cString'5fnumber'7cSwallow'7cSystem'5fstart'5fdelimiter'7cTab'5fharmonic'7cTab'5fnote'5fheads'7cTab'5fstaff'5fsymbol'7cText'7cText'5fspanner'7cTie'7cTime'5fsignature'7cTrill'5fspanner'7cTuplet'7cTweak'7cVaticana'5fligature'7cVertical'5falign'7cVertically'5fspaced'5fcontexts'7cVolta'29'5fengraver'29'5cb'5c1 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'22'3f'29'5cb'28'28Beam'7cControl'5ftrack'7cDrum'5fnote'7cDynamic'7cKey'7cLyric'7cNote'7cPiano'5fpedal'7cSlur'7cStaff'7cSwallow'7cTempo'7cTie'7cTime'5fsignature'29'5fperformer'29'5cb'5c1 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'22'3f'29'5cb'28'28Note'5fswallow'7cRest'5fswallow'7cSkip'5fevent'5fswallow'7cTiming'29'5ftranslator'29'5cb'5c1 >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_layoutobjects >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_properties >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5cb'28dedication'7c'28sub'29'7b'2c2'7dtitle'7cpoet'7ccomposer'7cmeter'7copus'7carranger'7cinstrument'7cpiece'7cbreakbefore'7ccopyright'7ctagline'7cmutopia'28title'7ccomposer'7cpoet'7copus'7cinstrument'29'7cdate'7centeredby'7csource'7cstyle'7cmaintainer'28Email'7cWeb'29'3f'7cmoreInfo'7clastupdated'7ctexidoc'7cfooter'7c'28top'7cbottom'7cleft'7cright'29'2dmargin'7c'28foot'7chead'29'2dseparation'7cindent'7cshort'2dindent'7cpaper'2d'28height'7cwidth'29'7chorizontal'2dshift'7cline'2dwidth'7c'28inner'7couter'29'2dmargin'7ctwo'2dsided'7cbinding'2doffset'7c'28after'7cbefore'7cbetween'29'2dtitle'2dspace'7cbetween'2dsystem'2d'28space'7cpadding'29'7cpage'2dtop'2dspace'7cpage'2dbreaking'2dbetween'2dsystem'2dpadding'7c'28after'7cbefore'7cbetween'29'2dtitle'2dspacing'7cbetween'2d'28scores'2d'29'3fsystem'2dspacing'7cbottom'2dsystem'2dspacing'7ctop'2dtitle'2dspacing'7ctop'2dsystem'2dspacing'7cpage'2dbreaking'2dbetween'2dsystem'2dspacing'7csystem'2dcount'7c'28min'2d'7cmax'2d'29'3fsystems'2dper'2dpage'7cannotate'2dspacing'7cauto'2dfirst'2dpage'2dnumber'7cblank'2d'28last'2d'29'3fpage'2dforce'7cfirst'2dpage'2dnumber'7cpage'2dcount'7cpage'2dlimit'2dinter'2dsystem'2dspace'7cpage'2dlimit'2dinter'2dsystem'2dspace'2dfactor'7cpage'2dspacing'2dweight'7cprint'2dall'2dheaders'7cprint'2dfirst'2dpage'2dnumber'7cprint'2dpage'2dnumber'7cragged'2d'28bottom'7cright'29'7cragged'2dlast'28'2dbottom'29'3f'7csystem'2dseparator'2dmarkup'7cforce'2dassignment'7cinput'2dencoding'7coutput'2dscale'7c'28'28even'7codd'29'28Footer'7cHeader'29'7c'28book'7cscore'7ctoc'29Title'7ctocItem'29Markup'7csystem'2dcount'7c'28short'2d'29'3findent'29'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_deprecatedproperties >>= withAttribute DataTypeTok))
   <|>
   ((parseRules ("LilyPond","default")))
   <|>
   (currentContext >>= \x -> guard (x == ("LilyPond","sectionrules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LilyPond","context") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_contexts >>= withAttribute DataTypeTok) >>~ pushContext ("LilyPond","context2"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_deprecatedcontexts >>= withAttribute DataTypeTok) >>~ pushContext ("LilyPond","context2"))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5d'2b >>= withAttribute FunctionTok) >>~ pushContext ("LilyPond","context2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("LilyPond","section2"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","context2") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'3d'28'5cs'2a'5bA'2dZa'2dz'5d'2b'29'3f >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","set") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_contexts >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_deprecatedcontexts >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '.' >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_properties >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_deprecatedproperties >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5d'2b >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","override") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_contexts >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_deprecatedcontexts >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '.' >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'_0123456789" list_layoutobjects >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5d'2b'28'3f'3d'5cs'2a'5c'2e'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5d'2b >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("LilyPond","tempo") =
  (((pRegExpr regex_'5c'5cmarkup'28lines'29'3f'28'3f'21'5bA'2dZa'2dz'5d'29 >>= withAttribute BaseNTok) >>~ pushContext ("LilyPond","markup"))
   <|>
   ((pRegExpr regex_'5cd'2b'5c'2e'2a'5cs'2a'3d'5cs'2a'5cd'2b >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((parseRules ("LilyPond","basic")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("LilyPond","lilypond") <|> fail ("Unknown context" ++ show x)
