//nolint
package irc

const (
	// RFC1459
	RPL_TRACELINK         = "200"
	RPL_TRACECONNECTING   = "201"
	RPL_TRACEHANDSHAKE    = "202"
	RPL_TRACEUNKNOWN      = "203"
	RPL_TRACEOPERATOR     = "204"
	RPL_TRACEUSER         = "205"
	RPL_TRACESERVER       = "206"
	RPL_TRACENEWTYPE      = "208"
	RPL_STATSLINKINFO     = "211"
	RPL_STATSCOMMANDS     = "212"
	RPL_STATSCLINE        = "213"
	RPL_STATSNLINE        = "214"
	RPL_STATSILINE        = "215"
	RPL_STATSKLINE        = "216"
	RPL_STATSQLINE        = "217"
	RPL_STATSYLINE        = "218"
	RPL_ENDOFSTATS        = "219"
	RPL_UMODEIS           = "221"
	RPL_STATSLLINE        = "241"
	RPL_STATSUPTIME       = "242"
	RPL_STATSOLINE        = "243"
	RPL_STATSHLINE        = "244"
	RPL_LUSERCLIENT       = "251"
	RPL_LUSEROP           = "252"
	RPL_LUSERUNKNOWN      = "253"
	RPL_LUSERCHANNELS     = "254"
	RPL_LUSERME           = "255"
	RPL_ADMINME           = "256"
	RPL_ADMINLOC1         = "257"
	RPL_ADMINLOC2         = "258"
	RPL_ADMINEMAIL        = "259"
	RPL_TRACELOG          = "261"
	RPL_NONE              = "300"
	RPL_AWAY              = "301"
	RPL_USERHOST          = "302"
	RPL_ISON              = "303"
	RPL_UNAWAY            = "305"
	RPL_NOWAWAY           = "306"
	RPL_WHOISUSER         = "311"
	RPL_WHOISSERVER       = "312"
	RPL_WHOISOPERATOR     = "313"
	RPL_WHOWASUSER        = "314"
	RPL_ENDOFWHO          = "315"
	RPL_WHOISIDLE         = "317"
	RPL_ENDOFWHOIS        = "318"
	RPL_WHOISCHANNELS     = "319"
	RPL_LIST              = "322"
	RPL_LISTEND           = "323"
	RPL_CHANNELMODEIS     = "324"
	RPL_NOTOPIC           = "331"
	RPL_TOPIC             = "332"
	RPL_INVITING          = "341"
	RPL_VERSION           = "351"
	RPL_WHOREPLY          = "352"
	RPL_NAMREPLY          = "353"
	RPL_LINKS             = "364"
	RPL_ENDOFLINKS        = "365"
	RPL_ENDOFNAMES        = "366"
	RPL_BANLIST           = "367"
	RPL_ENDOFBANLIST      = "368"
	RPL_ENDOFWHOWAS       = "369"
	RPL_INFO              = "371"
	RPL_MOTD              = "372"
	RPL_ENDOFINFO         = "374"
	RPL_MOTDSTART         = "375"
	RPL_ENDOFMOTD         = "376"
	RPL_YOUREOPER         = "381"
	RPL_REHASHING         = "382"
	RPL_TIME              = "391"
	RPL_USERSSTART        = "392"
	RPL_USERS             = "393"
	RPL_ENDOFUSERS        = "394"
	RPL_NOUSERS           = "395"
	ERR_NOSUCHNICK        = "401"
	ERR_NOSUCHSERVER      = "402"
	ERR_NOSUCHCHANNEL     = "403"
	ERR_CANNOTSENDTOCHAN  = "404"
	ERR_TOOMANYCHANNELS   = "405"
	ERR_WASNOSUCHNICK     = "406"
	ERR_TOOMANYTARGETS    = "407"
	ERR_NOORIGIN          = "409"
	ERR_NORECIPIENT       = "411"
	ERR_NOTEXTTOSEND      = "412"
	ERR_NOTOPLEVEL        = "413"
	ERR_WILDTOPLEVEL      = "414"
	ERR_UNKNOWNCOMMAND    = "421"
	ERR_NOMOTD            = "422"
	ERR_NOADMININFO       = "423"
	ERR_FILEERROR         = "424"
	ERR_NONICKNAMEGIVEN   = "431"
	ERR_ERRONEUSNICKNAME  = "432"
	ERR_NICKNAMEINUSE     = "433"
	ERR_NICKCOLLISION     = "436"
	ERR_USERNOTINCHANNEL  = "441"
	ERR_NOTONCHANNEL      = "442"
	ERR_USERONCHANNEL     = "443"
	ERR_NOLOGIN           = "444"
	ERR_SUMMONDISABLED    = "445"
	ERR_USERSDISABLED     = "446"
	ERR_NOTREGISTERED     = "451"
	ERR_NEEDMOREPARAMS    = "461"
	ERR_ALREADYREGISTERED = "462"
	ERR_NOPERMFORHOST     = "463"
	ERR_PASSWDMISMATCH    = "464"
	ERR_YOUREBANNEDCREEP  = "465"
	ERR_KEYSET            = "467"
	ERR_CHANNELISFULL     = "471"
	ERR_UNKNOWNMODE       = "472"
	ERR_INVITEONLYCHAN    = "473"
	ERR_BANNEDFROMCHAN    = "474"
	ERR_BADCHANNELKEY     = "475"
	ERR_NOPRIVILEGES      = "481"
	ERR_CHANOPRIVSNEEDED  = "482"
	ERR_CANTKILLSERVER    = "483"
	ERR_NOOPERHOST        = "491"
	ERR_UMODEUNKNOWNFLAG  = "501"
	ERR_USERSDONTMATCH    = "502"

	// RFC1459 (Obsolete)
	RPL_SERVICEINFO     = "231"
	RPL_ENDOFSERVICES   = "232"
	RPL_SERVICE         = "233"
	RPL_WHOISCHANOP     = "316"
	RPL_LISTSTART       = "321"
	RPL_SUMMONING       = "342"
	RPL_KILLDONE        = "361"
	RPL_CLOSING         = "362"
	RPL_CLOSEEND        = "363"
	RPL_INFOSTART       = "373"
	RPL_MYPORTIS        = "384"
	ERR_YOUWILLBEBANNED = "466"
	ERR_NOSERVICEHOST   = "492"

	// RFC2812
	RPL_WELCOME          = "001"
	RPL_YOURHOST         = "002"
	RPL_CREATED          = "003"
	RPL_MYINFO           = "004"
	RPL_TRACESERVICE     = "207"
	RPL_TRACECLASS       = "209"
	RPL_SERVLIST         = "234"
	RPL_SERVLISTEND      = "235"
	RPL_STATSVLINE       = "240"
	RPL_STATSBLINE       = "247"
	RPL_STATSDLINE       = "250"
	RPL_TRACEEND         = "262"
	RPL_TRYAGAIN         = "263"
	RPL_UNIQOPIS         = "325"
	RPL_INVITELIST       = "346"
	RPL_ENDOFINVITELIST  = "347"
	RPL_EXCEPTLIST       = "348"
	RPL_ENDOFEXCEPTLIST  = "349"
	RPL_YOURESERVICE     = "383"
	ERR_NOSUCHSERVICE    = "408"
	ERR_BADMASK          = "415"
	ERR_UNAVAILRESOURCE  = "437"
	ERR_BADCHANMASK      = "476"
	ERR_NOCHANMODES      = "477"
	ERR_BANLISTFULL      = "478"
	ERR_RESTRICTED       = "484"
	ERR_UNIQOPRIVSNEEDED = "485"

	// RFC2812 (Obsolete)
	RPL_BOUNCE         = "005"
	RPL_TRACERECONNECT = "210"
	RPL_STATSPING      = "246"

	// IRCv3
	ERR_INVALIDCAPCMD   = "410" // Undernet?
	RPL_STARTTLS        = "670"
	ERR_STARTTLS        = "691"
	RPL_MONONLINE       = "730" // RatBox
	RPL_MONOFFLINE      = "731" // RatBox
	RPL_MONLIST         = "732" // RatBox
	RPL_ENDOFMONLIST    = "733" // RatBox
	ERR_MONLISTFULL     = "734" // RatBox
	RPL_WHOISKEYVALUE   = "760"
	RPL_KEYVALUE        = "761"
	RPL_METADATAEND     = "762"
	ERR_METADATALIMIT   = "764"
	ERR_TARGETINVALID   = "765"
	ERR_NOMATCHINGKEY   = "766"
	ERR_KEYINVALID      = "767"
	ERR_KEYNOTSET       = "768"
	ERR_KEYNOPERMISSION = "769"
	RPL_LOGGEDIN        = "900" // Charybdis/Atheme, IRCv3
	RPL_LOGGEDOUT       = "901" // Charybdis/Atheme, IRCv3
	ERR_NICKLOCKED      = "902" // Charybdis/Atheme, IRCv3
	RPL_SASLSUCCESS     = "903" // Charybdis/Atheme, IRCv3
	ERR_SASLFAIL        = "904" // Charybdis/Atheme, IRCv3
	ERR_SASLTOOLONG     = "905" // Charybdis/Atheme, IRCv3
	ERR_SASLABORTED     = "906" // Charybdis/Atheme, IRCv3
	ERR_SASLALREADY     = "907" // Charybdis/Atheme, IRCv3
	RPL_SASLMECHS       = "908" // Charybdis/Atheme, IRCv3

	// Other
	RPL_ISUPPORT = "005"

	// Ignored
	//
	// Anything not in an RFC has not been included because
	// there are way too many conflicts to deal with.
	/*
		RPL_MAP                  = "006" // Unreal
		RPL_MAPEND               = "007" // Unreal
		RPL_SNOMASK              = "008" // ircu
		RPL_STATMEMTOT           = "009" // ircu
		RPL_BOUNCE               = "010"
		RPL_YOURCOOKIE           = "014" // Hybrid?
		RPL_MAP                  = "015" // ircu
		RPL_MAPMORE              = "016" // ircu
		RPL_MAPEND               = "017" // ircu
		RPL_MAPUSERS             = "018" // InspIRCd
		RPL_HELLO                = "020" // rusnet-ircd
		RPL_APASSWARN_SET        = "030" // ircu
		RPL_APASSWARN_SECRET     = "031" // ircu
		RPL_APASSWARN_CLEAR      = "032" // ircu
		RPL_YOURID               = "042" // IRCnet
		RPL_SAVENICK             = "043" // IRCnet
		RPL_ATTEMPTINGJUNC       = "050" // aircd
		RPL_ATTEMPTINGREROUTE    = "051" // aircd
		RPL_REMOTEISUPPORT       = "105" // Unreal
		RPL_STATS                = "210" // aircd
		RPL_STATSHELP            = "210" // Unreal
		RPL_STATSPLINE           = "217" // ircu
		RPL_STATSPLINE           = "220" // Hybrid
		RPL_STATSBLINE           = "220" // Bahamut, Unreal
		RPL_STATSWLINE           = "220" // Nefarious
		RPL_MODLIST              = "222"
		RPL_SQLINE_NICK          = "222" // Unreal
		RPL_STATSBLINE           = "222" // Bahamut
		RPL_STATSJLINE           = "222" // ircu
		RPL_CODEPAGE             = "222" // rusnet-ircd
		RPL_STATSELINE           = "223" // Bahamut
		RPL_STATSGLINE           = "223" // Unreal
		RPL_CHARSET              = "223" // rusnet-ircd
		RPL_STATSFLINE           = "224" // Hybrid, Bahamut
		RPL_STATSTLINE           = "224" // Unreal
		RPL_STATSDLINE           = "225" // Hybrid
		RPL_STATSCLONE           = "225" // Bahamut
		RPL_STATSELINE           = "225" // Unreal
		RPL_STATSCOUNT           = "226" // Bahamut
		RPL_STATSALINE           = "226" // Hybrid
		RPL_STATSNLINE           = "226" // Unreal
		RPL_STATSGLINE           = "227" // Bahamut
		RPL_STATSVLINE           = "227" // Unreal
		RPL_STATSBLINE           = "227" // Rizon
		RPL_STATSQLINE           = "228" // ircu
		RPL_STATSBANVER          = "228" // Unreal
		RPL_STATSSPAMF           = "229" // Unreal
		RPL_STATSEXCEPTTKL       = "230" // Unreal
		RPL_RULES                = "232" // Unreal
		RPL_STATSVERBOSE         = "236" // ircu
		RPL_STATSENGINE          = "237" // ircu
		RPL_STATSFLINE           = "238" // ircu
		RPL_STATSIAUTH           = "239" // IRCnet
		RPL_STATSXLINE           = "240" // AustHex
		RPL_STATSSLINE           = "245" // Bahamut, IRCnet, Hybrid
		RPL_STATSTLINE           = "245" // Hybrid?
		RPL_STATSSERVICE         = "246" // Hybrid
		RPL_STATSTLINE           = "246" // ircu
		RPL_STATSULINE           = "246" // Hybrid
		RPL_STATSXLINE           = "247" // Hybrid, PTlink, Unreal
		RPL_STATSGLINE           = "247" // ircu
		RPL_STATSULINE           = "248" // ircu
		RPL_STATSDEFINE          = "248" // IRCnet
		RPL_STATSULINE           = "249"
		RPL_STATSDEBUG           = "249" // Hybrid
		RPL_STATSCONN            = "250" // ircu, Unreal
		RPL_TRACEPING            = "262"
		RPL_USINGSSL             = "264" // rusnet-ircd
		RPL_LOCALUSERS           = "265" // aircd, Hybrid, Bahamut
		RPL_GLOBALUSERS          = "266" // aircd, Hybrid, Bahamut
		RPL_START_NETSTAT        = "267" // aircd
		RPL_NETSTAT              = "268" // aircd
		RPL_END_NETSTAT          = "269" // aircd
		RPL_PRIVS                = "270" // ircu
		RPL_SILELIST             = "271" // ircu
		RPL_ENDOFSILELIST        = "272" // ircu
		RPL_NOTIFY               = "273" // aircd
		RPL_ENDNOTIFY            = "274" // aircd
		RPL_STATSDELTA           = "274" // IRCnet
		RPL_STATSDLINE           = "275" // ircu, Ultimate
		RPL_USINGSSL             = "275" // Bahamut
		RPL_WHOISCERTFP          = "276" // oftc-hybrid
		RPL_STATSRLINE           = "276" // ircu
		RPL_GLIST                = "280" // ircu
		RPL_ENDOFGLIST           = "281" // ircu
		RPL_ACCEPTLIST           = "281"
		RPL_ENDOFACCEPT          = "282"
		RPL_JUPELIST             = "282" // ircu
		RPL_ALIST                = "283"
		RPL_ENDOFJUPELIST        = "283" // ircu
		RPL_ENDOFALIST           = "284"
		RPL_FEATURE              = "284" // ircu
		RPL_GLIST_HASH           = "285"
		RPL_CHANINFO_HANDLE      = "285" // aircd
		RPL_NEWHOSTIS            = "285" // QuakeNet
		RPL_CHANINFO_USERS       = "286" // aircd
		RPL_CHKHEAD              = "286" // QuakeNet
		RPL_CHANINFO_CHOPS       = "287" // aircd
		RPL_CHANUSER             = "287" // QuakeNet
		RPL_CHANINFO_VOICES      = "288" // aircd
		RPL_PATCHHEAD            = "288" // QuakeNet
		RPL_CHANINFO_AWAY        = "289" // aircd
		RPL_PATCHCON             = "289" // QuakeNet
		RPL_CHANINFO_OPERS       = "290" // aircd
		RPL_HELPHDR              = "290" // Unreal
		RPL_DATASTR              = "290" // QuakeNet
		RPL_CHANINFO_BANNED      = "291" // aircd
		RPL_HELPOP               = "291" // Unreal
		RPL_ENDOFCHECK           = "291" // QuakeNet
		RPL_CHANINFO_BANS        = "292" // aircd
		RPL_HELPTLR              = "292" // Unreal
		ERR_SEARCHNOMATCH        = "292" // Nefarious
		RPL_CHANINFO_INVITE      = "293" // aircd
		RPL_HELPHLP              = "293" // Unreal
		RPL_CHANINFO_INVITES     = "294" // aircd
		RPL_HELPFWD              = "294" // Unreal
		RPL_CHANINFO_KICK        = "295" // aircd
		RPL_HELPIGN              = "295" // Unreal
		RPL_CHANINFO_KICKS       = "296" // aircd
		RPL_END_CHANINFO         = "299" // aircd
		RPL_TEXT                 = "304" // irc2?
		RPL_USERIP               = "307"
		RPL_WHOISREGNICK         = "307" // Bahamut, Unreal
		RPL_SUSERHOST            = "307" // AustHex
		RPL_NOTIFYACTION         = "308" // aircd
		RPL_WHOISADMIN           = "308" // Bahamut
		RPL_RULESSTART           = "308" // Unreal
		RPL_NICKTRACE            = "309" // aircd
		RPL_WHOISSADMIN          = "309" // Bahamut
		RPL_ENDOFRULES           = "309" // Unreal
		RPL_WHOISHELPER          = "309" // AustHex
		RPL_WHOISSVCMSG          = "310" // Bahamut
		RPL_WHOISHELPOP          = "310" // Unreal
		RPL_WHOISSERVICE         = "310" // AustHex
		RPL_WHOISPRIVDEAF        = "316" // Nefarious
		RPL_WHOISVIRT            = "320" // AustHex
		RPL_WHOIS_HIDDEN         = "320" // Anothernet
		RPL_WHOISSPECIAL         = "320" // Unreal
		RPL_CHANNELPASSIS        = "325"
		RPL_WHOISWEBIRC          = "325" // Nefarious
		RPL_NOCHANPASS           = "326"
		RPL_CHPASSUNKNOWN        = "327"
		RPL_WHOISHOST            = "327" // rusnet-ircd
		RPL_CHANNEL_URL          = "328" // Bahamut, AustHex
		RPL_CREATIONTIME         = "329" // Bahamut
		RPL_WHOWAS_TIME          = "330"
		RPL_WHOISACCOUNT         = "330" // ircu
		RPL_TOPICWHOTIME         = "333" // ircu
		RPL_LISTUSAGE            = "334" // ircu
		RPL_COMMANDSYNTAX        = "334" // Bahamut
		RPL_LISTSYNTAX           = "334" // Unreal
		RPL_WHOISBOT             = "335" // Unreal
		RPL_WHOISTEXT            = "335" // Hybrid
		RPL_WHOISACCOUNTONLY     = "335" // Nefarious
		RPL_INVITELIST           = "336" // Hybrid
		RPL_WHOISBOT             = "336" // Nefarious
		RPL_ENDOFINVITELIST      = "337" // Hybrid
		RPL_WHOISTEXT            = "337" // Hybrid?
		RPL_CHANPASSOK           = "338"
		RPL_WHOISACTUALLY        = "338" // ircu, Bahamut
		RPL_BADCHANPASS          = "339"
		RPL_WHOISMARKS           = "339" // Nefarious
		RPL_USERIP               = "340" // ircu
		RPL_WHOISKILL            = "343" // Nefarious
		RPL_WHOISCOUNTRY         = "344" // InspIRCd 3.0
		RPL_INVITED              = "345" // GameSurge
		RPL_WHOISGATEWAY         = "350" // InspIRCd 3.0
		RPL_WHOSPCRPL            = "354" // ircu
		RPL_NAMREPLY_            = "355" // QuakeNet
		RPL_MAP                  = "357" // AustHex
		RPL_MAPMORE              = "358" // AustHex
		RPL_MAPEND               = "359" // AustHex
		RPL_KICKEXPIRED          = "377" // aircd
		RPL_BANEXPIRED           = "378" // aircd
		RPL_WHOISHOST            = "378" // Unreal
		RPL_KICKLINKED           = "379" // aircd
		RPL_WHOISMODES           = "379" // Unreal
		RPL_BANLINKED            = "380" // aircd
		RPL_YOURHELPER           = "380" // AustHex
		RPL_NOTOPERANYMORE       = "385" // AustHex, Hybrid, Unreal
		RPL_QLIST                = "386" // Unreal
		RPL_IRCOPS               = "386" // Ultimate
		RPL_IRCOPSHEADER         = "386" // Nefarious
		RPL_ENDOFQLIST           = "387" // Unreal
		RPL_ENDOFIRCOPS          = "387" // Ultimate
		RPL_IRCOPS               = "387" // Nefarious
		RPL_ALIST                = "388" // Unreal
		RPL_ENDOFIRCOPS          = "388" // Nefarious
		RPL_ENDOFALIST           = "389" // Unreal
		RPL_TIME                 = "391" // ircu
		RPL_TIME                 = "391" // bdq-ircd
		RPL_TIME                 = "391"
		RPL_VISIBLEHOST          = "396" // Hybrid
		RPL_CLONES               = "399" // InspIRCd 3.0
		ERR_UNKNOWNERROR         = "400"
		ERR_NOCOLORSONCHAN       = "408" // Bahamut
		ERR_NOCTRLSONCHAN        = "408" // Hybrid
		ERR_TOOMANYMATCHES       = "416" // IRCnet
		ERR_QUERYTOOLONG         = "416" // ircu
		ERR_INPUTTOOLONG         = "417" // ircu
		ERR_LENGTHTRUNCATED      = "419" // aircd
		ERR_AMBIGUOUSCOMMAND     = "420" // InspIRCd
		ERR_NOOPERMOTD           = "425" // Unreal
		ERR_TOOMANYAWAY          = "429" // Bahamut
		ERR_EVENTNICKCHANGE      = "430" // AustHex
		ERR_SERVICENAMEINUSE     = "434" // AustHex?
		ERR_NORULES              = "434" // Unreal, Ultimate
		ERR_SERVICECONFUSED      = "435" // Unreal
		ERR_BANONCHAN            = "435" // Bahamut
		ERR_BANNICKCHANGE        = "437" // ircu
		ERR_NICKTOOFAST          = "438" // ircu
		ERR_DEAD                 = "438" // IRCnet
		ERR_TARGETTOOFAST        = "439" // ircu
		ERR_SERVICESDOWN         = "440" // Bahamut, Unreal
		ERR_NONICKCHANGE         = "447" // Unreal
		ERR_FORBIDDENCHANNEL     = "448" // Unreal
		ERR_NOTIMPLEMENTED       = "449" // Undernet
		ERR_IDCOLLISION          = "452"
		ERR_NICKLOST             = "453"
		ERR_HOSTILENAME          = "455" // Unreal
		ERR_ACCEPTFULL           = "456"
		ERR_ACCEPTEXIST          = "457"
		ERR_ACCEPTNOT            = "458"
		ERR_NOHIDING             = "459" // Unreal
		ERR_NOTFORHALFOPS        = "460" // Unreal
		ERR_INVALIDUSERNAME      = "468" // ircu
		ERR_ONLYSERVERSCANCHANGE = "468" // Bahamut, Unreal
		ERR_NOCODEPAGE           = "468" // rusnet-ircd
		ERR_LINKSET              = "469" // Unreal
		ERR_LINKCHANNEL          = "470" // Unreal
		ERR_KICKEDFROMCHAN       = "470" // aircd
		ERR_7BIT                 = "470" // rusnet-ircd
		ERR_NEEDREGGEDNICK       = "477" // Bahamut, ircu, Unreal
		ERR_BADCHANNAME          = "479" // Hybrid
		ERR_LINKFAIL             = "479" // Unreal
		ERR_NOCOLOR              = "479" // rusnet-ircd
		ERR_NOULINE              = "480" // AustHex
		ERR_CANNOTKNOCK          = "480" // Unreal
		ERR_THROTTLE             = "480" // Ratbox
		ERR_NOWALLOP             = "480" // rusnet-ircd
		ERR_ISCHANSERVICE        = "484" // Undernet
		ERR_DESYNC               = "484" // Bahamut, Hybrid, PTlink
		ERR_ATTACKDENY           = "484" // Unreal
		ERR_KILLDENY             = "485" // Unreal
		ERR_CANTKICKADMIN        = "485" // PTlink
		ERR_ISREALSERVICE        = "485" // QuakeNet
		ERR_CHANBANREASON        = "485" // Hybrid
		ERR_NONONREG             = "486" // Unreal?
		ERR_HTMDISABLED          = "486" // Unreal
		ERR_ACCOUNTONLY          = "486" // QuakeNet
		ERR_RLINED               = "486" // rusnet-ircd
		ERR_CHANTOORECENT        = "487" // IRCnet
		ERR_MSGSERVICES          = "487" // Bahamut
		ERR_NOTFORUSERS          = "487" // Unreal?
		ERR_NONONSSL             = "487" // ChatIRCd
		ERR_TSLESSCHAN           = "488" // IRCnet
		ERR_HTMDISABLED          = "488" // Unreal?
		ERR_NOSSL                = "488" // Bahamut
		ERR_SECUREONLYCHAN       = "489" // Unreal
		ERR_VOICENEEDED          = "489" // Undernet
		ERR_ALLMUSTSSL           = "490" // InspIRCd
		ERR_NOSWEAR              = "490" // Unreal
		ERR_NOCTCP               = "492" // Hybrid / Unreal?
		ERR_CANNOTSENDTOUSER     = "492" // Charybdis?
		ERR_NOSHAREDCHAN         = "493" // Bahamut
		ERR_NOFEATURE            = "493" // ircu
		ERR_BADFEATVALUE         = "494" // ircu
		ERR_OWNMODE              = "494" // Bahamut, charybdis?
		ERR_BADLOGTYPE           = "495" // ircu
		ERR_BADLOGSYS            = "496" // ircu
		ERR_BADLOGVALUE          = "497" // ircu
		ERR_ISOPERLCHAN          = "498" // ircu
		ERR_CHANOWNPRIVNEEDED    = "499" // Unreal
		ERR_TOOMANYJOINS         = "500" // Unreal?
		ERR_NOREHASHPARAM        = "500" // rusnet-ircd
		ERR_CANNOTSETMODER       = "500" // InspIRCd
		ERR_UNKNOWNSNOMASK       = "501" // InspIRCd
		ERR_USERNOTONSERV        = "504"
		ERR_SILELISTFULL         = "511" // ircu
		ERR_TOOMANYWATCH         = "512" // Bahamut
		ERR_NOSUCHGLINE          = "512" // ircu
		ERR_BADPING              = "513" // ircu
		ERR_TOOMANYDCC           = "514" // Bahamut
		ERR_NOSUCHJUPE           = "514" // irch
		ERR_BADEXPIRE            = "515" // ircu
		ERR_DONTCHEAT            = "516" // ircu
		ERR_DISABLED             = "517" // ircu
		ERR_NOINVITE             = "518" // Unreal
		ERR_LONGMASK             = "518" // ircu
		ERR_ADMONLY              = "519" // Unreal
		ERR_TOOMANYUSERS         = "519" // ircu
		ERR_OPERONLY             = "520" // Unreal
		ERR_MASKTOOWIDE          = "520" // ircu
		ERR_LISTSYNTAX           = "521" // Bahamut
		ERR_NOSUCHGLINE          = "521" // Nefarious
		ERR_WHOSYNTAX            = "522" // Bahamut
		ERR_WHOLIMEXCEED         = "523" // Bahamut
		ERR_QUARANTINED          = "524" // ircu
		ERR_OPERSPVERIFY         = "524" // Unreal
		ERR_HELPNOTFOUND         = "524" // Hybrid
		ERR_INVALIDKEY           = "525" // ircu
		ERR_CANTSENDTOUSER       = "531" // InspIRCd
		ERR_BADHOSTMASK          = "550" // QuakeNet
		ERR_HOSTUNAVAIL          = "551" // QuakeNet
		ERR_USINGSLINE           = "552" // QuakeNet
		ERR_STATSSLINE           = "553" // QuakeNet
		ERR_NOTLOWEROPLEVEL      = "560" // ircu
		ERR_NOTMANAGER           = "561" // ircu
		ERR_CHANSECURED          = "562" // ircu
		ERR_UPASSSET             = "563" // ircu
		ERR_UPASSNOTSET          = "564" // ircu
		ERR_NOMANAGER            = "566" // ircu
		ERR_UPASS_SAME_APASS     = "567" // ircu
		ERR_LASTERROR            = "568" // ircu
		RPL_NOOMOTD              = "568" // Nefarious
		RPL_REAWAY               = "597" // Unreal
		RPL_GONEAWAY             = "598" // Unreal
		RPL_NOTAWAY              = "599" // Unreal
		RPL_LOGON                = "600" // Bahamut, Unreal
		RPL_LOGOFF               = "601" // Bahamut, Unreal
		RPL_WATCHOFF             = "602" // Bahamut, Unreal
		RPL_WATCHSTAT            = "603" // Bahamut, Unreal
		RPL_NOWON                = "604" // Bahamut, Unreal
		RPL_NOWOFF               = "605" // Bahamut, Unreal
		RPL_WATCHLIST            = "606" // Bahamut, Unreal
		RPL_ENDOFWATCHLIST       = "607" // Bahamut, Unreal
		RPL_WATCHCLEAR           = "608" // Ultimate
		RPL_NOWISAWAY            = "609" // Unreal
		RPL_MAPMORE              = "610" // Unreal
		RPL_ISOPER               = "610" // Ultimate
		RPL_ISLOCOP              = "611" // Ultimate
		RPL_ISNOTOPER            = "612" // Ultimate
		RPL_ENDOFISOPER          = "613" // Ultimate
		RPL_MAPMORE              = "615" // PTlink
		RPL_WHOISMODES           = "615" // Ultimate
		RPL_WHOISHOST            = "616" // Ultimate
		RPL_WHOISSSLFP           = "617" // Nefarious
		RPL_DCCSTATUS            = "617" // Bahamut
		RPL_WHOISBOT             = "617" // Ultimate
		RPL_DCCLIST              = "618" // Bahamut
		RPL_ENDOFDCCLIST         = "619" // Bahamut
		RPL_WHOWASHOST           = "619" // Ultimate
		RPL_DCCINFO              = "620" // Bahamut
		RPL_RULESSTART           = "620" // Ultimate
		RPL_RULES                = "621" // Ultimate
		RPL_ENDOFRULES           = "622" // Ultimate
		RPL_MAPMORE              = "623" // Ultimate
		RPL_OMOTDSTART           = "624" // Ultimate
		RPL_OMOTD                = "625" // Ultimate
		RPL_ENDOFOMOTD           = "626" // Ultimate
		RPL_SETTINGS             = "630" // Ultimate
		RPL_ENDOFSETTINGS        = "631" // Ultimate
		RPL_SYNTAX               = "650" // InspIRCd 3.0
		RPL_CHANNELSMSG          = "651" // InspIRCd 3.0
		RPL_WHOWASIP             = "652" // InspIRCd 3.0
		RPL_UNINVITED            = "653" // InspIRCd 3.0
		RPL_SPAMCMDFWD           = "659" // Unreal
		RPL_WHOISSECURE          = "671" // Unreal
		RPL_UNKNOWNMODES         = "672" // Ithildin
		RPL_WHOISREALIP          = "672" // Rizon
		RPL_CANNOTSETMODES       = "673" // Ithildin
		RPL_WHOISYOURID          = "674" // ChatIRCd
		RPL_LANGUAGES            = "690" // Unreal?
		ERR_INVALIDMODEPARAM     = "696" // InspIRCd 3.0
		ERR_LISTMODEALREADYSET   = "697" // InspIRCd 3.0
		ERR_LISTMODENOTSET       = "698" // InspIRCd 3.0
		RPL_COMMANDS             = "700" // InspIRCd 3.0
		RPL_COMMANDSEND          = "701" // InspIRCd 3.0
		RPL_MODLIST              = "702" // RatBox
		RPL_ENDOFMODLIST         = "703" // RatBox
		RPL_HELPSTART            = "704" // RatBox
		RPL_HELPTXT              = "705" // RatBox
		RPL_ENDOFHELP            = "706" // RatBox
		ERR_TARGCHANGE           = "707" // RatBox
		RPL_ETRACEFULL           = "708" // RatBox
		RPL_ETRACE               = "709" // RatBox
		RPL_KNOCK                = "710" // RatBox
		RPL_KNOCKDLVR            = "711" // RatBox
		ERR_TOOMANYKNOCK         = "712" // RatBox
		ERR_CHANOPEN             = "713" // RatBox
		ERR_KNOCKONCHAN          = "714" // RatBox
		ERR_KNOCKDISABLED        = "715" // RatBox
		ERR_TOOMANYINVITE        = "715" // Hybrid
		RPL_INVITETHROTTLE       = "715" // Rizon
		RPL_TARGUMODEG           = "716" // RatBox
		RPL_TARGNOTIFY           = "717" // RatBox
		RPL_UMODEGMSG            = "718" // RatBox
		RPL_OMOTDSTART           = "720" // RatBox
		RPL_OMOTD                = "721" // RatBox
		RPL_ENDOFOMOTD           = "722" // RatBox
		ERR_NOPRIVS              = "723" // RatBox
		RPL_TESTMASK             = "724" // RatBox
		RPL_TESTLINE             = "725" // RatBox
		RPL_NOTESTLINE           = "726" // RatBox
		RPL_TESTMASKGECOS        = "727" // RatBox
		RPL_QUIETLIST            = "728" // Charybdis
		RPL_ENDOFQUIETLIST       = "729" // Charybdis
		RPL_RSACHALLENGE2        = "740" // RatBox
		RPL_ENDOFRSACHALLENGE2   = "741" // RatBox
		ERR_MLOCKRESTRICTED      = "742" // Charybdis
		ERR_INVALIDBAN           = "743" // Charybdis
		ERR_TOPICLOCK            = "744" // InspIRCd?
		RPL_SCANMATCHED          = "750" // RatBox
		RPL_SCANUMODES           = "751" // RatBox
		RPL_ETRACEEND            = "759" // irc2.11
		RPL_XINFO                = "771" // Ithildin
		RPL_XINFOSTART           = "773" // Ithildin
		RPL_XINFOEND             = "774" // Ithildin
		RPL_CHECK                = "802" // InspIRCd 3.0
		RPL_OTHERUMODEIS         = "803" // InspIRCd 3.0
		RPL_OTHERSNOMASKIS       = "804" // InspIRCd 3.0
		ERR_BADCHANNEL           = "926" // InspIRCd
		ERR_INVALIDWATCHNICK     = "942" // InspIRCd
		RPL_IDLETIMESET          = "944" // InspIRCd
		RPL_NICKLOCKOFF          = "945" // InspIRCd
		ERR_NICKNOTLOCKED        = "946" // InspIRCd
		RPL_NICKLOCKON           = "947" // InspIRCd
		ERR_INVALIDIDLETIME      = "948" // InspIRCd
		RPL_UNSILENCED           = "950" // InspIRCd
		RPL_SILENCED             = "951" // InspIRCd
		ERR_NOTSILENCED          = "952" // InspIRCd
		RPL_ENDOFPROPLIST        = "960" // InspIRCd
		RPL_PROPLIST             = "961" // InspIRCd
		ERR_CANNOTDOCOMMAND      = "972" // Unreal
		ERR_CANTUNLOADMODULE     = "972" // InspIRCd
		RPL_UNLOADEDMODULE       = "973" // InspIRCd
		ERR_CANNOTCHANGECHANMODE = "974" // Unreal
		ERR_CANTLOADMODULE       = "974" // InspIRCd
		RPL_LOADEDMODULE         = "975" // InspIRCd
		ERR_LASTERROR            = "975" // Nefarious
		RPL_SERVLOCKON           = "988" // InspIRCd
		RPL_SERVLOCKOFF          = "989" // InspIRCd
		RPL_DCCALLOWSTART        = "990" // InspIRCd
		RPL_DCCALLOWLIST         = "991" // InspIRCd
		RPL_DCCALLOWEND          = "992" // InspIRCd
		RPL_DCCALLOWTIMED        = "993" // InspIRCd
		RPL_DCCALLOWPERMANENT    = "994" // InspIRCd
		RPL_DCCALLOWREMOVED      = "995" // InspIRCd
		ERR_DCCALLOWINVALID      = "996" // InspIRCd
		RPL_DCCALLOWEXPIRED      = "997" // InspIRCd
		ERR_UNKNOWNDCCALLOWCMD   = "998" // InspIRCd
		ERR_NUMERIC_ERR          = "999" // Bahamut
	//*/

	// Obsolete
	/*
		RPL_STATMEM             = "010" // ircu
		RPL_STATSZLINE          = "225" // Bahamut
		RPL_MAPUSERS            = "270" // InspIRCd 2.0
		RPL_VCHANEXIST          = "276" // Hybrid
		RPL_VCHANLIST           = "277" // Hybrid
		RPL_VCHANHELP           = "278" // Hybrid 7.0?
		RPL_CHANNELMLOCKIS      = "325" // sorircd
		RPL_WHOWASREAL          = "360" // Charybdis
		RPL_SPAM                = "377" // AustHex
		RPL_MOTD                = "378" // AustHex
		RPL_WHOWASIP            = "379" // InspIRCd 2.0
		RPL_RSACHALLENGE        = "386" // Hybrid
		ERR_SSLONLYCHAN         = "480" // Hybrid
		ERR_BANNEDNICK          = "485" // Ratbox
		ERR_DELAYREJOIN         = "495" // InspIRCd 2.0
		ERR_GHOSTEDCLIENT       = "503" // Hybrid
		ERR_VWORLDWARN          = "503" // AustHex
		ERR_INVALID_ERROR       = "514" // ircu
		ERR_WHOTRUNC            = "520" // AustHex
		ERR_REMOTEPFX           = "525" // CAPAB USERCMDPFX
		ERR_PFXUNROUTABLE       = "526" // CAPAB USERCMDPFX
		RPL_DUMPING             = "640" // Unreal
		RPL_DUMPRPL             = "641" // Unreal
		RPL_EODUMP              = "642" // Unreal
		RPL_COMMANDS            = "702" // InspIRCd 2.0
		RPL_COMMANDSEND         = "703" // InspIRCd 2.0
		ERR_WORDFILTERED        = "936" // InspIRCd
		ERR_ALREADYCHANFILTERED = "937" // InspIRCd 2.0
		ERR_NOSUCHCHANFILTER    = "938" // InspIRCd 2.0
		ERR_CHANFILTERFULL      = "939" // InspIRCd 2.0
		RPL_DCCALLOWHELP        = "998" // InspIRCd
		RPL_ENDOFDCCALLOWHELP   = "999" // InspIRCd 2.0
	//*/
)
