// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file constantsTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "constantsTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "constants.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

void register_alias_short_type_identifier(
        TypeIdentifierPair& type_ids_alias_short)
{
    ReturnCode_t return_code_alias_short {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_short =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "alias_short", type_ids_alias_short);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_short)
    {
        AliasTypeFlag alias_flags_alias_short = 0;
        QualifiedTypeName type_name_alias_short = "alias_short";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_short;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_short;
        CompleteTypeDetail detail_alias_short = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_short, ann_custom_alias_short, type_name_alias_short.to_string());
        CompleteAliasHeader header_alias_short = TypeObjectUtils::build_complete_alias_header(detail_alias_short);
        AliasMemberFlag related_flags_alias_short = 0;
        return_code_alias_short =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int16_t", type_ids_alias_short);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_short)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "alias_short related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_short_ec {false};
        CommonAliasBody common_alias_short {TypeObjectUtils::build_common_alias_body(related_flags_alias_short,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_short, common_alias_short_ec))};
        if (!common_alias_short_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "alias_short related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_short;
        ann_custom_alias_short.reset();
        CompleteAliasBody body_alias_short = TypeObjectUtils::build_complete_alias_body(common_alias_short,
                member_ann_builtin_alias_short, ann_custom_alias_short);
        CompleteAliasType alias_type_alias_short = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_short,
                header_alias_short, body_alias_short);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_short,
                    type_name_alias_short.to_string(), type_ids_alias_short))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "alias_short already registered in TypeObjectRegistry for a different type.");
        }
    }
}

namespace const_module1 {
void register_alias_short_moduled_type_identifier(
        TypeIdentifierPair& type_ids_alias_short_moduled)
{
    ReturnCode_t return_code_alias_short_moduled {eprosima::fastdds::dds::RETCODE_OK};
    return_code_alias_short_moduled =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "const_module1::alias_short_moduled", type_ids_alias_short_moduled);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_short_moduled)
    {
        AliasTypeFlag alias_flags_alias_short_moduled = 0;
        QualifiedTypeName type_name_alias_short_moduled = "const_module1::alias_short_moduled";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_alias_short_moduled;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_alias_short_moduled;
        CompleteTypeDetail detail_alias_short_moduled = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_alias_short_moduled, ann_custom_alias_short_moduled, type_name_alias_short_moduled.to_string());
        CompleteAliasHeader header_alias_short_moduled = TypeObjectUtils::build_complete_alias_header(detail_alias_short_moduled);
        AliasMemberFlag related_flags_alias_short_moduled = 0;
        return_code_alias_short_moduled =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int16_t", type_ids_alias_short_moduled);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_short_moduled)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "const_module1::alias_short_moduled related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_alias_short_moduled_ec {false};
        CommonAliasBody common_alias_short_moduled {TypeObjectUtils::build_common_alias_body(related_flags_alias_short_moduled,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_short_moduled, common_alias_short_moduled_ec))};
        if (!common_alias_short_moduled_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "const_module1::alias_short_moduled related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_short_moduled;
        ann_custom_alias_short_moduled.reset();
        CompleteAliasBody body_alias_short_moduled = TypeObjectUtils::build_complete_alias_body(common_alias_short_moduled,
                member_ann_builtin_alias_short_moduled, ann_custom_alias_short_moduled);
        CompleteAliasType alias_type_alias_short_moduled = TypeObjectUtils::build_complete_alias_type(alias_flags_alias_short_moduled,
                header_alias_short_moduled, body_alias_short_moduled);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_alias_short_moduled,
                    type_name_alias_short_moduled.to_string(), type_ids_alias_short_moduled))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "const_module1::alias_short_moduled already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ModuleConstsLiteralsStruct_type_identifier(
        TypeIdentifierPair& type_ids_ModuleConstsLiteralsStruct)
{

    ReturnCode_t return_code_ModuleConstsLiteralsStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ModuleConstsLiteralsStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "const_module1::ModuleConstsLiteralsStruct", type_ids_ModuleConstsLiteralsStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ModuleConstsLiteralsStruct)
    {
        StructTypeFlag struct_flags_ModuleConstsLiteralsStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ModuleConstsLiteralsStruct = "const_module1::ModuleConstsLiteralsStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ModuleConstsLiteralsStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ModuleConstsLiteralsStruct;
        CompleteTypeDetail detail_ModuleConstsLiteralsStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ModuleConstsLiteralsStruct, ann_custom_ModuleConstsLiteralsStruct, type_name_ModuleConstsLiteralsStruct.to_string());
        CompleteStructHeader header_ModuleConstsLiteralsStruct;
        header_ModuleConstsLiteralsStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ModuleConstsLiteralsStruct);
        CompleteStructMemberSeq member_seq_ModuleConstsLiteralsStruct;
        {
            TypeIdentifierPair type_ids_module1_array_literal_const_moduled;
            ReturnCode_t return_code_module1_array_literal_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module1_array_literal_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_11", type_ids_module1_array_literal_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module1_array_literal_const_moduled)
            {
                return_code_module1_array_literal_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module1_array_literal_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module1_array_literal_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module1_array_literal_const_moduled, element_identifier_anonymous_array_int16_t_11_ec))};
                if (!element_identifier_anonymous_array_int16_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_module1_array_literal_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_11, element_flags_anonymous_array_int16_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_11", type_ids_module1_array_literal_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module1_array_literal_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module1_array_literal_const_moduled = 0x00000000;
            bool common_module1_array_literal_const_moduled_ec {false};
            CommonStructMember common_module1_array_literal_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_module1_array_literal_const_moduled, member_flags_module1_array_literal_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module1_array_literal_const_moduled, common_module1_array_literal_const_moduled_ec))};
            if (!common_module1_array_literal_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module1_array_literal_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module1_array_literal_const_moduled = "module1_array_literal_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module1_array_literal_const_moduled;
            ann_custom_ModuleConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module1_array_literal_const_moduled = TypeObjectUtils::build_complete_member_detail(name_module1_array_literal_const_moduled, member_ann_builtin_module1_array_literal_const_moduled, ann_custom_ModuleConstsLiteralsStruct);
            CompleteStructMember member_module1_array_literal_const_moduled = TypeObjectUtils::build_complete_struct_member(common_module1_array_literal_const_moduled, detail_module1_array_literal_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleConstsLiteralsStruct, member_module1_array_literal_const_moduled);
        }
        {
            TypeIdentifierPair type_ids_module1_array_literal_const_alias_const_moduled;
            ReturnCode_t return_code_module1_array_literal_const_alias_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module1_array_literal_const_alias_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_module1_array_literal_const_alias_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module1_array_literal_const_alias_const_moduled)
            {
                return_code_module1_array_literal_const_alias_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module1_array_literal_const_alias_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module1_array_literal_const_alias_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module1_array_literal_const_alias_const_moduled, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_module1_array_literal_const_alias_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_module1_array_literal_const_alias_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module1_array_literal_const_alias_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module1_array_literal_const_alias_const_moduled = 0x00000001;
            bool common_module1_array_literal_const_alias_const_moduled_ec {false};
            CommonStructMember common_module1_array_literal_const_alias_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_module1_array_literal_const_alias_const_moduled, member_flags_module1_array_literal_const_alias_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module1_array_literal_const_alias_const_moduled, common_module1_array_literal_const_alias_const_moduled_ec))};
            if (!common_module1_array_literal_const_alias_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module1_array_literal_const_alias_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module1_array_literal_const_alias_const_moduled = "module1_array_literal_const_alias_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module1_array_literal_const_alias_const_moduled;
            ann_custom_ModuleConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module1_array_literal_const_alias_const_moduled = TypeObjectUtils::build_complete_member_detail(name_module1_array_literal_const_alias_const_moduled, member_ann_builtin_module1_array_literal_const_alias_const_moduled, ann_custom_ModuleConstsLiteralsStruct);
            CompleteStructMember member_module1_array_literal_const_alias_const_moduled = TypeObjectUtils::build_complete_struct_member(common_module1_array_literal_const_alias_const_moduled, detail_module1_array_literal_const_alias_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleConstsLiteralsStruct, member_module1_array_literal_const_alias_const_moduled);
        }
        {
            TypeIdentifierPair type_ids_var1;
            ReturnCode_t return_code_var1 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var1 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "alias_short", type_ids_var1);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var1)
            {
            ::register_alias_short_type_identifier(type_ids_var1);
            }
            StructMemberFlag member_flags_var1 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var1 = 0x00000002;
            bool common_var1_ec {false};
            CommonStructMember common_var1 {TypeObjectUtils::build_common_struct_member(member_id_var1, member_flags_var1, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var1, common_var1_ec))};
            if (!common_var1_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var1 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var1 = "var1";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var1;
            ann_custom_ModuleConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_var1 = TypeObjectUtils::build_complete_member_detail(name_var1, member_ann_builtin_var1, ann_custom_ModuleConstsLiteralsStruct);
            CompleteStructMember member_var1 = TypeObjectUtils::build_complete_struct_member(common_var1, detail_var1);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleConstsLiteralsStruct, member_var1);
        }
        {
            TypeIdentifierPair type_ids_var2;
            ReturnCode_t return_code_var2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "const_module1::alias_short_moduled", type_ids_var2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var2)
            {
                const_module1::register_alias_short_moduled_type_identifier(type_ids_var2);
            }
            StructMemberFlag member_flags_var2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var2 = 0x00000003;
            bool common_var2_ec {false};
            CommonStructMember common_var2 {TypeObjectUtils::build_common_struct_member(member_id_var2, member_flags_var2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var2, common_var2_ec))};
            if (!common_var2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var2 = "var2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var2;
            ann_custom_ModuleConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_var2 = TypeObjectUtils::build_complete_member_detail(name_var2, member_ann_builtin_var2, ann_custom_ModuleConstsLiteralsStruct);
            CompleteStructMember member_var2 = TypeObjectUtils::build_complete_struct_member(common_var2, detail_var2);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleConstsLiteralsStruct, member_var2);
        }
        CompleteStructType struct_type_ModuleConstsLiteralsStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ModuleConstsLiteralsStruct, header_ModuleConstsLiteralsStruct, member_seq_ModuleConstsLiteralsStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ModuleConstsLiteralsStruct, type_name_ModuleConstsLiteralsStruct.to_string(), type_ids_ModuleConstsLiteralsStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "const_module1::ModuleConstsLiteralsStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

} // namespace const_module1
namespace const_module2 {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Module2ConstsLiteralsStruct_type_identifier(
        TypeIdentifierPair& type_ids_Module2ConstsLiteralsStruct)
{

    ReturnCode_t return_code_Module2ConstsLiteralsStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Module2ConstsLiteralsStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "const_module2::Module2ConstsLiteralsStruct", type_ids_Module2ConstsLiteralsStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Module2ConstsLiteralsStruct)
    {
        StructTypeFlag struct_flags_Module2ConstsLiteralsStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Module2ConstsLiteralsStruct = "const_module2::Module2ConstsLiteralsStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Module2ConstsLiteralsStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Module2ConstsLiteralsStruct;
        CompleteTypeDetail detail_Module2ConstsLiteralsStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Module2ConstsLiteralsStruct, ann_custom_Module2ConstsLiteralsStruct, type_name_Module2ConstsLiteralsStruct.to_string());
        CompleteStructHeader header_Module2ConstsLiteralsStruct;
        header_Module2ConstsLiteralsStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Module2ConstsLiteralsStruct);
        CompleteStructMemberSeq member_seq_Module2ConstsLiteralsStruct;
        {
            TypeIdentifierPair type_ids_module2_array_literal_const_moduled;
            ReturnCode_t return_code_module2_array_literal_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module2_array_literal_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_22", type_ids_module2_array_literal_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_moduled)
            {
                return_code_module2_array_literal_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module2_array_literal_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_22_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_22 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_moduled, element_identifier_anonymous_array_int16_t_22_ec))};
                if (!element_identifier_anonymous_array_int16_t_22_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_22 = EK_COMPLETE;
                if (TK_NONE == type_ids_module2_array_literal_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_22 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_22 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_22 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_22, element_flags_anonymous_array_int16_t_22);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(22));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_22, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_22));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_22", type_ids_module2_array_literal_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_22 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module2_array_literal_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module2_array_literal_const_moduled = 0x00000000;
            bool common_module2_array_literal_const_moduled_ec {false};
            CommonStructMember common_module2_array_literal_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_module2_array_literal_const_moduled, member_flags_module2_array_literal_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_moduled, common_module2_array_literal_const_moduled_ec))};
            if (!common_module2_array_literal_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module2_array_literal_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module2_array_literal_const_moduled = "module2_array_literal_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module2_array_literal_const_moduled;
            ann_custom_Module2ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module2_array_literal_const_moduled = TypeObjectUtils::build_complete_member_detail(name_module2_array_literal_const_moduled, member_ann_builtin_module2_array_literal_const_moduled, ann_custom_Module2ConstsLiteralsStruct);
            CompleteStructMember member_module2_array_literal_const_moduled = TypeObjectUtils::build_complete_struct_member(common_module2_array_literal_const_moduled, detail_module2_array_literal_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_Module2ConstsLiteralsStruct, member_module2_array_literal_const_moduled);
        }
        {
            TypeIdentifierPair type_ids_module2_array_literal_const_alias_const_moduled;
            ReturnCode_t return_code_module2_array_literal_const_alias_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module2_array_literal_const_alias_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_2", type_ids_module2_array_literal_const_alias_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_alias_const_moduled)
            {
                return_code_module2_array_literal_const_alias_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module2_array_literal_const_alias_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_alias_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_alias_const_moduled, element_identifier_anonymous_array_int16_t_2_ec))};
                if (!element_identifier_anonymous_array_int16_t_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_2 = EK_COMPLETE;
                if (TK_NONE == type_ids_module2_array_literal_const_alias_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_2 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_2 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_2, element_flags_anonymous_array_int16_t_2);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_2, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_2", type_ids_module2_array_literal_const_alias_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module2_array_literal_const_alias_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module2_array_literal_const_alias_const_moduled = 0x00000001;
            bool common_module2_array_literal_const_alias_const_moduled_ec {false};
            CommonStructMember common_module2_array_literal_const_alias_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_module2_array_literal_const_alias_const_moduled, member_flags_module2_array_literal_const_alias_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_alias_const_moduled, common_module2_array_literal_const_alias_const_moduled_ec))};
            if (!common_module2_array_literal_const_alias_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module2_array_literal_const_alias_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module2_array_literal_const_alias_const_moduled = "module2_array_literal_const_alias_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module2_array_literal_const_alias_const_moduled;
            ann_custom_Module2ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module2_array_literal_const_alias_const_moduled = TypeObjectUtils::build_complete_member_detail(name_module2_array_literal_const_alias_const_moduled, member_ann_builtin_module2_array_literal_const_alias_const_moduled, ann_custom_Module2ConstsLiteralsStruct);
            CompleteStructMember member_module2_array_literal_const_alias_const_moduled = TypeObjectUtils::build_complete_struct_member(common_module2_array_literal_const_alias_const_moduled, detail_module2_array_literal_const_alias_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_Module2ConstsLiteralsStruct, member_module2_array_literal_const_alias_const_moduled);
        }
        {
            TypeIdentifierPair type_ids_module2_array_literal_const_scoped_moduled;
            ReturnCode_t return_code_module2_array_literal_const_scoped_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module2_array_literal_const_scoped_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_22", type_ids_module2_array_literal_const_scoped_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_scoped_moduled)
            {
                return_code_module2_array_literal_const_scoped_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module2_array_literal_const_scoped_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_scoped_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_22_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_22 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_scoped_moduled, element_identifier_anonymous_array_int16_t_22_ec))};
                if (!element_identifier_anonymous_array_int16_t_22_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_22 = EK_COMPLETE;
                if (TK_NONE == type_ids_module2_array_literal_const_scoped_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_22 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_22 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_22 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_22, element_flags_anonymous_array_int16_t_22);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(22));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_22, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_22));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_22", type_ids_module2_array_literal_const_scoped_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_22 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module2_array_literal_const_scoped_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module2_array_literal_const_scoped_moduled = 0x00000002;
            bool common_module2_array_literal_const_scoped_moduled_ec {false};
            CommonStructMember common_module2_array_literal_const_scoped_moduled {TypeObjectUtils::build_common_struct_member(member_id_module2_array_literal_const_scoped_moduled, member_flags_module2_array_literal_const_scoped_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_scoped_moduled, common_module2_array_literal_const_scoped_moduled_ec))};
            if (!common_module2_array_literal_const_scoped_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module2_array_literal_const_scoped_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module2_array_literal_const_scoped_moduled = "module2_array_literal_const_scoped_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module2_array_literal_const_scoped_moduled;
            ann_custom_Module2ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module2_array_literal_const_scoped_moduled = TypeObjectUtils::build_complete_member_detail(name_module2_array_literal_const_scoped_moduled, member_ann_builtin_module2_array_literal_const_scoped_moduled, ann_custom_Module2ConstsLiteralsStruct);
            CompleteStructMember member_module2_array_literal_const_scoped_moduled = TypeObjectUtils::build_complete_struct_member(common_module2_array_literal_const_scoped_moduled, detail_module2_array_literal_const_scoped_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_Module2ConstsLiteralsStruct, member_module2_array_literal_const_scoped_moduled);
        }
        {
            TypeIdentifierPair type_ids_module2_array_literal_module1_const_moduled;
            ReturnCode_t return_code_module2_array_literal_module1_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module2_array_literal_module1_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_11", type_ids_module2_array_literal_module1_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_module1_const_moduled)
            {
                return_code_module2_array_literal_module1_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module2_array_literal_module1_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_module1_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_module1_const_moduled, element_identifier_anonymous_array_int16_t_11_ec))};
                if (!element_identifier_anonymous_array_int16_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_module2_array_literal_module1_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_11, element_flags_anonymous_array_int16_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_11", type_ids_module2_array_literal_module1_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module2_array_literal_module1_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module2_array_literal_module1_const_moduled = 0x00000003;
            bool common_module2_array_literal_module1_const_moduled_ec {false};
            CommonStructMember common_module2_array_literal_module1_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_module2_array_literal_module1_const_moduled, member_flags_module2_array_literal_module1_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_module1_const_moduled, common_module2_array_literal_module1_const_moduled_ec))};
            if (!common_module2_array_literal_module1_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module2_array_literal_module1_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module2_array_literal_module1_const_moduled = "module2_array_literal_module1_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module2_array_literal_module1_const_moduled;
            ann_custom_Module2ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module2_array_literal_module1_const_moduled = TypeObjectUtils::build_complete_member_detail(name_module2_array_literal_module1_const_moduled, member_ann_builtin_module2_array_literal_module1_const_moduled, ann_custom_Module2ConstsLiteralsStruct);
            CompleteStructMember member_module2_array_literal_module1_const_moduled = TypeObjectUtils::build_complete_struct_member(common_module2_array_literal_module1_const_moduled, detail_module2_array_literal_module1_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_Module2ConstsLiteralsStruct, member_module2_array_literal_module1_const_moduled);
        }
        {
            TypeIdentifierPair type_ids_module2_array_literal_const_moduled_module1;
            ReturnCode_t return_code_module2_array_literal_const_moduled_module1 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_module2_array_literal_const_moduled_module1 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_11", type_ids_module2_array_literal_const_moduled_module1);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_moduled_module1)
            {
                return_code_module2_array_literal_const_moduled_module1 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_module2_array_literal_const_moduled_module1);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_module2_array_literal_const_moduled_module1)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_moduled_module1, element_identifier_anonymous_array_int16_t_11_ec))};
                if (!element_identifier_anonymous_array_int16_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_module2_array_literal_const_moduled_module1.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_11, element_flags_anonymous_array_int16_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_11", type_ids_module2_array_literal_const_moduled_module1))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_module2_array_literal_const_moduled_module1 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_module2_array_literal_const_moduled_module1 = 0x00000004;
            bool common_module2_array_literal_const_moduled_module1_ec {false};
            CommonStructMember common_module2_array_literal_const_moduled_module1 {TypeObjectUtils::build_common_struct_member(member_id_module2_array_literal_const_moduled_module1, member_flags_module2_array_literal_const_moduled_module1, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_module2_array_literal_const_moduled_module1, common_module2_array_literal_const_moduled_module1_ec))};
            if (!common_module2_array_literal_const_moduled_module1_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure module2_array_literal_const_moduled_module1 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_module2_array_literal_const_moduled_module1 = "module2_array_literal_const_moduled_module1";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_module2_array_literal_const_moduled_module1;
            ann_custom_Module2ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_module2_array_literal_const_moduled_module1 = TypeObjectUtils::build_complete_member_detail(name_module2_array_literal_const_moduled_module1, member_ann_builtin_module2_array_literal_const_moduled_module1, ann_custom_Module2ConstsLiteralsStruct);
            CompleteStructMember member_module2_array_literal_const_moduled_module1 = TypeObjectUtils::build_complete_struct_member(common_module2_array_literal_const_moduled_module1, detail_module2_array_literal_const_moduled_module1);
            TypeObjectUtils::add_complete_struct_member(member_seq_Module2ConstsLiteralsStruct, member_module2_array_literal_const_moduled_module1);
        }
        CompleteStructType struct_type_Module2ConstsLiteralsStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_Module2ConstsLiteralsStruct, header_Module2ConstsLiteralsStruct, member_seq_Module2ConstsLiteralsStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Module2ConstsLiteralsStruct, type_name_Module2ConstsLiteralsStruct.to_string(), type_ids_Module2ConstsLiteralsStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "const_module2::Module2ConstsLiteralsStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

} // namespace const_module2
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ConstsLiteralsStruct_type_identifier(
        TypeIdentifierPair& type_ids_ConstsLiteralsStruct)
{

    ReturnCode_t return_code_ConstsLiteralsStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ConstsLiteralsStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ConstsLiteralsStruct", type_ids_ConstsLiteralsStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ConstsLiteralsStruct)
    {
        StructTypeFlag struct_flags_ConstsLiteralsStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ConstsLiteralsStruct = "ConstsLiteralsStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ConstsLiteralsStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ConstsLiteralsStruct;
        CompleteTypeDetail detail_ConstsLiteralsStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ConstsLiteralsStruct, ann_custom_ConstsLiteralsStruct, type_name_ConstsLiteralsStruct.to_string());
        CompleteStructHeader header_ConstsLiteralsStruct;
        header_ConstsLiteralsStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ConstsLiteralsStruct);
        CompleteStructMemberSeq member_seq_ConstsLiteralsStruct;
        {
            TypeIdentifierPair type_ids_array_literal_const_short;
            ReturnCode_t return_code_array_literal_const_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_87", type_ids_array_literal_const_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_short)
            {
                return_code_array_literal_const_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literal_const_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_87_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_87 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_short, element_identifier_anonymous_array_int16_t_87_ec))};
                if (!element_identifier_anonymous_array_int16_t_87_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_87 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_87 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_87 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_87 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_87, element_flags_anonymous_array_int16_t_87);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(87));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_87, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_87));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_87", type_ids_array_literal_const_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_87 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_short = 0x00000000;
            bool common_array_literal_const_short_ec {false};
            CommonStructMember common_array_literal_const_short {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_short, member_flags_array_literal_const_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_short, common_array_literal_const_short_ec))};
            if (!common_array_literal_const_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_short = "array_literal_const_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_short;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_short = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_short, member_ann_builtin_array_literal_const_short, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_short = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_short, detail_array_literal_const_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_short);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_ushort;
            ReturnCode_t return_code_array_literal_const_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_43", type_ids_array_literal_const_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_ushort)
            {
                return_code_array_literal_const_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_array_literal_const_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_43_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_43 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_ushort, element_identifier_anonymous_array_uint16_t_43_ec))};
                if (!element_identifier_anonymous_array_uint16_t_43_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_43 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_ushort.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_43 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_43 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_43 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_43, element_flags_anonymous_array_uint16_t_43);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(43));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_43, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_43));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_43", type_ids_array_literal_const_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_43 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_ushort = 0x00000001;
            bool common_array_literal_const_ushort_ec {false};
            CommonStructMember common_array_literal_const_ushort {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_ushort, member_flags_array_literal_const_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_ushort, common_array_literal_const_ushort_ec))};
            if (!common_array_literal_const_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_ushort = "array_literal_const_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_ushort;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_ushort = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_ushort, member_ann_builtin_array_literal_const_ushort, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_ushort = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_ushort, detail_array_literal_const_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_ushort);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_long;
            ReturnCode_t return_code_array_literal_const_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_23", type_ids_array_literal_const_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_long)
            {
                return_code_array_literal_const_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_array_literal_const_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_23_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_23 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_long, element_identifier_anonymous_array_int32_t_23_ec))};
                if (!element_identifier_anonymous_array_int32_t_23_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_23 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_long.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_23 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_23 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_23 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_23, element_flags_anonymous_array_int32_t_23);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(23));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_23, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_23));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_23", type_ids_array_literal_const_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_23 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_long = 0x00000002;
            bool common_array_literal_const_long_ec {false};
            CommonStructMember common_array_literal_const_long {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_long, member_flags_array_literal_const_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_long, common_array_literal_const_long_ec))};
            if (!common_array_literal_const_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_long = "array_literal_const_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_long;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_long = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_long, member_ann_builtin_array_literal_const_long, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_long = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_long, detail_array_literal_const_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_long);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_ulong;
            ReturnCode_t return_code_array_literal_const_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_6", type_ids_array_literal_const_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_ulong)
            {
                return_code_array_literal_const_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_array_literal_const_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_6_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_6 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_ulong, element_identifier_anonymous_array_uint32_t_6_ec))};
                if (!element_identifier_anonymous_array_uint32_t_6_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_6 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_ulong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_6 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_6 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_6 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_6, element_flags_anonymous_array_uint32_t_6);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(6));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_6, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_6));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_6", type_ids_array_literal_const_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_6 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_ulong = 0x00000003;
            bool common_array_literal_const_ulong_ec {false};
            CommonStructMember common_array_literal_const_ulong {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_ulong, member_flags_array_literal_const_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_ulong, common_array_literal_const_ulong_ec))};
            if (!common_array_literal_const_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_ulong = "array_literal_const_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_ulong;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_ulong = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_ulong, member_ann_builtin_array_literal_const_ulong, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_ulong = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_ulong, detail_array_literal_const_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_ulong);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_longlong;
            ReturnCode_t return_code_array_literal_const_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_8", type_ids_array_literal_const_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_longlong)
            {
                return_code_array_literal_const_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_array_literal_const_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_8_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_8 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_longlong, element_identifier_anonymous_array_int64_t_8_ec))};
                if (!element_identifier_anonymous_array_int64_t_8_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_8 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_longlong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_8 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_8 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_8 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_8, element_flags_anonymous_array_int64_t_8);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(8));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_8, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_8));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_8", type_ids_array_literal_const_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_8 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_longlong = 0x00000004;
            bool common_array_literal_const_longlong_ec {false};
            CommonStructMember common_array_literal_const_longlong {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_longlong, member_flags_array_literal_const_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_longlong, common_array_literal_const_longlong_ec))};
            if (!common_array_literal_const_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_longlong = "array_literal_const_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_longlong;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_longlong = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_longlong, member_ann_builtin_array_literal_const_longlong, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_longlong = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_longlong, detail_array_literal_const_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_longlong);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_ulonglong;
            ReturnCode_t return_code_array_literal_const_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_67", type_ids_array_literal_const_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_ulonglong)
            {
                return_code_array_literal_const_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_array_literal_const_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_67_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_67 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_ulonglong, element_identifier_anonymous_array_uint64_t_67_ec))};
                if (!element_identifier_anonymous_array_uint64_t_67_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_67 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_ulonglong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_67 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_67 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_67 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_67, element_flags_anonymous_array_uint64_t_67);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(67));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_67, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_67));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_67", type_ids_array_literal_const_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_67 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_ulonglong = 0x00000005;
            bool common_array_literal_const_ulonglong_ec {false};
            CommonStructMember common_array_literal_const_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_ulonglong, member_flags_array_literal_const_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_ulonglong, common_array_literal_const_ulonglong_ec))};
            if (!common_array_literal_const_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_ulonglong = "array_literal_const_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_ulonglong;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_ulonglong = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_ulonglong, member_ann_builtin_array_literal_const_ulonglong, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_ulonglong = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_ulonglong, detail_array_literal_const_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_ulonglong);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_int8;
            ReturnCode_t return_code_array_literal_const_int8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_int8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int8_t_53", type_ids_array_literal_const_int8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int8)
            {
                return_code_array_literal_const_int8 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int8_t", type_ids_array_literal_const_int8);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int8)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int8_t_53_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int8_t_53 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int8, element_identifier_anonymous_array_int8_t_53_ec))};
                if (!element_identifier_anonymous_array_int8_t_53_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int8_t_53 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_int8.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int8_t_53 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int8_t_53 = 0;
                PlainCollectionHeader header_anonymous_array_int8_t_53 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int8_t_53, element_flags_anonymous_array_int8_t_53);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(53));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int8_t_53, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int8_t_53));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int8_t_53", type_ids_array_literal_const_int8))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int8_t_53 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_int8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_int8 = 0x00000006;
            bool common_array_literal_const_int8_ec {false};
            CommonStructMember common_array_literal_const_int8 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_int8, member_flags_array_literal_const_int8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int8, common_array_literal_const_int8_ec))};
            if (!common_array_literal_const_int8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_int8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_int8 = "array_literal_const_int8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_int8;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_int8 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_int8, member_ann_builtin_array_literal_const_int8, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_int8 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_int8, detail_array_literal_const_int8);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_int8);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_uint8;
            ReturnCode_t return_code_array_literal_const_uint8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_uint8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_11", type_ids_array_literal_const_uint8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint8)
            {
                return_code_array_literal_const_uint8 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint8_t", type_ids_array_literal_const_uint8);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint8)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint8, element_identifier_anonymous_array_uint8_t_11_ec))};
                if (!element_identifier_anonymous_array_uint8_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_uint8.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_11, element_flags_anonymous_array_uint8_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_11", type_ids_array_literal_const_uint8))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_uint8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_uint8 = 0x00000007;
            bool common_array_literal_const_uint8_ec {false};
            CommonStructMember common_array_literal_const_uint8 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_uint8, member_flags_array_literal_const_uint8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint8, common_array_literal_const_uint8_ec))};
            if (!common_array_literal_const_uint8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_uint8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_uint8 = "array_literal_const_uint8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_uint8;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_uint8 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_uint8, member_ann_builtin_array_literal_const_uint8, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_uint8 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_uint8, detail_array_literal_const_uint8);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_uint8);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_int16;
            ReturnCode_t return_code_array_literal_const_int16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_int16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_27", type_ids_array_literal_const_int16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int16)
            {
                return_code_array_literal_const_int16 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literal_const_int16);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int16)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_27_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_27 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int16, element_identifier_anonymous_array_int16_t_27_ec))};
                if (!element_identifier_anonymous_array_int16_t_27_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_27 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_int16.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_27 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_27 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_27 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_27, element_flags_anonymous_array_int16_t_27);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(27));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_27, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_27));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_27", type_ids_array_literal_const_int16))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_27 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_int16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_int16 = 0x00000008;
            bool common_array_literal_const_int16_ec {false};
            CommonStructMember common_array_literal_const_int16 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_int16, member_flags_array_literal_const_int16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int16, common_array_literal_const_int16_ec))};
            if (!common_array_literal_const_int16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_int16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_int16 = "array_literal_const_int16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_int16;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_int16 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_int16, member_ann_builtin_array_literal_const_int16, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_int16 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_int16, detail_array_literal_const_int16);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_int16);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_uint16;
            ReturnCode_t return_code_array_literal_const_uint16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_uint16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_31", type_ids_array_literal_const_uint16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint16)
            {
                return_code_array_literal_const_uint16 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_array_literal_const_uint16);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint16)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_31_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_31 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint16, element_identifier_anonymous_array_uint16_t_31_ec))};
                if (!element_identifier_anonymous_array_uint16_t_31_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_31 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_uint16.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_31 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_31 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_31 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_31, element_flags_anonymous_array_uint16_t_31);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(31));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_31, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_31));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_31", type_ids_array_literal_const_uint16))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_31 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_uint16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_uint16 = 0x00000009;
            bool common_array_literal_const_uint16_ec {false};
            CommonStructMember common_array_literal_const_uint16 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_uint16, member_flags_array_literal_const_uint16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint16, common_array_literal_const_uint16_ec))};
            if (!common_array_literal_const_uint16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_uint16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_uint16 = "array_literal_const_uint16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_uint16;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_uint16 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_uint16, member_ann_builtin_array_literal_const_uint16, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_uint16 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_uint16, detail_array_literal_const_uint16);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_uint16);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_int32;
            ReturnCode_t return_code_array_literal_const_int32 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_int32 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_74", type_ids_array_literal_const_int32);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int32)
            {
                return_code_array_literal_const_int32 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_array_literal_const_int32);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int32)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_74_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_74 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int32, element_identifier_anonymous_array_int32_t_74_ec))};
                if (!element_identifier_anonymous_array_int32_t_74_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_74 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_int32.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_74 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_74 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_74 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_74, element_flags_anonymous_array_int32_t_74);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(74));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_74, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_74));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_74", type_ids_array_literal_const_int32))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_74 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_int32 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_int32 = 0x0000000a;
            bool common_array_literal_const_int32_ec {false};
            CommonStructMember common_array_literal_const_int32 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_int32, member_flags_array_literal_const_int32, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int32, common_array_literal_const_int32_ec))};
            if (!common_array_literal_const_int32_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_int32 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_int32 = "array_literal_const_int32";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_int32;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_int32 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_int32, member_ann_builtin_array_literal_const_int32, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_int32 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_int32, detail_array_literal_const_int32);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_int32);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_uint32;
            ReturnCode_t return_code_array_literal_const_uint32 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_uint32 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_64", type_ids_array_literal_const_uint32);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint32)
            {
                return_code_array_literal_const_uint32 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_array_literal_const_uint32);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint32)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_64_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_64 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint32, element_identifier_anonymous_array_uint32_t_64_ec))};
                if (!element_identifier_anonymous_array_uint32_t_64_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_64 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_uint32.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_64 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_64 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_64 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_64, element_flags_anonymous_array_uint32_t_64);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(64));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_64, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_64));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_64", type_ids_array_literal_const_uint32))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_64 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_uint32 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_uint32 = 0x0000000b;
            bool common_array_literal_const_uint32_ec {false};
            CommonStructMember common_array_literal_const_uint32 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_uint32, member_flags_array_literal_const_uint32, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint32, common_array_literal_const_uint32_ec))};
            if (!common_array_literal_const_uint32_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_uint32 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_uint32 = "array_literal_const_uint32";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_uint32;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_uint32 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_uint32, member_ann_builtin_array_literal_const_uint32, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_uint32 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_uint32, detail_array_literal_const_uint32);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_uint32);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_int64;
            ReturnCode_t return_code_array_literal_const_int64 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_int64 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_17", type_ids_array_literal_const_int64);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int64)
            {
                return_code_array_literal_const_int64 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_array_literal_const_int64);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_int64)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_17_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_17 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int64, element_identifier_anonymous_array_int64_t_17_ec))};
                if (!element_identifier_anonymous_array_int64_t_17_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_17 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_int64.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_17 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_17 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_17 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_17, element_flags_anonymous_array_int64_t_17);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(17));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_17, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_17));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_17", type_ids_array_literal_const_int64))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_17 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_int64 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_int64 = 0x0000000c;
            bool common_array_literal_const_int64_ec {false};
            CommonStructMember common_array_literal_const_int64 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_int64, member_flags_array_literal_const_int64, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_int64, common_array_literal_const_int64_ec))};
            if (!common_array_literal_const_int64_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_int64 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_int64 = "array_literal_const_int64";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_int64;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_int64 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_int64, member_ann_builtin_array_literal_const_int64, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_int64 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_int64, detail_array_literal_const_int64);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_int64);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_uint64;
            ReturnCode_t return_code_array_literal_const_uint64 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_uint64 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_19", type_ids_array_literal_const_uint64);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint64)
            {
                return_code_array_literal_const_uint64 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_array_literal_const_uint64);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_uint64)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_19_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_19 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint64, element_identifier_anonymous_array_uint64_t_19_ec))};
                if (!element_identifier_anonymous_array_uint64_t_19_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_19 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_uint64.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_19 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_19 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_19 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_19, element_flags_anonymous_array_uint64_t_19);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(19));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_19, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_19));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_19", type_ids_array_literal_const_uint64))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_19 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_uint64 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_uint64 = 0x0000000d;
            bool common_array_literal_const_uint64_ec {false};
            CommonStructMember common_array_literal_const_uint64 {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_uint64, member_flags_array_literal_const_uint64, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_uint64, common_array_literal_const_uint64_ec))};
            if (!common_array_literal_const_uint64_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_uint64 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_uint64 = "array_literal_const_uint64";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_uint64;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_uint64 = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_uint64, member_ann_builtin_array_literal_const_uint64, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_uint64 = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_uint64, detail_array_literal_const_uint64);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_uint64);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations1_const;
            ReturnCode_t return_code_array_literals_operations1_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations1_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_110", type_ids_array_literals_operations1_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations1_const)
            {
                return_code_array_literals_operations1_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations1_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations1_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_110_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_110 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations1_const, element_identifier_anonymous_array_int16_t_110_ec))};
                if (!element_identifier_anonymous_array_int16_t_110_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_110 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations1_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_110 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_110 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_110 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_110, element_flags_anonymous_array_int16_t_110);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(110));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_110, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_110));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_110", type_ids_array_literals_operations1_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_110 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations1_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations1_const = 0x0000000e;
            bool common_array_literals_operations1_const_ec {false};
            CommonStructMember common_array_literals_operations1_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations1_const, member_flags_array_literals_operations1_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations1_const, common_array_literals_operations1_const_ec))};
            if (!common_array_literals_operations1_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations1_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations1_const = "array_literals_operations1_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations1_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations1_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations1_const, member_ann_builtin_array_literals_operations1_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations1_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations1_const, detail_array_literals_operations1_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations1_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations2_const;
            ReturnCode_t return_code_array_literals_operations2_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations2_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_64", type_ids_array_literals_operations2_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations2_const)
            {
                return_code_array_literals_operations2_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations2_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations2_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_64_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_64 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations2_const, element_identifier_anonymous_array_int16_t_64_ec))};
                if (!element_identifier_anonymous_array_int16_t_64_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_64 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations2_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_64 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_64 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_64 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_64, element_flags_anonymous_array_int16_t_64);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(64));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_64, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_64));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_64", type_ids_array_literals_operations2_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_64 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations2_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations2_const = 0x0000000f;
            bool common_array_literals_operations2_const_ec {false};
            CommonStructMember common_array_literals_operations2_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations2_const, member_flags_array_literals_operations2_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations2_const, common_array_literals_operations2_const_ec))};
            if (!common_array_literals_operations2_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations2_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations2_const = "array_literals_operations2_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations2_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations2_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations2_const, member_ann_builtin_array_literals_operations2_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations2_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations2_const, detail_array_literals_operations2_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations2_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations3_const;
            ReturnCode_t return_code_array_literals_operations3_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations3_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_109", type_ids_array_literals_operations3_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations3_const)
            {
                return_code_array_literals_operations3_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations3_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations3_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_109_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_109 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations3_const, element_identifier_anonymous_array_int16_t_109_ec))};
                if (!element_identifier_anonymous_array_int16_t_109_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_109 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations3_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_109 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_109 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_109 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_109, element_flags_anonymous_array_int16_t_109);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(109));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_109, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_109));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_109", type_ids_array_literals_operations3_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_109 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations3_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations3_const = 0x00000010;
            bool common_array_literals_operations3_const_ec {false};
            CommonStructMember common_array_literals_operations3_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations3_const, member_flags_array_literals_operations3_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations3_const, common_array_literals_operations3_const_ec))};
            if (!common_array_literals_operations3_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations3_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations3_const = "array_literals_operations3_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations3_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations3_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations3_const, member_ann_builtin_array_literals_operations3_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations3_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations3_const, detail_array_literals_operations3_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations3_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations4_const;
            ReturnCode_t return_code_array_literals_operations4_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations4_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_11", type_ids_array_literals_operations4_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations4_const)
            {
                return_code_array_literals_operations4_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations4_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations4_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations4_const, element_identifier_anonymous_array_int16_t_11_ec))};
                if (!element_identifier_anonymous_array_int16_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations4_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_11, element_flags_anonymous_array_int16_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_11", type_ids_array_literals_operations4_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations4_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations4_const = 0x00000011;
            bool common_array_literals_operations4_const_ec {false};
            CommonStructMember common_array_literals_operations4_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations4_const, member_flags_array_literals_operations4_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations4_const, common_array_literals_operations4_const_ec))};
            if (!common_array_literals_operations4_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations4_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations4_const = "array_literals_operations4_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations4_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations4_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations4_const, member_ann_builtin_array_literals_operations4_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations4_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations4_const, detail_array_literals_operations4_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations4_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations5_const;
            ReturnCode_t return_code_array_literals_operations5_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations5_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_2001", type_ids_array_literals_operations5_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations5_const)
            {
                return_code_array_literals_operations5_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations5_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations5_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_2001_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_2001 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations5_const, element_identifier_anonymous_array_int16_t_2001_ec))};
                if (!element_identifier_anonymous_array_int16_t_2001_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_2001 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations5_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_2001 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_2001 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_2001 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_2001, element_flags_anonymous_array_int16_t_2001);
                {
                    LBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<LBound>(2001));

                    PlainArrayLElemDefn array_ldefn = TypeObjectUtils::build_plain_array_l_elem_defn(header_anonymous_array_int16_t_2001, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_2001));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_array_type_identifier(array_ldefn, "anonymous_array_int16_t_2001", type_ids_array_literals_operations5_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_2001 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations5_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations5_const = 0x00000012;
            bool common_array_literals_operations5_const_ec {false};
            CommonStructMember common_array_literals_operations5_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations5_const, member_flags_array_literals_operations5_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations5_const, common_array_literals_operations5_const_ec))};
            if (!common_array_literals_operations5_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations5_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations5_const = "array_literals_operations5_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations5_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations5_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations5_const, member_ann_builtin_array_literals_operations5_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations5_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations5_const, detail_array_literals_operations5_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations5_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations6_const;
            ReturnCode_t return_code_array_literals_operations6_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations6_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_3", type_ids_array_literals_operations6_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations6_const)
            {
                return_code_array_literals_operations6_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations6_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations6_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations6_const, element_identifier_anonymous_array_int16_t_3_ec))};
                if (!element_identifier_anonymous_array_int16_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations6_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_3, element_flags_anonymous_array_int16_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_3", type_ids_array_literals_operations6_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations6_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations6_const = 0x00000013;
            bool common_array_literals_operations6_const_ec {false};
            CommonStructMember common_array_literals_operations6_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations6_const, member_flags_array_literals_operations6_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations6_const, common_array_literals_operations6_const_ec))};
            if (!common_array_literals_operations6_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations6_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations6_const = "array_literals_operations6_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations6_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations6_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations6_const, member_ann_builtin_array_literals_operations6_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations6_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations6_const, detail_array_literals_operations6_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations6_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations7_const;
            ReturnCode_t return_code_array_literals_operations7_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations7_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_1914", type_ids_array_literals_operations7_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations7_const)
            {
                return_code_array_literals_operations7_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations7_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations7_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_1914_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_1914 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations7_const, element_identifier_anonymous_array_int16_t_1914_ec))};
                if (!element_identifier_anonymous_array_int16_t_1914_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_1914 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations7_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_1914 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_1914 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_1914 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_1914, element_flags_anonymous_array_int16_t_1914);
                {
                    LBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<LBound>(1914));

                    PlainArrayLElemDefn array_ldefn = TypeObjectUtils::build_plain_array_l_elem_defn(header_anonymous_array_int16_t_1914, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_1914));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_array_type_identifier(array_ldefn, "anonymous_array_int16_t_1914", type_ids_array_literals_operations7_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_1914 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations7_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations7_const = 0x00000014;
            bool common_array_literals_operations7_const_ec {false};
            CommonStructMember common_array_literals_operations7_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations7_const, member_flags_array_literals_operations7_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations7_const, common_array_literals_operations7_const_ec))};
            if (!common_array_literals_operations7_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations7_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations7_const = "array_literals_operations7_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations7_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations7_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations7_const, member_ann_builtin_array_literals_operations7_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations7_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations7_const, detail_array_literals_operations7_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations7_const);
        }
        {
            TypeIdentifierPair type_ids_array_literals_operations8_const;
            ReturnCode_t return_code_array_literals_operations8_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literals_operations8_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_11", type_ids_array_literals_operations8_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations8_const)
            {
                return_code_array_literals_operations8_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literals_operations8_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literals_operations8_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations8_const, element_identifier_anonymous_array_int16_t_11_ec))};
                if (!element_identifier_anonymous_array_int16_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literals_operations8_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_11, element_flags_anonymous_array_int16_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_11", type_ids_array_literals_operations8_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literals_operations8_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literals_operations8_const = 0x00000015;
            bool common_array_literals_operations8_const_ec {false};
            CommonStructMember common_array_literals_operations8_const {TypeObjectUtils::build_common_struct_member(member_id_array_literals_operations8_const, member_flags_array_literals_operations8_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literals_operations8_const, common_array_literals_operations8_const_ec))};
            if (!common_array_literals_operations8_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literals_operations8_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literals_operations8_const = "array_literals_operations8_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literals_operations8_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literals_operations8_const = TypeObjectUtils::build_complete_member_detail(name_array_literals_operations8_const, member_ann_builtin_array_literals_operations8_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literals_operations8_const = TypeObjectUtils::build_complete_struct_member(common_array_literals_operations8_const, detail_array_literals_operations8_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literals_operations8_const);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_inner_const_helper;
            ReturnCode_t return_code_array_literal_const_inner_const_helper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_inner_const_helper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_1", type_ids_array_literal_const_inner_const_helper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_inner_const_helper)
            {
                return_code_array_literal_const_inner_const_helper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literal_const_inner_const_helper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_inner_const_helper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_1_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_1 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_inner_const_helper, element_identifier_anonymous_array_int16_t_1_ec))};
                if (!element_identifier_anonymous_array_int16_t_1_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_1 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_inner_const_helper.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_1 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_1 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_1 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_1, element_flags_anonymous_array_int16_t_1);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(1));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_1, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_1));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_1", type_ids_array_literal_const_inner_const_helper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_1 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_inner_const_helper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_inner_const_helper = 0x00000016;
            bool common_array_literal_const_inner_const_helper_ec {false};
            CommonStructMember common_array_literal_const_inner_const_helper {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_inner_const_helper, member_flags_array_literal_const_inner_const_helper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_inner_const_helper, common_array_literal_const_inner_const_helper_ec))};
            if (!common_array_literal_const_inner_const_helper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_inner_const_helper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_inner_const_helper = "array_literal_const_inner_const_helper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_inner_const_helper;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_inner_const_helper = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_inner_const_helper, member_ann_builtin_array_literal_const_inner_const_helper, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_inner_const_helper = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_inner_const_helper, detail_array_literal_const_inner_const_helper);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_inner_const_helper);
        }
        {
            TypeIdentifierPair type_ids_array_moduled1_literal_const;
            ReturnCode_t return_code_array_moduled1_literal_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_moduled1_literal_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_11", type_ids_array_moduled1_literal_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled1_literal_const)
            {
                return_code_array_moduled1_literal_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_moduled1_literal_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled1_literal_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_11_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_11 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled1_literal_const, element_identifier_anonymous_array_int16_t_11_ec))};
                if (!element_identifier_anonymous_array_int16_t_11_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_11 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_moduled1_literal_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_11 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_11 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_11 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_11, element_flags_anonymous_array_int16_t_11);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(11));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_11, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_11));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_11", type_ids_array_moduled1_literal_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_11 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_moduled1_literal_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_moduled1_literal_const = 0x00000017;
            bool common_array_moduled1_literal_const_ec {false};
            CommonStructMember common_array_moduled1_literal_const {TypeObjectUtils::build_common_struct_member(member_id_array_moduled1_literal_const, member_flags_array_moduled1_literal_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled1_literal_const, common_array_moduled1_literal_const_ec))};
            if (!common_array_moduled1_literal_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_moduled1_literal_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_moduled1_literal_const = "array_moduled1_literal_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_moduled1_literal_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_moduled1_literal_const = TypeObjectUtils::build_complete_member_detail(name_array_moduled1_literal_const, member_ann_builtin_array_moduled1_literal_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_moduled1_literal_const = TypeObjectUtils::build_complete_struct_member(common_array_moduled1_literal_const, detail_array_moduled1_literal_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_moduled1_literal_const);
        }
        {
            TypeIdentifierPair type_ids_array_moduled2_literal_const;
            ReturnCode_t return_code_array_moduled2_literal_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_moduled2_literal_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_22", type_ids_array_moduled2_literal_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled2_literal_const)
            {
                return_code_array_moduled2_literal_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_moduled2_literal_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled2_literal_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_22_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_22 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled2_literal_const, element_identifier_anonymous_array_int16_t_22_ec))};
                if (!element_identifier_anonymous_array_int16_t_22_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_22 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_moduled2_literal_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_22 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_22 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_22 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_22, element_flags_anonymous_array_int16_t_22);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(22));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_22, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_22));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_22", type_ids_array_moduled2_literal_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_22 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_moduled2_literal_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_moduled2_literal_const = 0x00000018;
            bool common_array_moduled2_literal_const_ec {false};
            CommonStructMember common_array_moduled2_literal_const {TypeObjectUtils::build_common_struct_member(member_id_array_moduled2_literal_const, member_flags_array_moduled2_literal_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled2_literal_const, common_array_moduled2_literal_const_ec))};
            if (!common_array_moduled2_literal_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_moduled2_literal_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_moduled2_literal_const = "array_moduled2_literal_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_moduled2_literal_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_moduled2_literal_const = TypeObjectUtils::build_complete_member_detail(name_array_moduled2_literal_const, member_ann_builtin_array_moduled2_literal_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_moduled2_literal_const = TypeObjectUtils::build_complete_struct_member(common_array_moduled2_literal_const, detail_array_moduled2_literal_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_moduled2_literal_const);
        }
        {
            TypeIdentifierPair type_ids_array_literal_const_alias_const;
            ReturnCode_t return_code_array_literal_const_alias_const {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_literal_const_alias_const =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_55", type_ids_array_literal_const_alias_const);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_alias_const)
            {
                return_code_array_literal_const_alias_const =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_literal_const_alias_const);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_literal_const_alias_const)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_55_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_55 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_alias_const, element_identifier_anonymous_array_int16_t_55_ec))};
                if (!element_identifier_anonymous_array_int16_t_55_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_55 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_literal_const_alias_const.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_55 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_55 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_55 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_55, element_flags_anonymous_array_int16_t_55);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(55));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_55, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_55));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_55", type_ids_array_literal_const_alias_const))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_55 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_literal_const_alias_const = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_literal_const_alias_const = 0x00000019;
            bool common_array_literal_const_alias_const_ec {false};
            CommonStructMember common_array_literal_const_alias_const {TypeObjectUtils::build_common_struct_member(member_id_array_literal_const_alias_const, member_flags_array_literal_const_alias_const, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_literal_const_alias_const, common_array_literal_const_alias_const_ec))};
            if (!common_array_literal_const_alias_const_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_literal_const_alias_const member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_literal_const_alias_const = "array_literal_const_alias_const";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_literal_const_alias_const;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_literal_const_alias_const = TypeObjectUtils::build_complete_member_detail(name_array_literal_const_alias_const, member_ann_builtin_array_literal_const_alias_const, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_literal_const_alias_const = TypeObjectUtils::build_complete_struct_member(common_array_literal_const_alias_const, detail_array_literal_const_alias_const);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_literal_const_alias_const);
        }
        {
            TypeIdentifierPair type_ids_array_moduled1_literal_alias_const_moduled;
            ReturnCode_t return_code_array_moduled1_literal_alias_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_moduled1_literal_alias_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_array_moduled1_literal_alias_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled1_literal_alias_const_moduled)
            {
                return_code_array_moduled1_literal_alias_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_moduled1_literal_alias_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled1_literal_alias_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled1_literal_alias_const_moduled, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_moduled1_literal_alias_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_array_moduled1_literal_alias_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_moduled1_literal_alias_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_moduled1_literal_alias_const_moduled = 0x0000001a;
            bool common_array_moduled1_literal_alias_const_moduled_ec {false};
            CommonStructMember common_array_moduled1_literal_alias_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_array_moduled1_literal_alias_const_moduled, member_flags_array_moduled1_literal_alias_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled1_literal_alias_const_moduled, common_array_moduled1_literal_alias_const_moduled_ec))};
            if (!common_array_moduled1_literal_alias_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_moduled1_literal_alias_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_moduled1_literal_alias_const_moduled = "array_moduled1_literal_alias_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_moduled1_literal_alias_const_moduled;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_moduled1_literal_alias_const_moduled = TypeObjectUtils::build_complete_member_detail(name_array_moduled1_literal_alias_const_moduled, member_ann_builtin_array_moduled1_literal_alias_const_moduled, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_moduled1_literal_alias_const_moduled = TypeObjectUtils::build_complete_struct_member(common_array_moduled1_literal_alias_const_moduled, detail_array_moduled1_literal_alias_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_moduled1_literal_alias_const_moduled);
        }
        {
            TypeIdentifierPair type_ids_array_moduled2_literal_alias_const_moduled;
            ReturnCode_t return_code_array_moduled2_literal_alias_const_moduled {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_moduled2_literal_alias_const_moduled =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_2", type_ids_array_moduled2_literal_alias_const_moduled);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled2_literal_alias_const_moduled)
            {
                return_code_array_moduled2_literal_alias_const_moduled =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_moduled2_literal_alias_const_moduled);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_moduled2_literal_alias_const_moduled)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled2_literal_alias_const_moduled, element_identifier_anonymous_array_int16_t_2_ec))};
                if (!element_identifier_anonymous_array_int16_t_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_2 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_moduled2_literal_alias_const_moduled.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_2 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_2 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_2, element_flags_anonymous_array_int16_t_2);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_2, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_2", type_ids_array_moduled2_literal_alias_const_moduled))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_moduled2_literal_alias_const_moduled = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_moduled2_literal_alias_const_moduled = 0x0000001b;
            bool common_array_moduled2_literal_alias_const_moduled_ec {false};
            CommonStructMember common_array_moduled2_literal_alias_const_moduled {TypeObjectUtils::build_common_struct_member(member_id_array_moduled2_literal_alias_const_moduled, member_flags_array_moduled2_literal_alias_const_moduled, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_moduled2_literal_alias_const_moduled, common_array_moduled2_literal_alias_const_moduled_ec))};
            if (!common_array_moduled2_literal_alias_const_moduled_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_moduled2_literal_alias_const_moduled member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_moduled2_literal_alias_const_moduled = "array_moduled2_literal_alias_const_moduled";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_moduled2_literal_alias_const_moduled;
            ann_custom_ConstsLiteralsStruct.reset();
            CompleteMemberDetail detail_array_moduled2_literal_alias_const_moduled = TypeObjectUtils::build_complete_member_detail(name_array_moduled2_literal_alias_const_moduled, member_ann_builtin_array_moduled2_literal_alias_const_moduled, ann_custom_ConstsLiteralsStruct);
            CompleteStructMember member_array_moduled2_literal_alias_const_moduled = TypeObjectUtils::build_complete_struct_member(common_array_moduled2_literal_alias_const_moduled, detail_array_moduled2_literal_alias_const_moduled);
            TypeObjectUtils::add_complete_struct_member(member_seq_ConstsLiteralsStruct, member_array_moduled2_literal_alias_const_moduled);
        }
        CompleteStructType struct_type_ConstsLiteralsStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ConstsLiteralsStruct, header_ConstsLiteralsStruct, member_seq_ConstsLiteralsStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ConstsLiteralsStruct, type_name_ConstsLiteralsStruct.to_string(), type_ids_ConstsLiteralsStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ConstsLiteralsStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

