/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fannj;

import com.googlecode.fannj.Layer;
import com.googlecode.fannj.Neuron;
import com.googlecode.fannj.WindowsFunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.util.List;
import java.util.Map;

public class Fann {
    protected Pointer ann;

    protected Fann() {
    }

    public Fann(String file) {
        this.ann = Fann.fann_create_from_file(file);
    }

    public Fann(List<Layer> layers) {
        if (layers == null) {
            throw new IllegalArgumentException("layers == null");
        }
        if (layers.isEmpty()) {
            throw new IllegalArgumentException("layers is empty");
        }
        int[] neurons = new int[layers.size()];
        for (int x = 0; x < neurons.length; ++x) {
            neurons[x] = layers.get(x).size();
        }
        this.ann = Fann.fann_create_standard_array(neurons.length, neurons);
        this.addLayers(layers);
    }

    protected void addLayers(List<Layer> layers) {
        for (int x = 1; x < layers.size(); ++x) {
            Layer layer = layers.get(x);
            for (int n = 0; n < layer.size(); ++n) {
                Fann.fann_set_activation_function(this.ann, ((Neuron)layer.get(n)).getActivationFunction().ordinal(), x, n);
                Fann.fann_set_activation_steepness(this.ann, ((Neuron)layer.get(n)).getSteepness(), x, n);
            }
        }
    }

    public int getNumInputNeurons() {
        return Fann.fann_get_num_input(this.ann);
    }

    public int getNumOutputNeurons() {
        return Fann.fann_get_num_output(this.ann);
    }

    public int getTotalNumNeurons() {
        return Fann.fann_get_total_neurons(this.ann);
    }

    public boolean save(String file) {
        return Fann.fann_save(this.ann, file) == 0;
    }

    public float[] run(float[] input) {
        Pointer result = Fann.fann_run(this.ann, input);
        float[] output = result.getFloatArray(0L, this.getNumOutputNeurons());
        return output;
    }

    public void close() {
        if (this.ann != null) {
            Fann.fann_destroy(this.ann);
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected static native Pointer fann_create_standard_array(int var0, int[] var1);

    protected static native Pointer fann_create_sparse_array(float var0, int var1, int[] var2);

    protected static native Pointer fann_create_shortcut_array(int var0, int[] var1);

    protected static native float fann_get_MSE(Pointer var0);

    protected static native Pointer fann_run(Pointer var0, float[] var1);

    protected static native void fann_destroy(Pointer var0);

    protected static native int fann_get_num_input(Pointer var0);

    protected static native int fann_get_num_output(Pointer var0);

    protected static native int fann_get_total_neurons(Pointer var0);

    protected static native void fann_set_activation_function(Pointer var0, int var1, int var2, int var3);

    protected static native void fann_set_activation_steepness(Pointer var0, float var1, int var2, int var3);

    protected static native Pointer fann_get_neuron(Pointer var0, int var1, int var2);

    protected static native Pointer fann_create_from_file(String var0);

    protected static native int fann_save(Pointer var0, String var1);

    static {
        NativeLibrary fann;
        if (Platform.isWindows()) {
            fann = NativeLibrary.getInstance((String)"fannfloat");
            Map options = fann.getOptions();
            options.put("calling-convention", 1);
            options.put("function-mapper", new WindowsFunctionMapper());
        } else {
            fann = NativeLibrary.getInstance((String)"fann");
        }
        Native.register((NativeLibrary)fann);
    }
}

