/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceGroup;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.ColourSchemeI;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;

public class AnnotationColourChooser
extends Panel
implements ActionListener,
AdjustmentListener,
ItemListener,
MouseListener {
    Frame frame;
    AlignViewport av;
    AlignmentPanel ap;
    ColourSchemeI oldcs;
    Hashtable oldgroupColours;
    AlignmentAnnotation currentAnnotation;
    boolean adjusting = false;
    Choice annotations = new Choice();
    Button minColour = new Button();
    Button maxColour = new Button();
    Button ok = new Button();
    Button cancel = new Button();
    Panel jPanel1 = new Panel();
    Panel jPanel2 = new Panel();
    Choice threshold = new Choice();
    FlowLayout flowLayout1 = new FlowLayout();
    Panel jPanel3 = new Panel();
    Scrollbar slider = new Scrollbar(0);
    TextField thresholdValue = new TextField(20);
    Checkbox currentColours = new Checkbox();
    BorderLayout borderLayout1 = new BorderLayout();
    Checkbox thresholdIsMin = new Checkbox();

    public AnnotationColourChooser(AlignViewport av, AlignmentPanel ap) {
        int i;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.oldcs = av.getGlobalColourScheme();
        if (av.alignment.getGroups() != null) {
            this.oldgroupColours = new Hashtable();
            Vector allGroups = ap.av.alignment.getGroups();
            for (int g = 0; g < allGroups.size(); ++g) {
                SequenceGroup sg = (SequenceGroup)allGroups.elementAt(g);
                if (sg.cs != null) {
                    this.oldgroupColours.put(sg, sg.cs);
                    continue;
                }
                this.oldgroupColours.put(sg, "null");
            }
        }
        this.av = av;
        this.ap = ap;
        this.slider.addAdjustmentListener(this);
        this.slider.addMouseListener(this);
        if (av.alignment.getAlignmentAnnotation() == null) {
            return;
        }
        if (this.oldcs instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)this.oldcs;
            this.minColour.setBackground(acg.getMinColour());
            this.maxColour.setBackground(acg.getMaxColour());
        } else {
            this.minColour.setBackground(Color.orange);
            this.maxColour.setBackground(Color.red);
        }
        this.adjusting = true;
        Vector<String> list = new Vector<String>();
        int index = 1;
        for (i = 0; i < av.alignment.getAlignmentAnnotation().length; ++i) {
            String label = av.alignment.getAlignmentAnnotation()[i].label;
            if (!list.contains(label)) {
                list.addElement(label);
                continue;
            }
            list.addElement(label + "_" + index++);
        }
        for (i = 0; i < list.size(); ++i) {
            this.annotations.addItem(list.elementAt(i).toString());
        }
        this.threshold.addItem("No Threshold");
        this.threshold.addItem("Above Threshold");
        this.threshold.addItem("Below Threshold");
        this.adjusting = false;
        this.changeColour();
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, "Colour by Annotation", 480, 145);
        this.validate();
    }

    public AnnotationColourChooser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.minColour.setFont(new Font("Verdana", 0, 11));
        this.minColour.setLabel("Min Colour");
        this.minColour.addActionListener(this);
        this.maxColour.setFont(new Font("Verdana", 0, 11));
        this.maxColour.setLabel("Max Colour");
        this.maxColour.addActionListener(this);
        this.thresholdIsMin.addItemListener(this);
        this.ok.setLabel("OK");
        this.ok.addActionListener(this);
        this.cancel.setLabel("Cancel");
        this.cancel.addActionListener(this);
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.annotations.addItemListener(this);
        this.jPanel1.setBackground(Color.white);
        this.jPanel2.setBackground(Color.white);
        this.threshold.addItemListener(this);
        this.jPanel3.setLayout(null);
        this.thresholdValue.addActionListener(this);
        this.slider.setBackground(Color.white);
        this.slider.setEnabled(false);
        this.slider.setBounds(new Rectangle(153, 3, 93, 21));
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setBounds(new Rectangle(248, 2, 79, 22));
        this.thresholdValue.setColumns(5);
        this.jPanel3.setBackground(Color.white);
        this.currentColours.setFont(new Font("Verdana", 0, 11));
        this.currentColours.setLabel("Use Original Colours");
        this.currentColours.addItemListener(this);
        this.threshold.setBounds(new Rectangle(11, 3, 139, 22));
        this.thresholdIsMin.setBackground(Color.white);
        this.thresholdIsMin.setLabel("Threshold is min/max");
        this.thresholdIsMin.setBounds(new Rectangle(328, 3, 135, 23));
        this.jPanel1.add(this.ok);
        this.jPanel1.add(this.cancel);
        this.jPanel2.add(this.annotations);
        this.jPanel2.add(this.currentColours);
        this.jPanel2.add(this.minColour);
        this.jPanel2.add(this.maxColour);
        this.jPanel3.add(this.threshold);
        this.jPanel3.add(this.slider);
        this.jPanel3.add(this.thresholdValue);
        this.jPanel3.add(this.thresholdIsMin);
        this.add((Component)this.jPanel2, "North");
        this.add((Component)this.jPanel3, "Center");
        this.add((Component)this.jPanel1, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.thresholdValue) {
            try {
                float f = new Float(this.thresholdValue.getText()).floatValue();
                this.slider.setValue((int)(f * 1000.0f));
                this.adjustmentValueChanged(null);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (evt.getSource() == this.minColour) {
            this.minColour_actionPerformed(null);
        } else if (evt.getSource() == this.maxColour) {
            this.maxColour_actionPerformed(null);
        } else if (evt.getSource() == this.ok) {
            this.changeColour();
            this.frame.setVisible(false);
        } else if (evt.getSource() == this.cancel) {
            this.reset();
            this.ap.paintAlignment(true);
            this.frame.setVisible(false);
        } else {
            this.changeColour();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.currentColours) {
            if (this.currentColours.getState()) {
                this.reset();
            }
            this.maxColour.setEnabled(!this.currentColours.getState());
            this.minColour.setEnabled(!this.currentColours.getState());
        }
        this.changeColour();
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (!this.adjusting) {
            this.thresholdValue.setText((float)this.slider.getValue() / 1000.0f + "");
            if (this.currentColours.getState() && !(this.av.getGlobalColourScheme() instanceof AnnotationColourGradient)) {
                this.changeColour();
            }
            this.currentAnnotation.threshold.value = (float)this.slider.getValue() / 1000.0f;
            this.ap.paintAlignment(false);
        }
    }

    public void minColour_actionPerformed(Color newCol) {
        if (newCol != null) {
            this.minColour.setBackground(newCol);
            this.minColour.repaint();
            this.changeColour();
        } else {
            new UserDefinedColours((Object)this, "Min Colour", this.minColour.getBackground());
        }
    }

    public void maxColour_actionPerformed(Color newCol) {
        if (newCol != null) {
            this.maxColour.setBackground(newCol);
            this.maxColour.repaint();
            this.changeColour();
        } else {
            new UserDefinedColours((Object)this, "Max Colour", this.maxColour.getBackground());
        }
    }

    void changeColour() {
        if (this.adjusting) {
            return;
        }
        this.currentAnnotation = this.av.alignment.getAlignmentAnnotation()[this.annotations.getSelectedIndex()];
        int aboveThreshold = -1;
        if (this.threshold.getSelectedItem().equals("Above Threshold")) {
            aboveThreshold = AnnotationColourGradient.ABOVE_THRESHOLD;
        } else if (this.threshold.getSelectedItem().equals("Below Threshold")) {
            aboveThreshold = AnnotationColourGradient.BELOW_THRESHOLD;
        }
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        if (aboveThreshold == AnnotationColourGradient.NO_THRESHOLD) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdValue.setText("");
        } else if (aboveThreshold != AnnotationColourGradient.NO_THRESHOLD && this.currentAnnotation.threshold == null) {
            this.currentAnnotation.setThreshold(new GraphLine((this.currentAnnotation.graphMax - this.currentAnnotation.graphMin) / 2.0f, "Threshold", Color.black));
        }
        if (aboveThreshold != AnnotationColourGradient.NO_THRESHOLD) {
            this.adjusting = true;
            this.slider.setMinimum((int)(this.currentAnnotation.graphMin * 1000.0f));
            this.slider.setMaximum((int)(this.currentAnnotation.graphMax * 1000.0f));
            this.slider.setValue((int)(this.currentAnnotation.threshold.value * 1000.0f));
            this.thresholdValue.setText(this.currentAnnotation.threshold.value + "");
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.adjusting = false;
        }
        AnnotationColourGradient acg = null;
        acg = this.currentColours.getState() ? new AnnotationColourGradient(this.currentAnnotation, this.av.getGlobalColourScheme(), aboveThreshold) : new AnnotationColourGradient(this.currentAnnotation, this.minColour.getBackground(), this.maxColour.getBackground(), aboveThreshold);
        if (this.currentAnnotation.graphMin == 0.0f && this.currentAnnotation.graphMax == 0.0f) {
            acg.predefinedColours = true;
        }
        acg.thresholdIsMinMax = this.thresholdIsMin.getState();
        this.av.setGlobalColourScheme(acg);
        if (this.av.alignment.getGroups() != null) {
            Vector allGroups = this.ap.av.alignment.getGroups();
            for (int g = 0; g < allGroups.size(); ++g) {
                SequenceGroup sg = (SequenceGroup)allGroups.elementAt(g);
                if (sg.cs == null) continue;
                sg.cs = this.currentColours.getState() ? new AnnotationColourGradient(this.currentAnnotation, sg.cs, aboveThreshold) : new AnnotationColourGradient(this.currentAnnotation, this.minColour.getBackground(), this.maxColour.getBackground(), aboveThreshold);
            }
        }
        this.ap.paintAlignment(false);
    }

    void reset() {
        this.av.setGlobalColourScheme(this.oldcs);
        if (this.av.alignment.getGroups() != null) {
            Vector allGroups = this.ap.av.alignment.getGroups();
            for (int g = 0; g < allGroups.size(); ++g) {
                SequenceGroup sg = (SequenceGroup)allGroups.elementAt(g);
                Object cs = this.oldgroupColours.get(sg);
                sg.cs = cs instanceof ColourSchemeI ? (ColourSchemeI)cs : null;
            }
        }
        this.ap.paintAlignment(true);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
        this.ap.paintAlignment(true);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }
}

