/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/filter_test_data.cpp
 * @brief [LEVEL: beta] implementation of @ref diagnostics::unittest::Filter_Test_Data class
 *
 * $Id: filter_test_data.cpp,v 1.9 2005/06/23 09:54:25 esdentem Exp $
 * 
 * @author Christian Schallhart
 */
#include <diagnostics/unittest/test_system/filter_test_data.hpp>

#include <diagnostics/unittest/test_system_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

Filter_Test_Data::~Filter_Test_Data()
{
}


Filter_Test_Data::Filter_Test_Data() :
    m_prefix(""),
    m_backend(NULL)
{
}


void Filter_Test_Data::attach(::std::string const & prefix, Test_Data * const test_data) 
{
    if(test_data==NULL) throw Test_System_Exception("test_data_source==NULL");
    m_prefix=prefix;
    m_backend=test_data;
}


::std::string const & Filter_Test_Data::get(::std::string const & id) const 
{
    if(m_backend==NULL) throw Test_System_Exception("test_data_source==NULL");
    return m_backend->get(m_prefix+id);
}

bool Filter_Test_Data::compare(::std::string const & id,::std::string const & data) const
{
    if(m_backend==NULL) throw Test_System_Exception("test_data_source==NULL");
    return m_backend->compare(m_prefix+id,data);
}



UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
