/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class XSLNamespaceAlias
extends StyleElement {
    private short stylesheetURICode;
    private int resultNamespaceCode;

    public void prepareAttributes() throws XPathException {
        String string;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            string = this.getNamePool().getClarkName(n);
            if (string == "stylesheet-prefix") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string == "result-prefix") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string2 == null) {
            this.reportAbsence("stylesheet-prefix");
            return;
        }
        if (string2.equals("#default")) {
            string2 = "";
        }
        if (string3 == null) {
            this.reportAbsence("result-prefix");
            return;
        }
        if (string3.equals("#default")) {
            string3 = "";
        }
        try {
            String string4 = this.getURIForPrefix(string2, true);
            if (string4 == null) {
                this.compileError("stylesheet-prefix " + string2 + " has not been declared", "XTSE0812");
                this.stylesheetURICode = 0;
                this.resultNamespaceCode = 0;
                return;
            }
            this.stylesheetURICode = string4.equals("") ? (short)0 : this.getURICodeForPrefix(string2);
            NamePool namePool = this.getNamePool();
            string = this.getURIForPrefix(string3, true);
            if (string == null) {
                this.compileError("result-prefix " + string3 + " has not been declared", "XTSE0812");
                this.stylesheetURICode = 0;
                this.resultNamespaceCode = 0;
                return;
            }
            this.resultNamespaceCode = string.equals("") ? 0 : namePool.getNamespaceCode(string3, string);
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }

    public short getStylesheetURICode() {
        return this.stylesheetURICode;
    }

    public int getResultNamespaceCode() {
        return this.resultNamespaceCode;
    }
}

