// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "BasicRenderedStringParser.pypp.hpp"

namespace bp = boost::python;

struct BasicRenderedStringParser_wrapper : CEGUI::BasicRenderedStringParser, bp::wrapper< CEGUI::BasicRenderedStringParser > {

    BasicRenderedStringParser_wrapper(CEGUI::BasicRenderedStringParser const & arg )
    : CEGUI::BasicRenderedStringParser( arg )
      , bp::wrapper< CEGUI::BasicRenderedStringParser >(){
        // copy constructor
        
    }

    BasicRenderedStringParser_wrapper( )
    : CEGUI::BasicRenderedStringParser( )
      , bp::wrapper< CEGUI::BasicRenderedStringParser >(){
        // null constructor
    
    }

    BasicRenderedStringParser_wrapper(::CEGUI::String const & initial_font, ::CEGUI::ColourRect const & initial_colours )
    : CEGUI::BasicRenderedStringParser( boost::ref(initial_font), boost::ref(initial_colours) )
      , bp::wrapper< CEGUI::BasicRenderedStringParser >(){
        // constructor
    
    }

    virtual ::CEGUI::RenderedString parse( ::CEGUI::String const & input_string, ::CEGUI::Font * initial_font, ::CEGUI::ColourRect const * initial_colours ) {
        if( bp::override func_parse = this->get_override( "parse" ) )
            return func_parse( boost::ref(input_string), boost::python::ptr(initial_font), boost::python::ptr(initial_colours) );
        else{
            return this->CEGUI::BasicRenderedStringParser::parse( boost::ref(input_string), boost::python::ptr(initial_font), boost::python::ptr(initial_colours) );
        }
    }
    
    ::CEGUI::RenderedString default_parse( ::CEGUI::String const & input_string, ::CEGUI::Font * initial_font, ::CEGUI::ColourRect const * initial_colours ) {
        return CEGUI::BasicRenderedStringParser::parse( boost::ref(input_string), boost::python::ptr(initial_font), boost::python::ptr(initial_colours) );
    }

};

void register_BasicRenderedStringParser_class(){

    { //::CEGUI::BasicRenderedStringParser
        typedef bp::class_< BasicRenderedStringParser_wrapper, bp::bases< CEGUI::RenderedStringParser > > BasicRenderedStringParser_exposer_t;
        BasicRenderedStringParser_exposer_t BasicRenderedStringParser_exposer = BasicRenderedStringParser_exposer_t( "BasicRenderedStringParser", "*!\n\
        \n\
            Basic RenderedStringParser class that offers support for the following tags:\n\
            - 'colour' value is a CEGUI colour property value.\n\
            - 'font' value is the name of a font.\n\
            - 'image' value is a CEGUI image property value.\n\
            - 'window' value is the name of a window.\n\
            - 'vert-alignment' value is either top, bottom, centre or stretch.\n\
            - 'padding' value is a CEGUI Rect property value.\n\
            - 'top-padding' value is a float.\n\
            - 'bottom-padding' value is a float.\n\
            - 'left-padding' value is a float.\n\
            - 'right-padding' value is a float.\n\
            - 'image-size' value is a CEGUI size property value.\n\
            - 'image-width' value is a float.\n\
            - 'image-height' value is a float.\n\
            - 'aspect-lock' value is a boolean (NB: this currently has no effect).\n\
        *\n", bp::init< >("! Constructor.\n") );
        bp::scope BasicRenderedStringParser_scope( BasicRenderedStringParser_exposer );
        BasicRenderedStringParser_exposer.def( bp::init< CEGUI::String const &, CEGUI::ColourRect const & >(( bp::arg("initial_font"), bp::arg("initial_colours") ), "*!\n\
            \n\
                Initialising constructor.\n\
        \n\
            @param initial_font\n\
                Reference to a String holding the name of the initial font to be used.\n\
        \n\
            @param initial_colours\n\
                Reference to a ColourRect describing the initial colours to be used.\n\
            *\n") );
        { //::CEGUI::BasicRenderedStringParser::getInitialColours
        
            typedef ::CEGUI::ColourRect const & ( ::CEGUI::BasicRenderedStringParser::*getInitialColours_function_type )(  ) const;
            
            BasicRenderedStringParser_exposer.def( 
                "getInitialColours"
                , getInitialColours_function_type( &::CEGUI::BasicRenderedStringParser::getInitialColours )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
            \n\
                Return a ColourRect describing the initial colours used in each parse.\n\
            *\n" );
        
        }
        { //::CEGUI::BasicRenderedStringParser::getInitialFontName
        
            typedef ::CEGUI::String const & ( ::CEGUI::BasicRenderedStringParser::*getInitialFontName_function_type )(  ) const;
            
            BasicRenderedStringParser_exposer.def( 
                "getInitialFontName"
                , getInitialFontName_function_type( &::CEGUI::BasicRenderedStringParser::getInitialFontName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
            \n\
                Return the name of the initial font used in each parse.\n\
            *\n" );
        
        }
        { //::CEGUI::BasicRenderedStringParser::parse
        
            typedef ::CEGUI::RenderedString ( ::CEGUI::BasicRenderedStringParser::*parse_function_type )( ::CEGUI::String const &,::CEGUI::Font *,::CEGUI::ColourRect const * ) ;
            typedef ::CEGUI::RenderedString ( BasicRenderedStringParser_wrapper::*default_parse_function_type )( ::CEGUI::String const &,::CEGUI::Font *,::CEGUI::ColourRect const * ) ;
            
            BasicRenderedStringParser_exposer.def( 
                "parse"
                , parse_function_type(&::CEGUI::BasicRenderedStringParser::parse)
                , default_parse_function_type(&BasicRenderedStringParser_wrapper::default_parse)
                , ( bp::arg("input_string"), bp::arg("initial_font"), bp::arg("initial_colours") ) );
        
        }
        { //::CEGUI::BasicRenderedStringParser::setInitialColours
        
            typedef void ( ::CEGUI::BasicRenderedStringParser::*setInitialColours_function_type )( ::CEGUI::ColourRect const & ) ;
            
            BasicRenderedStringParser_exposer.def( 
                "setInitialColours"
                , setInitialColours_function_type( &::CEGUI::BasicRenderedStringParser::setInitialColours )
                , ( bp::arg("colours") )
                , "*!\n\
                \n\
                    Set the initial colours to be used on subsequent calls to parse.\n\
            \n\
                @param colours\n\
                    ColourRect object holding the colours.\n\
                *\n" );
        
        }
        { //::CEGUI::BasicRenderedStringParser::setInitialFontName
        
            typedef void ( ::CEGUI::BasicRenderedStringParser::*setInitialFontName_function_type )( ::CEGUI::String const & ) ;
            
            BasicRenderedStringParser_exposer.def( 
                "setInitialFontName"
                , setInitialFontName_function_type( &::CEGUI::BasicRenderedStringParser::setInitialFontName )
                , ( bp::arg("font_name") )
                , "*!\n\
                \n\
                    set the initial font name to be used on subsequent calls to parse.\n\
            \n\
                @param font_name\n\
                    String object holding the name of the font.\n\
                *\n" );
        
        }
        BasicRenderedStringParser_exposer.add_static_property( "AspectLockTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::AspectLockTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "BottomAlignedValueName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::BottomAlignedValueName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "BottomPaddingTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::BottomPaddingTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "CentreAlignedValueName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::CentreAlignedValueName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "ColourTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::ColourTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "FontTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::FontTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "ImageHeightTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::ImageHeightTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "ImageSizeTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::ImageSizeTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "ImageTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::ImageTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "ImageWidthTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::ImageWidthTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "LeftPaddingTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::LeftPaddingTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "PaddingTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::PaddingTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "RightPaddingTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::RightPaddingTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "StretchAlignedValueName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::StretchAlignedValueName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "TopAlignedValueName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::TopAlignedValueName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "TopPaddingTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::TopPaddingTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "VertAlignmentTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::VertAlignmentTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
        BasicRenderedStringParser_exposer.add_static_property( "WindowTagName"
                        , bp::make_getter( &CEGUI::BasicRenderedStringParser::WindowTagName
                                , bp::return_value_policy< bp::return_by_value >() ) );
    }

}
