/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _FLUXREG_F_H_
#define _FLUXREG_F_H_  "%W% %G%"

#ifdef BL_LANG_FORT
#    define FORT_FRCRSEINIT  frcrseinit
#    define FORT_FRFINEADD   frfineadd
#    define FORT_FRCAINIT    frcainit
#    define FORT_FRFAADD     frfaadd
#    define FORT_FRREFLUX    frreflux
#    define FORT_FRCVREFLUX  frcvreflux
#    define FORT_SCALADDTO   scaladdto
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_FRCRSEINIT  FRCRSEINIT
#    define FORT_FRFINEADD   FRFINEADD
#    define FORT_FRCAINIT    FRCAINIT
#    define FORT_FRFAADD     FRFAADD
#    define FORT_FRREFLUX    FRREFLUX
#    define FORT_FRCVREFLUX  FRCVREFLUX
#    define FORT_SCALADDTO   SCALADDTO
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_FRCRSEINIT  frcrseinit
#    define FORT_FRFINEADD   frfineadd
#    define FORT_FRCAINIT    frcainit
#    define FORT_FRFAADD     frfaadd
#    define FORT_FRREFLUX    frreflux
#    define FORT_FRCVREFLUX  frcvreflux
#    define FORT_SCALADDTO   scaladdto
#  else
#    define FORT_FRCRSEINIT  frcrseinit_
#    define FORT_FRFINEADD   frfineadd_
#    define FORT_FRCAINIT    frcainit_
#    define FORT_FRFAADD     frfaadd_
#    define FORT_FRREFLUX    frreflux_
#    define FORT_FRCVREFLUX  frcvreflux_
#    define FORT_SCALADDTO   scaladdto_
#  endif
#  endif

#include <ArrayLim.H>

extern "C"
{

    void FORT_FRCRSEINIT (Real* reg,       ARLIM_P(rlo), ARLIM_P(rhi),
                          const Real* flx, ARLIM_P(flo), ARLIM_P(fhi),
                          const int* lo, const int* hi,
                          const int* numcomp, const int* dir,
                          const Real* mult);

    void FORT_FRCAINIT (Real* reg,        ARLIM_P(rlo), ARLIM_P(rhi),
                        const Real* flx,  ARLIM_P(flo), ARLIM_P(fhi),
                        const Real* area, ARLIM_P(alo), ARLIM_P(ahi),
                        const int* lo, const int* hi,
                        const int* numcomp, const int* dir,
                        const Real* mult);

    void FORT_FRFINEADD (Real* reg,       ARLIM_P(rlo), ARLIM_P(rhi),
                         const Real* flx, ARLIM_P(flo), ARLIM_P(fhi),
                         const int* numcomp, const int* dir,
                         const int* ratio, const Real* mult);

    void FORT_FRFAADD (Real* reg,        ARLIM_P(rlo), ARLIM_P(rhi),
                       const Real* flx,  ARLIM_P(flo), ARLIM_P(fhi),
                       const Real* area, ARLIM_P(alo), ARLIM_P(ahi),
                       const int* numcomp, const int* dir,
                       const int* ratio, const Real* mult);

    void FORT_FRREFLUX (Real* s,         ARLIM_P(slo), ARLIM_P(shi),
			const Real* vol, ARLIM_P(vlo), ARLIM_P(vhi),
			const Real* reg, ARLIM_P(rlo), ARLIM_P(rhi),
			const int* lo, const int* hi,
			const int* numcomp, const Real* mult);

    void FORT_FRCVREFLUX (Real* s, ARLIM_P(slo), ARLIM_P(shi),
			  const Real* dx,
			  const Real* reg, ARLIM_P(rlo), ARLIM_P(rhi),
			  const int* lo, const int* hi,
			  const int* numcomp, const Real* mult);

    void FORT_SCALADDTO (Real * flx,         ARLIM_P(flo), ARLIM_P(fhi),
                         const Real * area,  ARLIM_P(alo), ARLIM_P(ahi),
                         Real * reg,         ARLIM_P(rlo), ARLIM_P(rhi),
                         const int * lo, const int * hi,
                         const int * numcomp, const Real * mult);

}
#endif

#endif
