{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetForce: TVector3;
    procedure SetForce(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdForce: TSFVec3f;
    { Internal wrapper for property @code(Force). This wrapper API may change, we advise to access simpler @code(Force) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdForce: TSFVec3f read FFdForce;
    {  }
    property Force: TVector3 read GetForce write SetForce;

{$endif read_interface}

{$ifdef read_implementation}

{ TForcePhysicsModelNode ----------------------------------------------- }

function TForcePhysicsModelNode.GetForce: TVector3;
begin
  Result := FdForce.Value;
end;

procedure TForcePhysicsModelNode.SetForce(const Value: TVector3);
begin
  FdForce.Send(Value);
end;

class function TForcePhysicsModelNode.ClassX3DType: String;
begin
  Result := 'ForcePhysicsModel';
end;

procedure TForcePhysicsModelNode.CreateNode;
begin
  inherited;

  FFdForce := TSFVec3f.Create(Self, True, 'force', Vector3(0, -9.8, 0));
   FdForce.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdForce);
end;

{$endif read_implementation}
