{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAnchorPoint: TVector3;
    procedure SetAnchorPoint(const Value: TVector3);
    function GetAxis1: TVector3;
    procedure SetAxis1(const Value: TVector3);
    function GetAxis2: TVector3;
    procedure SetAxis2(const Value: TVector3);
    function GetStopBounce1: Single;
    procedure SetStopBounce1(const Value: Single);
    function GetStop1ErrorCorrection: Single;
    procedure SetStop1ErrorCorrection(const Value: Single);
    function GetStop2Bounce: Single;
    procedure SetStop2Bounce(const Value: Single);
    function GetStop2ErrorCorrection: Single;
    procedure SetStop2ErrorCorrection(const Value: Single);
  public
    property AnchorPoint: TVector3 read GetAnchorPoint write SetAnchorPoint;
    property Axis1: TVector3 read GetAxis1 write SetAxis1;
    property Axis2: TVector3 read GetAxis2 write SetAxis2;
    property StopBounce1: Single read GetStopBounce1 write SetStopBounce1;
    property Stop1ErrorCorrection: Single read GetStop1ErrorCorrection write SetStop1ErrorCorrection;
    property Stop2Bounce: Single read GetStop2Bounce write SetStop2Bounce;
    property Stop2ErrorCorrection: Single read GetStop2ErrorCorrection write SetStop2ErrorCorrection;

{$endif read_interface}

{$ifdef read_implementation}

{ TUniversalJointNode ----------------------------------------------- }

function TUniversalJointNode.GetAnchorPoint: TVector3;
begin
  Result := FdAnchorPoint.Value;
end;

procedure TUniversalJointNode.SetAnchorPoint(const Value: TVector3);
begin
  FdAnchorPoint.Send(Value);
end;

function TUniversalJointNode.GetAxis1: TVector3;
begin
  Result := FdAxis1.Value;
end;

procedure TUniversalJointNode.SetAxis1(const Value: TVector3);
begin
  FdAxis1.Send(Value);
end;

function TUniversalJointNode.GetAxis2: TVector3;
begin
  Result := FdAxis2.Value;
end;

procedure TUniversalJointNode.SetAxis2(const Value: TVector3);
begin
  FdAxis2.Send(Value);
end;

function TUniversalJointNode.GetStopBounce1: Single;
begin
  Result := FdStopBounce1.Value;
end;

procedure TUniversalJointNode.SetStopBounce1(const Value: Single);
begin
  FdStopBounce1.Send(Value);
end;

function TUniversalJointNode.GetStop1ErrorCorrection: Single;
begin
  Result := FdStop1ErrorCorrection.Value;
end;

procedure TUniversalJointNode.SetStop1ErrorCorrection(const Value: Single);
begin
  FdStop1ErrorCorrection.Send(Value);
end;

function TUniversalJointNode.GetStop2Bounce: Single;
begin
  Result := FdStop2Bounce.Value;
end;

procedure TUniversalJointNode.SetStop2Bounce(const Value: Single);
begin
  FdStop2Bounce.Send(Value);
end;

function TUniversalJointNode.GetStop2ErrorCorrection: Single;
begin
  Result := FdStop2ErrorCorrection.Value;
end;

procedure TUniversalJointNode.SetStop2ErrorCorrection(const Value: Single);
begin
  FdStop2ErrorCorrection.Send(Value);
end;

{$endif read_implementation}
