/* component-person.c generated by valac 0.28.0, the Vala compiler
 * generated from component-person.vala, do not modify */

/* Copyright 2014-2015 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <libical/ical.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COMPONENT_TYPE_PERSON (california_component_person_get_type ())
#define CALIFORNIA_COMPONENT_PERSON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson))
#define CALIFORNIA_COMPONENT_PERSON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPersonClass))
#define CALIFORNIA_COMPONENT_IS_PERSON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_PERSON))
#define CALIFORNIA_COMPONENT_IS_PERSON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_PERSON))
#define CALIFORNIA_COMPONENT_PERSON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPersonClass))

typedef struct _CaliforniaComponentPerson CaliforniaComponentPerson;
typedef struct _CaliforniaComponentPersonClass CaliforniaComponentPersonClass;
typedef struct _CaliforniaComponentPersonPrivate CaliforniaComponentPersonPrivate;

#define CALIFORNIA_COMPONENT_PERSON_TYPE_RELATIONSHIP (california_component_person_relationship_get_type ())
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _icalparameter_free0(var) ((var == NULL) ? NULL : (var = (icalparameter_free (var), NULL)))
#define _icalproperty_free0(var) ((var == NULL) ? NULL : (var = (icalproperty_free (var), NULL)))

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaComponentPerson {
	CaliforniaBaseObject parent_instance;
	CaliforniaComponentPersonPrivate * priv;
};

struct _CaliforniaComponentPersonClass {
	CaliforniaBaseObjectClass parent_class;
};

typedef enum  {
	CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ORGANIZER,
	CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ATTENDEE
} CaliforniaComponentPersonRelationship;

struct _CaliforniaComponentPersonPrivate {
	CaliforniaComponentPersonRelationship _relationship;
	SoupURI* _mailto;
	gchar* _common_name;
	icalparameter_role _role;
	gboolean _rsvp;
	gchar* _full_mailbox;
	gboolean _send_invite;
	GeeHashSet* parameters;
};

typedef enum  {
	CALIFORNIA_COMPONENT_ERROR_INVALID,
	CALIFORNIA_COMPONENT_ERROR_MISMATCH,
	CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE
} CaliforniaComponentError;
#define CALIFORNIA_COMPONENT_ERROR california_component_error_quark ()

static gpointer california_component_person_parent_class = NULL;
static GeeHashableIface* california_component_person_gee_hashable_parent_iface = NULL;
static GeeComparableIface* california_component_person_gee_comparable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_component_person_get_type (void) G_GNUC_CONST;
GType california_component_person_relationship_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_COMPONENT_PERSON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPersonPrivate))
enum  {
	CALIFORNIA_COMPONENT_PERSON_DUMMY_PROPERTY,
	CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP,
	CALIFORNIA_COMPONENT_PERSON_MAILTO,
	CALIFORNIA_COMPONENT_PERSON_COMMON_NAME,
	CALIFORNIA_COMPONENT_PERSON_ROLE,
	CALIFORNIA_COMPONENT_PERSON_RSVP,
	CALIFORNIA_COMPONENT_PERSON_MAILTO_TEXT,
	CALIFORNIA_COMPONENT_PERSON_MAILBOX,
	CALIFORNIA_COMPONENT_PERSON_FULL_MAILBOX,
	CALIFORNIA_COMPONENT_PERSON_SEND_INVITE
};
static void _vala_SoupURI_free (SoupURI* self);
guint california_string_ci_hash (const gchar* str);
static guint _california_string_ci_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean california_string_ci_equal (const gchar* a, const gchar* b);
static gboolean _california_string_ci_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
#define CALIFORNIA_COMPONENT_PERSON_PROP_SEND_INVITE "send-invite"
GQuark california_component_error_quark (void);
CaliforniaComponentPerson* california_component_person_new (CaliforniaComponentPersonRelationship relationship, SoupURI* mailto, const gchar* common_name, icalparameter_role role, gboolean rsvp, GError** error);
CaliforniaComponentPerson* california_component_person_construct (GType object_type, CaliforniaComponentPersonRelationship relationship, SoupURI* mailto, const gchar* common_name, icalparameter_role role, gboolean rsvp, GError** error);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static void california_component_person_validate_mailto (SoupURI* uri, GError** error);
static void california_component_person_set_relationship (CaliforniaComponentPerson* self, CaliforniaComponentPersonRelationship value);
static void california_component_person_set_mailto (CaliforniaComponentPerson* self, SoupURI* value);
static void california_component_person_set_common_name (CaliforniaComponentPerson* self, const gchar* value);
static void california_component_person_set_role (CaliforniaComponentPerson* self, icalparameter_role value);
static void california_component_person_set_rsvp (CaliforniaComponentPerson* self, gboolean value);
static gchar* california_component_person_make_full_address (SoupURI* mailto, const gchar* common_name);
static void california_component_person_set_full_mailbox (CaliforniaComponentPerson* self, const gchar* value);
gboolean california_string_is_empty (const gchar* str);
CaliforniaComponentPerson* california_component_person_new_from_property (icalproperty* prop, GError** error);
CaliforniaComponentPerson* california_component_person_construct_from_property (GType object_type, icalproperty* prop, GError** error);
const gchar* ical_icalproperty_kind_to_string (icalproperty_kind self);
static const char* _ical_icalproperty_kind_to_string (icalproperty_kind value);
const gchar* ical_icalvalue_kind_to_string (icalvalue_kind self);
static const char* _ical_icalvalue_kind_to_string (icalvalue_kind value);
SoupURI* california_uri_parse (const gchar* uri, GError** error);
SoupURI* california_component_person_get_mailto (CaliforniaComponentPerson* self);
const gchar* california_component_person_get_common_name (CaliforniaComponentPerson* self);
gboolean california_email_is_valid_mailbox (const gchar* str);
gboolean california_string_ascii_ci_equal (const gchar* a, const gchar* b);
icalproperty* california_component_person_as_ical_property (CaliforniaComponentPerson* self);
CaliforniaComponentPersonRelationship california_component_person_get_relationship (CaliforniaComponentPerson* self);
gchar* california_component_person_get_mailto_text (CaliforniaComponentPerson* self);
static guint california_component_person_real_hash (GeeHashable* base);
static gboolean california_component_person_real_equal_to (GeeHashable* base, CaliforniaComponentPerson* other);
static gint california_component_person_real_compare_to (GeeComparable* base, CaliforniaComponentPerson* other);
gint california_string_stricmp (const gchar* a, const gchar* b);
const gchar* california_component_person_get_mailbox (CaliforniaComponentPerson* self);
static gchar* california_component_person_real_to_string (CaliforniaBaseObject* base);
static SoupURI* _vala_SoupURI_copy (SoupURI* self);
icalparameter_role california_component_person_get_role (CaliforniaComponentPerson* self);
gboolean california_component_person_get_rsvp (CaliforniaComponentPerson* self);
const gchar* california_component_person_get_full_mailbox (CaliforniaComponentPerson* self);
gboolean california_component_person_get_send_invite (CaliforniaComponentPerson* self);
void california_component_person_set_send_invite (CaliforniaComponentPerson* self, gboolean value);
static void california_component_person_finalize (GObject* obj);
static void _vala_california_component_person_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_component_person_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * The relationship of this {@link Person} to the {@link Instance}.
     */
GType california_component_person_relationship_get_type (void) {
	static volatile gsize california_component_person_relationship_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_person_relationship_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ORGANIZER, "CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ORGANIZER", "organizer"}, {CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ATTENDEE, "CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ATTENDEE", "attendee"}, {0, NULL, NULL}};
		GType california_component_person_relationship_type_id;
		california_component_person_relationship_type_id = g_enum_register_static ("CaliforniaComponentPersonRelationship", values);
		g_once_init_leave (&california_component_person_relationship_type_id__volatile, california_component_person_relationship_type_id);
	}
	return california_component_person_relationship_type_id__volatile;
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 179 "component-person.c"
}


static guint _california_string_ci_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = california_string_ci_hash ((const gchar*) v);
#line 98 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 188 "component-person.c"
}


static gboolean _california_string_ci_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = california_string_ci_equal ((const gchar*) a, (const gchar*) b);
#line 98 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 197 "component-person.c"
}


/**
     * Create a {@link Person} with the required {@link mailto} and optional {@link common_name}.
     */
CaliforniaComponentPerson* california_component_person_construct (GType object_type, CaliforniaComponentPersonRelationship relationship, SoupURI* mailto, const gchar* common_name, icalparameter_role role, gboolean rsvp, GError** error) {
	CaliforniaComponentPerson * self = NULL;
	SoupURI* _tmp0_ = NULL;
	CaliforniaComponentPersonRelationship _tmp1_ = 0;
	SoupURI* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	icalparameter_role _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	SoupURI* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	icalparameter_role _tmp17_ = 0;
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
#line 103 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (mailto != NULL, NULL);
#line 103 "/home/jim/git/california/src/component/component-person.vala"
	self = (CaliforniaComponentPerson*) california_base_object_construct (object_type);
#line 106 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = mailto;
#line 106 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_validate_mailto (_tmp0_, &_inner_error_);
#line 106 "/home/jim/git/california/src/component/component-person.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/jim/git/california/src/component/component-person.vala"
		if (_inner_error_->domain == CALIFORNIA_COMPONENT_ERROR) {
#line 106 "/home/jim/git/california/src/component/component-person.vala"
			g_propagate_error (error, _inner_error_);
#line 106 "/home/jim/git/california/src/component/component-person.vala"
			_g_object_unref0 (self);
#line 106 "/home/jim/git/california/src/component/component-person.vala"
			return NULL;
#line 239 "component-person.c"
		} else {
#line 106 "/home/jim/git/california/src/component/component-person.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jim/git/california/src/component/component-person.vala"
			g_clear_error (&_inner_error_);
#line 106 "/home/jim/git/california/src/component/component-person.vala"
			return NULL;
#line 247 "component-person.c"
		}
	}
#line 108 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = relationship;
#line 108 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_relationship (self, _tmp1_);
#line 109 "/home/jim/git/california/src/component/component-person.vala"
	_tmp2_ = mailto;
#line 109 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_mailto (self, _tmp2_);
#line 110 "/home/jim/git/california/src/component/component-person.vala"
	_tmp3_ = common_name;
#line 110 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_common_name (self, _tmp3_);
#line 111 "/home/jim/git/california/src/component/component-person.vala"
	_tmp4_ = role;
#line 111 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_role (self, _tmp4_);
#line 112 "/home/jim/git/california/src/component/component-person.vala"
	_tmp5_ = rsvp;
#line 112 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_rsvp (self, _tmp5_);
#line 113 "/home/jim/git/california/src/component/component-person.vala"
	_tmp6_ = mailto;
#line 113 "/home/jim/git/california/src/component/component-person.vala"
	_tmp7_ = common_name;
#line 113 "/home/jim/git/california/src/component/component-person.vala"
	_tmp8_ = california_component_person_make_full_address (_tmp6_, _tmp7_);
#line 113 "/home/jim/git/california/src/component/component-person.vala"
	_tmp9_ = _tmp8_;
#line 113 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_full_mailbox (self, _tmp9_);
#line 113 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (_tmp9_);
#line 116 "/home/jim/git/california/src/component/component-person.vala"
	_tmp10_ = common_name;
#line 116 "/home/jim/git/california/src/component/component-person.vala"
	_tmp11_ = california_string_is_empty (_tmp10_);
#line 116 "/home/jim/git/california/src/component/component-person.vala"
	if (!_tmp11_) {
#line 288 "component-person.c"
		GeeHashSet* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		icalparameter* _tmp14_ = NULL;
		icalparameter* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		_tmp12_ = self->priv->parameters;
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		_tmp13_ = common_name;
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		_tmp14_ = icalparameter_new_cn (_tmp13_);
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		_tmp15_ = _tmp14_;
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		_tmp16_ = icalparameter_as_ical_string (_tmp15_);
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 117 "/home/jim/git/california/src/component/component-person.vala"
		_icalparameter_free0 (_tmp15_);
#line 308 "component-person.c"
	}
#line 119 "/home/jim/git/california/src/component/component-person.vala"
	_tmp17_ = role;
#line 119 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp17_ != ICAL_ROLE_REQPARTICIPANT) {
#line 314 "component-person.c"
		GeeHashSet* _tmp18_ = NULL;
		icalparameter_role _tmp19_ = 0;
		icalparameter* _tmp20_ = NULL;
		icalparameter* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		_tmp18_ = self->priv->parameters;
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		_tmp19_ = role;
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		_tmp20_ = icalparameter_new_role (_tmp19_);
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		_tmp21_ = _tmp20_;
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		_tmp22_ = icalparameter_as_ical_string (_tmp21_);
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp22_);
#line 120 "/home/jim/git/california/src/component/component-person.vala"
		_icalparameter_free0 (_tmp21_);
#line 334 "component-person.c"
	}
#line 122 "/home/jim/git/california/src/component/component-person.vala"
	_tmp23_ = rsvp;
#line 122 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp23_) {
#line 340 "component-person.c"
		GeeHashSet* _tmp24_ = NULL;
		icalparameter* _tmp25_ = NULL;
		icalparameter* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
#line 123 "/home/jim/git/california/src/component/component-person.vala"
		_tmp24_ = self->priv->parameters;
#line 123 "/home/jim/git/california/src/component/component-person.vala"
		_tmp25_ = icalparameter_new_rsvp (ICAL_RSVP_TRUE);
#line 123 "/home/jim/git/california/src/component/component-person.vala"
		_tmp26_ = _tmp25_;
#line 123 "/home/jim/git/california/src/component/component-person.vala"
		_tmp27_ = icalparameter_as_ical_string (_tmp26_);
#line 123 "/home/jim/git/california/src/component/component-person.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp27_);
#line 123 "/home/jim/git/california/src/component/component-person.vala"
		_icalparameter_free0 (_tmp26_);
#line 357 "component-person.c"
	}
#line 103 "/home/jim/git/california/src/component/component-person.vala"
	return self;
#line 361 "component-person.c"
}


CaliforniaComponentPerson* california_component_person_new (CaliforniaComponentPersonRelationship relationship, SoupURI* mailto, const gchar* common_name, icalparameter_role role, gboolean rsvp, GError** error) {
#line 103 "/home/jim/git/california/src/component/component-person.vala"
	return california_component_person_construct (CALIFORNIA_COMPONENT_TYPE_PERSON, relationship, mailto, common_name, role, rsvp, error);
#line 368 "component-person.c"
}


static const char* _ical_icalproperty_kind_to_string (icalproperty_kind value) {
#line 137 "/home/jim/git/california/src/component/component-person.vala"
	switch (value) {
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ANY_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ANY_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ACTION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ACTION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ALLOWCONFLICT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ALLOWCONFLICT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ATTACH_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ATTACH_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ATTENDEE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ATTENDEE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CALID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CALID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CALMASTER_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CALMASTER_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CALSCALE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CALSCALE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CAPVERSION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CAPVERSION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CARLEVEL_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CARLEVEL_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CARID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CARID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CATEGORIES_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CATEGORIES_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CLASS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CLASS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CMD_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CMD_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_COMMENT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_COMMENT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_COMPLETED_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_COMPLETED_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_COMPONENTS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_COMPONENTS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CONTACT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CONTACT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CREATED_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CREATED_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CSID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CSID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DATEMAX_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DATEMAX_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DATEMIN_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DATEMIN_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DECREED_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DECREED_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DEFAULTCHARSET_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DEFAULTCHARSET_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DEFAULTLOCALE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DEFAULTLOCALE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DEFAULTTZID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DEFAULTTZID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DEFAULTVCARS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DEFAULTVCARS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DENY_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DENY_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DESCRIPTION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DESCRIPTION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DTEND_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DTEND_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DTSTAMP_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DTSTAMP_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DTSTART_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DTSTART_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DUE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DUE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DURATION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DURATION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_EXDATE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_EXDATE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_EXPAND_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_EXPAND_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_EXRULE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_EXRULE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_FREEBUSY_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_FREEBUSY_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_GEO_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_GEO_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_GRANT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_GRANT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ITIPVERSION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ITIPVERSION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_LASTMODIFIED_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_LASTMODIFIED_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_LOCATION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_LOCATION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_MAXCOMPONENTSIZE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_MAXCOMPONENTSIZE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_MAXDATE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_MAXDATE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_MAXRESULTS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_MAXRESULTS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_MAXRESULTSSIZE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_MAXRESULTSSIZE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_METHOD_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_METHOD_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_MINDATE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_MINDATE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_MULTIPART_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_MULTIPART_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_NAME_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_NAME_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ORGANIZER_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ORGANIZER_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_OWNER_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_OWNER_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_PERCENTCOMPLETE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_PERCENTCOMPLETE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_PERMISSION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_PERMISSION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_PRIORITY_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_PRIORITY_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_PRODID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_PRODID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_QUERY_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_QUERY_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_QUERYLEVEL_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_QUERYLEVEL_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_QUERYID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_QUERYID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_QUERYNAME_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_QUERYNAME_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RDATE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RDATE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RECURACCEPTED_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RECURACCEPTED_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RECUREXPAND_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RECUREXPAND_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RECURLIMIT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RECURLIMIT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RECURRENCEID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RECURRENCEID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RELATEDTO_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RELATEDTO_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RELCALID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RELCALID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_REPEAT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_REPEAT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_REQUESTSTATUS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_REQUESTSTATUS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RESOURCES_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RESOURCES_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RESTRICTION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RESTRICTION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RRULE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RRULE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_SCOPE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_SCOPE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_SEQUENCE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_SEQUENCE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_STATUS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_STATUS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_STORESEXPANDED_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_STORESEXPANDED_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_SUMMARY_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_SUMMARY_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TARGET_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TARGET_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TRANSP_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TRANSP_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TRIGGER_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TRIGGER_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TZID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TZID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TZNAME_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TZNAME_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TZOFFSETFROM_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TZOFFSETFROM_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TZOFFSETTO_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TZOFFSETTO_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TZURL_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TZURL_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_UID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_UID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_URL_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_URL_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_VERSION_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_VERSION_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_X_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_X_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICCLASS_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICCLASS_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICCLUSTERCOUNT_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICCLUSTERCOUNT_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICERROR_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICERROR_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICMIMECHARSET_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICMIMECHARSET_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICMIMECID_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICMIMECID_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICMIMECONTENTTYPE_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICMIMECONTENTTYPE_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICMIMEENCODING_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICMIMEENCODING_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICMIMEFILENAME_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICMIMEFILENAME_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICMIMEOPTINFO_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICMIMEOPTINFO_PROPERTY";
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_NO_PROPERTY:
#line 137 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_NO_PROPERTY";
#line 775 "component-person.c"
	}
#line 137 "/home/jim/git/california/src/component/component-person.vala"
	return NULL;
#line 779 "component-person.c"
}


static const char* _ical_icalvalue_kind_to_string (icalvalue_kind value) {
#line 148 "/home/jim/git/california/src/component/component-person.vala"
	switch (value) {
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ANY_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ANY_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_QUERY_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_QUERY_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DATE_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DATE_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ATTACH_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ATTACH_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_GEO_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_GEO_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_STATUS_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_STATUS_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TRANSP_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TRANSP_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_STRING_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_STRING_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TEXT_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TEXT_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_REQUESTSTATUS_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_REQUESTSTATUS_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CMD_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CMD_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_BINARY_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_BINARY_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_QUERYLEVEL_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_QUERYLEVEL_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_PERIOD_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_PERIOD_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_FLOAT_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_FLOAT_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DATETIMEPERIOD_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DATETIMEPERIOD_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CARLEVEL_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CARLEVEL_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_INTEGER_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_INTEGER_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CLASS_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CLASS_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_URI_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_URI_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DURATION_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DURATION_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_BOOLEAN_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_BOOLEAN_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_X_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_X_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_CALADDRESS_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_CALADDRESS_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_TRIGGER_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_TRIGGER_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_XLICCLASS_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_XLICCLASS_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_RECUR_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_RECUR_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ACTION_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_ACTION_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_DATETIME_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_DATETIME_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_UTCOFFSET_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_UTCOFFSET_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_METHOD_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_METHOD_VALUE";
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_NO_VALUE:
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return "ICAL_NO_VALUE";
#line 914 "component-person.c"
	}
#line 148 "/home/jim/git/california/src/component/component-person.vala"
	return NULL;
#line 918 "component-person.c"
}


CaliforniaComponentPerson* california_component_person_construct_from_property (GType object_type, icalproperty* prop, GError** error) {
	CaliforniaComponentPerson * self = NULL;
	icalproperty* _tmp0_ = NULL;
	icalproperty_kind _tmp1_ = 0;
	icalvalue* prop_value = NULL;
	icalproperty* _tmp6_ = NULL;
	icalvalue* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	icalvalue* _tmp9_ = NULL;
	icalvalue* _tmp16_ = NULL;
	icalvalue_kind _tmp17_ = 0;
	gchar* uri = NULL;
	icalvalue* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	SoupURI* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	SoupURI* _tmp33_ = NULL;
	SoupURI* _tmp34_ = NULL;
	icalparameter* param = NULL;
	icalproperty* _tmp35_ = NULL;
	icalparameter* _tmp36_ = NULL;
	SoupURI* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
#line 126 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (prop != NULL, NULL);
#line 126 "/home/jim/git/california/src/component/component-person.vala"
	self = (CaliforniaComponentPerson*) california_base_object_construct (object_type);
#line 127 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = prop;
#line 127 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = icalproperty_isa (_tmp0_);
#line 127 "/home/jim/git/california/src/component/component-person.vala"
	switch (_tmp1_) {
#line 127 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ATTENDEE_PROPERTY:
#line 963 "component-person.c"
		{
#line 129 "/home/jim/git/california/src/component/component-person.vala"
			california_component_person_set_relationship (self, CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ATTENDEE);
#line 130 "/home/jim/git/california/src/component/component-person.vala"
			break;
#line 969 "component-person.c"
		}
#line 127 "/home/jim/git/california/src/component/component-person.vala"
		case ICAL_ORGANIZER_PROPERTY:
#line 973 "component-person.c"
		{
#line 133 "/home/jim/git/california/src/component/component-person.vala"
			california_component_person_set_relationship (self, CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ORGANIZER);
#line 134 "/home/jim/git/california/src/component/component-person.vala"
			break;
#line 979 "component-person.c"
		}
		default:
		{
			icalproperty* _tmp2_ = NULL;
			icalproperty_kind _tmp3_ = 0;
			const gchar* _tmp4_ = NULL;
			GError* _tmp5_ = NULL;
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			_tmp2_ = prop;
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			_tmp3_ = icalproperty_isa (_tmp2_);
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			_tmp4_ = _ical_icalproperty_kind_to_string (_tmp3_);
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			_tmp5_ = g_error_new (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Property must be an ATTENDEE or ORGANIZER: %s", _tmp4_);
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			_inner_error_ = _tmp5_;
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			g_propagate_error (error, _inner_error_);
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			_g_object_unref0 (self);
#line 137 "/home/jim/git/california/src/component/component-person.vala"
			return NULL;
#line 1003 "component-person.c"
		}
	}
#line 141 "/home/jim/git/california/src/component/component-person.vala"
	_tmp6_ = prop;
#line 141 "/home/jim/git/california/src/component/component-person.vala"
	_tmp7_ = icalproperty_get_value (_tmp6_);
#line 141 "/home/jim/git/california/src/component/component-person.vala"
	prop_value = _tmp7_;
#line 142 "/home/jim/git/california/src/component/component-person.vala"
	_tmp9_ = prop_value;
#line 142 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp9_ == NULL) {
#line 142 "/home/jim/git/california/src/component/component-person.vala"
		_tmp8_ = TRUE;
#line 1018 "component-person.c"
	} else {
		icalvalue* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 142 "/home/jim/git/california/src/component/component-person.vala"
		_tmp10_ = prop_value;
#line 142 "/home/jim/git/california/src/component/component-person.vala"
		_tmp11_ = icalvalue_is_valid (_tmp10_);
#line 142 "/home/jim/git/california/src/component/component-person.vala"
		_tmp8_ = _tmp11_ == 0;
#line 1028 "component-person.c"
	}
#line 142 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp8_) {
#line 1032 "component-person.c"
		icalproperty* _tmp12_ = NULL;
		icalproperty_kind _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		_tmp12_ = prop;
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		_tmp13_ = icalproperty_isa (_tmp12_);
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		_tmp14_ = _ical_icalproperty_kind_to_string (_tmp13_);
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		_tmp15_ = g_error_new (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Property of kind %s has no associated value", _tmp14_);
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		_inner_error_ = _tmp15_;
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		g_propagate_error (error, _inner_error_);
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		_g_object_unref0 (self);
#line 143 "/home/jim/git/california/src/component/component-person.vala"
		return NULL;
#line 1053 "component-person.c"
	}
#line 147 "/home/jim/git/california/src/component/component-person.vala"
	_tmp16_ = prop_value;
#line 147 "/home/jim/git/california/src/component/component-person.vala"
	_tmp17_ = icalvalue_isa (_tmp16_);
#line 147 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp17_ != ICAL_CALADDRESS_VALUE) {
#line 1061 "component-person.c"
		icalproperty* _tmp18_ = NULL;
		icalproperty_kind _tmp19_ = 0;
		const gchar* _tmp20_ = NULL;
		icalvalue* _tmp21_ = NULL;
		icalvalue_kind _tmp22_ = 0;
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp18_ = prop;
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp19_ = icalproperty_isa (_tmp18_);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp20_ = _ical_icalproperty_kind_to_string (_tmp19_);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp21_ = prop_value;
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp22_ = icalvalue_isa (_tmp21_);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp23_ = _ical_icalvalue_kind_to_string (_tmp22_);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_tmp24_ = g_error_new (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Property of kind %s has value of kind %s", _tmp20_, _tmp23_);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_inner_error_ = _tmp24_;
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		g_propagate_error (error, _inner_error_);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		_g_object_unref0 (self);
#line 148 "/home/jim/git/california/src/component/component-person.vala"
		return NULL;
#line 1091 "component-person.c"
	}
#line 152 "/home/jim/git/california/src/component/component-person.vala"
	_tmp25_ = prop_value;
#line 152 "/home/jim/git/california/src/component/component-person.vala"
	_tmp26_ = icalvalue_get_caladdress (_tmp25_);
#line 152 "/home/jim/git/california/src/component/component-person.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 152 "/home/jim/git/california/src/component/component-person.vala"
	uri = _tmp27_;
#line 153 "/home/jim/git/california/src/component/component-person.vala"
	_tmp28_ = uri;
#line 153 "/home/jim/git/california/src/component/component-person.vala"
	_tmp29_ = california_string_is_empty (_tmp28_);
#line 153 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp29_) {
#line 1107 "component-person.c"
		GError* _tmp30_ = NULL;
#line 154 "/home/jim/git/california/src/component/component-person.vala"
		_tmp30_ = g_error_new_literal (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Invalid Person property: no CAL-ADDRESS value");
#line 154 "/home/jim/git/california/src/component/component-person.vala"
		_inner_error_ = _tmp30_;
#line 154 "/home/jim/git/california/src/component/component-person.vala"
		g_propagate_error (error, _inner_error_);
#line 154 "/home/jim/git/california/src/component/component-person.vala"
		_g_free0 (uri);
#line 154 "/home/jim/git/california/src/component/component-person.vala"
		_g_object_unref0 (self);
#line 154 "/home/jim/git/california/src/component/component-person.vala"
		return NULL;
#line 1121 "component-person.c"
	}
#line 156 "/home/jim/git/california/src/component/component-person.vala"
	_tmp32_ = uri;
#line 156 "/home/jim/git/california/src/component/component-person.vala"
	_tmp33_ = california_uri_parse (_tmp32_, &_inner_error_);
#line 156 "/home/jim/git/california/src/component/component-person.vala"
	_tmp31_ = _tmp33_;
#line 156 "/home/jim/git/california/src/component/component-person.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 156 "/home/jim/git/california/src/component/component-person.vala"
		g_propagate_error (error, _inner_error_);
#line 156 "/home/jim/git/california/src/component/component-person.vala"
		_g_free0 (uri);
#line 156 "/home/jim/git/california/src/component/component-person.vala"
		_g_object_unref0 (self);
#line 156 "/home/jim/git/california/src/component/component-person.vala"
		return NULL;
#line 1139 "component-person.c"
	}
#line 156 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_mailto (self, _tmp31_);
#line 157 "/home/jim/git/california/src/component/component-person.vala"
	_tmp34_ = self->priv->_mailto;
#line 157 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_validate_mailto (_tmp34_, &_inner_error_);
#line 157 "/home/jim/git/california/src/component/component-person.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/jim/git/california/src/component/component-person.vala"
		g_propagate_error (error, _inner_error_);
#line 157 "/home/jim/git/california/src/component/component-person.vala"
		__vala_SoupURI_free0 (_tmp31_);
#line 157 "/home/jim/git/california/src/component/component-person.vala"
		_g_free0 (uri);
#line 157 "/home/jim/git/california/src/component/component-person.vala"
		_g_object_unref0 (self);
#line 157 "/home/jim/git/california/src/component/component-person.vala"
		return NULL;
#line 1159 "component-person.c"
	}
#line 160 "/home/jim/git/california/src/component/component-person.vala"
	_tmp35_ = prop;
#line 160 "/home/jim/git/california/src/component/component-person.vala"
	_tmp36_ = icalproperty_get_first_parameter (_tmp35_, ICAL_ANY_PARAMETER);
#line 160 "/home/jim/git/california/src/component/component-person.vala"
	param = _tmp36_;
#line 161 "/home/jim/git/california/src/component/component-person.vala"
	while (TRUE) {
#line 1169 "component-person.c"
		icalparameter* _tmp37_ = NULL;
		GeeHashSet* _tmp38_ = NULL;
		icalparameter* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		icalparameter* _tmp41_ = NULL;
		icalparameter_kind _tmp42_ = 0;
		icalproperty* _tmp49_ = NULL;
		icalparameter* _tmp50_ = NULL;
#line 161 "/home/jim/git/california/src/component/component-person.vala"
		_tmp37_ = param;
#line 161 "/home/jim/git/california/src/component/component-person.vala"
		if (!(_tmp37_ != NULL)) {
#line 161 "/home/jim/git/california/src/component/component-person.vala"
			break;
#line 1184 "component-person.c"
		}
#line 162 "/home/jim/git/california/src/component/component-person.vala"
		_tmp38_ = self->priv->parameters;
#line 162 "/home/jim/git/california/src/component/component-person.vala"
		_tmp39_ = param;
#line 162 "/home/jim/git/california/src/component/component-person.vala"
		_tmp40_ = icalparameter_as_ical_string (_tmp39_);
#line 162 "/home/jim/git/california/src/component/component-person.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp40_);
#line 165 "/home/jim/git/california/src/component/component-person.vala"
		_tmp41_ = param;
#line 165 "/home/jim/git/california/src/component/component-person.vala"
		_tmp42_ = icalparameter_isa (_tmp41_);
#line 165 "/home/jim/git/california/src/component/component-person.vala"
		switch (_tmp42_) {
#line 165 "/home/jim/git/california/src/component/component-person.vala"
			case ICAL_CN_PARAMETER:
#line 1202 "component-person.c"
			{
				icalparameter* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
#line 167 "/home/jim/git/california/src/component/component-person.vala"
				_tmp43_ = param;
#line 167 "/home/jim/git/california/src/component/component-person.vala"
				_tmp44_ = icalparameter_get_cn (_tmp43_);
#line 167 "/home/jim/git/california/src/component/component-person.vala"
				california_component_person_set_common_name (self, _tmp44_);
#line 168 "/home/jim/git/california/src/component/component-person.vala"
				break;
#line 1214 "component-person.c"
			}
#line 165 "/home/jim/git/california/src/component/component-person.vala"
			case ICAL_ROLE_PARAMETER:
#line 1218 "component-person.c"
			{
				icalparameter* _tmp45_ = NULL;
				icalparameter_role _tmp46_ = 0;
#line 171 "/home/jim/git/california/src/component/component-person.vala"
				_tmp45_ = param;
#line 171 "/home/jim/git/california/src/component/component-person.vala"
				_tmp46_ = icalparameter_get_role (_tmp45_);
#line 171 "/home/jim/git/california/src/component/component-person.vala"
				california_component_person_set_role (self, _tmp46_);
#line 172 "/home/jim/git/california/src/component/component-person.vala"
				break;
#line 1230 "component-person.c"
			}
#line 165 "/home/jim/git/california/src/component/component-person.vala"
			case ICAL_RSVP_PARAMETER:
#line 1234 "component-person.c"
			{
				icalparameter* _tmp47_ = NULL;
				icalparameter_rsvp _tmp48_ = 0;
#line 175 "/home/jim/git/california/src/component/component-person.vala"
				_tmp47_ = param;
#line 175 "/home/jim/git/california/src/component/component-person.vala"
				_tmp48_ = icalparameter_get_rsvp (_tmp47_);
#line 175 "/home/jim/git/california/src/component/component-person.vala"
				california_component_person_set_rsvp (self, _tmp48_ == ICAL_RSVP_TRUE);
#line 176 "/home/jim/git/california/src/component/component-person.vala"
				break;
#line 1246 "component-person.c"
			}
			default:
			{
#line 180 "/home/jim/git/california/src/component/component-person.vala"
				break;
#line 1252 "component-person.c"
			}
		}
#line 183 "/home/jim/git/california/src/component/component-person.vala"
		_tmp49_ = prop;
#line 183 "/home/jim/git/california/src/component/component-person.vala"
		_tmp50_ = icalproperty_get_next_parameter (_tmp49_, ICAL_ANY_PARAMETER);
#line 183 "/home/jim/git/california/src/component/component-person.vala"
		param = _tmp50_;
#line 1261 "component-person.c"
	}
#line 186 "/home/jim/git/california/src/component/component-person.vala"
	_tmp51_ = self->priv->_mailto;
#line 186 "/home/jim/git/california/src/component/component-person.vala"
	_tmp52_ = self->priv->_common_name;
#line 186 "/home/jim/git/california/src/component/component-person.vala"
	_tmp53_ = california_component_person_make_full_address (_tmp51_, _tmp52_);
#line 186 "/home/jim/git/california/src/component/component-person.vala"
	_tmp54_ = _tmp53_;
#line 186 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_set_full_mailbox (self, _tmp54_);
#line 186 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (_tmp54_);
#line 126 "/home/jim/git/california/src/component/component-person.vala"
	__vala_SoupURI_free0 (_tmp31_);
#line 126 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (uri);
#line 126 "/home/jim/git/california/src/component/component-person.vala"
	return self;
#line 1281 "component-person.c"
}


CaliforniaComponentPerson* california_component_person_new_from_property (icalproperty* prop, GError** error) {
#line 126 "/home/jim/git/california/src/component/component-person.vala"
	return california_component_person_construct_from_property (CALIFORNIA_COMPONENT_TYPE_PERSON, prop, error);
#line 1288 "component-person.c"
}


static void california_component_person_validate_mailto (SoupURI* uri, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	SoupURI* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 189 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (uri != NULL);
#line 190 "/home/jim/git/california/src/component/component-person.vala"
	_tmp2_ = uri;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
	_tmp3_ = _tmp2_->scheme;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
	_tmp4_ = california_string_ci_equal (_tmp3_, "mailto");
#line 190 "/home/jim/git/california/src/component/component-person.vala"
	if (!_tmp4_) {
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp1_ = TRUE;
#line 1311 "component-person.c"
	} else {
		SoupURI* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp5_ = uri;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp6_ = _tmp5_->path;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp7_ = california_string_is_empty (_tmp6_);
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp1_ = _tmp7_;
#line 1324 "component-person.c"
	}
#line 190 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp1_) {
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp0_ = TRUE;
#line 1330 "component-person.c"
	} else {
		SoupURI* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp8_ = uri;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp9_ = _tmp8_->path;
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp10_ = california_email_is_valid_mailbox (_tmp9_);
#line 190 "/home/jim/git/california/src/component/component-person.vala"
		_tmp0_ = !_tmp10_;
#line 1343 "component-person.c"
	}
#line 190 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp0_) {
#line 1347 "component-person.c"
		SoupURI* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_tmp11_ = uri;
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_tmp12_ = soup_uri_to_string (_tmp11_, FALSE);
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_tmp13_ = _tmp12_;
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_tmp14_ = g_error_new (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Invalid mailto: %s", _tmp13_);
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_tmp15_ = _tmp14_;
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_g_free0 (_tmp13_);
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		_inner_error_ = _tmp15_;
#line 191 "/home/jim/git/california/src/component/component-person.vala"
		if (_inner_error_->domain == CALIFORNIA_COMPONENT_ERROR) {
#line 191 "/home/jim/git/california/src/component/component-person.vala"
			g_propagate_error (error, _inner_error_);
#line 191 "/home/jim/git/california/src/component/component-person.vala"
			return;
#line 1373 "component-person.c"
		} else {
#line 191 "/home/jim/git/california/src/component/component-person.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 191 "/home/jim/git/california/src/component/component-person.vala"
			g_clear_error (&_inner_error_);
#line 191 "/home/jim/git/california/src/component/component-person.vala"
			return;
#line 1381 "component-person.c"
		}
	}
}


static gchar* california_component_person_make_full_address (SoupURI* mailto, const gchar* common_name) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp10_ = NULL;
	SoupURI* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
#line 194 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (mailto != NULL, NULL);
#line 196 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = common_name;
#line 196 "/home/jim/git/california/src/component/component-person.vala"
	_tmp2_ = california_string_is_empty (_tmp1_);
#line 196 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp2_) {
#line 196 "/home/jim/git/california/src/component/component-person.vala"
		_tmp0_ = TRUE;
#line 1406 "component-person.c"
	} else {
		SoupURI* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 196 "/home/jim/git/california/src/component/component-person.vala"
		_tmp3_ = mailto;
#line 196 "/home/jim/git/california/src/component/component-person.vala"
		_tmp4_ = _tmp3_->path;
#line 196 "/home/jim/git/california/src/component/component-person.vala"
		_tmp5_ = common_name;
#line 196 "/home/jim/git/california/src/component/component-person.vala"
		_tmp6_ = california_string_ascii_ci_equal (_tmp4_, _tmp5_);
#line 196 "/home/jim/git/california/src/component/component-person.vala"
		_tmp0_ = _tmp6_;
#line 1422 "component-person.c"
	}
#line 196 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp0_) {
#line 1426 "component-person.c"
		SoupURI* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 197 "/home/jim/git/california/src/component/component-person.vala"
		_tmp7_ = mailto;
#line 197 "/home/jim/git/california/src/component/component-person.vala"
		_tmp8_ = _tmp7_->path;
#line 197 "/home/jim/git/california/src/component/component-person.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 197 "/home/jim/git/california/src/component/component-person.vala"
		result = _tmp9_;
#line 197 "/home/jim/git/california/src/component/component-person.vala"
		return result;
#line 1440 "component-person.c"
	}
#line 199 "/home/jim/git/california/src/component/component-person.vala"
	_tmp10_ = common_name;
#line 199 "/home/jim/git/california/src/component/component-person.vala"
	_tmp11_ = mailto;
#line 199 "/home/jim/git/california/src/component/component-person.vala"
	_tmp12_ = _tmp11_->path;
#line 199 "/home/jim/git/california/src/component/component-person.vala"
	_tmp13_ = g_strdup_printf ("%s <%s>", _tmp10_, _tmp12_);
#line 199 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp13_;
#line 199 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1454 "component-person.c"
}


icalproperty* california_component_person_as_ical_property (CaliforniaComponentPerson* self) {
	icalproperty* result = NULL;
	icalproperty* prop = NULL;
	CaliforniaComponentPersonRelationship _tmp0_ = 0;
#line 202 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), NULL);
#line 204 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_relationship;
#line 204 "/home/jim/git/california/src/component/component-person.vala"
	switch (_tmp0_) {
#line 204 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ATTENDEE:
#line 1470 "component-person.c"
		{
			gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			icalproperty* _tmp4_ = NULL;
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			_tmp1_ = california_component_person_get_mailto_text (self);
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			_tmp2_ = _tmp1_;
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			_tmp3_ = _tmp2_;
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			_tmp4_ = icalproperty_new_attendee (_tmp3_);
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			_icalproperty_free0 (prop);
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			prop = _tmp4_;
#line 206 "/home/jim/git/california/src/component/component-person.vala"
			_g_free0 (_tmp3_);
#line 207 "/home/jim/git/california/src/component/component-person.vala"
			break;
#line 1492 "component-person.c"
		}
#line 204 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP_ORGANIZER:
#line 1496 "component-person.c"
		{
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			icalproperty* _tmp8_ = NULL;
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			_tmp5_ = california_component_person_get_mailto_text (self);
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			_tmp6_ = _tmp5_;
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			_tmp7_ = _tmp6_;
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			_tmp8_ = icalproperty_new_organizer (_tmp7_);
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			_icalproperty_free0 (prop);
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			prop = _tmp8_;
#line 210 "/home/jim/git/california/src/component/component-person.vala"
			_g_free0 (_tmp7_);
#line 211 "/home/jim/git/california/src/component/component-person.vala"
			break;
#line 1518 "component-person.c"
		}
		default:
		{
#line 214 "/home/jim/git/california/src/component/component-person.vala"
			g_assert_not_reached ();
#line 1524 "component-person.c"
		}
	}
	{
		GeeIterator* _parameter_it = NULL;
		GeeHashSet* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
#line 217 "/home/jim/git/california/src/component/component-person.vala"
		_tmp9_ = self->priv->parameters;
#line 217 "/home/jim/git/california/src/component/component-person.vala"
		_tmp10_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 217 "/home/jim/git/california/src/component/component-person.vala"
		_parameter_it = _tmp10_;
#line 217 "/home/jim/git/california/src/component/component-person.vala"
		while (TRUE) {
#line 1539 "component-person.c"
			GeeIterator* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gchar* parameter = NULL;
			GeeIterator* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			icalparameter* param = NULL;
			const gchar* _tmp15_ = NULL;
			icalparameter* _tmp16_ = NULL;
			icalproperty* _tmp17_ = NULL;
			icalparameter* _tmp18_ = NULL;
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			_tmp11_ = _parameter_it;
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			if (!_tmp12_) {
#line 217 "/home/jim/git/california/src/component/component-person.vala"
				break;
#line 1558 "component-person.c"
			}
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			_tmp13_ = _parameter_it;
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			parameter = (gchar*) _tmp14_;
#line 218 "/home/jim/git/california/src/component/component-person.vala"
			_tmp15_ = parameter;
#line 218 "/home/jim/git/california/src/component/component-person.vala"
			_tmp16_ = icalparameter_new_from_string (_tmp15_);
#line 218 "/home/jim/git/california/src/component/component-person.vala"
			param = _tmp16_;
#line 219 "/home/jim/git/california/src/component/component-person.vala"
			_tmp17_ = prop;
#line 219 "/home/jim/git/california/src/component/component-person.vala"
			_tmp18_ = param;
#line 219 "/home/jim/git/california/src/component/component-person.vala"
			param = NULL;
#line 219 "/home/jim/git/california/src/component/component-person.vala"
			icalproperty_add_parameter (_tmp17_, _tmp18_);
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			_icalparameter_free0 (param);
#line 217 "/home/jim/git/california/src/component/component-person.vala"
			_g_free0 (parameter);
#line 1584 "component-person.c"
		}
#line 217 "/home/jim/git/california/src/component/component-person.vala"
		_g_object_unref0 (_parameter_it);
#line 1588 "component-person.c"
	}
#line 222 "/home/jim/git/california/src/component/component-person.vala"
	result = prop;
#line 222 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1594 "component-person.c"
}


static guint california_component_person_real_hash (GeeHashable* base) {
	CaliforniaComponentPerson * self;
	guint result = 0U;
	SoupURI* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	CaliforniaComponentPersonRelationship _tmp3_ = 0;
#line 225 "/home/jim/git/california/src/component/component-person.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 226 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_mailto;
#line 226 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = _tmp0_->path;
#line 226 "/home/jim/git/california/src/component/component-person.vala"
	_tmp2_ = california_string_ci_hash (_tmp1_);
#line 226 "/home/jim/git/california/src/component/component-person.vala"
	_tmp3_ = self->priv->_relationship;
#line 226 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp2_ ^ _tmp3_;
#line 226 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1619 "component-person.c"
}


static gboolean california_component_person_real_equal_to (GeeHashable* base, CaliforniaComponentPerson* other) {
	CaliforniaComponentPerson * self;
	gboolean result = FALSE;
	CaliforniaComponentPerson* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CaliforniaComponentPersonRelationship _tmp2_ = 0;
	CaliforniaComponentPerson* _tmp3_ = NULL;
	CaliforniaComponentPersonRelationship _tmp4_ = 0;
#line 229 "/home/jim/git/california/src/component/component-person.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 229 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (other), FALSE);
#line 230 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = other;
#line 230 "/home/jim/git/california/src/component/component-person.vala"
	if (self == _tmp0_) {
#line 231 "/home/jim/git/california/src/component/component-person.vala"
		result = TRUE;
#line 231 "/home/jim/git/california/src/component/component-person.vala"
		return result;
#line 1643 "component-person.c"
	}
#line 233 "/home/jim/git/california/src/component/component-person.vala"
	_tmp2_ = self->priv->_relationship;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
	_tmp3_ = other;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
	_tmp4_ = _tmp3_->priv->_relationship;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp2_ == _tmp4_) {
#line 1653 "component-person.c"
		SoupURI* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		CaliforniaComponentPerson* _tmp7_ = NULL;
		SoupURI* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp5_ = self->priv->_mailto;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp6_ = _tmp5_->path;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp7_ = other;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp8_ = _tmp7_->priv->_mailto;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp9_ = _tmp8_->path;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp10_ = california_string_ci_equal (_tmp6_, _tmp9_);
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp1_ = _tmp10_;
#line 1674 "component-person.c"
	} else {
#line 233 "/home/jim/git/california/src/component/component-person.vala"
		_tmp1_ = FALSE;
#line 1678 "component-person.c"
	}
#line 233 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp1_;
#line 233 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1684 "component-person.c"
}


static gint california_component_person_real_compare_to (GeeComparable* base, CaliforniaComponentPerson* other) {
	CaliforniaComponentPerson * self;
	gint result = 0;
	CaliforniaComponentPerson* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint compare = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	CaliforniaComponentPerson* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	CaliforniaComponentPersonRelationship _tmp19_ = 0;
	CaliforniaComponentPerson* _tmp20_ = NULL;
	CaliforniaComponentPersonRelationship _tmp21_ = 0;
#line 236 "/home/jim/git/california/src/component/component-person.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 236 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (other), 0);
#line 237 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = other;
#line 237 "/home/jim/git/california/src/component/component-person.vala"
	if (self == _tmp0_) {
#line 238 "/home/jim/git/california/src/component/component-person.vala"
		result = 0;
#line 238 "/home/jim/git/california/src/component/component-person.vala"
		return result;
#line 1718 "component-person.c"
	}
#line 241 "/home/jim/git/california/src/component/component-person.vala"
	_tmp2_ = self->priv->_common_name;
#line 241 "/home/jim/git/california/src/component/component-person.vala"
	_tmp3_ = california_string_is_empty (_tmp2_);
#line 241 "/home/jim/git/california/src/component/component-person.vala"
	if (!_tmp3_) {
#line 1726 "component-person.c"
		CaliforniaComponentPerson* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 241 "/home/jim/git/california/src/component/component-person.vala"
		_tmp4_ = other;
#line 241 "/home/jim/git/california/src/component/component-person.vala"
		_tmp5_ = _tmp4_->priv->_common_name;
#line 241 "/home/jim/git/california/src/component/component-person.vala"
		_tmp6_ = california_string_is_empty (_tmp5_);
#line 241 "/home/jim/git/california/src/component/component-person.vala"
		_tmp1_ = !_tmp6_;
#line 1738 "component-person.c"
	} else {
#line 241 "/home/jim/git/california/src/component/component-person.vala"
		_tmp1_ = FALSE;
#line 1742 "component-person.c"
	}
#line 241 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp1_) {
#line 1746 "component-person.c"
		gint compare = 0;
		const gchar* _tmp7_ = NULL;
		CaliforniaComponentPerson* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 242 "/home/jim/git/california/src/component/component-person.vala"
		_tmp7_ = self->priv->_common_name;
#line 242 "/home/jim/git/california/src/component/component-person.vala"
		_tmp8_ = other;
#line 242 "/home/jim/git/california/src/component/component-person.vala"
		_tmp9_ = _tmp8_->priv->_common_name;
#line 242 "/home/jim/git/california/src/component/component-person.vala"
		_tmp10_ = california_string_stricmp (_tmp7_, _tmp9_);
#line 242 "/home/jim/git/california/src/component/component-person.vala"
		compare = _tmp10_;
#line 243 "/home/jim/git/california/src/component/component-person.vala"
		_tmp11_ = compare;
#line 243 "/home/jim/git/california/src/component/component-person.vala"
		if (_tmp11_ != 0) {
#line 244 "/home/jim/git/california/src/component/component-person.vala"
			result = compare;
#line 244 "/home/jim/git/california/src/component/component-person.vala"
			return result;
#line 1771 "component-person.c"
		}
	}
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	_tmp12_ = california_component_person_get_mailbox (self);
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	_tmp13_ = _tmp12_;
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	_tmp14_ = other;
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	_tmp15_ = california_component_person_get_mailbox (_tmp14_);
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	_tmp16_ = _tmp15_;
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	_tmp17_ = california_string_stricmp (_tmp13_, _tmp16_);
#line 247 "/home/jim/git/california/src/component/component-person.vala"
	compare = _tmp17_;
#line 248 "/home/jim/git/california/src/component/component-person.vala"
	_tmp18_ = compare;
#line 248 "/home/jim/git/california/src/component/component-person.vala"
	if (_tmp18_ != 0) {
#line 249 "/home/jim/git/california/src/component/component-person.vala"
		result = compare;
#line 249 "/home/jim/git/california/src/component/component-person.vala"
		return result;
#line 1796 "component-person.c"
	}
#line 251 "/home/jim/git/california/src/component/component-person.vala"
	_tmp19_ = self->priv->_relationship;
#line 251 "/home/jim/git/california/src/component/component-person.vala"
	_tmp20_ = other;
#line 251 "/home/jim/git/california/src/component/component-person.vala"
	_tmp21_ = _tmp20_->priv->_relationship;
#line 251 "/home/jim/git/california/src/component/component-person.vala"
	result = (gint) (_tmp19_ - _tmp21_);
#line 251 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1808 "component-person.c"
}


static gchar* california_component_person_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaComponentPerson * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 254 "/home/jim/git/california/src/component/component-person.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 255 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = california_component_person_get_mailto_text (self);
#line 255 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = _tmp0_;
#line 255 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp1_;
#line 255 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1827 "component-person.c"
}


CaliforniaComponentPersonRelationship california_component_person_get_relationship (CaliforniaComponentPerson* self) {
	CaliforniaComponentPersonRelationship result;
	CaliforniaComponentPersonRelationship _tmp0_ = 0;
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), 0);
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_relationship;
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1842 "component-person.c"
}


static void california_component_person_set_relationship (CaliforniaComponentPerson* self, CaliforniaComponentPersonRelationship value) {
	CaliforniaComponentPersonRelationship _tmp0_ = 0;
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_relationship = _tmp0_;
#line 42 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "relationship");
#line 1856 "component-person.c"
}


SoupURI* california_component_person_get_mailto (CaliforniaComponentPerson* self) {
	SoupURI* result;
	SoupURI* _tmp0_ = NULL;
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), NULL);
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_mailto;
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1871 "component-person.c"
}


static SoupURI* _vala_SoupURI_copy (SoupURI* self) {
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	return g_boxed_copy (soup_uri_get_type (), self);
#line 1878 "component-person.c"
}


static gpointer __vala_SoupURI_copy0 (gpointer self) {
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	return self ? _vala_SoupURI_copy (self) : NULL;
#line 1885 "component-person.c"
}


static void california_component_person_set_mailto (CaliforniaComponentPerson* self, SoupURI* value) {
	SoupURI* _tmp0_ = NULL;
	SoupURI* _tmp1_ = NULL;
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = __vala_SoupURI_copy0 (_tmp0_);
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	__vala_SoupURI_free0 (self->priv->_mailto);
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_mailto = _tmp1_;
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "mailto");
#line 1904 "component-person.c"
}


const gchar* california_component_person_get_common_name (CaliforniaComponentPerson* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), NULL);
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_common_name;
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1919 "component-person.c"
}


static void california_component_person_set_common_name (CaliforniaComponentPerson* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (self->priv->_common_name);
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_common_name = _tmp1_;
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "common-name");
#line 1938 "component-person.c"
}


icalparameter_role california_component_person_get_role (CaliforniaComponentPerson* self) {
	icalparameter_role result;
	icalparameter_role _tmp0_ = 0;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), 0);
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_role;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1953 "component-person.c"
}


static void california_component_person_set_role (CaliforniaComponentPerson* self, icalparameter_role value) {
	icalparameter_role _tmp0_ = 0;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_role = _tmp0_;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "role");
#line 1967 "component-person.c"
}


gboolean california_component_person_get_rsvp (CaliforniaComponentPerson* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), FALSE);
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_rsvp;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 1982 "component-person.c"
}


static void california_component_person_set_rsvp (CaliforniaComponentPerson* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_rsvp = _tmp0_;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "rsvp");
#line 1996 "component-person.c"
}


gchar* california_component_person_get_mailto_text (CaliforniaComponentPerson* self) {
	gchar* result;
	SoupURI* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 72 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), NULL);
#line 72 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_mailto;
#line 72 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = soup_uri_to_string (_tmp0_, FALSE);
#line 72 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp1_;
#line 72 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 2014 "component-person.c"
}


const gchar* california_component_person_get_mailbox (CaliforniaComponentPerson* self) {
	const gchar* result;
	SoupURI* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 80 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), NULL);
#line 80 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_mailto;
#line 80 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = _tmp0_->path;
#line 80 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp1_;
#line 80 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 2032 "component-person.c"
}


const gchar* california_component_person_get_full_mailbox (CaliforniaComponentPerson* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), NULL);
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_full_mailbox;
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 2047 "component-person.c"
}


static void california_component_person_set_full_mailbox (CaliforniaComponentPerson* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (self->priv->_full_mailbox);
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_full_mailbox = _tmp1_;
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "full-mailbox");
#line 2066 "component-person.c"
}


gboolean california_component_person_get_send_invite (CaliforniaComponentPerson* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self), FALSE);
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = self->priv->_send_invite;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	result = _tmp0_;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	return result;
#line 2081 "component-person.c"
}


void california_component_person_set_send_invite (CaliforniaComponentPerson* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_PERSON (self));
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = value;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_send_invite = _tmp0_;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	g_object_notify ((GObject *) self, "send-invite");
#line 2095 "component-person.c"
}


static void california_component_person_class_init (CaliforniaComponentPersonClass * klass) {
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaComponentPersonPrivate));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_component_person_real_to_string;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_component_person_get_property;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_component_person_set_property;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	G_OBJECT_CLASS (klass)->finalize = california_component_person_finalize;
#line 2112 "component-person.c"
	/**
	     * The {@link Person}'s {@link Relationship} to the {@link Instance}.
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP, g_param_spec_enum ("relationship", "relationship", "relationship", CALIFORNIA_COMPONENT_PERSON_TYPE_RELATIONSHIP, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2118 "component-person.c"
	/**
	     * The mailto: of the {@link Person}, the only required value for the property.
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_MAILTO, g_param_spec_boxed ("mailto", "mailto", "mailto", soup_uri_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2124 "component-person.c"
	/**
	     * The CN (common name) for the {@link Person}.
	     *
	     * Note that it's common for agents to use the {@link mailbox} for the common name if a name
	     * is not given when producing the component.
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_COMMON_NAME, g_param_spec_string ("common-name", "common-name", "common-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2133 "component-person.c"
	/**
	     * The participation ROLE for the {@link Person}.
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_ROLE, g_param_spec_int ("role", "role", "role", G_MININT, G_MAXINT, ICAL_ROLE_REQPARTICIPANT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2139 "component-person.c"
	/**
	     * RSVP required for the {@link Person}.
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_RSVP, g_param_spec_boolean ("rsvp", "rsvp", "rsvp", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2145 "component-person.c"
	/**
	     * The {@link mailto} URI as a text string.
	     *
	     * @see mailbox
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_MAILTO_TEXT, g_param_spec_string ("mailto-text", "mailto-text", "mailto-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2153 "component-person.c"
	/**
	     * The {@link mailto} as a simple (unadorned) RFC822 mailbox (i.e. email address).
	     *
	     * This does not include the "mailto:" scheme nor the {@link common_name}, i.e.
	     * "bob@example.com"
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_MAILBOX, g_param_spec_string ("mailbox", "mailbox", "mailbox", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2162 "component-person.c"
	/**
	     * The {@link mailto} as a complete (adorned) RFC822 mailbox (i.e. email address) with
	     * user-readable name, if supplied.
	     *
	     * This does not include the "mailto:" scheme but it will include the {@link common_name} if
	     * present, i.e. "Bob Jones <bob@example.com>".
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_FULL_MAILBOX, g_param_spec_string ("full-mailbox", "full-mailbox", "full-mailbox", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2172 "component-person.c"
	/**
	     * A mutable property indicating an invitation should be sent to the {@link Person}.
	     *
	     * In general, invites are not sent to organizers.
	     */
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_PERSON_SEND_INVITE, g_param_spec_boolean ("send-invite", "send-invite", "send-invite", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2180 "component-person.c"
}


static void california_component_person_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_component_person_real_hash;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_component_person_real_equal_to;
#line 2191 "component-person.c"
}


static void california_component_person_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	california_component_person_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_component_person_real_compare_to;
#line 2200 "component-person.c"
}


static void california_component_person_instance_init (CaliforniaComponentPerson * self) {
	GeeHashSet* _tmp0_ = NULL;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	self->priv = CALIFORNIA_COMPONENT_PERSON_GET_PRIVATE (self);
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_common_name = NULL;
#line 60 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_role = ICAL_ROLE_REQPARTICIPANT;
#line 65 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_rsvp = FALSE;
#line 96 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->_send_invite = TRUE;
#line 98 "/home/jim/git/california/src/component/component-person.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _california_string_ci_hash_gee_hash_data_func, NULL, NULL, _california_string_ci_equal_gee_equal_data_func, NULL, NULL);
#line 98 "/home/jim/git/california/src/component/component-person.vala"
	self->priv->parameters = _tmp0_;
#line 2220 "component-person.c"
}


static void california_component_person_finalize (GObject* obj) {
	CaliforniaComponentPerson * self;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 47 "/home/jim/git/california/src/component/component-person.vala"
	__vala_SoupURI_free0 (self->priv->_mailto);
#line 55 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (self->priv->_common_name);
#line 89 "/home/jim/git/california/src/component/component-person.vala"
	_g_free0 (self->priv->_full_mailbox);
#line 98 "/home/jim/git/california/src/component/component-person.vala"
	_g_object_unref0 (self->priv->parameters);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	G_OBJECT_CLASS (california_component_person_parent_class)->finalize (obj);
#line 2238 "component-person.c"
}


/**
 * A (mostly) immutable representation of an iCalendar CAL-ADDRESS (ATTENDEE, ORGANIZER, etc.)
 *
 * Person is not guaranteed to represent an individual per se, but it always represents an RFC822
 * mailbox (i.e. email address), which may be a group list address, multiuser mailbox, etc.
 *
 * Person is mostly immutable in the sense that the {@link send_invite} property is mutable, but
 * this parameter is application-specific and not represented in the iCalendar component.  Notably,
 * this property is not used for any comparison operations.
 *
 * For equality purposes, only the {@link mailto} is used.  All other parameters are ignored when
 * comparing Persons for equality.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.3.3]],
 * [[https://tools.ietf.org/html/rfc5545#section-3.8.4.1]],
 * [[https://tools.ietf.org/html/rfc5545#section-3.8.4.3]],
 * [[https://tools.ietf.org/html/rfc5545#section-3.2.2]], and more.
 */
GType california_component_person_get_type (void) {
	static volatile gsize california_component_person_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_person_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaComponentPersonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_component_person_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaComponentPerson), 0, (GInstanceInitFunc) california_component_person_instance_init, NULL };
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_component_person_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_component_person_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_component_person_type_id;
		california_component_person_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaComponentPerson", &g_define_type_info, 0);
		g_type_add_interface_static (california_component_person_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_type_add_interface_static (california_component_person_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_once_init_leave (&california_component_person_type_id__volatile, california_component_person_type_id);
	}
	return california_component_person_type_id__volatile;
}


static void _vala_california_component_person_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaComponentPerson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	switch (property_id) {
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_enum (value, california_component_person_get_relationship (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_MAILTO:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_boxed (value, california_component_person_get_mailto (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_COMMON_NAME:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_string (value, california_component_person_get_common_name (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_ROLE:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_int (value, california_component_person_get_role (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_RSVP:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_boolean (value, california_component_person_get_rsvp (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_MAILTO_TEXT:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_take_string (value, california_component_person_get_mailto_text (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_MAILBOX:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_string (value, california_component_person_get_mailbox (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_FULL_MAILBOX:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_string (value, california_component_person_get_full_mailbox (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_SEND_INVITE:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		g_value_set_boolean (value, california_component_person_get_send_invite (self));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 2335 "component-person.c"
		default:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 2341 "component-person.c"
	}
}


static void _vala_california_component_person_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaComponentPerson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_PERSON, CaliforniaComponentPerson);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
	switch (property_id) {
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_RELATIONSHIP:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_relationship (self, g_value_get_enum (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_MAILTO:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_mailto (self, g_value_get_boxed (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_COMMON_NAME:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_common_name (self, g_value_get_string (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_ROLE:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_role (self, g_value_get_int (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_RSVP:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_rsvp (self, g_value_get_boolean (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_FULL_MAILBOX:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_full_mailbox (self, g_value_get_string (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		case CALIFORNIA_COMPONENT_PERSON_SEND_INVITE:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		california_component_person_set_send_invite (self, g_value_get_boolean (value));
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 2393 "component-person.c"
		default:
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jim/git/california/src/component/component-person.vala"
		break;
#line 2399 "component-person.c"
	}
}



