//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Item/DataItemBundleWidget.h
//! @brief     Defines class DataItemBundleWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_ITEM_DATAITEMBUNDLEWIDGET_H
#define BORNAGAIN_GUI_VIEW_ITEM_DATAITEMBUNDLEWIDGET_H

#include <QWidget>

class IntensityDataItem;
class SpecularDataItem;

//! The DataItemBundleWidget class is a base for widgets, representing the SpecularDataItem and
//! IntensityDataItem. It may store a list of SpecularDataItems that are required for
//! simultaneous, synchronous work while plotting and changing their properties.

class DataItemBundleWidget : public QWidget {
    Q_OBJECT
public:
    explicit DataItemBundleWidget(QWidget* parent = nullptr);
    ~DataItemBundleWidget() override;

    virtual void setIntensityItem(IntensityDataItem* item);
    IntensityDataItem* intensityDataItem() const;

    virtual void setSpecularItems(const QList<SpecularDataItem*>& items);
    QList<SpecularDataItem*> specularDataItems() const;
    SpecularDataItem* currentSpecularDataItem() const;

private:
    QList<SpecularDataItem*> m_specularDataItems;
    IntensityDataItem* m_intensityDataItem = nullptr;
};

#endif // BORNAGAIN_GUI_VIEW_ITEM_DATAITEMBUNDLEWIDGET_H
