# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to Sanyo SCP-3200"""

from prototypes import *

# Make all sanyo stuff available in this module as well
from p_sanyo import *
from p_sanyomedia import *
from p_sanyonewer import *
from p_brew import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb
_NUMPBSLOTS=300
_NUMSPEEDDIALS=8
_NUMLONGNUMBERS=5
_LONGPHONENUMBERLEN=30
_NUMEVENTSLOTS=100
_NUMCALLALARMSLOTS=15
 # Need to check.  Is max phone will hold 32/96 or 33/97
_MAXNUMBERLEN=32
_MAXEMAILLEN=96
HASRINGPICBUF=0

#BREW_FILE_SYSTEM=2

class req41(BaseProtogenClass):
    __fields=['fortyone', 'msl']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(req41,self).__init__(**dict)
        if self.__class__ is req41:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(req41,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(req41,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_fortyone
        except:
            self.__field_fortyone=UINT(**{'sizeinbytes': 1, 'default': 0x41})
        self.__field_fortyone.writetobuffer(buf)
        self.__field_msl.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_fortyone=UINT(**{'sizeinbytes': 1, 'default': 0x41})
        self.__field_fortyone.readfrombuffer(buf)
        self.__field_msl=USTRING(**{'sizeinbytes': 6, 'terminator': None})
        self.__field_msl.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_fortyone(self):
        try: self.__field_fortyone
        except:
            self.__field_fortyone=UINT(**{'sizeinbytes': 1, 'default': 0x41})
        return self.__field_fortyone.getvalue()

    def __setfield_fortyone(self, value):
        if isinstance(value,UINT):
            self.__field_fortyone=value
        else:
            self.__field_fortyone=UINT(value,**{'sizeinbytes': 1, 'default': 0x41})

    def __delfield_fortyone(self): del self.__field_fortyone

    fortyone=property(__getfield_fortyone, __setfield_fortyone, __delfield_fortyone, None)

    def __getfield_msl(self):
        return self.__field_msl.getvalue()

    def __setfield_msl(self, value):
        if isinstance(value,USTRING):
            self.__field_msl=value
        else:
            self.__field_msl=USTRING(value,**{'sizeinbytes': 6, 'terminator': None})

    def __delfield_msl(self): del self.__field_msl

    msl=property(__getfield_msl, __setfield_msl, __delfield_msl, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('fortyone', self.__field_fortyone, None)
        yield ('msl', self.__field_msl, None)




class res41(BaseProtogenClass):
    __fields=['fortyone', 'ans']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(res41,self).__init__(**dict)
        if self.__class__ is res41:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(res41,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(res41,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_fortyone.writetobuffer(buf)
        self.__field_ans.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_fortyone=UINT(**{'sizeinbytes': 1, 'default': 0x41})
        self.__field_fortyone.readfrombuffer(buf)
        self.__field_ans=UINT(**{'sizeinbytes': 1})
        self.__field_ans.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_fortyone(self):
        return self.__field_fortyone.getvalue()

    def __setfield_fortyone(self, value):
        if isinstance(value,UINT):
            self.__field_fortyone=value
        else:
            self.__field_fortyone=UINT(value,**{'sizeinbytes': 1, 'default': 0x41})

    def __delfield_fortyone(self): del self.__field_fortyone

    fortyone=property(__getfield_fortyone, __setfield_fortyone, __delfield_fortyone, None)

    def __getfield_ans(self):
        return self.__field_ans.getvalue()

    def __setfield_ans(self, value):
        if isinstance(value,UINT):
            self.__field_ans=value
        else:
            self.__field_ans=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ans(self): del self.__field_ans

    ans=property(__getfield_ans, __setfield_ans, __delfield_ans, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('fortyone', self.__field_fortyone, None)
        yield ('ans', self.__field_ans, None)




class fastatusrequest(BaseProtogenClass):
    __fields=['preamble', 'command', 'packettype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(fastatusrequest,self).__init__(**dict)
        if self.__class__ is fastatusrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(fastatusrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(fastatusrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_preamble
        except:
            self.__field_preamble=sanyofaheader(**{'faset': 0x13})
        self.__field_preamble.writetobuffer(buf)
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_command.writetobuffer(buf)
        try: self.__field_packettype
        except:
            self.__field_packettype=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_packettype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_preamble=sanyofaheader(**{'faset': 0x13})
        self.__field_preamble.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_command.readfrombuffer(buf)
        self.__field_packettype=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_packettype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_preamble(self):
        try: self.__field_preamble
        except:
            self.__field_preamble=sanyofaheader(**{'faset': 0x13})
        return self.__field_preamble.getvalue()

    def __setfield_preamble(self, value):
        if isinstance(value,sanyofaheader):
            self.__field_preamble=value
        else:
            self.__field_preamble=sanyofaheader(value,**{'faset': 0x13})

    def __delfield_preamble(self): del self.__field_preamble

    preamble=property(__getfield_preamble, __setfield_preamble, __delfield_preamble, None)

    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_packettype(self):
        try: self.__field_packettype
        except:
            self.__field_packettype=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_packettype.getvalue()

    def __setfield_packettype(self, value):
        if isinstance(value,UINT):
            self.__field_packettype=value
        else:
            self.__field_packettype=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_packettype(self): del self.__field_packettype

    packettype=property(__getfield_packettype, __setfield_packettype, __delfield_packettype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('preamble', self.__field_preamble, None)
        yield ('command', self.__field_command, None)
        yield ('packettype', self.__field_packettype, None)




class fastatusresponse(BaseProtogenClass):
    __fields=['preamble', 'status', 'packettype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(fastatusresponse,self).__init__(**dict)
        if self.__class__ is fastatusresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(fastatusresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(fastatusresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_preamble
        except:
            self.__field_preamble=sanyofaheader()
        self.__field_preamble.writetobuffer(buf)
        self.__field_status.writetobuffer(buf)
        self.__field_packettype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_preamble=sanyofaheader()
        self.__field_preamble.readfrombuffer(buf)
        self.__field_status=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_status.readfrombuffer(buf)
        self.__field_packettype=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_packettype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_preamble(self):
        try: self.__field_preamble
        except:
            self.__field_preamble=sanyofaheader()
        return self.__field_preamble.getvalue()

    def __setfield_preamble(self, value):
        if isinstance(value,sanyofaheader):
            self.__field_preamble=value
        else:
            self.__field_preamble=sanyofaheader(value,)

    def __delfield_preamble(self): del self.__field_preamble

    preamble=property(__getfield_preamble, __setfield_preamble, __delfield_preamble, None)

    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def __getfield_packettype(self):
        return self.__field_packettype.getvalue()

    def __setfield_packettype(self, value):
        if isinstance(value,UINT):
            self.__field_packettype=value
        else:
            self.__field_packettype=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_packettype(self): del self.__field_packettype

    packettype=property(__getfield_packettype, __setfield_packettype, __delfield_packettype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('preamble', self.__field_preamble, None)
        yield ('status', self.__field_status, None)
        yield ('packettype', self.__field_packettype, None)




class response(BaseProtogenClass):
    __fields=['pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(response,self).__init__(**dict)
        if self.__class__ is response:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(response,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(response,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pad=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pad', self.__field_pad, None)




class qcpheader(BaseProtogenClass):
    __fields=['readwrite', 'command', 'packettype']

    def __init__(self, *args, **kwargs):
        dict={}
        # User specified arguments in the packet description
        dict.update({'readwrite': 0x26})
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(qcpheader,self).__init__(**dict)
        if self.__class__ is qcpheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(qcpheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(qcpheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_readwrite.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self.__field_packettype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_readwrite=UINT(**{'sizeinbytes': 1})
        self.__field_readwrite.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_packettype=UINT(**{'sizeinbytes': 1})
        self.__field_packettype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_readwrite(self):
        return self.__field_readwrite.getvalue()

    def __setfield_readwrite(self, value):
        if isinstance(value,UINT):
            self.__field_readwrite=value
        else:
            self.__field_readwrite=UINT(value,**{'sizeinbytes': 1})

    def __delfield_readwrite(self): del self.__field_readwrite

    readwrite=property(__getfield_readwrite, __setfield_readwrite, __delfield_readwrite, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_packettype(self):
        return self.__field_packettype.getvalue()

    def __setfield_packettype(self, value):
        if isinstance(value,UINT):
            self.__field_packettype=value
        else:
            self.__field_packettype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_packettype(self): del self.__field_packettype

    packettype=property(__getfield_packettype, __setfield_packettype, __delfield_packettype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('readwrite', self.__field_readwrite, None)
        yield ('command', self.__field_command, None)
        yield ('packettype', self.__field_packettype, None)




class qcpwriteheader(BaseProtogenClass):
    __fields=['readwrite', 'command', 'packettype', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # User specified arguments in the packet description
        dict.update({'readwrite': 0x27})
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(qcpwriteheader,self).__init__(**dict)
        if self.__class__ is qcpwriteheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(qcpwriteheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(qcpwriteheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_readwrite.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self.__field_packettype.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_readwrite=UINT(**{'sizeinbytes': 1})
        self.__field_readwrite.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_packettype=UINT(**{'sizeinbytes': 1})
        self.__field_packettype.readfrombuffer(buf)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_readwrite(self):
        return self.__field_readwrite.getvalue()

    def __setfield_readwrite(self, value):
        if isinstance(value,UINT):
            self.__field_readwrite=value
        else:
            self.__field_readwrite=UINT(value,**{'sizeinbytes': 1})

    def __delfield_readwrite(self): del self.__field_readwrite

    readwrite=property(__getfield_readwrite, __setfield_readwrite, __delfield_readwrite, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_packettype(self):
        return self.__field_packettype.getvalue()

    def __setfield_packettype(self, value):
        if isinstance(value,UINT):
            self.__field_packettype=value
        else:
            self.__field_packettype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_packettype(self): del self.__field_packettype

    packettype=property(__getfield_packettype, __setfield_packettype, __delfield_packettype, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('readwrite', self.__field_readwrite, None)
        yield ('command', self.__field_command, None)
        yield ('packettype', self.__field_packettype, None)
        yield ('pad', self.__field_pad, None)




class eventrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventrequest,self).__init__(**dict)
        if self.__class__ is eventrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=qcpheader(**{'packettype': 0x0c, 'command': 0x23})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 129})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=qcpheader(**{'packettype': 0x0c, 'command': 0x23})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 129})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=qcpheader(**{'packettype': 0x0c, 'command': 0x23})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,qcpheader):
            self.__field_header=value
        else:
            self.__field_header=qcpheader(value,**{'packettype': 0x0c, 'command': 0x23})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 129})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 129})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class eventslotinuserequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventslotinuserequest,self).__init__(**dict)
        if self.__class__ is eventslotinuserequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventslotinuserequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventslotinuserequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=qcpheader(**{'readwrite': 0x26, 'packettype': 0x0d, 'command': 0x74})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 129})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=qcpheader(**{'readwrite': 0x26, 'packettype': 0x0d, 'command': 0x74})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 129})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=qcpheader(**{'readwrite': 0x26, 'packettype': 0x0d, 'command': 0x74})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,qcpheader):
            self.__field_header=value
        else:
            self.__field_header=qcpheader(value,**{'readwrite': 0x26, 'packettype': 0x0d, 'command': 0x74})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 129})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 129})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class evententry(BaseProtogenClass):
    __fields=['slot', 'eventname', 'pad1', 'eventname_len', 'start', 'end', 'location', 'pad2', 'location_len', 'alarmdiff', 'period', 'dom', 'alarm', 'pad3', 'serial', 'pad4', 'ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(evententry,self).__init__(**dict)
        if self.__class__ is evententry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(evententry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(evententry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_eventname.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.writetobuffer(buf)
        self.__field_eventname_len.writetobuffer(buf)
        self.__field_start.writetobuffer(buf)
        self.__field_end.writetobuffer(buf)
        self.__field_location.writetobuffer(buf)
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad2.writetobuffer(buf)
        self.__field_location_len.writetobuffer(buf)
        self.__field_alarmdiff.writetobuffer(buf)
        self.__field_period.writetobuffer(buf)
        self.__field_dom.writetobuffer(buf)
        self.__field_alarm.writetobuffer(buf)
        try: self.__field_pad3
        except:
            self.__field_pad3=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad3.writetobuffer(buf)
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.writetobuffer(buf)
        try: self.__field_pad4
        except:
            self.__field_pad4=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad4.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_eventname=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_eventname.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_eventname_len=UINT(**{'sizeinbytes': 1})
        self.__field_eventname_len.readfrombuffer(buf)
        self.__field_start=UINT(**{'sizeinbytes': 4})
        self.__field_start.readfrombuffer(buf)
        self.__field_end=UINT(**{'sizeinbytes': 4})
        self.__field_end.readfrombuffer(buf)
        self.__field_location=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_location.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad2.readfrombuffer(buf)
        self.__field_location_len=UINT(**{'sizeinbytes': 1})
        self.__field_location_len.readfrombuffer(buf)
        self.__field_alarmdiff=UINT(**{'sizeinbytes': 4})
        self.__field_alarmdiff.readfrombuffer(buf)
        self.__field_period=UINT(**{'sizeinbytes': 1})
        self.__field_period.readfrombuffer(buf)
        self.__field_dom=UINT(**{'sizeinbytes': 1})
        self.__field_dom.readfrombuffer(buf)
        self.__field_alarm=UINT(**{'sizeinbytes': 4})
        self.__field_alarm.readfrombuffer(buf)
        self.__field_pad3=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad3.readfrombuffer(buf)
        self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.readfrombuffer(buf)
        self.__field_pad4=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad4.readfrombuffer(buf)
        self.__field_ringtone=UINT(**{'sizeinbytes': 2})
        self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_eventname(self):
        return self.__field_eventname.getvalue()

    def __setfield_eventname(self, value):
        if isinstance(value,USTRING):
            self.__field_eventname=value
        else:
            self.__field_eventname=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_eventname(self): del self.__field_eventname

    eventname=property(__getfield_eventname, __setfield_eventname, __delfield_eventname, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_eventname_len(self):
        return self.__field_eventname_len.getvalue()

    def __setfield_eventname_len(self, value):
        if isinstance(value,UINT):
            self.__field_eventname_len=value
        else:
            self.__field_eventname_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_eventname_len(self): del self.__field_eventname_len

    eventname_len=property(__getfield_eventname_len, __setfield_eventname_len, __delfield_eventname_len, None)

    def __getfield_start(self):
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,UINT):
            self.__field_start=value
        else:
            self.__field_start=UINT(value,**{'sizeinbytes': 4})

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, "# seconds since Jan 1, 1980 approximately")

    def __getfield_end(self):
        return self.__field_end.getvalue()

    def __setfield_end(self, value):
        if isinstance(value,UINT):
            self.__field_end=value
        else:
            self.__field_end=UINT(value,**{'sizeinbytes': 4})

    def __delfield_end(self): del self.__field_end

    end=property(__getfield_end, __setfield_end, __delfield_end, None)

    def __getfield_location(self):
        return self.__field_location.getvalue()

    def __setfield_location(self, value):
        if isinstance(value,USTRING):
            self.__field_location=value
        else:
            self.__field_location=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_location(self): del self.__field_location

    location=property(__getfield_location, __setfield_location, __delfield_location, None)

    def __getfield_pad2(self):
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 7})
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def __getfield_location_len(self):
        return self.__field_location_len.getvalue()

    def __setfield_location_len(self, value):
        if isinstance(value,UINT):
            self.__field_location_len=value
        else:
            self.__field_location_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_location_len(self): del self.__field_location_len

    location_len=property(__getfield_location_len, __setfield_location_len, __delfield_location_len, None)

    def __getfield_alarmdiff(self):
        return self.__field_alarmdiff.getvalue()

    def __setfield_alarmdiff(self, value):
        if isinstance(value,UINT):
            self.__field_alarmdiff=value
        else:
            self.__field_alarmdiff=UINT(value,**{'sizeinbytes': 4})

    def __delfield_alarmdiff(self): del self.__field_alarmdiff

    alarmdiff=property(__getfield_alarmdiff, __setfield_alarmdiff, __delfield_alarmdiff, "Displayed alarm time")

    def __getfield_period(self):
        return self.__field_period.getvalue()

    def __setfield_period(self, value):
        if isinstance(value,UINT):
            self.__field_period=value
        else:
            self.__field_period=UINT(value,**{'sizeinbytes': 1})

    def __delfield_period(self): del self.__field_period

    period=property(__getfield_period, __setfield_period, __delfield_period, "No, Daily, Weekly, Monthly, Yearly")

    def __getfield_dom(self):
        return self.__field_dom.getvalue()

    def __setfield_dom(self, value):
        if isinstance(value,UINT):
            self.__field_dom=value
        else:
            self.__field_dom=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dom(self): del self.__field_dom

    dom=property(__getfield_dom, __setfield_dom, __delfield_dom, "Day of month for the event")

    def __getfield_alarm(self):
        return self.__field_alarm.getvalue()

    def __setfield_alarm(self, value):
        if isinstance(value,UINT):
            self.__field_alarm=value
        else:
            self.__field_alarm=UINT(value,**{'sizeinbytes': 4})

    def __delfield_alarm(self): del self.__field_alarm

    alarm=property(__getfield_alarm, __setfield_alarm, __delfield_alarm, None)

    def __getfield_pad3(self):
        try: self.__field_pad3
        except:
            self.__field_pad3=UNKNOWN(**{'sizeinbytes': 1})
        return self.__field_pad3.getvalue()

    def __setfield_pad3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad3=value
        else:
            self.__field_pad3=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad3(self): del self.__field_pad3

    pad3=property(__getfield_pad3, __setfield_pad3, __delfield_pad3, None)

    def __getfield_serial(self):
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_serial.getvalue()

    def __setfield_serial(self, value):
        if isinstance(value,UINT):
            self.__field_serial=value
        else:
            self.__field_serial=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_serial(self): del self.__field_serial

    serial=property(__getfield_serial, __setfield_serial, __delfield_serial, "Some kind of serial number")

    def __getfield_pad4(self):
        try: self.__field_pad4
        except:
            self.__field_pad4=UNKNOWN(**{'sizeinbytes': 3})
        return self.__field_pad4.getvalue()

    def __setfield_pad4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad4=value
        else:
            self.__field_pad4=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_pad4(self): del self.__field_pad4

    pad4=property(__getfield_pad4, __setfield_pad4, __delfield_pad4, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 2})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('eventname', self.__field_eventname, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('eventname_len', self.__field_eventname_len, None)
        yield ('start', self.__field_start, "# seconds since Jan 1, 1980 approximately")
        yield ('end', self.__field_end, None)
        yield ('location', self.__field_location, None)
        yield ('pad2', self.__field_pad2, None)
        yield ('location_len', self.__field_location_len, None)
        yield ('alarmdiff', self.__field_alarmdiff, "Displayed alarm time")
        yield ('period', self.__field_period, "No, Daily, Weekly, Monthly, Yearly")
        yield ('dom', self.__field_dom, "Day of month for the event")
        yield ('alarm', self.__field_alarm, None)
        yield ('pad3', self.__field_pad3, None)
        yield ('serial', self.__field_serial, "Some kind of serial number")
        yield ('pad4', self.__field_pad4, None)
        yield ('ringtone', self.__field_ringtone, None)




class eventresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventresponse,self).__init__(**dict)
        if self.__class__ is eventresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=qcpheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=evententry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,qcpheader):
            self.__field_header=value
        else:
            self.__field_header=qcpheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,evententry):
            self.__field_entry=value
        else:
            self.__field_entry=evententry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class eventslotinuseresponse(BaseProtogenClass):
    __fields=['header', 'slot', 'flag', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventslotinuseresponse,self).__init__(**dict)
        if self.__class__ is eventslotinuseresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventslotinuseresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventslotinuseresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=qcpheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,qcpheader):
            self.__field_header=value
        else:
            self.__field_header=qcpheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, None)
        yield ('pad', self.__field_pad, None)




class eventslotinuseupdaterequest(BaseProtogenClass):
    __fields=['header', 'slot', 'flag', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventslotinuseupdaterequest,self).__init__(**dict)
        if self.__class__ is eventslotinuseupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventslotinuseupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventslotinuseupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=qcpwriteheader(**{'packettype': 0x0d, 'command': 0x74})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 124})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=qcpwriteheader(**{'packettype': 0x0d, 'command': 0x74})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 124})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=qcpwriteheader(**{'packettype': 0x0d, 'command': 0x74})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,qcpwriteheader):
            self.__field_header=value
        else:
            self.__field_header=qcpwriteheader(value,**{'packettype': 0x0d, 'command': 0x74})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 124})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 124})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, None)
        yield ('pad', self.__field_pad, None)




class eventupdaterequest(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventupdaterequest,self).__init__(**dict)
        if self.__class__ is eventupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=qcpwriteheader(**{'packettype': 0x0c, 'command':0x23})
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 56})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=qcpwriteheader(**{'packettype': 0x0c, 'command':0x23})
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=evententry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 56})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=qcpwriteheader(**{'packettype': 0x0c, 'command':0x23})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,qcpwriteheader):
            self.__field_header=value
        else:
            self.__field_header=qcpwriteheader(value,**{'packettype': 0x0c, 'command':0x23})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,evententry):
            self.__field_entry=value
        else:
            self.__field_entry=evententry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 56})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 56})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class callalarmrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmrequest,self).__init__(**dict)
        if self.__class__ is callalarmrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x24})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x24})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x24})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,		'command': 0x24})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class callalarmentry(BaseProtogenClass):
    __fields=['slot', 'flag', 'dunno1', 'phonenum', 'phonenum_len', 'date', 'period', 'dom', 'datedup', 'name', 'pad1', 'name_len', 'phonenumbertype', 'phonenumberslot', 'serial', 'pad2', 'ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmentry,self).__init__(**dict)
        if self.__class__ is callalarmentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_dunno1.writetobuffer(buf)
        self.__field_phonenum.writetobuffer(buf)
        self.__field_phonenum_len.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_period.writetobuffer(buf)
        self.__field_dom.writetobuffer(buf)
        self.__field_datedup.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.writetobuffer(buf)
        self.__field_name_len.writetobuffer(buf)
        self.__field_phonenumbertype.writetobuffer(buf)
        self.__field_phonenumberslot.writetobuffer(buf)
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.writetobuffer(buf)
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad2.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_phonenum=USTRING(**{'sizeinbytes': 49, 'raiseonunterminatedread': False})
        self.__field_phonenum.readfrombuffer(buf)
        self.__field_phonenum_len=UINT(**{'sizeinbytes': 1})
        self.__field_phonenum_len.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_period=UINT(**{'sizeinbytes': 1})
        self.__field_period.readfrombuffer(buf)
        self.__field_dom=UINT(**{'sizeinbytes': 1})
        self.__field_dom.readfrombuffer(buf)
        self.__field_datedup=UINT(**{'sizeinbytes': 4})
        self.__field_datedup.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_name.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_name_len=UINT(**{'sizeinbytes': 1})
        self.__field_name_len.readfrombuffer(buf)
        self.__field_phonenumbertype=UINT(**{'sizeinbytes': 1})
        self.__field_phonenumbertype.readfrombuffer(buf)
        self.__field_phonenumberslot=UINT(**{'sizeinbytes': 2})
        self.__field_phonenumberslot.readfrombuffer(buf)
        self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad2.readfrombuffer(buf)
        self.__field_ringtone=UINT(**{'sizeinbytes': 1})
        self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0: Not used, 1: Scheduled, 2: Already Happened")

    def __getfield_dunno1(self):
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, "Related to Snooze?")

    def __getfield_phonenum(self):
        return self.__field_phonenum.getvalue()

    def __setfield_phonenum(self, value):
        if isinstance(value,USTRING):
            self.__field_phonenum=value
        else:
            self.__field_phonenum=USTRING(value,**{'sizeinbytes': 49, 'raiseonunterminatedread': False})

    def __delfield_phonenum(self): del self.__field_phonenum

    phonenum=property(__getfield_phonenum, __setfield_phonenum, __delfield_phonenum, None)

    def __getfield_phonenum_len(self):
        return self.__field_phonenum_len.getvalue()

    def __setfield_phonenum_len(self, value):
        if isinstance(value,UINT):
            self.__field_phonenum_len=value
        else:
            self.__field_phonenum_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenum_len(self): del self.__field_phonenum_len

    phonenum_len=property(__getfield_phonenum_len, __setfield_phonenum_len, __delfield_phonenum_len, None)

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, "# seconds since Jan 1, 1980 approximately")

    def __getfield_period(self):
        return self.__field_period.getvalue()

    def __setfield_period(self, value):
        if isinstance(value,UINT):
            self.__field_period=value
        else:
            self.__field_period=UINT(value,**{'sizeinbytes': 1})

    def __delfield_period(self): del self.__field_period

    period=property(__getfield_period, __setfield_period, __delfield_period, "No, Daily, Weekly, Monthly, Yearly")

    def __getfield_dom(self):
        return self.__field_dom.getvalue()

    def __setfield_dom(self, value):
        if isinstance(value,UINT):
            self.__field_dom=value
        else:
            self.__field_dom=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dom(self): del self.__field_dom

    dom=property(__getfield_dom, __setfield_dom, __delfield_dom, "Day of month for the event")

    def __getfield_datedup(self):
        return self.__field_datedup.getvalue()

    def __setfield_datedup(self, value):
        if isinstance(value,UINT):
            self.__field_datedup=value
        else:
            self.__field_datedup=UINT(value,**{'sizeinbytes': 4})

    def __delfield_datedup(self): del self.__field_datedup

    datedup=property(__getfield_datedup, __setfield_datedup, __delfield_datedup, "Copy of the date.  Always the same???")

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_name_len(self):
        return self.__field_name_len.getvalue()

    def __setfield_name_len(self, value):
        if isinstance(value,UINT):
            self.__field_name_len=value
        else:
            self.__field_name_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_name_len(self): del self.__field_name_len

    name_len=property(__getfield_name_len, __setfield_name_len, __delfield_name_len, None)

    def __getfield_phonenumbertype(self):
        return self.__field_phonenumbertype.getvalue()

    def __setfield_phonenumbertype(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumbertype=value
        else:
            self.__field_phonenumbertype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenumbertype(self): del self.__field_phonenumbertype

    phonenumbertype=property(__getfield_phonenumbertype, __setfield_phonenumbertype, __delfield_phonenumbertype, "1: Home, 2: Work, ...")

    def __getfield_phonenumberslot(self):
        return self.__field_phonenumberslot.getvalue()

    def __setfield_phonenumberslot(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumberslot=value
        else:
            self.__field_phonenumberslot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_phonenumberslot(self): del self.__field_phonenumberslot

    phonenumberslot=property(__getfield_phonenumberslot, __setfield_phonenumberslot, __delfield_phonenumberslot, None)

    def __getfield_serial(self):
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_serial.getvalue()

    def __setfield_serial(self, value):
        if isinstance(value,UINT):
            self.__field_serial=value
        else:
            self.__field_serial=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_serial(self): del self.__field_serial

    serial=property(__getfield_serial, __setfield_serial, __delfield_serial, None)

    def __getfield_pad2(self):
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 3})
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, "0: Not used, 1: Scheduled, 2: Already Happened")
        yield ('dunno1', self.__field_dunno1, "Related to Snooze?")
        yield ('phonenum', self.__field_phonenum, None)
        yield ('phonenum_len', self.__field_phonenum_len, None)
        yield ('date', self.__field_date, "# seconds since Jan 1, 1980 approximately")
        yield ('period', self.__field_period, "No, Daily, Weekly, Monthly, Yearly")
        yield ('dom', self.__field_dom, "Day of month for the event")
        yield ('datedup', self.__field_datedup, "Copy of the date.  Always the same???")
        yield ('name', self.__field_name, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('name_len', self.__field_name_len, None)
        yield ('phonenumbertype', self.__field_phonenumbertype, "1: Home, 2: Work, ...")
        yield ('phonenumberslot', self.__field_phonenumberslot, None)
        yield ('serial', self.__field_serial, None)
        yield ('pad2', self.__field_pad2, None)
        yield ('ringtone', self.__field_ringtone, None)




class callalarmresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmresponse,self).__init__(**dict)
        if self.__class__ is callalarmresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=callalarmentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,callalarmentry):
            self.__field_entry=value
        else:
            self.__field_entry=callalarmentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 417})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class callalarmupdaterequest(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmupdaterequest,self).__init__(**dict)
        if self.__class__ is callalarmupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyowriteheader(**{'packettype': 0x0c, 'command':0x24})
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyowriteheader(**{'packettype': 0x0c, 'command':0x24})
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=callalarmentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyowriteheader(**{'packettype': 0x0c, 'command':0x24})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyowriteheader):
            self.__field_header=value
        else:
            self.__field_header=sanyowriteheader(value,**{'packettype': 0x0c, 'command':0x24})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,callalarmentry):
            self.__field_entry=value
        else:
            self.__field_entry=callalarmentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 417})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class bufferpartrequest(BaseProtogenClass):
    __fields=['bufpartsize', 'header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(bufferpartrequest,self).__init__(**dict)
        if self.__class__ is bufferpartrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(bufferpartrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(bufferpartrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bufpartsize
        except:
            self.__field_bufpartsize=UINT(**{'constant': 1024})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0f})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 1026})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0f})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 1026})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bufpartsize(self):
        return self.__field_bufpartsize.getvalue()

    def __setfield_bufpartsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufpartsize=value
        else:
            self.__field_bufpartsize=UINT(value,**{'constant': 1024})

    def __delfield_bufpartsize(self): del self.__field_bufpartsize

    bufpartsize=property(__getfield_bufpartsize, __setfield_bufpartsize, __delfield_bufpartsize, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0f})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0f})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 1026})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 1026})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bufpartsize', self.__field_bufpartsize, None)
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class bufferpartresponse(BaseProtogenClass):
    __fields=['bufpartsize', 'header', 'data', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(bufferpartresponse,self).__init__(**dict)
        if self.__class__ is bufferpartresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(bufferpartresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(bufferpartresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bufpartsize
        except:
            self.__field_bufpartsize=UINT(**{'constant': 1024})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.bufpartsize})
        self.__field_data.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bufpartsize(self):
        return self.__field_bufpartsize.getvalue()

    def __setfield_bufpartsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufpartsize=value
        else:
            self.__field_bufpartsize=UINT(value,**{'constant': 1024})

    def __delfield_bufpartsize(self): del self.__field_bufpartsize

    bufpartsize=property(__getfield_bufpartsize, __setfield_bufpartsize, __delfield_bufpartsize, None)

    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.bufpartsize})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bufpartsize', self.__field_bufpartsize, None)
        yield ('header', self.__field_header, None)
        yield ('data', self.__field_data, None)
        yield ('pad', self.__field_pad, None)




class bufferpartupdaterequest(BaseProtogenClass):
    __fields=['bufpartsize', 'header', 'data', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(bufferpartupdaterequest,self).__init__(**dict)
        if self.__class__ is bufferpartupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(bufferpartupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(bufferpartupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bufpartsize
        except:
            self.__field_bufpartsize=UINT(**{'constant': 1024})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyowriteheader(**{'packettype': 0x0f})
        self.__field_header.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyowriteheader(**{'packettype': 0x0f})
        self.__field_header.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.bufpartsize})
        self.__field_data.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bufpartsize(self):
        return self.__field_bufpartsize.getvalue()

    def __setfield_bufpartsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufpartsize=value
        else:
            self.__field_bufpartsize=UINT(value,**{'constant': 1024})

    def __delfield_bufpartsize(self): del self.__field_bufpartsize

    bufpartsize=property(__getfield_bufpartsize, __setfield_bufpartsize, __delfield_bufpartsize, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyowriteheader(**{'packettype': 0x0f})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyowriteheader):
            self.__field_header=value
        else:
            self.__field_header=sanyowriteheader(value,**{'packettype': 0x0f})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.bufpartsize})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bufpartsize', self.__field_bufpartsize, None)
        yield ('header', self.__field_header, None)
        yield ('data', self.__field_data, None)
        yield ('pad', self.__field_pad, None)




class calleridbuffer(BaseProtogenClass):
    "Index so that phone can show a name instead of number"
    __fields=['maxentries', 'startcommand', 'bufsize', 'comment', 'numentries', 'items', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(calleridbuffer,self).__init__(**dict)
        if self.__class__ is calleridbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(calleridbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(calleridbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_maxentries
        except:
            self.__field_maxentries=UINT(**{'constant': 500})
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x46})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 7168})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "callerid"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numentries.writetobuffer(buf)
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})
        self.__field_items.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 666})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numentries=UINT(**{'sizeinbytes': 2})
        self.__field_numentries.readfrombuffer(buf)
        self.__field_items=LIST(**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 666})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_maxentries(self):
        return self.__field_maxentries.getvalue()

    def __setfield_maxentries(self, value):
        if isinstance(value,UINT):
            self.__field_maxentries=value
        else:
            self.__field_maxentries=UINT(value,**{'constant': 500})

    def __delfield_maxentries(self): del self.__field_maxentries

    maxentries=property(__getfield_maxentries, __setfield_maxentries, __delfield_maxentries, None)

    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x46})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 7168})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "callerid"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "callerid"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_numentries(self):
        return self.__field_numentries.getvalue()

    def __setfield_numentries(self, value):
        if isinstance(value,UINT):
            self.__field_numentries=value
        else:
            self.__field_numentries=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numentries(self): del self.__field_numentries

    numentries=property(__getfield_numentries, __setfield_numentries, __delfield_numentries, "Number phone numbers")

    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 666})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 666})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('maxentries', self.__field_maxentries, None)
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('numentries', self.__field_numentries, "Number phone numbers")
        yield ('items', self.__field_items, None)
        yield ('pad', self.__field_pad, None)




class ringerpicbuffer(BaseProtogenClass):
    "Index of ringer and picture assignments"
    __fields=['numpbslots', 'startcommand', 'packettype', 'bufsize', 'comment', 'ringtones', 'wallpapers', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ringerpicbuffer,self).__init__(**dict)
        if self.__class__ is ringerpicbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ringerpicbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ringerpicbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_numpbslots
        except:
            self.__field_numpbslots=UINT(**{'constant': _NUMPBSLOTS})
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0xd7})
        try: self.__field_packettype
        except:
            self.__field_packettype=UINT(**{'constant': 0x0f})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 1024})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "ringer/picture assignments"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_ringtones
        except:
            self.__field_ringtones=LIST(**{'elementclass': _gen_p_sanyo3200_200, 'length': _NUMPBSLOTS})
        self.__field_ringtones.writetobuffer(buf)
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'elementclass': _gen_p_sanyo3200_202, 'length': _NUMPBSLOTS})
        self.__field_wallpapers.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 424})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_ringtones=LIST(**{'elementclass': _gen_p_sanyo3200_200, 'length': _NUMPBSLOTS})
        self.__field_ringtones.readfrombuffer(buf)
        self.__field_wallpapers=LIST(**{'elementclass': _gen_p_sanyo3200_202, 'length': _NUMPBSLOTS})
        self.__field_wallpapers.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 424})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numpbslots(self):
        return self.__field_numpbslots.getvalue()

    def __setfield_numpbslots(self, value):
        if isinstance(value,UINT):
            self.__field_numpbslots=value
        else:
            self.__field_numpbslots=UINT(value,**{'constant': _NUMPBSLOTS})

    def __delfield_numpbslots(self): del self.__field_numpbslots

    numpbslots=property(__getfield_numpbslots, __setfield_numpbslots, __delfield_numpbslots, "Number of phone book slots")

    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0xd7})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_packettype(self):
        return self.__field_packettype.getvalue()

    def __setfield_packettype(self, value):
        if isinstance(value,UINT):
            self.__field_packettype=value
        else:
            self.__field_packettype=UINT(value,**{'constant': 0x0f})

    def __delfield_packettype(self): del self.__field_packettype

    packettype=property(__getfield_packettype, __setfield_packettype, __delfield_packettype, "Non standard packet type")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 1024})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "ringer/picture assignments"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "ringer/picture assignments"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_ringtones(self):
        try: self.__field_ringtones
        except:
            self.__field_ringtones=LIST(**{'elementclass': _gen_p_sanyo3200_200, 'length': _NUMPBSLOTS})
        return self.__field_ringtones.getvalue()

    def __setfield_ringtones(self, value):
        if isinstance(value,LIST):
            self.__field_ringtones=value
        else:
            self.__field_ringtones=LIST(value,**{'elementclass': _gen_p_sanyo3200_200, 'length': _NUMPBSLOTS})

    def __delfield_ringtones(self): del self.__field_ringtones

    ringtones=property(__getfield_ringtones, __setfield_ringtones, __delfield_ringtones, None)

    def __getfield_wallpapers(self):
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'elementclass': _gen_p_sanyo3200_202, 'length': _NUMPBSLOTS})
        return self.__field_wallpapers.getvalue()

    def __setfield_wallpapers(self, value):
        if isinstance(value,LIST):
            self.__field_wallpapers=value
        else:
            self.__field_wallpapers=LIST(value,**{'elementclass': _gen_p_sanyo3200_202, 'length': _NUMPBSLOTS})

    def __delfield_wallpapers(self): del self.__field_wallpapers

    wallpapers=property(__getfield_wallpapers, __setfield_wallpapers, __delfield_wallpapers, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 424})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 424})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numpbslots', self.__field_numpbslots, "Number of phone book slots")
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('packettype', self.__field_packettype, "Non standard packet type")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('ringtones', self.__field_ringtones, None)
        yield ('wallpapers', self.__field_wallpapers, None)
        yield ('pad', self.__field_pad, None)




class _gen_p_sanyo3200_200(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_200,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_200:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_200,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_200,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_ringtone=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_ringtone=UINT(**{'sizeinbytes': 1})
        self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, "ringtone index")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('ringtone', self.__field_ringtone, "ringtone index")




class _gen_p_sanyo3200_202(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['wallpaper']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_202,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_202:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_202,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_202,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_wallpaper=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_wallpaper.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_wallpaper=UINT(**{'sizeinbytes': 1})
        self.__field_wallpaper.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_wallpaper(self):
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 1})

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, "wallpaper index")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('wallpaper', self.__field_wallpaper, "wallpaper index")




class pbsortbuffer(BaseProtogenClass):
    "Various arrays for sorting the phone book, speed dial, determining which"
    __fields=['startcommand', 'bufsize', 'comment', 'usedflags', 'slotsused', 'slotsused2', 'numemail', 'numurl', 'firsttypes', 'sortorder', 'pbfirstletters', 'sortorder2', 'speeddialindex', 'longnumbersindex', 'emails', 'emailfirstletters', 'urls', 'urlfirstletters', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbsortbuffer,self).__init__(**dict)
        if self.__class__ is pbsortbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbsortbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbsortbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x3c})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 4096})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "sort buffer"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_usedflags
        except:
            self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo3200_223, 'length': _NUMPBSLOTS, 'createdefault': True})
        self.__field_usedflags.writetobuffer(buf)
        self.__field_slotsused.writetobuffer(buf)
        self.__field_slotsused2.writetobuffer(buf)
        self.__field_numemail.writetobuffer(buf)
        self.__field_numurl.writetobuffer(buf)
        try: self.__field_firsttypes
        except:
            self.__field_firsttypes=LIST(**{'elementclass': _gen_p_sanyo3200_229, 'length': _NUMPBSLOTS})
        self.__field_firsttypes.writetobuffer(buf)
        try: self.__field_sortorder
        except:
            self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo3200_231, 'length': _NUMPBSLOTS})
        self.__field_sortorder.writetobuffer(buf)
        self.__field_pbfirstletters.writetobuffer(buf)
        try: self.__field_sortorder2
        except:
            self.__field_sortorder2=LIST(**{'elementclass': _gen_p_sanyo3200_234, 'length': _NUMPBSLOTS})
        self.__field_sortorder2.writetobuffer(buf)
        try: self.__field_speeddialindex
        except:
            self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo3200_236, 'length': _NUMSPEEDDIALS})
        self.__field_speeddialindex.writetobuffer(buf)
        try: self.__field_longnumbersindex
        except:
            self.__field_longnumbersindex=LIST(**{'elementclass': _gen_p_sanyo3200_238, 'length': _NUMLONGNUMBERS})
        self.__field_longnumbersindex.writetobuffer(buf)
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_sanyo3200_240, 'length': _NUMPBSLOTS})
        self.__field_emails.writetobuffer(buf)
        self.__field_emailfirstletters.writetobuffer(buf)
        try: self.__field_urls
        except:
            self.__field_urls=LIST(**{'elementclass': _gen_p_sanyo3200_243, 'length': _NUMPBSLOTS})
        self.__field_urls.writetobuffer(buf)
        self.__field_urlfirstletters.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 162})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo3200_223, 'length': _NUMPBSLOTS, 'createdefault': True})
        self.__field_usedflags.readfrombuffer(buf)
        self.__field_slotsused=UINT(**{'sizeinbytes': 2})
        self.__field_slotsused.readfrombuffer(buf)
        self.__field_slotsused2=UINT(**{'sizeinbytes': 2})
        self.__field_slotsused2.readfrombuffer(buf)
        self.__field_numemail=UINT(**{'sizeinbytes': 2})
        self.__field_numemail.readfrombuffer(buf)
        self.__field_numurl=UINT(**{'sizeinbytes': 2})
        self.__field_numurl.readfrombuffer(buf)
        self.__field_firsttypes=LIST(**{'elementclass': _gen_p_sanyo3200_229, 'length': _NUMPBSLOTS})
        self.__field_firsttypes.readfrombuffer(buf)
        self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo3200_231, 'length': _NUMPBSLOTS})
        self.__field_sortorder.readfrombuffer(buf)
        self.__field_pbfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})
        self.__field_pbfirstletters.readfrombuffer(buf)
        self.__field_sortorder2=LIST(**{'elementclass': _gen_p_sanyo3200_234, 'length': _NUMPBSLOTS})
        self.__field_sortorder2.readfrombuffer(buf)
        self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo3200_236, 'length': _NUMSPEEDDIALS})
        self.__field_speeddialindex.readfrombuffer(buf)
        self.__field_longnumbersindex=LIST(**{'elementclass': _gen_p_sanyo3200_238, 'length': _NUMLONGNUMBERS})
        self.__field_longnumbersindex.readfrombuffer(buf)
        self.__field_emails=LIST(**{'elementclass': _gen_p_sanyo3200_240, 'length': _NUMPBSLOTS})
        self.__field_emails.readfrombuffer(buf)
        self.__field_emailfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})
        self.__field_emailfirstletters.readfrombuffer(buf)
        self.__field_urls=LIST(**{'elementclass': _gen_p_sanyo3200_243, 'length': _NUMPBSLOTS})
        self.__field_urls.readfrombuffer(buf)
        self.__field_urlfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})
        self.__field_urlfirstletters.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 162})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x3c})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 4096})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "sort buffer"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "sort buffer"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_usedflags(self):
        try: self.__field_usedflags
        except:
            self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo3200_223, 'length': _NUMPBSLOTS, 'createdefault': True})
        return self.__field_usedflags.getvalue()

    def __setfield_usedflags(self, value):
        if isinstance(value,LIST):
            self.__field_usedflags=value
        else:
            self.__field_usedflags=LIST(value,**{'elementclass': _gen_p_sanyo3200_223, 'length': _NUMPBSLOTS, 'createdefault': True})

    def __delfield_usedflags(self): del self.__field_usedflags

    usedflags=property(__getfield_usedflags, __setfield_usedflags, __delfield_usedflags, None)

    def __getfield_slotsused(self):
        return self.__field_slotsused.getvalue()

    def __setfield_slotsused(self, value):
        if isinstance(value,UINT):
            self.__field_slotsused=value
        else:
            self.__field_slotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slotsused(self): del self.__field_slotsused

    slotsused=property(__getfield_slotsused, __setfield_slotsused, __delfield_slotsused, None)

    def __getfield_slotsused2(self):
        return self.__field_slotsused2.getvalue()

    def __setfield_slotsused2(self, value):
        if isinstance(value,UINT):
            self.__field_slotsused2=value
        else:
            self.__field_slotsused2=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slotsused2(self): del self.__field_slotsused2

    slotsused2=property(__getfield_slotsused2, __setfield_slotsused2, __delfield_slotsused2, "Always seems to be the same.  Why duplicated?")

    def __getfield_numemail(self):
        return self.__field_numemail.getvalue()

    def __setfield_numemail(self, value):
        if isinstance(value,UINT):
            self.__field_numemail=value
        else:
            self.__field_numemail=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numemail(self): del self.__field_numemail

    numemail=property(__getfield_numemail, __setfield_numemail, __delfield_numemail, "Num of slots with email")

    def __getfield_numurl(self):
        return self.__field_numurl.getvalue()

    def __setfield_numurl(self, value):
        if isinstance(value,UINT):
            self.__field_numurl=value
        else:
            self.__field_numurl=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numurl(self): del self.__field_numurl

    numurl=property(__getfield_numurl, __setfield_numurl, __delfield_numurl, "Num of slots with URL")

    def __getfield_firsttypes(self):
        try: self.__field_firsttypes
        except:
            self.__field_firsttypes=LIST(**{'elementclass': _gen_p_sanyo3200_229, 'length': _NUMPBSLOTS})
        return self.__field_firsttypes.getvalue()

    def __setfield_firsttypes(self, value):
        if isinstance(value,LIST):
            self.__field_firsttypes=value
        else:
            self.__field_firsttypes=LIST(value,**{'elementclass': _gen_p_sanyo3200_229, 'length': _NUMPBSLOTS})

    def __delfield_firsttypes(self): del self.__field_firsttypes

    firsttypes=property(__getfield_firsttypes, __setfield_firsttypes, __delfield_firsttypes, None)

    def __getfield_sortorder(self):
        try: self.__field_sortorder
        except:
            self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo3200_231, 'length': _NUMPBSLOTS})
        return self.__field_sortorder.getvalue()

    def __setfield_sortorder(self, value):
        if isinstance(value,LIST):
            self.__field_sortorder=value
        else:
            self.__field_sortorder=LIST(value,**{'elementclass': _gen_p_sanyo3200_231, 'length': _NUMPBSLOTS})

    def __delfield_sortorder(self): del self.__field_sortorder

    sortorder=property(__getfield_sortorder, __setfield_sortorder, __delfield_sortorder, None)

    def __getfield_pbfirstletters(self):
        return self.__field_pbfirstletters.getvalue()

    def __setfield_pbfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_pbfirstletters=value
        else:
            self.__field_pbfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})

    def __delfield_pbfirstletters(self): del self.__field_pbfirstletters

    pbfirstletters=property(__getfield_pbfirstletters, __setfield_pbfirstletters, __delfield_pbfirstletters, None)

    def __getfield_sortorder2(self):
        try: self.__field_sortorder2
        except:
            self.__field_sortorder2=LIST(**{'elementclass': _gen_p_sanyo3200_234, 'length': _NUMPBSLOTS})
        return self.__field_sortorder2.getvalue()

    def __setfield_sortorder2(self, value):
        if isinstance(value,LIST):
            self.__field_sortorder2=value
        else:
            self.__field_sortorder2=LIST(value,**{'elementclass': _gen_p_sanyo3200_234, 'length': _NUMPBSLOTS})

    def __delfield_sortorder2(self): del self.__field_sortorder2

    sortorder2=property(__getfield_sortorder2, __setfield_sortorder2, __delfield_sortorder2, "Is this the same")

    def __getfield_speeddialindex(self):
        try: self.__field_speeddialindex
        except:
            self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo3200_236, 'length': _NUMSPEEDDIALS})
        return self.__field_speeddialindex.getvalue()

    def __setfield_speeddialindex(self, value):
        if isinstance(value,LIST):
            self.__field_speeddialindex=value
        else:
            self.__field_speeddialindex=LIST(value,**{'elementclass': _gen_p_sanyo3200_236, 'length': _NUMSPEEDDIALS})

    def __delfield_speeddialindex(self): del self.__field_speeddialindex

    speeddialindex=property(__getfield_speeddialindex, __setfield_speeddialindex, __delfield_speeddialindex, None)

    def __getfield_longnumbersindex(self):
        try: self.__field_longnumbersindex
        except:
            self.__field_longnumbersindex=LIST(**{'elementclass': _gen_p_sanyo3200_238, 'length': _NUMLONGNUMBERS})
        return self.__field_longnumbersindex.getvalue()

    def __setfield_longnumbersindex(self, value):
        if isinstance(value,LIST):
            self.__field_longnumbersindex=value
        else:
            self.__field_longnumbersindex=LIST(value,**{'elementclass': _gen_p_sanyo3200_238, 'length': _NUMLONGNUMBERS})

    def __delfield_longnumbersindex(self): del self.__field_longnumbersindex

    longnumbersindex=property(__getfield_longnumbersindex, __setfield_longnumbersindex, __delfield_longnumbersindex, None)

    def __getfield_emails(self):
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_sanyo3200_240, 'length': _NUMPBSLOTS})
        return self.__field_emails.getvalue()

    def __setfield_emails(self, value):
        if isinstance(value,LIST):
            self.__field_emails=value
        else:
            self.__field_emails=LIST(value,**{'elementclass': _gen_p_sanyo3200_240, 'length': _NUMPBSLOTS})

    def __delfield_emails(self): del self.__field_emails

    emails=property(__getfield_emails, __setfield_emails, __delfield_emails, "Sorted list of slots with Email")

    def __getfield_emailfirstletters(self):
        return self.__field_emailfirstletters.getvalue()

    def __setfield_emailfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_emailfirstletters=value
        else:
            self.__field_emailfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})

    def __delfield_emailfirstletters(self): del self.__field_emailfirstletters

    emailfirstletters=property(__getfield_emailfirstletters, __setfield_emailfirstletters, __delfield_emailfirstletters, "First letters in sort order")

    def __getfield_urls(self):
        try: self.__field_urls
        except:
            self.__field_urls=LIST(**{'elementclass': _gen_p_sanyo3200_243, 'length': _NUMPBSLOTS})
        return self.__field_urls.getvalue()

    def __setfield_urls(self, value):
        if isinstance(value,LIST):
            self.__field_urls=value
        else:
            self.__field_urls=LIST(value,**{'elementclass': _gen_p_sanyo3200_243, 'length': _NUMPBSLOTS})

    def __delfield_urls(self): del self.__field_urls

    urls=property(__getfield_urls, __setfield_urls, __delfield_urls, "Sorted list of slots with a URL")

    def __getfield_urlfirstletters(self):
        return self.__field_urlfirstletters.getvalue()

    def __setfield_urlfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_urlfirstletters=value
        else:
            self.__field_urlfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})

    def __delfield_urlfirstletters(self): del self.__field_urlfirstletters

    urlfirstletters=property(__getfield_urlfirstletters, __setfield_urlfirstletters, __delfield_urlfirstletters, "First letters in sort order")

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 162})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 162})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('usedflags', self.__field_usedflags, None)
        yield ('slotsused', self.__field_slotsused, None)
        yield ('slotsused2', self.__field_slotsused2, "Always seems to be the same.  Why duplicated?")
        yield ('numemail', self.__field_numemail, "Num of slots with email")
        yield ('numurl', self.__field_numurl, "Num of slots with URL")
        yield ('firsttypes', self.__field_firsttypes, None)
        yield ('sortorder', self.__field_sortorder, None)
        yield ('pbfirstletters', self.__field_pbfirstletters, None)
        yield ('sortorder2', self.__field_sortorder2, "Is this the same")
        yield ('speeddialindex', self.__field_speeddialindex, None)
        yield ('longnumbersindex', self.__field_longnumbersindex, None)
        yield ('emails', self.__field_emails, "Sorted list of slots with Email")
        yield ('emailfirstletters', self.__field_emailfirstletters, "First letters in sort order")
        yield ('urls', self.__field_urls, "Sorted list of slots with a URL")
        yield ('urlfirstletters', self.__field_urlfirstletters, "First letters in sort order")
        yield ('pad', self.__field_pad, None)




class _gen_p_sanyo3200_223(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_223,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_223:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_223,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_223,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo3200_229(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['firsttype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_229,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_229:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_229,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_229,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_firsttype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_firsttype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_firsttype=UINT(**{'sizeinbytes': 1})
        self.__field_firsttype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_firsttype(self):
        return self.__field_firsttype.getvalue()

    def __setfield_firsttype(self, value):
        if isinstance(value,UINT):
            self.__field_firsttype=value
        else:
            self.__field_firsttype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_firsttype(self): del self.__field_firsttype

    firsttype=property(__getfield_firsttype, __setfield_firsttype, __delfield_firsttype, "First phone number type in each slot")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('firsttype', self.__field_firsttype, "First phone number type in each slot")




class _gen_p_sanyo3200_231(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_231,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_231:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_231,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_231,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo3200_234(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_234,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_234:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_234,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_234,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo3200_236(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslotandtype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_236,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_236:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_236,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_236,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslotandtype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslotandtype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslotandtype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslotandtype(self):
        return self.__field_pbslotandtype.getvalue()

    def __setfield_pbslotandtype(self, value):
        if isinstance(value,UINT):
            self.__field_pbslotandtype=value
        else:
            self.__field_pbslotandtype=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslotandtype(self): del self.__field_pbslotandtype

    pbslotandtype=property(__getfield_pbslotandtype, __setfield_pbslotandtype, __delfield_pbslotandtype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslotandtype', self.__field_pbslotandtype, None)




class _gen_p_sanyo3200_238(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslotandtype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_238,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_238:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_238,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_238,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslotandtype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslotandtype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslotandtype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslotandtype(self):
        return self.__field_pbslotandtype.getvalue()

    def __setfield_pbslotandtype(self, value):
        if isinstance(value,UINT):
            self.__field_pbslotandtype=value
        else:
            self.__field_pbslotandtype=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslotandtype(self): del self.__field_pbslotandtype

    pbslotandtype=property(__getfield_pbslotandtype, __setfield_pbslotandtype, __delfield_pbslotandtype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslotandtype', self.__field_pbslotandtype, None)




class _gen_p_sanyo3200_240(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_240,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_240:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_240,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_240,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo3200_243(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo3200_243,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo3200_243:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo3200_243,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo3200_243,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class wallpaperbuffer(BaseProtogenClass):
    "Addition buffer of wallpaper assignment info"
    __fields=['numpbslots', 'startcommand', 'bufsize', 'comment', 'wallpapers', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(wallpaperbuffer,self).__init__(**dict)
        if self.__class__ is wallpaperbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(wallpaperbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(wallpaperbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_numpbslots
        except:
            self.__field_numpbslots=UINT(**{'constant': _NUMPBSLOTS})
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x69})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 2048})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "wallpaper assignment info"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})
        self.__field_wallpapers.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 548})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_wallpapers=LIST(**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})
        self.__field_wallpapers.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 548})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numpbslots(self):
        return self.__field_numpbslots.getvalue()

    def __setfield_numpbslots(self, value):
        if isinstance(value,UINT):
            self.__field_numpbslots=value
        else:
            self.__field_numpbslots=UINT(value,**{'constant': _NUMPBSLOTS})

    def __delfield_numpbslots(self): del self.__field_numpbslots

    numpbslots=property(__getfield_numpbslots, __setfield_numpbslots, __delfield_numpbslots, "Number of phone book slots")

    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x69})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 2048})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "wallpaper assignment info"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "wallpaper assignment info"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_wallpapers(self):
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})
        return self.__field_wallpapers.getvalue()

    def __setfield_wallpapers(self, value):
        if isinstance(value,LIST):
            self.__field_wallpapers=value
        else:
            self.__field_wallpapers=LIST(value,**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})

    def __delfield_wallpapers(self): del self.__field_wallpapers

    wallpapers=property(__getfield_wallpapers, __setfield_wallpapers, __delfield_wallpapers, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 548})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 548})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numpbslots', self.__field_numpbslots, "Number of phone book slots")
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('wallpapers', self.__field_wallpapers, None)
        yield ('pad', self.__field_pad, None)




class messagerequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messagerequest,self).__init__(**dict)
        if self.__class__ is messagerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messagerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messagerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0xe1})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0xe1})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0xe1})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,                   'command': 0xe1})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class messagesentrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messagesentrequest,self).__init__(**dict)
        if self.__class__ is messagesentrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messagesentrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messagesentrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0d,                   'command': 0x55})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0d,                   'command': 0x55})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0d,                   'command': 0x55})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0d,                   'command': 0x55})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class messageentry(BaseProtogenClass):
    __fields=['slot', 'read', 'counter', 'pad1', 'dunno1', 'dunno2', 'dunno3', 'pad2', 'dunno4', 'dunno5', 'pad3', 'message_len', 'message', 'pad4', 'year', 'month', 'day', 'hour', 'minute', 'second', 'callback_len', 'callback', 'phonenum_len', 'phonenum', 'dunno6', 'priority', 'pad6', 'dunno7', 'dunno8']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messageentry,self).__init__(**dict)
        if self.__class__ is messageentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messageentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messageentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_read.writetobuffer(buf)
        self.__field_counter.writetobuffer(buf)
        self.__field_pad1.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_pad2.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self.__field_dunno5.writetobuffer(buf)
        self.__field_pad3.writetobuffer(buf)
        self.__field_message_len.writetobuffer(buf)
        self.__field_message.writetobuffer(buf)
        self.__field_pad4.writetobuffer(buf)
        self.__field_year.writetobuffer(buf)
        self.__field_month.writetobuffer(buf)
        self.__field_day.writetobuffer(buf)
        self.__field_hour.writetobuffer(buf)
        self.__field_minute.writetobuffer(buf)
        self.__field_second.writetobuffer(buf)
        self.__field_callback_len.writetobuffer(buf)
        self.__field_callback.writetobuffer(buf)
        self.__field_phonenum_len.writetobuffer(buf)
        self.__field_phonenum.writetobuffer(buf)
        self.__field_dunno6.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        self.__field_pad6.writetobuffer(buf)
        self.__field_dunno7.writetobuffer(buf)
        self.__field_dunno8.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_read=UINT(**{'sizeinbytes': 1})
        self.__field_read.readfrombuffer(buf)
        self.__field_counter=UINT(**{'sizeinbytes': 1})
        self.__field_counter.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 1})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_dunno2=UINT(**{'sizeinbytes': 1})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_dunno3=UINT(**{'sizeinbytes': 1})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad2.readfrombuffer(buf)
        self.__field_dunno4=UINT(**{'sizeinbytes': 1})
        self.__field_dunno4.readfrombuffer(buf)
        self.__field_dunno5=UINT(**{'sizeinbytes': 1})
        self.__field_dunno5.readfrombuffer(buf)
        self.__field_pad3=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad3.readfrombuffer(buf)
        self.__field_message_len=UINT(**{'sizeinbytes': 1})
        self.__field_message_len.readfrombuffer(buf)
        self.__field_message=USTRING(**{'sizeinbytes': 255})
        self.__field_message.readfrombuffer(buf)
        self.__field_pad4=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad4.readfrombuffer(buf)
        self.__field_year=UINT(**{'sizeinbytes': 1})
        self.__field_year.readfrombuffer(buf)
        self.__field_month=UINT(**{'sizeinbytes': 1})
        self.__field_month.readfrombuffer(buf)
        self.__field_day=UINT(**{'sizeinbytes': 1})
        self.__field_day.readfrombuffer(buf)
        self.__field_hour=UINT(**{'sizeinbytes': 1})
        self.__field_hour.readfrombuffer(buf)
        self.__field_minute=UINT(**{'sizeinbytes': 1})
        self.__field_minute.readfrombuffer(buf)
        self.__field_second=UINT(**{'sizeinbytes': 1})
        self.__field_second.readfrombuffer(buf)
        self.__field_callback_len=UINT(**{'sizeinbytes': 1})
        self.__field_callback_len.readfrombuffer(buf)
        self.__field_callback=USTRING(**{'sizeinbytes': 34})
        self.__field_callback.readfrombuffer(buf)
        self.__field_phonenum_len=UINT(**{'sizeinbytes': 1})
        self.__field_phonenum_len.readfrombuffer(buf)
        self.__field_phonenum=USTRING(**{'sizeinbytes': 37})
        self.__field_phonenum.readfrombuffer(buf)
        self.__field_dunno6=UINT(**{'sizeinbytes': 1})
        self.__field_dunno6.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 1})
        self.__field_priority.readfrombuffer(buf)
        self.__field_pad6=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad6.readfrombuffer(buf)
        self.__field_dunno7=UINT(**{'sizeinbytes': 1})
        self.__field_dunno7.readfrombuffer(buf)
        self.__field_dunno8=UINT(**{'sizeinbytes': 1})
        self.__field_dunno8.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_read(self):
        return self.__field_read.getvalue()

    def __setfield_read(self, value):
        if isinstance(value,UINT):
            self.__field_read=value
        else:
            self.__field_read=UINT(value,**{'sizeinbytes': 1})

    def __delfield_read(self): del self.__field_read

    read=property(__getfield_read, __setfield_read, __delfield_read, None)

    def __getfield_counter(self):
        return self.__field_counter.getvalue()

    def __setfield_counter(self, value):
        if isinstance(value,UINT):
            self.__field_counter=value
        else:
            self.__field_counter=UINT(value,**{'sizeinbytes': 1})

    def __delfield_counter(self): del self.__field_counter

    counter=property(__getfield_counter, __setfield_counter, __delfield_counter, None)

    def __getfield_pad1(self):
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UINT):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UINT):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_pad2(self):
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UINT):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def __getfield_dunno5(self):
        return self.__field_dunno5.getvalue()

    def __setfield_dunno5(self, value):
        if isinstance(value,UINT):
            self.__field_dunno5=value
        else:
            self.__field_dunno5=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno5(self): del self.__field_dunno5

    dunno5=property(__getfield_dunno5, __setfield_dunno5, __delfield_dunno5, None)

    def __getfield_pad3(self):
        return self.__field_pad3.getvalue()

    def __setfield_pad3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad3=value
        else:
            self.__field_pad3=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad3(self): del self.__field_pad3

    pad3=property(__getfield_pad3, __setfield_pad3, __delfield_pad3, None)

    def __getfield_message_len(self):
        return self.__field_message_len.getvalue()

    def __setfield_message_len(self, value):
        if isinstance(value,UINT):
            self.__field_message_len=value
        else:
            self.__field_message_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_message_len(self): del self.__field_message_len

    message_len=property(__getfield_message_len, __setfield_message_len, __delfield_message_len, None)

    def __getfield_message(self):
        return self.__field_message.getvalue()

    def __setfield_message(self, value):
        if isinstance(value,USTRING):
            self.__field_message=value
        else:
            self.__field_message=USTRING(value,**{'sizeinbytes': 255})

    def __delfield_message(self): del self.__field_message

    message=property(__getfield_message, __setfield_message, __delfield_message, "Text of the notification")

    def __getfield_pad4(self):
        return self.__field_pad4.getvalue()

    def __setfield_pad4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad4=value
        else:
            self.__field_pad4=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad4(self): del self.__field_pad4

    pad4=property(__getfield_pad4, __setfield_pad4, __delfield_pad4, None)

    def __getfield_year(self):
        return self.__field_year.getvalue()

    def __setfield_year(self, value):
        if isinstance(value,UINT):
            self.__field_year=value
        else:
            self.__field_year=UINT(value,**{'sizeinbytes': 1})

    def __delfield_year(self): del self.__field_year

    year=property(__getfield_year, __setfield_year, __delfield_year, None)

    def __getfield_month(self):
        return self.__field_month.getvalue()

    def __setfield_month(self, value):
        if isinstance(value,UINT):
            self.__field_month=value
        else:
            self.__field_month=UINT(value,**{'sizeinbytes': 1})

    def __delfield_month(self): del self.__field_month

    month=property(__getfield_month, __setfield_month, __delfield_month, None)

    def __getfield_day(self):
        return self.__field_day.getvalue()

    def __setfield_day(self, value):
        if isinstance(value,UINT):
            self.__field_day=value
        else:
            self.__field_day=UINT(value,**{'sizeinbytes': 1})

    def __delfield_day(self): del self.__field_day

    day=property(__getfield_day, __setfield_day, __delfield_day, None)

    def __getfield_hour(self):
        return self.__field_hour.getvalue()

    def __setfield_hour(self, value):
        if isinstance(value,UINT):
            self.__field_hour=value
        else:
            self.__field_hour=UINT(value,**{'sizeinbytes': 1})

    def __delfield_hour(self): del self.__field_hour

    hour=property(__getfield_hour, __setfield_hour, __delfield_hour, None)

    def __getfield_minute(self):
        return self.__field_minute.getvalue()

    def __setfield_minute(self, value):
        if isinstance(value,UINT):
            self.__field_minute=value
        else:
            self.__field_minute=UINT(value,**{'sizeinbytes': 1})

    def __delfield_minute(self): del self.__field_minute

    minute=property(__getfield_minute, __setfield_minute, __delfield_minute, None)

    def __getfield_second(self):
        return self.__field_second.getvalue()

    def __setfield_second(self, value):
        if isinstance(value,UINT):
            self.__field_second=value
        else:
            self.__field_second=UINT(value,**{'sizeinbytes': 1})

    def __delfield_second(self): del self.__field_second

    second=property(__getfield_second, __setfield_second, __delfield_second, None)

    def __getfield_callback_len(self):
        return self.__field_callback_len.getvalue()

    def __setfield_callback_len(self, value):
        if isinstance(value,UINT):
            self.__field_callback_len=value
        else:
            self.__field_callback_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_len(self): del self.__field_callback_len

    callback_len=property(__getfield_callback_len, __setfield_callback_len, __delfield_callback_len, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,USTRING):
            self.__field_callback=value
        else:
            self.__field_callback=USTRING(value,**{'sizeinbytes': 34})

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_phonenum_len(self):
        return self.__field_phonenum_len.getvalue()

    def __setfield_phonenum_len(self, value):
        if isinstance(value,UINT):
            self.__field_phonenum_len=value
        else:
            self.__field_phonenum_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenum_len(self): del self.__field_phonenum_len

    phonenum_len=property(__getfield_phonenum_len, __setfield_phonenum_len, __delfield_phonenum_len, None)

    def __getfield_phonenum(self):
        return self.__field_phonenum.getvalue()

    def __setfield_phonenum(self, value):
        if isinstance(value,USTRING):
            self.__field_phonenum=value
        else:
            self.__field_phonenum=USTRING(value,**{'sizeinbytes': 37})

    def __delfield_phonenum(self): del self.__field_phonenum

    phonenum=property(__getfield_phonenum, __setfield_phonenum, __delfield_phonenum, None)

    def __getfield_dunno6(self):
        return self.__field_dunno6.getvalue()

    def __setfield_dunno6(self, value):
        if isinstance(value,UINT):
            self.__field_dunno6=value
        else:
            self.__field_dunno6=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno6(self): del self.__field_dunno6

    dunno6=property(__getfield_dunno6, __setfield_dunno6, __delfield_dunno6, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_pad6(self):
        return self.__field_pad6.getvalue()

    def __setfield_pad6(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad6=value
        else:
            self.__field_pad6=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_pad6(self): del self.__field_pad6

    pad6=property(__getfield_pad6, __setfield_pad6, __delfield_pad6, None)

    def __getfield_dunno7(self):
        return self.__field_dunno7.getvalue()

    def __setfield_dunno7(self, value):
        if isinstance(value,UINT):
            self.__field_dunno7=value
        else:
            self.__field_dunno7=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno7(self): del self.__field_dunno7

    dunno7=property(__getfield_dunno7, __setfield_dunno7, __delfield_dunno7, None)

    def __getfield_dunno8(self):
        return self.__field_dunno8.getvalue()

    def __setfield_dunno8(self, value):
        if isinstance(value,UINT):
            self.__field_dunno8=value
        else:
            self.__field_dunno8=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno8(self): del self.__field_dunno8

    dunno8=property(__getfield_dunno8, __setfield_dunno8, __delfield_dunno8, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('read', self.__field_read, None)
        yield ('counter', self.__field_counter, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('pad2', self.__field_pad2, None)
        yield ('dunno4', self.__field_dunno4, None)
        yield ('dunno5', self.__field_dunno5, None)
        yield ('pad3', self.__field_pad3, None)
        yield ('message_len', self.__field_message_len, None)
        yield ('message', self.__field_message, "Text of the notification")
        yield ('pad4', self.__field_pad4, None)
        yield ('year', self.__field_year, None)
        yield ('month', self.__field_month, None)
        yield ('day', self.__field_day, None)
        yield ('hour', self.__field_hour, None)
        yield ('minute', self.__field_minute, None)
        yield ('second', self.__field_second, None)
        yield ('callback_len', self.__field_callback_len, None)
        yield ('callback', self.__field_callback, None)
        yield ('phonenum_len', self.__field_phonenum_len, None)
        yield ('phonenum', self.__field_phonenum, None)
        yield ('dunno6', self.__field_dunno6, None)
        yield ('priority', self.__field_priority, None)
        yield ('pad6', self.__field_pad6, None)
        yield ('dunno7', self.__field_dunno7, None)
        yield ('dunno8', self.__field_dunno8, None)




class messageresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messageresponse,self).__init__(**dict)
        if self.__class__ is messageresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messageresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messageresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=messageentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,messageentry):
            self.__field_entry=value
        else:
            self.__field_entry=messageentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class messagesentresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messagesentresponse,self).__init__(**dict)
        if self.__class__ is messagesentresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messagesentresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messagesentresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=messageentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,messageentry):
            self.__field_entry=value
        else:
            self.__field_entry=messageentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class foldernamerequest(BaseProtogenClass):
    __fields=['header', 'index', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(foldernamerequest,self).__init__(**dict)
        if self.__class__ is foldernamerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(foldernamerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(foldernamerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0b, 'command': 0xef})
        self.__field_header.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0b, 'command': 0xef})
        self.__field_header.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 1})
        self.__field_index.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0b, 'command': 0xef})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0b, 'command': 0xef})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 1})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('index', self.__field_index, None)
        yield ('pad', self.__field_pad, None)




class foldernameentry(BaseProtogenClass):
    __fields=['index', 'flag', 'autofile', 'notify', 'icon', 'name', 'pad', 'keyword']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(foldernameentry,self).__init__(**dict)
        if self.__class__ is foldernameentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(foldernameentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(foldernameentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_index.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_autofile.writetobuffer(buf)
        self.__field_notify.writetobuffer(buf)
        self.__field_icon.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad.writetobuffer(buf)
        self.__field_keyword.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 1})
        self.__field_index.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_autofile=UINT(**{'sizeinbytes': 1})
        self.__field_autofile.readfrombuffer(buf)
        self.__field_notify=UINT(**{'sizeinbytes': 1})
        self.__field_notify.readfrombuffer(buf)
        self.__field_icon=UINT(**{'sizeinbytes': 1})
        self.__field_icon.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 13, 'raiseonunterminatedread': False})
        self.__field_name.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad.readfrombuffer(buf)
        self.__field_keyword=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False})
        self.__field_keyword.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 1})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0 if empty, 1 in use")

    def __getfield_autofile(self):
        return self.__field_autofile.getvalue()

    def __setfield_autofile(self, value):
        if isinstance(value,UINT):
            self.__field_autofile=value
        else:
            self.__field_autofile=UINT(value,**{'sizeinbytes': 1})

    def __delfield_autofile(self): del self.__field_autofile

    autofile=property(__getfield_autofile, __setfield_autofile, __delfield_autofile, "If 1, autofile messages with keyword")

    def __getfield_notify(self):
        return self.__field_notify.getvalue()

    def __setfield_notify(self, value):
        if isinstance(value,UINT):
            self.__field_notify=value
        else:
            self.__field_notify=UINT(value,**{'sizeinbytes': 1})

    def __delfield_notify(self): del self.__field_notify

    notify=property(__getfield_notify, __setfield_notify, __delfield_notify, None)

    def __getfield_icon(self):
        return self.__field_icon.getvalue()

    def __setfield_icon(self, value):
        if isinstance(value,UINT):
            self.__field_icon=value
        else:
            self.__field_icon=UINT(value,**{'sizeinbytes': 1})

    def __delfield_icon(self): del self.__field_icon

    icon=property(__getfield_icon, __setfield_icon, __delfield_icon, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 13, 'raiseonunterminatedread': False})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, "Name of the folder")

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 3})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def __getfield_keyword(self):
        return self.__field_keyword.getvalue()

    def __setfield_keyword(self, value):
        if isinstance(value,USTRING):
            self.__field_keyword=value
        else:
            self.__field_keyword=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False})

    def __delfield_keyword(self): del self.__field_keyword

    keyword=property(__getfield_keyword, __setfield_keyword, __delfield_keyword, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)
        yield ('flag', self.__field_flag, "0 if empty, 1 in use")
        yield ('autofile', self.__field_autofile, "If 1, autofile messages with keyword")
        yield ('notify', self.__field_notify, None)
        yield ('icon', self.__field_icon, None)
        yield ('name', self.__field_name, "Name of the folder")
        yield ('pad', self.__field_pad, None)
        yield ('keyword', self.__field_keyword, None)




class foldernameresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(foldernameresponse,self).__init__(**dict)
        if self.__class__ is foldernameresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(foldernameresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(foldernameresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=foldernameentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 467})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,foldernameentry):
            self.__field_entry=value
        else:
            self.__field_entry=foldernameentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 467})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class todorequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(todorequest,self).__init__(**dict)
        if self.__class__ is todorequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(todorequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(todorequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,'command': 0x25})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,'command': 0x25})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,'command': 0x25})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,'command': 0x25})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class todoentry(BaseProtogenClass):
    __fields=['slot', 'flag', 'todo', 'pad1', 'todo_len', 'priority', 'dunno', 'order']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(todoentry,self).__init__(**dict)
        if self.__class__ is todoentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(todoentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(todoentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_todo.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.writetobuffer(buf)
        self.__field_todo_len.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 1})
        self.__field_dunno.writetobuffer(buf)
        self.__field_order.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_todo=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False})
        self.__field_todo.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_todo_len=UINT(**{'sizeinbytes': 1})
        self.__field_todo_len.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 1})
        self.__field_priority.readfrombuffer(buf)
        self.__field_dunno=UINT(**{'sizeinbytes': 1})
        self.__field_dunno.readfrombuffer(buf)
        self.__field_order=UINT(**{'sizeinbytes': 1})
        self.__field_order.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0: Not used, 1: Used")

    def __getfield_todo(self):
        return self.__field_todo.getvalue()

    def __setfield_todo(self, value):
        if isinstance(value,USTRING):
            self.__field_todo=value
        else:
            self.__field_todo=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False})

    def __delfield_todo(self): del self.__field_todo

    todo=property(__getfield_todo, __setfield_todo, __delfield_todo, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_todo_len(self):
        return self.__field_todo_len.getvalue()

    def __setfield_todo_len(self, value):
        if isinstance(value,UINT):
            self.__field_todo_len=value
        else:
            self.__field_todo_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_todo_len(self): del self.__field_todo_len

    todo_len=property(__getfield_todo_len, __setfield_todo_len, __delfield_todo_len, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, "0: Normal, 1: Urgent, 2: Done")

    def __getfield_dunno(self):
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 1})
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UINT):
            self.__field_dunno=value
        else:
            self.__field_dunno=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, "Maybe always zero")

    def __getfield_order(self):
        return self.__field_order.getvalue()

    def __setfield_order(self, value):
        if isinstance(value,UINT):
            self.__field_order=value
        else:
            self.__field_order=UINT(value,**{'sizeinbytes': 1})

    def __delfield_order(self): del self.__field_order

    order=property(__getfield_order, __setfield_order, __delfield_order, "Gets sorted on screen in this order")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, "0: Not used, 1: Used")
        yield ('todo', self.__field_todo, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('todo_len', self.__field_todo_len, None)
        yield ('priority', self.__field_priority, "0: Normal, 1: Urgent, 2: Done")
        yield ('dunno', self.__field_dunno, "Maybe always zero")
        yield ('order', self.__field_order, "Gets sorted on screen in this order")




class todoresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(todoresponse,self).__init__(**dict)
        if self.__class__ is todoresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(todoresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(todoresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=todoentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 472})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,todoentry):
            self.__field_entry=value
        else:
            self.__field_entry=todoentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 472})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class historyrequest(BaseProtogenClass):
    __fields=['type', 'header', 'header', 'header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historyrequest,self).__init__(**dict)
        if self.__class__ is historyrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historyrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historyrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_type
        except:
            self.__field_type=UINT()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if self.type==OUTGOING:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3d})
            self.__field_header.writetobuffer(buf)
        if self.type==INCOMING:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3e})
            self.__field_header.writetobuffer(buf)
        if self.type==MISSED:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3f})
            self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        if self.type==OUTGOING:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3d})
            self.__field_header.readfrombuffer(buf)
        if self.type==INCOMING:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3e})
            self.__field_header.readfrombuffer(buf)
        if self.type==MISSED:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3f})
            self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,)

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, "0: Outgoing, 1: Incoming, 2: Missed")

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3d})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x3d})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3e})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x3e})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3f})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x3f})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('type', self.__field_type, "0: Outgoing, 1: Incoming, 2: Missed")
        if self.type==OUTGOING:
            yield ('header', self.__field_header, None)
        if self.type==INCOMING:
            yield ('header', self.__field_header, None)
        if self.type==MISSED:
            yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class historyentry(BaseProtogenClass):
    __fields=['slot', 'date', 'phonenumlen', 'phonenum', 'name']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historyentry,self).__init__(**dict)
        if self.__class__ is historyentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historyentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historyentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_phonenumlen.writetobuffer(buf)
        self.__field_phonenum.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 2})
        self.__field_slot.readfrombuffer(buf)
        self.__field_date=GPSDATE(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_phonenumlen=UINT(**{'sizeinbytes': 1})
        self.__field_phonenumlen.readfrombuffer(buf)
        self.__field_phonenum=USTRING(**{'sizeinbytes': 48, 'raiseonunterminatedread': False})
        self.__field_phonenum.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_name.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,GPSDATE):
            self.__field_date=value
        else:
            self.__field_date=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_phonenumlen(self):
        return self.__field_phonenumlen.getvalue()

    def __setfield_phonenumlen(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumlen=value
        else:
            self.__field_phonenumlen=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenumlen(self): del self.__field_phonenumlen

    phonenumlen=property(__getfield_phonenumlen, __setfield_phonenumlen, __delfield_phonenumlen, None)

    def __getfield_phonenum(self):
        return self.__field_phonenum.getvalue()

    def __setfield_phonenum(self, value):
        if isinstance(value,USTRING):
            self.__field_phonenum=value
        else:
            self.__field_phonenum=USTRING(value,**{'sizeinbytes': 48, 'raiseonunterminatedread': False})

    def __delfield_phonenum(self): del self.__field_phonenum

    phonenum=property(__getfield_phonenum, __setfield_phonenum, __delfield_phonenum, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('date', self.__field_date, None)
        yield ('phonenumlen', self.__field_phonenumlen, None)
        yield ('phonenum', self.__field_phonenum, None)
        yield ('name', self.__field_name, None)




class historyresponse(BaseProtogenClass):
    __fields=['header', 'entry']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historyresponse,self).__init__(**dict)
        if self.__class__ is historyresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historyresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historyresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=historyentry()
        self.__field_entry.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,historyentry):
            self.__field_entry=value
        else:
            self.__field_entry=historyentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)




