/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:57:09 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class StringVector_ESTest extends StringVector_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("", "Zu_RCRSaz?Bjx-h;Y=4", true);
      StringVector stringVector1 = stringVector0.copy();
      assertEquals(0, stringVector1.capacity());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        StringVector.getStrings((String) null, "ET8igw/ZK]xvGYDDF|=", false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      // Undeclared exception!
      try { 
        StringVector.getStrings((String) null, " of declared type ");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        StringVector.getStrings((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      StringVector stringVector0 = null;
      try {
        stringVector0 = new StringVector((String[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      StringVector stringVector0 = null;
      try {
        stringVector0 = new StringVector((StringVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("NA", "NA", false);
      assertEquals(0, stringVector0.size());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("u", "TIME TAKEN ", true);
      assertEquals("[u]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("3q\"d18Gmp;U5~2@-G", "@Xx CkHOUMZ{fp2h", false);
      assertEquals("[3q\"d18Gmp;U5~2@-G]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      StringVector stringVector0 = new StringVector();
      assertEquals("[]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings(" {");
      assertEquals("[{]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("alt name cannot be null", " ");
      assertEquals("[alt, name, cannot, be, null]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "H%.}+r";
      stringArray0[3] = "H%.}+r";
      StringVector stringVector0 = new StringVector(stringArray0);
      stringVector0.sort();
      assertEquals("[null, null, null, null, null, null, H%.}+r, H%.}+r]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[3] = "H%.}+r";
      StringVector stringVector0 = new StringVector(stringArray0);
      stringVector0.sort();
      assertEquals("[null, null, null, null, null, null, null, H%.}+r]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      String[] stringArray0 = new String[8];
      StringVector stringVector0 = new StringVector(stringArray0);
      StringVector stringVector1 = new StringVector(stringVector0);
      stringVector1.add(stringVector0);
      assertFalse(stringVector1.equals((Object)stringVector0));
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("KT", "KT");
      assertTrue(stringVector0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("");
      // Undeclared exception!
      try { 
        stringVector0.add((StringVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("KT", "KT", true);
      assertEquals("[]", stringVector0.toString());
      assertFalse(stringVector0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      String[] stringArray0 = new String[8];
      StringVector stringVector0 = new StringVector(stringArray0);
      StringVector stringVector1 = stringVector0.copy();
      assertEquals("[null, null, null, null, null, null, null, null]", stringVector1.toString());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      StringVector stringVector0 = new StringVector("~AWxRh");
      // Undeclared exception!
      stringVector0.add(stringVector0);
  }
}
