/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:32:53 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MarkerChangeEvent_ESTest extends MarkerChangeEvent_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("TQeFCz^FW");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstCodingBaseMarker();
      MarkerChangeEvent markerChangeEvent0 = new MarkerChangeEvent(marker0, (Strand) null, 5);
      Strand strand0 = markerChangeEvent0.getStrand();
      assertNull(strand0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uk.ac.sanger.artemis.sequence.MarkerChangeEvent");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = new Strand(bases0, (-52));
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerChangeEvent markerChangeEvent0 = new MarkerChangeEvent(marker0, strand0, 1089);
      Strand strand1 = markerChangeEvent0.getStrand();
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      MarkerChangeEvent markerChangeEvent0 = null;
      try {
        markerChangeEvent0 = new MarkerChangeEvent((Marker) null, (Strand) null, 0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("TQeFCz^FW");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Marker marker0 = feature0.getFirstCodingBaseMarker();
      MarkerChangeEvent markerChangeEvent0 = new MarkerChangeEvent(marker0, (Strand) null, 5);
      markerChangeEvent0.getMarker();
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uk.ac.sanger.artemis.sequence.MarkerChangeEvent");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerChangeEvent markerChangeEvent0 = new MarkerChangeEvent(marker0, strand0, 1089);
      Strand strand1 = markerChangeEvent0.getStrand();
      assertSame(strand0, strand1);
  }
}
