val home_directory : string
val directory_in_home : string -> string
class configurator :
  ?defaults:string list ->
  ?directory:string ->
  ?primary_file:string ->
  unit ->
  object
    val mutable context : Configfile.context
    val mutable defaults : string list
    val mutable directory : string
    val mutable primary : string option
    method context : Configfile.context
    method ensure_directory_presence : unit
    method get : ?default:Configfile.t -> string -> Configfile.t
    method get_bool : ?default:bool -> string -> bool
    method get_int : ?default:int -> string -> int
    method get_string : ?default:string -> string -> string
    method get_string_pair : string -> string * string
    method load : ?merge_with:Configfile.t list -> unit -> (string * exn) list
    method load_defaults : (string * exn) list
    method path : string -> string
    method save : unit
    method set : string -> Configfile.t -> unit
    method set_bool : string -> bool -> unit
    method set_config : Configfile.t -> unit
    method set_context : Configfile.context -> unit
    method set_defaults : string list -> unit
    method set_directory : string -> unit
    method set_int : string -> int -> unit
    method set_primary : string -> unit
    method set_string : string -> string -> unit
    method set_string_pair : string -> string * string -> unit
  end
val duplicate : configurator -> configurator
