//
// anyRemote
// a wi-fi or bluetooth remote for your PC.
//
// Copyright (C) 2012-2014 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//
// Message queue related wrappers
//

#ifndef _QUEUE_H_
#define _QUEUE_H_ 1

#include "list.h"

enum QueueID {
    Q_DISP = 0,
    Q_FE,
    Q_EXEC,
    Q_MAIN,
    Q_WEB,
    Q_MAX
};

int   queueNew   (int id);
void* queuePop   (int id); 
int   queueCanPop(int id);
int   queuePush  (int id, void* data);
int   queueExists(int id);
void  queueRemove(int id, DestroyCallback func);

#endif
