
use warnings;
use strict;

use lib "util/subs/common";
use abinit_variables;

my $type = "";
my $cont = 0;
my $wait = 1;

my ($var,$grp,$i,@tmp1,@tmp2,%vars,%dims);

%vars = extract_variables("src/defs/defs_datatypes.F90","dataset_type");

open(OUT,">src/13iovars/is_input_variable.F90")
or die "Could not open src/13iovars/is_input_variable.F90 for writing";

print OUT <<EOF
!{\\src2tex{textfont=tt}}
!!****f* ABINIT/is_input_variable
!! NAME
!! is_input_variable
!!
!! FUNCTION
!!  Checks if the specified input variable is known to ABINIT
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (Y. Pouillon)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see ~abinit/doc/developers/contributors .
!!
!! INPUTS
!!  invar = name of the variable to check
!!
!! OUTPUT
!!  .true. if the variable is known to ABINIT, .false. else.
!!
!! NOTES
!!  This function has been automatically generated by a script:
!!  "~abinit/util/subs/iovars/make-sub-is_input_variable.pl".
!!
!!  Please do not edit this file. Since it is automatically generated,
!!  your changes would be systematically overwritten. You should
!!  directly modify the generating script itself to suit your needs
!!  instead.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
!no_abirules

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function is_input_variable(invar)

 implicit none

!Arguments ------------------------------------
 character(len=*),intent(in) :: invar

 logical :: is_input_variable

!Local variables-------------------------------

! ***************************************************************************

 is_input_variable = .false.

EOF
;

foreach $var (sort keys %vars)
{
	$var =~ s/\(.*//;
	printf OUT " if ( invar == \"%s\" ) is_input_variable = .true.\n",$var;
}

print OUT <<EOF

end function is_input_variable
!!***
EOF
;

close(OUT);
