#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Syberia: The World Before
# send your bug reports to contact@dotslashplay.it
###

script_version=20230126.2

GAME_ID='syberia-the-world-before-demo'
GAME_NAME='Syberia: The World Before - Prologue'

ARCHIVE_BASE_0='setup_syberia_the_world_before_prologue_1.0_(43455).exe'
ARCHIVE_BASE_0_MD5='22bd7e18e7cd06ddfbe94d262cef6cd9'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_syberia_the_world_before_prologue_1.0_(43455)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='153581ebbcce0a4608c7b700e9f1093c'
ARCHIVE_BASE_0_PART1_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='3400000'
ARCHIVE_BASE_0_VERSION='1.0-gog43455'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/syberia_the_world_before_demo'

UNITY3D_NAME='syberiatwbp'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
unityplayer.dll
monobleedingedge
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/plugins"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

WINE_DIRECT3D_RENDERER='dxvk'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/AppData/Roaming/SyberiaTWBP'
USER_PERSISTENT_FILES='
userdata/save.bin'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Add required user write access to game files

USER_PERSISTENT_FILES="$USER_PERSISTENT_FILES
${UNITY3D_NAME}_data/streamingassets/config.bin"

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
