#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Longest Journey
# send your bug reports to contact@dotslashplay.it
###

script_version=20230908.1

GAME_ID='the-longest-journey'
GAME_NAME='The Longest Journey'

ARCHIVE_BASE_1='setup_the_longest_journey_142_lang_update_(24607).exe'
ARCHIVE_BASE_1_MD5='540b2e016ab90dd509c53fc7df4397fd'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1='setup_the_longest_journey_142_lang_update_(24607)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='efb1cd664b1cbbd29d0e641ad2f81e05'
ARCHIVE_BASE_1_SIZE='1900000'
ARCHIVE_BASE_1_VERSION='142-gog24607'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_longest_journey'

ARCHIVE_BASE_0='setup_the_longest_journey_2.0.0.12.exe'
ARCHIVE_BASE_0_MD5='89b3cae144856579ed5fee10ecc76154'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1900000'
ARCHIVE_BASE_0_VERSION='142-gog2.0.0.12'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_MAIN_FILES='
global
static
fonts
??
x.xarc
game.exe
*.ini'
CONTENT_DOC_MAIN_FILES='
*.txt
*.pdf
*.html
tlj_faq_files'

APP_MAIN_SCUMMID='stark:tlj'
APP_MAIN_ICON='game.exe'

# Ensure easy upgrade from packages built with pre-20230908.1 game script
PKG_MAIN_PROVIDES='
the-longest-journey-data
the-longest-journey-scummvm
the-longest-journey-wine'

# Load common functions

target_version='2.25'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
