#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Rusty Lake Saga
# send your bug reports to contact@dotslashplay.it
###

script_version=20230103.1

GAME_ID_BASE='rusty-lake'
GAME_ID_HOTEL="${GAME_ID_BASE}-hotel"
GAME_ID_ROOTS="${GAME_ID_BASE}-roots"
GAME_ID_PARADISE="${GAME_ID_BASE}-paradise"

GAME_NAME_BASE='Rusty Lake'
GAME_NAME_HOTEL="$GAME_NAME_BASE Hotel"
GAME_NAME_ROOTS="$GAME_NAME_BASE Roots"
GAME_NAME_PARADISE="$GAME_NAME_BASE Paradise"

ARCHIVE_BASE_HOTEL_0='setup_rusty_lake_hotel_gog-1_(30681).exe'
ARCHIVE_BASE_HOTEL_0_MD5='a6121ae5cd353c8e86342e7b45cef9b4'
ARCHIVE_BASE_HOTEL_0_TYPE='innosetup'
ARCHIVE_BASE_HOTEL_0_SIZE='58000'
ARCHIVE_BASE_HOTEL_0_VERSION='1.0-gog30681'
ARCHIVE_BASE_HOTEL_0_URL='https://www.gog.com/game/rusty_lake_hotel'

ARCHIVE_BASE_ROOTS_0='setup_rusty_lake_roots_gog-1_(30681).exe'
ARCHIVE_BASE_ROOTS_0_MD5='dae526768d941d55dc80700cc4d3a678'
ARCHIVE_BASE_ROOTS_0_TYPE='innosetup'
ARCHIVE_BASE_ROOTS_0_SIZE='110000'
ARCHIVE_BASE_ROOTS_0_VERSION='1.0-gog30681'
ARCHIVE_BASE_ROOTS_0_URL='https://www.gog.com/game/rusty_lake_roots'

ARCHIVE_BASE_PARADISE_0='setup_rusty_lake_paradise_gog-1_(30704).exe'
ARCHIVE_BASE_PARADISE_0_MD5='5ff0a14bcc068232cb9948987474b503'
ARCHIVE_BASE_PARADISE_0_TYPE='innosetup'
ARCHIVE_BASE_PARADISE_0_SIZE='130000'
ARCHIVE_BASE_PARADISE_0_VERSION='1.0-gog30704'
ARCHIVE_BASE_PARADISE_0_URL='https://www.gog.com/game/rusty_lake_paradise'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
adobe?air
meta-inf'
CONTENT_GAME_BIN_FILES_HOTEL="$CONTENT_GAME_BIN_FILES
rustylakehotel.exe"
CONTENT_GAME_BIN_FILES_ROOTS="$CONTENT_GAME_BIN_FILES
rustylakeroots.exe"
CONTENT_GAME_BIN_FILES_PARADISE="$CONTENT_GAME_BIN_FILES
rustylakeparadise.exe"
CONTENT_GAME_DATA_FILES='
icons'
CONTENT_GAME_DATA_FILES_HOTEL="$CONTENT_GAME_DATA_FILES
rustylakehotel.swf"
CONTENT_GAME_DATA_FILES_ROOTS="$CONTENT_GAME_DATA_FILES
rustylakeroots.swf"
CONTENT_GAME_DATA_FILES_PARADISE="$CONTENT_GAME_DATA_FILES
paradise.swf
paradise-translations.xml"
CONTENT_DOC_DATA_FILES='
rusty?lake*read?me.pdf'

APP_MAIN_EXE_HOTEL='rustylakehotel.exe'
APP_MAIN_EXE_ROOTS='rustylakeroots.exe'
APP_MAIN_EXE_PARADISE='rustylakeparadise.exe'

APP_WINE_LINK_DIRS_HOTEL='
userdata:users/${USER}/AppData/Roaming/com.RustyLake.RustyLakeHotel'
APP_WINE_LINK_DIRS_ROOTS='
userdata:users/${USER}/Documents/Rusty Lake/Roots'
APP_WINE_LINK_DIRS_PARADISE='
userdata:users/${USER}/Documents/Rusty Lake/Paradise'
USER_PERSISTENT_DIRECTORIES='
userdata'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID_HOTEL="${GAME_ID_HOTEL}-data"
PKG_DATA_ID_ROOTS="${GAME_ID_ROOTS}-data"
PKG_DATA_ID_PARADISE="${GAME_ID_PARADISE}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS_HOTEL="$PKG_DATA_ID_HOTEL"
PKG_BIN_DEPS_ROOTS="$PKG_DATA_ID_ROOTS"
PKG_BIN_DEPS_PARADISE="$PKG_DATA_ID_PARADISE"

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
APP_MAIN_EXE=$(get_context_specific_value 'archive' 'APP_MAIN_EXE')
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary directories

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
APP_MAIN_EXE=$(get_context_specific_value 'archive' 'APP_MAIN_EXE')
APP_WINE_LINK_DIRS=$(get_context_specific_value 'archive' 'APP_WINE_LINK_DIRS')
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
