#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dragon Age: Origins
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220916.2

GAME_ID='dragon-age-origins'
GAME_NAME='Dragon Age: Origins'

ARCHIVE_BASE_0='setup_dragon_age_origins_ultimate_2.1.0.4.exe'
ARCHIVE_BASE_0_MD5='2bfdbc94523ef4c21476f64ef8029479'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--progress=1 --silent --lowercase --gog'
ARCHIVE_BASE_0_PART1='setup_dragon_age_origins_ultimate_2.1.0.4-1.bin'
ARCHIVE_BASE_0_PART1_MD5='b6e68b1b3b11fdddea809a5f11368036'
ARCHIVE_BASE_0_PART1_TYPE='rar'
ARCHIVE_BASE_0_PART2='setup_dragon_age_origins_ultimate_2.1.0.4-2.bin'
ARCHIVE_BASE_0_PART2_MD5='71d813d6827941a90422a40088d64b78'
ARCHIVE_BASE_0_PART3='setup_dragon_age_origins_ultimate_2.1.0.4-3.bin'
ARCHIVE_BASE_0_PART3_MD5='2ff9cc2bb41435429ee6277106a6a568'
ARCHIVE_BASE_0_PART4='setup_dragon_age_origins_ultimate_2.1.0.4-4.bin'
ARCHIVE_BASE_0_PART4_MD5='a25c58b43a2e468fcf72446f57542115'
ARCHIVE_BASE_0_PART5='setup_dragon_age_origins_ultimate_2.1.0.4-5.bin'
ARCHIVE_BASE_0_PART5_MD5='4ce5f6dceb01c9a1fc85c759c436b7b2'
ARCHIVE_BASE_0_PART6='setup_dragon_age_origins_ultimate_2.1.0.4-6.bin'
ARCHIVE_BASE_0_PART6_MD5='e2d13b236af30f210e0eb65aec5d137e'
ARCHIVE_BASE_0_VERSION='1.05-gog2.1.0.4'
ARCHIVE_BASE_0_SIZE='39000000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/dragon_age_origins'
## Add an explicit dependency on unar.
## This should no longer be required once the following issue is fixed:
## https://forge.dotslashplay.it/play.it/scripts/-/issues/335
SCRIPT_DEPS="$SCRIPT_DEPS unar"

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
bin_ship
daoriginslauncher.exe'
CONTENT_GAME_DATA_FILES='
addins
data
modules
offers
packages'
CONTENT_DOC_DATA_FILES='
manual.pdf'
CONTENT_DOC0_DATA_PATH="${CONTENT_PATH_DEFAULT}/docs"
CONTENT_DOC0_DATA_FILES='
*'
CONTENT_GAME_ENVIRONMENT_FILES='
addins/*/*/env
packages/*/env'
CONTENT_GAME_MOVIES_FILES='
addins/*/core/data/movies
modules/*/data/movies
packages/*/data/movies'
CONTENT_GAME_L10N_DE_FILES='
*/de-de
*/*_de-de*'
CONTENT_GAME_L10N_EN_FILES='
*/en-us
*/*_en-us*'
CONTENT_GAME_L10N_FR_FILES='
*/fr-fr
*/*_fr-fr*'
CONTENT_GAME_L10N_RU_FILES='
*/ru-ru
*/*_ru-ru*'
CONTENT_GAME_L10N_PL_FILES='
*/pl-pl
*/*_pl-pl*'
CONTENT_GAME_L10N_CS_FILES='
*/cs-cz
*/*_cs-cz*'
CONTENT_GAME_L10N_ES_FILES='
*/es-es
*/*_es-es*'
CONTENT_GAME_L10N_HU_FILES='
*/hu-hu
*/*_hu-hu*'
CONTENT_GAME_L10N_IT_FILES='
*/it-it
*/*_it-it*'
CONTENT_SETTINGS_PATH="${CONTENT_PATH_DEFAULT}/../support/userdocs"
CONTENT_SETTINGS_FILES='
*'
CONTENT_PHYSX_PATH="${CONTENT_PATH_DEFAULT}/redist"
CONTENT_PHYSX_FILES='
physx_9.09.0408_systemsoftware.exe'

APP_WINE_LINK_DIRS='
userdata:users/${USER}/Documents/BioWare/Dragon Age'

USER_PERSISTENT_DIRECTORIES='
userdata/characters
userdata/settings'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='bin_ship/daorigins.exe'
APP_MAIN_ICON="$APP_MAIN_EXE"

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_NAME="$GAME_NAME - Configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_TYPE='wine'
APP_CONFIG_EXE='bin_ship/daoriginsconfig.exe'
APP_CONFIG_ICON="$APP_CONFIG_EXE"

PACKAGES_LIST='PKG_BIN PKG_L10N_DE PKG_L10N_EN PKG_L10N_FR PKG_L10N_RU PKG_L10N_PL PKG_L10N_CS PKG_L10N_ES PKG_L10N_HU PKG_L10N_IT PKG_ENVIRONMENT PKG_MOVIES PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_ENVIRONMENT_ID="${GAME_ID}-environment"
PKG_ENVIRONMENT_DESCRIPTION='environment'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_L10N_ID="${GAME_ID}-l10n"

PKG_L10N_DE_ID="${PKG_L10N_ID}-de"
PKG_L10N_DE_PROVIDE="$PKG_L10N_ID"
PKG_L10N_DE_DESCRIPTION='German localization'
PKG_L10N_DE_DEPS="$GAME_ID"

PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_EN_PROVIDE="$PKG_L10N_ID"
PKG_L10N_EN_DESCRIPTION='English localization'
PKG_L10N_EN_DEPS="$GAME_ID"

PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_FR_PROVIDE="$PKG_L10N_ID"
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_FR_DEPS="$GAME_ID"

PKG_L10N_RU_ID="${PKG_L10N_ID}-ru"
PKG_L10N_RU_PROVIDE="$PKG_L10N_ID"
PKG_L10N_RU_DESCRIPTION='Russian localization'
PKG_L10N_RU_DEPS="$GAME_ID"

PKG_L10N_PL_ID="${PKG_L10N_ID}-pl"
PKG_L10N_PL_PROVIDE="$PKG_L10N_ID"
PKG_L10N_PL_DESCRIPTION='Polish localization'
PKG_L10N_PL_DEPS="$GAME_ID"

PKG_L10N_CS_ID="${PKG_L10N_ID}-cs"
PKG_L10N_CS_PROVIDE="$PKG_L10N_ID"
PKG_L10N_CS_DESCRIPTION='Czech localization'
PKG_L10N_CS_DEPS="$GAME_ID"

PKG_L10N_ES_ID="${PKG_L10N_ID}-es"
PKG_L10N_ES_PROVIDE="$PKG_L10N_ID"
PKG_L10N_ES_DESCRIPTION='Spanish localization'
PKG_L10N_ES_DEPS="$GAME_ID"

PKG_L10N_HU_ID="${PKG_L10N_ID}-hu"
PKG_L10N_HU_PROVIDE="$PKG_L10N_ID"
PKG_L10N_HU_DESCRIPTION='Hungarian localization'
PKG_L10N_HU_DEPS="$GAME_ID"

PKG_L10N_IT_ID="${PKG_L10N_ID}-it"
PKG_L10N_IT_PROVIDE="$PKG_L10N_ID"
PKG_L10N_IT_DESCRIPTION='Italian localization'
PKG_L10N_IT_DEPS="$GAME_ID"

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_ENVIRONMENT_ID $PKG_MOVIES_ID $PKG_DATA_ID"

# Install shipped build of PhysX

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Install shipped build of PhysX
if [ ! -e physx/installed ]; then
	wine physx/physx_9.09.0408_systemsoftware.exe
	touch physx/installed
fi'

# Load common functions

target_version='2.18'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	tolower .
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default
content_inclusion 'SETTINGS' 'PKG_DATA' "${PATH_GAME}/userdata/settings"
content_inclusion 'PHYSX' 'PKG_BIN' "${PATH_GAME}/physx"

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

common_packages='PKG_ENVIRONMENT PKG_MOVIES PKG_DATA PKG_BIN'
case "${LANG%_*}" in
	('fr')
		lang_string='version %s :'
		lang_de='allemande'
		lang_en='anglaise'
		lang_fr='française'
		lang_ru='russe'
		lang_pl='polonaise'
		lang_cs='tchèque'
		lang_es='espagnole'
		lang_hu='hongroise'
		lang_it='italienne'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_de='German'
		lang_en='English'
		lang_fr='French'
		lang_ru='Russian'
		lang_pl='Polish'
		lang_cs='Czech'
		lang_es='Spanish'
		lang_hu='Hungarian'
		lang_it='Italian'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_de"
print_instructions $common_packages 'PKG_L10N_DE'
printf "$lang_string" "$lang_en"
print_instructions $common_packages 'PKG_L10N_EN'
printf "$lang_string" "$lang_fr"
print_instructions $common_packages 'PKG_L10N_FR'
printf "$lang_string" "$lang_ru"
print_instructions $common_packages 'PKG_L10N_RU'
printf "$lang_string" "$lang_pl"
print_instructions $common_packages 'PKG_L10N_PL'
printf "$lang_string" "$lang_cs"
print_instructions $common_packages 'PKG_L10N_CS'
printf "$lang_string" "$lang_es"
print_instructions $common_packages 'PKG_L10N_ES'
printf "$lang_string" "$lang_hu"
print_instructions $common_packages 'PKG_L10N_HU'
printf "$lang_string" "$lang_it"
print_instructions $common_packages 'PKG_L10N_IT'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
