#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Ankh 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20230415.1

GAME_ID='ankh-1'
GAME_NAME='Ankh'

ARCHIVE_BASE_0='setup_ankh_-_anniversary_edition_1.0a_(34062).exe'
ARCHIVE_BASE_0_MD5='b1e6094c37d3da40352303c0a1f51f0c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='910000'
ARCHIVE_BASE_0_VERSION='1.0a-gog34062'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ankh_anniversary_edition'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
bin'
CONTENT_GAME_DATA_FILES='
media'
CONTENT_DOC_DATA_FILES='
readme.txt'

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/Roaming/Ankh'
USER_PERSISTENT_DIRECTORIES='
userdata'
USER_PERSISTENT_FILES='
bin/release/plugins.cfg
media/*.cfg
media/*.ini'

APP_MAIN_EXE='bin/release/ankh.exe'
APP_MAIN_ICON='bin/release/ankh.ico'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# The game expects a writable "save" directory,
# despite not using it to store saved games

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# The game expects a writable "save" directory,
# despite not using it to store saved games
mkdir --parents save
'

# Enable game logs storage

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Enable game logs storage
mkdir --parents bin/release/logs
'

# Run the game binary from its parent directory

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Drop log files
	rm --recursive \
		'bin/release/logs' \
		'bin/release/cegui.log' \
		'bin/release/ogre.log'
)

# Get icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
