/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_MEMORYCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_MEMORYCONFORMSTOPROFILEACCESS_H_

#include "SystemMemory_Common.h"

#include "OpenDRIM_MemoryConformsToProfile.h"
#include "assocOpenDRIM_MemoryConformsToProfile.h"

int SystemMemory_OpenDRIM_MemoryConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_unload(string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_MemoryConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_MemoryConformsToProfile& instance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemoryConformsToProfile& newInstance, const OpenDRIM_MemoryConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemoryConformsToProfile& instance, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemoryConformsToProfile& instance, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_MemoryConformsToProfile>& OpenDRIM_MemoryConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_MemoryConformsToProfile>& OpenDRIM_MemoryConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_populate(OpenDRIM_MemoryConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_MEMORYCONFORMSTOPROFILEACCESS_H_*/
