/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.pairhmm.N2MemoryPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMModel;

public class LoglessPairHMM
extends N2MemoryPairHMM {
    protected static final double INITIAL_CONDITION = Math.pow(2.0, 1020.0);
    protected static final double INITIAL_CONDITION_LOG10 = Math.log10(INITIAL_CONDITION);
    protected static final double TRISTATE_CORRECTION = 3.0;

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            double initialValue = INITIAL_CONDITION / (double)haplotypeBases.length;
            for (int j = 0; j < this.paddedHaplotypeLength; ++j) {
                this.deletionMatrix[0][j] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            LoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i = 1; i < this.paddedReadLength; ++i) {
            for (int j = hapStartIndex + 1; j < this.paddedHaplotypeLength; ++j) {
                this.matchMatrix[i][j] = this.prior[i][j] * (this.matchMatrix[i - 1][j - 1] * this.transition[i][0] + this.insertionMatrix[i - 1][j - 1] * this.transition[i][1] + this.deletionMatrix[i - 1][j - 1] * this.transition[i][1]);
                this.insertionMatrix[i][j] = this.matchMatrix[i - 1][j] * this.transition[i][2] + this.insertionMatrix[i - 1][j] * this.transition[i][3];
                this.deletionMatrix[i][j] = this.matchMatrix[i][j - 1] * this.transition[i][4] + this.deletionMatrix[i][j - 1] * this.transition[i][5];
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = 0.0;
        for (int j = 1; j < this.paddedHaplotypeLength; ++j) {
            finalSumProbabilities += this.matchMatrix[endI][j] + this.insertionMatrix[endI][j];
        }
        return Math.log10(finalSumProbabilities) - INITIAL_CONDITION_LOG10;
    }

    protected void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.prior[i + 1][j + 1] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual) / (this.doNotUseTristateCorrection ? 1.0 : 3.0);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected static void initializeProbabilities(double[][] transition, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        PairHMMModel.qualToTransProbs(transition, insertionGOP, deletionGOP, overallGCP);
    }

    protected void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior * (this.matchMatrix[indI - 1][indJ - 1] * transition[0] + this.insertionMatrix[indI - 1][indJ - 1] * transition[1] + this.deletionMatrix[indI - 1][indJ - 1] * transition[1]);
        this.insertionMatrix[indI][indJ] = this.matchMatrix[indI - 1][indJ] * transition[2] + this.insertionMatrix[indI - 1][indJ] * transition[3];
        this.deletionMatrix[indI][indJ] = this.matchMatrix[indI][indJ - 1] * transition[4] + this.deletionMatrix[indI][indJ - 1] * transition[5];
    }
}

