/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Opaque,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    public OpaqueDescriptor(String string, Connection connection) throws SQLException {
        super((short)58, string, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)58, sQLName, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, OracleTypeOPAQUE oracleTypeOPAQUE, Connection connection) throws SQLException {
        super((short)58, sQLName, oracleTypeOPAQUE, connection);
    }

    public OpaqueDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)58, oracleTypeADT, connection);
    }

    OpaqueDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    public static OpaqueDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(null, 60, "Invalid argument,'name' shouldn't be null nor an empty string and 'conn' should not be null");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLName sQLName = new SQLName(string, (OracleConnection)connection);
        return OpaqueDescriptor.createDescriptor(sQLName, connection);
    }

    public static OpaqueDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        String string = sQLName.getName();
        OpaqueDescriptor opaqueDescriptor = null;
        if (connection != null) {
            opaqueDescriptor = (OpaqueDescriptor)((OracleConnection)connection).getDescriptor(string);
        }
        if (opaqueDescriptor == null) {
            if (string.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, string, 7L);
                opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
            } else if (string.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, string, 7L);
                opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
            } else {
                opaqueDescriptor = new OpaqueDescriptor(sQLName, connection);
            }
            if (connection != null) {
                ((OracleConnection)connection).putDescriptor(string, opaqueDescriptor);
            }
        }
        return opaqueDescriptor;
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.OPAQUE;
    }

    private void initPickler() throws SQLException {
        try {
            this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + this.getName() + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.shareBytes() != null) {
            byArray = oPAQUE.shareBytes();
        } else {
            try {
                byArray = this.pickler.linearize(oPAQUE);
            }
            finally {
                if (!bl) {
                    oPAQUE.setShareBytes(null);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.value != null) {
            byArray = oPAQUE.value;
        } else {
            try {
                this.pickler.unlinearize(oPAQUE.shareBytes(), 0L, oPAQUE, 1, null);
                byArray = oPAQUE.value;
            }
            finally {
                if (!bl) {
                    oPAQUE.value = null;
                }
            }
        }
        return byArray;
    }

    @Override
    public int getTypeCode() throws SQLException {
        if ("SYS.XMLTYPE".equalsIgnoreCase(this.sqlName.getName())) {
            return 2009;
        }
        return 2007;
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = this;
        String string2 = opaqueDescriptor.getName();
        return string.equals(string2);
    }

    @Override
    public long getMaxLength() throws SQLException {
        long l2 = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
        return l2;
    }

    @Override
    public boolean isTrustedLibrary() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
    }

    @Override
    public boolean isModeledInC() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isModeledInC();
    }

    @Override
    public boolean hasUnboundedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
    }

    @Override
    public boolean hasFixedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isFixedSized();
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public Class getClass(Map map) throws SQLException {
        Class clazz = null;
        String string = this.getName();
        Class clazz2 = this.connection.getClassForType(string, map);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
            clazz2 = (Class)map.get(string3);
        }
        if (!SQLName.s_parseAllFormat) {
            clazz = clazz2;
        } else {
            if (clazz2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
                clazz2 = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
            clazz = clazz2;
        }
        return clazz;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

