/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGARG.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgGetarg(struct Cfg_Getopt *optstru);

 *	Return the next argument from the initialized structure

 	If _oHead != NULL, getarg() uses the cached arguments only.
 	Otherwise, getarg() returns NULL if type != CFG_ARG; _buf otherwise.

 	Return:
 		NULL: no argument found
 		else: pointer to argument; Note: the string might be located within
 			the dynamic memory and will be unavailable as soon this
 			function is called next

ob(ject): cfgGetarg
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Retrieve next argument
he(ader files): 
lo(ng description): Returns the next non-option argument. If an output
	stack is currently active, the next argument is read from there;
	otherwise the \subsys{cmdline} must have a non-option argument pending
	to let this function succeed.
pr(erequistes): 
va(lue): NULL: on failure \item else: pointer to internal buffer holding the
	argument
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgarg.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <assert.h>
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGARG.C 1.7 2001/02/27 01:27:20 ska Exp ska $";
#endif

char *cfgGetarg(struct Cfg_Getopt *optstru)
{	char *p;

	DBG_ENTER("cfgGetarg", Suppl_cmdline)

	assert(optstru);
	chkHeap

	if(C(_oHead)) {			/* return the cached arguments */
		if(!C(_oCur))		/* return first entry */
			C(_oCur) = C(_oHead);
		while(1) {
			if((p = (C(_oCur)->C_sqArg)(optstru, C(_oCur))) != 0)
				DBG_RETURN_S( p)		/* OK, found the entry */
			/* not found--> advance to next ostack item */
			if(C(_oCur)->C_nxt == C(_oHead))	/* already the last item */
				DBG_RETURN_S( 0)
			C(_oCur) = C(_oCur)->C_nxt;
		}
	}

	/* Get the argument if the caching is not enabled */

	chkHeap
	while(C(_stk))		/* fetch next argument */
		switch(cfgType(optstru)) {	/* what is currently available? */
		case CFG_ARG:			/* that was really easy! */	
			C(type) = CFG_NONE;
			DBG_RETURN_S( S(buf))

		case CFG_OPT:
			if(!C(_foundOpt) || (C(_foundOpt))(optstru) != 0)
				DBG_RETURN_S( 0)		/* cannot ignore this option */
			C(type) = CFG_NONE;		/* options are not of interest */
			S(poi) = 0;		/* force to fetch next argument
							because the complete rest of the line is
							some sort of part of an option */
			break;

		case CFG_EOF:			/* no more arguments */
			DBG_RETURN_S( 0)
		}

	DBG_RETURN_S( 0)
}
