package net.sf.saxon.charcode;

/*
 Copyright (C) 2006 Hewlett-Packard Development Company, L.P.

 The contents of this file are subject to the Mozilla Public License Version 1.1
 (the "License"); you may not use this file except in compliance with the
 License. You may obtain a copy of the License at http://www.mozilla.org/MPL/

 Software distributed under the License is distributed on an "AS IS" basis,
 WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 the specific language governing rights and limitations under the License.

 The Original Code is: all this file
 The Initial Developer of the Original Code is Lauren Ward. All Rights Reserved.
 Contributor(s): Integrated into Saxon by Michael Kay. Removed code to perform dynamic
 initialization of the boolean array, replaced it with generated static data.

 *************************
 Author:
 Lauren Ward
 Date:
 February 01, 2006
 Address:
 Hewlett-Packard Company
 3404 East Harmony Road
 Fort Collins, CO 80528-9599
 Revision:
 1.0 - Initial creation

 Description: This class implements the PluggableCharacterSet to support
 GB2312 encoding.  The character mapping was obtained by extracting the
 Unicode values from an iconv character table (hp15CN=ucs2) available on HP-UX 11.23.

 The class was tested by transforming numerous manuals and having localization engineers
 review the output. The class was also tested by transforming a document with GB2312
 set as the output encoding, converting GB2312 output to utf-8 using iconv,
 and then comparing converted content to the same transformed document with utf-8 set
 as the output encoding.

 */

public class GB2312CharacterSet implements net.sf.saxon.charcode.PluggableCharacterSet {

    private static GB2312CharacterSet THE_INSTANCE = new GB2312CharacterSet();

    public static GB2312CharacterSet getInstance() {
        return THE_INSTANCE;
    }


    private static long[] flags = {
        0xffffffffffffffffL, 0xffffffffffffffffL, 0x980c000L, 0x100c0ec3168L,
        0x4000101000100000L, 0x4000000100000L, 0x0L, 0x2aaa800000000L,
        0x0L, 0x0L, 0x0L, 0x140000000000000L,
        0x0L, 0x0L, 0x7fffdfc07fffL, 0xdfc0000000000000L,
        0x4000ffffffffffffL, 0xffff400000000000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x6cc0200b010L, 0x0L, 0x0L, 0x0L,
        0x1000020000000000L, 0xfff00000L, 0xf00000000000L, 0x0L,
        0x81402685f20f04L, 0x880000cc030000L, 0x4004000000L, 0x0L,
        0x200000000000L, 0x0L, 0x0L, 0x0L,
        0x0L, 0xffc00fffL, 0xfffffff000000000L, 0x0L,
        0xffffffffffffffffL, 0xfff0000000000000L, 0xc0003000L, 0x313000000000000L,
        0x600000000000000L, 0xa000000000000000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xf4ffdf0000000000L, 0x7fffffffffffffffL, 0xfffff0007fffffffL, 0xfffffffffffffe10L,
        0x7ffffffffc00000L, 0x0L, 0x0L, 0x0L,
        0xffc00000L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xd1fedefe2dbcaaf7L, 0x15dfbacfc240d002L, 0x2df7cb1efde3431L, 0xff765fc75cb8b715L,
        0x4067c1f3af31aaacL, 0x1207d5ff9d499a1bL, 0x18d5491497eb0401L, 0x1c23c1af52e750a2L,
        0xd28e946ee002aL, 0x118b042804080313L, 0x8484000015c82030L, 0x10220030e1410L,
        0x310200040000001L, 0xded44e28249edfdcL, 0xe4cc2758ac19f71cL, 0x8b594014c81596fdL,
        0xf3a663f488d693f5L, 0xf02cca0a45612005L, 0x60809017f0fc7003L, 0x1150a28108008063L,
        0x86858764d2220073L, 0x55e3772bfb53dda1L, 0x2e5c04a536c20211L, 0x60fc4bd19efff7dcL,
        0x5aeff717d3df6cdaL, 0x92b0bfd82a80779cL, 0xaa1bae741bfd5895L, 0xebcffd6f07e6302dL,
        0x4341c810b92bd10bL, 0x5a6086084f2e079aL, 0xf9f148cd01005556L, 0xc4c7a0d5eb93506L,
        0xc0cb0093190c6a51L, 0xe09c828f84218L, 0x603100010010108L, 0x200937e814cc67L,
        0x1ae0000910ef9072L, 0xa12fc13fcaf51318L, 0x3e183010fb562880L, 0x30132ce5880508e4L,
        0xa3144442c8208400L, 0x80c488204180002L, 0xd440306300c00008L, 0x44004400081a9240L,
        0x29050e690d7749e8L, 0x69d34fa0a4001ac4L, 0x7ba433421cf32052L, 0x230f9ac14880051L,
        0x5fc8508994406a08L, 0x8260042021200f21L, 0x203000203482L, 0x60482a88d2504000L,
        0x40030000002900L, 0x8000ddfd3e68d424L, 0xddd915fefe309ec7L, 0x2f08b0074c8280f9L,
        0x4a614eac2d0848ffL, 0xe4f3c442d6034061L, 0x608ccbf8305c5585L, 0x481020404ea48010L,
        0x33020a120b460806L, 0x138009400590800L, 0x2000004400000100L, 0x404001667d37906L,
        0x7689cefc0306419cL, 0x2c080c1260003abdL, 0x8b31df6b870417c2L, 0x60721000a00b23L,
        0xf8b1559187654068L, 0x8000b7846a6cd158L, 0xedf8a5c840a6050cL, 0x1e4de3c4c9364497L,
        0xfe272e5cc7f10419L, 0x7014a46439fd92fdL, 0x184c2a35929d6898L, 0x63044ad83df9a60L,
        0xc2c704219b100001L, 0xaa440421808500L, 0x12080401c80102L, 0x20b0680002000401L,
        0x2bfe7b16c2a1907L, 0xd1de7890137f924bL, 0x886077b1ec98445dL, 0x2feebbf937cf5b0fL,
        0x61c24237fcb12064L, 0x365f840371464330L, 0xa1eba280b5ee99aaL, 0xa47a202d0642a85L,
        0xe419981ac22c0825L, 0x4fa02882014400e0L, 0x2d006642084e85a8L, 0xa406a1822a000000L,
        0x8040208004130ed3L, 0x4c946563218a900L, 0x118d1594d55804cL, 0x5e1b2300a7cfc320L,
        0xb22b1c4585854e0aL, 0x50193f214a838b22L, 0x2908430401820842L, 0x5c0240b94bL,
        0x80f48d1502bd4c24L, 0xb2cbd20bc4e5b50bL, 0x495085ae35b59780L, 0x5801f8eea449d805L,
        0x85fb5304406031ceL, 0xfeeadc00ffd00b00L, 0x5601110023859400L, 0xa05424a09002c468L,
        0x4416a00188048845L, 0x20000926921241c8L, 0xabc40c9801944910L, 0x402a881180042005L,
        0x20018140a14406L, 0x90080d044004048L, 0x8802c10080580000L, 0x0L,
        0xf9002162L, 0x134800403f200058L, 0x7b74323040201d01L, 0x64153f5040311444L,
        0x705def16be3ac84L, 0xe3608d1fc8e0aa46L, 0x76c998515f7670dfL, 0xc689f12f4b3d7beL,
        0x491a21720532745eL, 0x57b7786a92630988L, 0x24ca5c17dbf32481L, 0x8f1842c6ca1a5158L,
        0x42ecb24dc5528a0L, 0x18061a9100120003L, 0x1641808925216b34L, 0x61115d23eec00840L,
        0x22411c0088755202L, 0x314008a220628a8L, 0x8ce000841001240L, 0xa0406002c0030000L,
        0x403010000440L, 0x90002001d868bL, 0x84622e4c001f51dcL, 0xf0a000d10bdd0144L,
        0x6096e00201c200L, 0x42a000a0b8230a4L, 0x82108c180881440L, 0x10020c0085020040L,
        0x200000400a8c7d5L, 0x18c225563432463L, 0xc8352001000d8bc0L, 0x7886a142c0cff9b8L,
        0x5022171e647a49c3L, 0x4a100800d0002L, 0x95242112053b130L, 0xa0e5c04285442000L,
        0x1661803026aa9e08L, 0x4000057b00048302L, 0xd112800a01c00020L, 0x200aba030b01L,
        0x80550e904ddf5b2L, 0x849b0878062028c1L, 0x12116b65dc1bfcceL, 0x3de42e923bb0c849L,
        0xd42885d1ae749c8bL, 0x900c0a0a10110096L, 0x2b92524008026801L, 0x26a7eb91040368caL,
        0x49d40061a2c507a8L, 0xd100c03076980047L, 0x8c0e6001a5689415L, 0x40118355e1287L,
        0xe04c6bad174c89faL, 0x850aa704003e0108L, 0x14e51b95500f842L, 0x44708c4000882920L,
        0x440010020800083aL, 0xc2c0133fa58501a0L, 0xcc21002001001076L, 0xd25464811b558094L,
        0xb21609229000115dL, 0x200410000008be1L, 0xda84678d868c1001L, 0x10024396050065L,
        0x1ab14c528eba50aaL, 0x559eab4a0026552L, 0x84048d0c63fc4880L, 0x430850644622410aL,
        0x119020103200081L, 0xc00400000000181cL, 0x40658f2c22704eL, 0x45ac074980810090L,
        0x200000a1110000L, 0x20100L, 0x2020000L, 0x0L,
        0x10L, 0x4100000000000000L, 0x20000011fffdf7e7L, 0xfffffdfff7f7ffbfL,
        0xffdf7ffdfffffea0L, 0x2c00cda160e26842L, 0x402a08274901a0cdL, 0x442a0c81c642d018L,
        0xde1cafc8a7e05795L, 0x323c28a000604001L, 0x9b5812bdec77692fL, 0xfa0e037e4dfdfaacL,
        0x2267faa200096282L, 0x2b8dc608546c87fL, 0xa0a1409c12a01030L, 0xf2280000112c181aL,
        0xee0ca81b70bddfd2L, 0x95100a10083b867L, 0x28b761cd4effd9c6L, 0x49bf7d9bde114950L,
        0x7fcb4d38019d5ee8L, 0x9341e83bdfff019cL, 0x642309a80f0fbecL, 0xc5290a8dc460e0c4L,
        0x5a1f408c0f80408cL, 0x2004178505c56a0L, 0x21da0148400128e5L, 0x4864d20596088009L,
        0x85121401801fcL, 0x10e0024208802872L, 0xd01001808a38140L, 0x4041940808400011L,
        0x400420001400088L, 0x7c822201a407fL, 0xe03c140c19e9ce20L, 0x8b73c8d30846f8c2L,
        0xb1e435aa74424913L, 0x1ca11409c028a1eL, 0x34941101009d1424L, 0x8230701084220042L,
        0x1020161060002048L, 0x8c0c09407cdaa107L, 0x6c94220828144108L, 0x66422cc13c80d8caL,
        0x2020b07044308a00L, 0x4800000302000011L, 0x5200000000000000L, 0x6ffbe22a16111000L,
        0x8100000000000002L, 0x80000000000040L, 0x60100000000000L, 0x0L,
        0x100000002000000L, 0x2080000L, 0xfff7bfefL, 0xfeff7fffffdfffffL,
        0xffbffffdffffff00L, 0x43480420603010e0L, 0x2468088000000000L, 0x0L,
        0x77fffffffL, 0xffff9efefb149f00L, 0x4c30480110005cabL, 0x1a1b433718b915f4L,
        0x4690807306b4464L, 0xe9f06040024daa09L, 0x4501880a00192020L, 0x2000000000000L,
        0x0L, 0x3dfffffL, 0x7ff7dffb10d0c246L, 0x6d82dcdf2ef691c4L,
        0xfe75eb37e207069aL, 0x6905f19034860c05L, 0xb0905554722bdef2L, 0x4d23d11c63950886L,
        0x2800004230014040L, 0x127fa1267c6befc7L, 0x55ce03030270c20L, 0x16f400800000000L,
        0x0L, 0x800L, 0x2000000020000L, 0x80000000000000L,
        0x2L, 0x200000L, 0x1000000000000L, 0x20020000000000L,
        0x2L, 0x100000L, 0x7ffbd7fffffffffL, 0xfefee7dffdffffefL,
        0xfffffff77effeffbL, 0xef6ffbdf7ffdf201L, 0x0L, 0xf7fffeL,
        0xfeffef6d60227e1dL, 0xafdc8c1169e82f00L, 0x69589c80100924eL, 0xcf4f240080e11342L,
        0xcbc7120a0024a0c2L, 0x3252e4401a08L, 0x414688090152800L, 0x37c1600L,
        0x0L, 0x7ffL, 0xffeddbbfef000000L, 0x274e301800000L,
        0x4800000020000L, 0xc0015ffef2dL, 0xcfb5ffc004800000L, 0x0L,
        0x0L, 0xfdfffL, 0xefb9f3bffd80c3a8L, 0xe418508142150050L,
        0x1081100110012018L, 0x7dc5480000000000L, 0x0L, 0x0L,
        0x0L, 0x9L, 0x6796ec3bffd6ffbcL, 0x1f3f9fcf20000000L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x1f6fd77e7L, 0x7ffb45ba1bfcd003L, 0x2190300502000896L, 0x847489da561005aL,
        0x169140a0090156L, 0x800c00000000001L, 0x9ff8007180000000L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x7fffffffffffffffL, 0xfffffffe00000000L, 0x0L, 0xd4000000L
    };


    public GB2312CharacterSet() {
        //if (c == null) init();
    }

    // Determine if it is a valid character
    public final boolean inCharset(int ch) {
        if (ch > 65535) {
            return false;
        }
        long g = flags[ch >> 6];
        long h = (g >> (63 - (ch & 0x3f))) & 1L;
        return h == 1L;
    }

    public final String getEncodingName() {
        // Canonical Name for java.io and java.lang API
        return "EUC_CN";
    }
}

