// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/session_entity_type.proto

package dialogflow

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The types of modifications for a session entity type.
type SessionEntityType_EntityOverrideMode int32

const (
	// Not specified. This value should be never used.
	SessionEntityType_ENTITY_OVERRIDE_MODE_UNSPECIFIED SessionEntityType_EntityOverrideMode = 0
	// The collection of session entities overrides the collection of entities
	// in the corresponding developer entity type.
	SessionEntityType_ENTITY_OVERRIDE_MODE_OVERRIDE SessionEntityType_EntityOverrideMode = 1
	// The collection of session entities extends the collection of entities in
	// the corresponding developer entity type.
	// Calls to `ListSessionEntityTypes`, `GetSessionEntityType`,
	// `CreateSessionEntityType` and `UpdateSessionEntityType` return the full
	// collection of entities from the developer entity type in the agent's
	// default language and the session entity type.
	SessionEntityType_ENTITY_OVERRIDE_MODE_SUPPLEMENT SessionEntityType_EntityOverrideMode = 2
)

var SessionEntityType_EntityOverrideMode_name = map[int32]string{
	0: "ENTITY_OVERRIDE_MODE_UNSPECIFIED",
	1: "ENTITY_OVERRIDE_MODE_OVERRIDE",
	2: "ENTITY_OVERRIDE_MODE_SUPPLEMENT",
}
var SessionEntityType_EntityOverrideMode_value = map[string]int32{
	"ENTITY_OVERRIDE_MODE_UNSPECIFIED": 0,
	"ENTITY_OVERRIDE_MODE_OVERRIDE":    1,
	"ENTITY_OVERRIDE_MODE_SUPPLEMENT":  2,
}

func (x SessionEntityType_EntityOverrideMode) String() string {
	return proto.EnumName(SessionEntityType_EntityOverrideMode_name, int32(x))
}
func (SessionEntityType_EntityOverrideMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor5, []int{0, 0}
}

// Represents a session entity type.
//
// Extends or replaces a developer entity type at the user session level (we
// refer to the entity types defined at the agent level as "developer entity
// types").
//
// Note: session entity types apply to all queries, regardless of the language.
type SessionEntityType struct {
	// Required. The unique identifier of this session entity type. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity Type
	// Display Name>`, or
	// `projects/<Project ID>/agent/runtimes/<Runtime ID>sessions/<Session
	// ID>/entityTypes/<Entity Type Display Name>`.
	// Note: Runtimes are under construction and will be available soon.
	// If <Runtime ID> is not specified, we assume default 'sandbox' runtime.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. Indicates whether the additional data should override or
	// supplement the developer entity type definition.
	EntityOverrideMode SessionEntityType_EntityOverrideMode `protobuf:"varint,2,opt,name=entity_override_mode,json=entityOverrideMode,enum=google.cloud.dialogflow.v2beta1.SessionEntityType_EntityOverrideMode" json:"entity_override_mode,omitempty"`
	// Required. The collection of entities associated with this session entity
	// type.
	Entities []*EntityType_Entity `protobuf:"bytes,3,rep,name=entities" json:"entities,omitempty"`
}

func (m *SessionEntityType) Reset()                    { *m = SessionEntityType{} }
func (m *SessionEntityType) String() string            { return proto.CompactTextString(m) }
func (*SessionEntityType) ProtoMessage()               {}
func (*SessionEntityType) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{0} }

func (m *SessionEntityType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SessionEntityType) GetEntityOverrideMode() SessionEntityType_EntityOverrideMode {
	if m != nil {
		return m.EntityOverrideMode
	}
	return SessionEntityType_ENTITY_OVERRIDE_MODE_UNSPECIFIED
}

func (m *SessionEntityType) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

// The request message for [SessionEntityTypes.ListSessionEntityTypes][google.cloud.dialogflow.v2beta1.SessionEntityTypes.ListSessionEntityTypes].
type ListSessionEntityTypesRequest struct {
	// Required. The session to list all session entity types from.
	// Format: `projects/<Project ID>/agent/sessions/<Session ID>` or
	// `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session ID>`.
	// Note: Runtimes are under construction and will be available soon.
	// If <Runtime ID> is not specified, we assume default 'sandbox' runtime.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListSessionEntityTypesRequest) Reset()                    { *m = ListSessionEntityTypesRequest{} }
func (m *ListSessionEntityTypesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSessionEntityTypesRequest) ProtoMessage()               {}
func (*ListSessionEntityTypesRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{1} }

func (m *ListSessionEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSessionEntityTypesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSessionEntityTypesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [SessionEntityTypes.ListSessionEntityTypes][google.cloud.dialogflow.v2beta1.SessionEntityTypes.ListSessionEntityTypes].
type ListSessionEntityTypesResponse struct {
	// The list of session entity types. There will be a maximum number of items
	// returned based on the page_size field in the request.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,1,rep,name=session_entity_types,json=sessionEntityTypes" json:"session_entity_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSessionEntityTypesResponse) Reset()                    { *m = ListSessionEntityTypesResponse{} }
func (m *ListSessionEntityTypesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSessionEntityTypesResponse) ProtoMessage()               {}
func (*ListSessionEntityTypesResponse) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{2} }

func (m *ListSessionEntityTypesResponse) GetSessionEntityTypes() []*SessionEntityType {
	if m != nil {
		return m.SessionEntityTypes
	}
	return nil
}

func (m *ListSessionEntityTypesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [SessionEntityTypes.GetSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.GetSessionEntityType].
type GetSessionEntityTypeRequest struct {
	// Required. The name of the session entity type. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity Type
	// Display Name>` or `projects/<Project ID>/agent/runtimes/<Runtime
	// ID>/sessions/<Session ID>/entityTypes/<Entity Type Display Name>`. Note:
	// Runtimes are under construction and will be available soon. If <Runtime ID>
	// is not specified, we assume default 'sandbox' runtime.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetSessionEntityTypeRequest) Reset()                    { *m = GetSessionEntityTypeRequest{} }
func (m *GetSessionEntityTypeRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSessionEntityTypeRequest) ProtoMessage()               {}
func (*GetSessionEntityTypeRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{3} }

func (m *GetSessionEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [SessionEntityTypes.CreateSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.CreateSessionEntityType].
type CreateSessionEntityTypeRequest struct {
	// Required. The session to create a session entity type for.
	// Format: `projects/<Project ID>/agent/sessions/<Session ID>` or
	// `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session ID>`.
	// Note: Runtimes are under construction and will be available soon.
	// If <Runtime ID> is not specified, we assume default 'sandbox' runtime.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The session entity type to create.
	SessionEntityType *SessionEntityType `protobuf:"bytes,2,opt,name=session_entity_type,json=sessionEntityType" json:"session_entity_type,omitempty"`
}

func (m *CreateSessionEntityTypeRequest) Reset()                    { *m = CreateSessionEntityTypeRequest{} }
func (m *CreateSessionEntityTypeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSessionEntityTypeRequest) ProtoMessage()               {}
func (*CreateSessionEntityTypeRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{4} }

func (m *CreateSessionEntityTypeRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSessionEntityTypeRequest) GetSessionEntityType() *SessionEntityType {
	if m != nil {
		return m.SessionEntityType
	}
	return nil
}

// The request message for [SessionEntityTypes.UpdateSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.UpdateSessionEntityType].
type UpdateSessionEntityTypeRequest struct {
	// Required. The entity type to update. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity Type
	// Display Name>` or `projects/<Project ID>/agent/runtimes/<Runtime
	// ID>/sessions/<Session ID>/entityTypes/<Entity Type Display Name>`. Note:
	// Runtimes are under construction and will be available soon. If <Runtime ID>
	// is not specified, we assume default 'sandbox' runtime.
	SessionEntityType *SessionEntityType `protobuf:"bytes,1,opt,name=session_entity_type,json=sessionEntityType" json:"session_entity_type,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateSessionEntityTypeRequest) Reset()                    { *m = UpdateSessionEntityTypeRequest{} }
func (m *UpdateSessionEntityTypeRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSessionEntityTypeRequest) ProtoMessage()               {}
func (*UpdateSessionEntityTypeRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{5} }

func (m *UpdateSessionEntityTypeRequest) GetSessionEntityType() *SessionEntityType {
	if m != nil {
		return m.SessionEntityType
	}
	return nil
}

func (m *UpdateSessionEntityTypeRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [SessionEntityTypes.DeleteSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.DeleteSessionEntityType].
type DeleteSessionEntityTypeRequest struct {
	// Required. The name of the entity type to delete. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity Type
	// Display Name>` or `projects/<Project ID>/agent/runtimes/<Runtime
	// ID>/sessions/<Session ID>/entityTypes/<Entity Type Display Name>`. Note:
	// Runtimes are under construction and will be available soon. If <Runtime ID>
	// is not specified, we assume default 'sandbox' runtime.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteSessionEntityTypeRequest) Reset()                    { *m = DeleteSessionEntityTypeRequest{} }
func (m *DeleteSessionEntityTypeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSessionEntityTypeRequest) ProtoMessage()               {}
func (*DeleteSessionEntityTypeRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{6} }

func (m *DeleteSessionEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*SessionEntityType)(nil), "google.cloud.dialogflow.v2beta1.SessionEntityType")
	proto.RegisterType((*ListSessionEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.ListSessionEntityTypesRequest")
	proto.RegisterType((*ListSessionEntityTypesResponse)(nil), "google.cloud.dialogflow.v2beta1.ListSessionEntityTypesResponse")
	proto.RegisterType((*GetSessionEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.GetSessionEntityTypeRequest")
	proto.RegisterType((*CreateSessionEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateSessionEntityTypeRequest")
	proto.RegisterType((*UpdateSessionEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateSessionEntityTypeRequest")
	proto.RegisterType((*DeleteSessionEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteSessionEntityTypeRequest")
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.SessionEntityType_EntityOverrideMode", SessionEntityType_EntityOverrideMode_name, SessionEntityType_EntityOverrideMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for SessionEntityTypes service

type SessionEntityTypesClient interface {
	// Returns the list of all session entity types in the specified session.
	ListSessionEntityTypes(ctx context.Context, in *ListSessionEntityTypesRequest, opts ...grpc.CallOption) (*ListSessionEntityTypesResponse, error)
	// Retrieves the specified session entity type.
	GetSessionEntityType(ctx context.Context, in *GetSessionEntityTypeRequest, opts ...grpc.CallOption) (*SessionEntityType, error)
	// Creates a session entity type.
	CreateSessionEntityType(ctx context.Context, in *CreateSessionEntityTypeRequest, opts ...grpc.CallOption) (*SessionEntityType, error)
	// Updates the specified session entity type.
	UpdateSessionEntityType(ctx context.Context, in *UpdateSessionEntityTypeRequest, opts ...grpc.CallOption) (*SessionEntityType, error)
	// Deletes the specified session entity type.
	DeleteSessionEntityType(ctx context.Context, in *DeleteSessionEntityTypeRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type sessionEntityTypesClient struct {
	cc *grpc.ClientConn
}

func NewSessionEntityTypesClient(cc *grpc.ClientConn) SessionEntityTypesClient {
	return &sessionEntityTypesClient{cc}
}

func (c *sessionEntityTypesClient) ListSessionEntityTypes(ctx context.Context, in *ListSessionEntityTypesRequest, opts ...grpc.CallOption) (*ListSessionEntityTypesResponse, error) {
	out := new(ListSessionEntityTypesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/ListSessionEntityTypes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionEntityTypesClient) GetSessionEntityType(ctx context.Context, in *GetSessionEntityTypeRequest, opts ...grpc.CallOption) (*SessionEntityType, error) {
	out := new(SessionEntityType)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/GetSessionEntityType", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionEntityTypesClient) CreateSessionEntityType(ctx context.Context, in *CreateSessionEntityTypeRequest, opts ...grpc.CallOption) (*SessionEntityType, error) {
	out := new(SessionEntityType)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/CreateSessionEntityType", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionEntityTypesClient) UpdateSessionEntityType(ctx context.Context, in *UpdateSessionEntityTypeRequest, opts ...grpc.CallOption) (*SessionEntityType, error) {
	out := new(SessionEntityType)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/UpdateSessionEntityType", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionEntityTypesClient) DeleteSessionEntityType(ctx context.Context, in *DeleteSessionEntityTypeRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/DeleteSessionEntityType", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for SessionEntityTypes service

type SessionEntityTypesServer interface {
	// Returns the list of all session entity types in the specified session.
	ListSessionEntityTypes(context.Context, *ListSessionEntityTypesRequest) (*ListSessionEntityTypesResponse, error)
	// Retrieves the specified session entity type.
	GetSessionEntityType(context.Context, *GetSessionEntityTypeRequest) (*SessionEntityType, error)
	// Creates a session entity type.
	CreateSessionEntityType(context.Context, *CreateSessionEntityTypeRequest) (*SessionEntityType, error)
	// Updates the specified session entity type.
	UpdateSessionEntityType(context.Context, *UpdateSessionEntityTypeRequest) (*SessionEntityType, error)
	// Deletes the specified session entity type.
	DeleteSessionEntityType(context.Context, *DeleteSessionEntityTypeRequest) (*google_protobuf2.Empty, error)
}

func RegisterSessionEntityTypesServer(s *grpc.Server, srv SessionEntityTypesServer) {
	s.RegisterService(&_SessionEntityTypes_serviceDesc, srv)
}

func _SessionEntityTypes_ListSessionEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionEntityTypesServer).ListSessionEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/ListSessionEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionEntityTypesServer).ListSessionEntityTypes(ctx, req.(*ListSessionEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionEntityTypes_GetSessionEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionEntityTypesServer).GetSessionEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/GetSessionEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionEntityTypesServer).GetSessionEntityType(ctx, req.(*GetSessionEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionEntityTypes_CreateSessionEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionEntityTypesServer).CreateSessionEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/CreateSessionEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionEntityTypesServer).CreateSessionEntityType(ctx, req.(*CreateSessionEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionEntityTypes_UpdateSessionEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSessionEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionEntityTypesServer).UpdateSessionEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/UpdateSessionEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionEntityTypesServer).UpdateSessionEntityType(ctx, req.(*UpdateSessionEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionEntityTypes_DeleteSessionEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionEntityTypesServer).DeleteSessionEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SessionEntityTypes/DeleteSessionEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionEntityTypesServer).DeleteSessionEntityType(ctx, req.(*DeleteSessionEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SessionEntityTypes_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.SessionEntityTypes",
	HandlerType: (*SessionEntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSessionEntityTypes",
			Handler:    _SessionEntityTypes_ListSessionEntityTypes_Handler,
		},
		{
			MethodName: "GetSessionEntityType",
			Handler:    _SessionEntityTypes_GetSessionEntityType_Handler,
		},
		{
			MethodName: "CreateSessionEntityType",
			Handler:    _SessionEntityTypes_CreateSessionEntityType_Handler,
		},
		{
			MethodName: "UpdateSessionEntityType",
			Handler:    _SessionEntityTypes_UpdateSessionEntityType_Handler,
		},
		{
			MethodName: "DeleteSessionEntityType",
			Handler:    _SessionEntityTypes_DeleteSessionEntityType_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/session_entity_type.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/session_entity_type.proto", fileDescriptor5)
}

var fileDescriptor5 = []byte{
	// 863 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0x66, 0x5c, 0x58, 0xed, 0xce, 0xf2, 0xa3, 0x3b, 0x54, 0x69, 0x94, 0xd2, 0x34, 0x78, 0x11,
	0xaa, 0x72, 0xb0, 0xd5, 0xc0, 0x65, 0x59, 0x7e, 0x48, 0xdb, 0x38, 0xab, 0x48, 0x9b, 0x34, 0x72,
	0xd2, 0x15, 0x94, 0x83, 0xe5, 0xd4, 0xaf, 0x96, 0x69, 0xe2, 0x31, 0x9e, 0xc9, 0x2e, 0x29, 0xea,
	0xa5, 0xdc, 0xb8, 0x70, 0x40, 0xdc, 0x38, 0x71, 0xe0, 0x80, 0x04, 0xa7, 0xfe, 0x03, 0x1c, 0xf8,
	0x0b, 0x10, 0x37, 0x8e, 0x5c, 0x39, 0x22, 0x71, 0x03, 0x79, 0xec, 0x34, 0xa5, 0x1e, 0xdb, 0x21,
	0xdb, 0x9b, 0xe7, 0xcd, 0x7c, 0xef, 0xbd, 0xef, 0x9b, 0xf7, 0x9e, 0x07, 0xdf, 0x73, 0x29, 0x75,
	0x47, 0xa0, 0x1f, 0x8e, 0xe8, 0xc4, 0xd1, 0x1d, 0xcf, 0x1e, 0x51, 0xf7, 0x68, 0x44, 0x9f, 0xea,
	0x4f, 0x1a, 0x43, 0xe0, 0xf6, 0x8e, 0xce, 0x80, 0x31, 0x8f, 0xfa, 0x16, 0xf8, 0xdc, 0xe3, 0x53,
	0x8b, 0x4f, 0x03, 0xd0, 0x82, 0x90, 0x72, 0x4a, 0xb6, 0x62, 0xa8, 0x26, 0xa0, 0xda, 0x1c, 0xaa,
	0x25, 0xd0, 0xca, 0x6b, 0x89, 0x6f, 0x3b, 0xf0, 0x74, 0xdb, 0xf7, 0x29, 0xb7, 0xb9, 0x47, 0x7d,
	0x16, 0xc3, 0x2b, 0x3b, 0x45, 0x91, 0x53, 0x11, 0x2b, 0x1b, 0x09, 0x44, 0xac, 0x86, 0x93, 0x23,
	0x1d, 0xc6, 0x01, 0x9f, 0x26, 0x9b, 0xb5, 0xab, 0x9b, 0x47, 0x1e, 0x8c, 0x1c, 0x6b, 0x6c, 0xb3,
	0xe3, 0xf8, 0x84, 0xfa, 0x97, 0x82, 0xef, 0xf4, 0x63, 0x3a, 0x86, 0xf0, 0x3d, 0x98, 0x06, 0x40,
	0x08, 0x7e, 0xde, 0xb7, 0xc7, 0x50, 0x46, 0x35, 0xb4, 0x7d, 0xcb, 0x14, 0xdf, 0xe4, 0x29, 0x5e,
	0x4b, 0xa2, 0xd3, 0x27, 0x10, 0x86, 0x9e, 0x03, 0xd6, 0x98, 0x3a, 0x50, 0x56, 0x6a, 0x68, 0xfb,
	0xe5, 0x86, 0xa1, 0x15, 0x30, 0xd7, 0x52, 0x51, 0xb4, 0xf8, 0x73, 0x2f, 0xf1, 0xd6, 0xa1, 0x0e,
	0x98, 0x04, 0x52, 0x36, 0xd2, 0xc5, 0x37, 0x85, 0xd5, 0x03, 0x56, 0x5e, 0xa9, 0xad, 0x6c, 0xdf,
	0x6e, 0x34, 0x0a, 0x83, 0xa5, 0xa2, 0x98, 0x17, 0x3e, 0xd4, 0x33, 0x84, 0x49, 0x3a, 0x34, 0x79,
	0x03, 0xd7, 0x8c, 0xee, 0xa0, 0x3d, 0xf8, 0xc8, 0xda, 0x7b, 0x6c, 0x98, 0x66, 0xbb, 0x69, 0x58,
	0x9d, 0xbd, 0xa6, 0x61, 0xed, 0x77, 0xfb, 0x3d, 0x63, 0xb7, 0xdd, 0x6a, 0x1b, 0xcd, 0xd5, 0xe7,
	0xc8, 0xeb, 0x78, 0x53, 0x7a, 0x6a, 0xb6, 0x5a, 0x45, 0xe4, 0x2e, 0xde, 0x92, 0x1e, 0xe9, 0xef,
	0xf7, 0x7a, 0x8f, 0x8c, 0x8e, 0xd1, 0x1d, 0xac, 0x2a, 0x2a, 0xc3, 0x9b, 0x8f, 0x3c, 0xc6, 0x53,
	0xa2, 0x30, 0x13, 0x3e, 0x9d, 0x00, 0xe3, 0xa4, 0x84, 0x6f, 0x04, 0x76, 0x08, 0x3e, 0x4f, 0x2e,
	0x21, 0x59, 0x91, 0x0d, 0x7c, 0x2b, 0xb0, 0x5d, 0xb0, 0x98, 0x77, 0x12, 0x6b, 0xff, 0x82, 0x79,
	0x33, 0x32, 0xf4, 0xbd, 0x13, 0x20, 0x9b, 0x18, 0x8b, 0x4d, 0x4e, 0x8f, 0xc1, 0x2f, 0xaf, 0x08,
	0xa0, 0x38, 0x3e, 0x88, 0x0c, 0xea, 0x4f, 0x08, 0x57, 0xb3, 0xa2, 0xb2, 0x80, 0xfa, 0x0c, 0x88,
	0x83, 0xd7, 0x24, 0xd5, 0xcd, 0xca, 0x68, 0x41, 0xe1, 0x53, 0xae, 0x4d, 0xc2, 0x52, 0xd1, 0xc8,
	0x9b, 0xf8, 0x15, 0x1f, 0x3e, 0xe3, 0xd6, 0xa5, 0x64, 0x15, 0x91, 0xec, 0x4b, 0x91, 0xb9, 0x77,
	0x91, 0xf0, 0x0e, 0xde, 0x78, 0x08, 0xe9, 0x74, 0x67, 0x1a, 0x49, 0xca, 0x54, 0xfd, 0x16, 0xe1,
	0xea, 0x6e, 0x08, 0x36, 0x87, 0x4c, 0x58, 0x96, 0xb4, 0x43, 0xfc, 0xaa, 0x84, 0xbb, 0xc8, 0x6c,
	0x39, 0xea, 0x77, 0x52, 0xd4, 0xd5, 0x9f, 0x11, 0xae, 0xee, 0x07, 0x4e, 0x5e, 0x7a, 0x19, 0x69,
	0xa0, 0x6b, 0x4c, 0x83, 0xdc, 0xc7, 0xb7, 0x27, 0x22, 0x0b, 0x31, 0x0b, 0x12, 0x8a, 0x95, 0x99,
	0xef, 0xd9, 0xb8, 0xd0, 0x5a, 0xd1, 0xb8, 0xe8, 0xd8, 0xec, 0xd8, 0xc4, 0xf1, 0xf1, 0xe8, 0x5b,
	0x7d, 0x1b, 0x57, 0x9b, 0x30, 0x82, 0x1c, 0x0a, 0x92, 0x8b, 0x69, 0x7c, 0xf5, 0x22, 0x26, 0xe9,
	0xc2, 0x23, 0xdf, 0x2b, 0xb8, 0x24, 0xaf, 0x49, 0xf2, 0x7e, 0x21, 0xd7, 0xdc, 0x16, 0xaa, 0x7c,
	0xb0, 0x34, 0x3e, 0x6e, 0x06, 0xf5, 0x4b, 0x74, 0xf6, 0xeb, 0x1f, 0x5f, 0x2b, 0x5f, 0x20, 0x72,
	0xef, 0x62, 0x02, 0x7f, 0x1e, 0x17, 0xcb, 0x7b, 0x41, 0x48, 0x3f, 0x81, 0x43, 0xce, 0xf4, 0xba,
	0x6e, 0xbb, 0xe0, 0xf3, 0xd9, 0x4f, 0x81, 0xe9, 0xf5, 0xd3, 0x64, 0x4c, 0x0b, 0x67, 0x07, 0x2d,
	0xd2, 0x2c, 0x06, 0x87, 0x13, 0x9f, 0x7b, 0x63, 0x88, 0x0c, 0x19, 0x7e, 0xc8, 0x37, 0x0a, 0x5e,
	0x93, 0x35, 0x03, 0x79, 0xb7, 0x90, 0x66, 0x4e, 0x0f, 0x55, 0x96, 0x28, 0x28, 0xb9, 0x2e, 0xd1,
	0x25, 0xe7, 0xa9, 0x72, 0x99, 0x8c, 0x5e, 0x3f, 0xfd, 0xaf, 0x2e, 0x72, 0xb0, 0x54, 0x95, 0x2b,
	0x7e, 0xc8, 0x2f, 0x0a, 0x5e, 0xcf, 0x68, 0x78, 0x52, 0x5c, 0x01, 0xf9, 0xa3, 0x62, 0x29, 0x75,
	0xce, 0x63, 0x75, 0x7e, 0x44, 0xea, 0xf2, 0x55, 0xf3, 0x8e, 0x6c, 0x04, 0x1c, 0x7c, 0xac, 0x5e,
	0x4b, 0x29, 0x49, 0x9d, 0x93, 0x3f, 0x15, 0xbc, 0x9e, 0x31, 0x99, 0x16, 0xd0, 0x31, 0x7f, 0xa6,
	0x2d, 0xa5, 0xe3, 0xef, 0xb1, 0x8e, 0xbf, 0xa1, 0x46, 0x67, 0xce, 0x5a, 0xf6, 0xf4, 0xfa, 0x9f,
	0x95, 0x27, 0xd7, 0x96, 0x36, 0x3e, 0x5c, 0x26, 0xca, 0x22, 0x25, 0x2a, 0xd7, 0xfb, 0x1f, 0x84,
	0xd7, 0x33, 0xc6, 0xe8, 0x02, 0x7a, 0xe7, 0x0f, 0xe0, 0x4a, 0x29, 0x35, 0xca, 0x8d, 0xe8, 0x59,
	0x38, 0xef, 0xdc, 0xfa, 0xb3, 0x74, 0x6e, 0xfd, 0x5a, 0x3a, 0xf7, 0xc1, 0x39, 0xc2, 0x77, 0x0f,
	0xe9, 0xb8, 0x88, 0xeb, 0x83, 0x52, 0x8a, 0x66, 0x2f, 0x62, 0xd5, 0x43, 0x07, 0xed, 0x04, 0xea,
	0xd2, 0x91, 0xed, 0xbb, 0x1a, 0x0d, 0x5d, 0xdd, 0x05, 0x5f, 0x70, 0xd6, 0xe3, 0x2d, 0x3b, 0xf0,
	0x58, 0xe6, 0x73, 0xfa, 0xfe, 0xdc, 0xf4, 0x37, 0x42, 0xdf, 0x29, 0x4a, 0xb3, 0xf5, 0x83, 0xb2,
	0xf5, 0x30, 0xf6, 0xb9, 0x2b, 0xd2, 0x69, 0xce, 0xd3, 0x79, 0x1c, 0x83, 0x86, 0x37, 0x84, 0xff,
	0xb7, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x65, 0x3a, 0xa2, 0x54, 0x27, 0x0c, 0x00, 0x00,
}
